/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.content.Context;
import android.text.BoringLayout;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextUtils;
import android.text.method.TransformationMethod;
import android.util.AttributeSet;
import android.view.RemotableViewMethod;
import android.view.View;
import android.widget.RemoteViews;
import android.widget.TextView;

@RemoteViews.RemoteView
public class ImageFloatingTextView
extends TextView {
    private int mIndentLines = 0;
    private boolean mHasImage = false;
    private int mResolvedDirection = -1;
    private int mMaxLinesForHeight = -1;
    private int mLayoutMaxLines = -1;
    private int mImageEndMargin;

    public ImageFloatingTextView(Context context) {
        this(context, null);
    }

    public ImageFloatingTextView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ImageFloatingTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public ImageFloatingTextView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    @Override
    protected Layout makeSingleLayout(int wantWidth, BoringLayout.Metrics boring, int ellipsisWidth, Layout.Alignment alignment, boolean shouldEllipsize, TextUtils.TruncateAt effectiveEllipsize, boolean useSaved) {
        TransformationMethod transformationMethod = this.getTransformationMethod();
        CharSequence text = this.getText();
        if (transformationMethod != null) {
            text = transformationMethod.getTransformation(text, this);
        }
        text = text == null ? "" : text;
        StaticLayout.Builder builder = StaticLayout.Builder.obtain(text, 0, text.length(), this.getPaint(), wantWidth).setAlignment(alignment).setTextDirection(this.getTextDirectionHeuristic()).setLineSpacing(this.getLineSpacingExtra(), this.getLineSpacingMultiplier()).setIncludePad(this.getIncludeFontPadding()).setUseLineSpacingFromFallbacks(true).setBreakStrategy(1).setHyphenationFrequency(4);
        int maxLines = this.mMaxLinesForHeight > 0 ? this.mMaxLinesForHeight : (this.getMaxLines() >= 0 ? this.getMaxLines() : Integer.MAX_VALUE);
        builder.setMaxLines(maxLines);
        this.mLayoutMaxLines = maxLines;
        if (shouldEllipsize) {
            builder.setEllipsize(effectiveEllipsize).setEllipsizedWidth(ellipsisWidth);
        }
        int[] margins = null;
        if (this.mHasImage && this.mIndentLines > 0) {
            margins = new int[this.mIndentLines + 1];
            for (int i = 0; i < this.mIndentLines; ++i) {
                margins[i] = this.mImageEndMargin;
            }
        }
        if (this.mResolvedDirection == 1) {
            builder.setIndents(margins, null);
        } else {
            builder.setIndents(null, margins);
        }
        return builder.build();
    }

    @RemotableViewMethod
    public void setImageEndMargin(int imageEndMargin) {
        if (this.mImageEndMargin != imageEndMargin) {
            this.mImageEndMargin = imageEndMargin;
            this.invalidateTextIfIndenting();
        }
    }

    @RemotableViewMethod
    public void setImageEndMarginDp(float imageEndMarginDp) {
        this.setImageEndMargin((int)(imageEndMarginDp * this.getResources().getDisplayMetrics().density));
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int availableHeight = View.MeasureSpec.getSize(heightMeasureSpec) - this.mPaddingTop - this.mPaddingBottom;
        if (this.getLayout() != null && this.getLayout().getHeight() != availableHeight) {
            this.mMaxLinesForHeight = -1;
            this.nullLayouts();
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        Layout layout2 = this.getLayout();
        if (layout2.getHeight() > availableHeight) {
            int maxLines;
            for (maxLines = layout2.getLineCount(); maxLines > 1 && layout2.getLineBottom(maxLines - 1) > availableHeight; --maxLines) {
            }
            if (this.getMaxLines() > 0) {
                maxLines = Math.min(this.getMaxLines(), maxLines);
            }
            if (maxLines != this.mLayoutMaxLines) {
                this.mMaxLinesForHeight = maxLines;
                this.nullLayouts();
                super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            }
        }
    }

    @Override
    public void onRtlPropertiesChanged(int layoutDirection) {
        super.onRtlPropertiesChanged(layoutDirection);
        if (layoutDirection != this.mResolvedDirection && this.isLayoutDirectionResolved()) {
            this.mResolvedDirection = layoutDirection;
            this.invalidateTextIfIndenting();
        }
    }

    private void invalidateTextIfIndenting() {
        if (this.mHasImage && this.mIndentLines > 0) {
            this.nullLayouts();
            this.requestLayout();
        }
    }

    @RemotableViewMethod
    public void setHasImage(boolean hasImage) {
        this.setHasImageAndNumIndentLines(hasImage, this.mIndentLines);
    }

    @RemotableViewMethod
    public void setNumIndentLines(int lines) {
        this.setHasImageAndNumIndentLines(this.mHasImage, lines);
    }

    private void setHasImageAndNumIndentLines(boolean hasImage, int lines) {
        int oldEffectiveLines = this.mHasImage ? this.mIndentLines : 0;
        int newEffectiveLines = hasImage ? lines : 0;
        this.mIndentLines = lines;
        this.mHasImage = hasImage;
        if (oldEffectiveLines != newEffectiveLines) {
            this.nullLayouts();
            this.requestLayout();
        }
    }
}

