/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.app.Notification;
import android.content.Context;
import android.text.Layout;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.RemoteViews;
import com.android.internal.widget.IMessagingLayout;
import com.android.internal.widget.ImageFloatingTextView;
import com.android.internal.widget.MessagingLayout;
import com.android.internal.widget.MessagingLinearLayout;
import com.android.internal.widget.MessagingMessage;
import com.android.internal.widget.MessagingMessageState;
import com.android.internal.widget.MessagingPool;

@RemoteViews.RemoteView
public class MessagingTextMessage
extends ImageFloatingTextView
implements MessagingMessage {
    private static final MessagingPool<MessagingTextMessage> sInstancePool = new MessagingPool(20);
    private final MessagingMessageState mState = new MessagingMessageState(this);

    public MessagingTextMessage(Context context) {
        super(context);
    }

    public MessagingTextMessage(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public MessagingTextMessage(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public MessagingTextMessage(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    @Override
    public MessagingMessageState getState() {
        return this.mState;
    }

    @Override
    public boolean setMessage(Notification.MessagingStyle.Message message) {
        MessagingMessage.super.setMessage(message);
        this.setText(message.getText());
        return true;
    }

    static MessagingMessage createMessage(IMessagingLayout layout2, Notification.MessagingStyle.Message m) {
        MessagingLinearLayout messagingLinearLayout = layout2.getMessagingLinearLayout();
        MessagingTextMessage createdMessage = (MessagingTextMessage)sInstancePool.acquire();
        if (createdMessage == null) {
            createdMessage = (MessagingTextMessage)LayoutInflater.from(layout2.getContext()).inflate(17367240, (ViewGroup)messagingLinearLayout, false);
            createdMessage.addOnLayoutChangeListener(MessagingLayout.MESSAGING_PROPERTY_ANIMATOR);
        }
        createdMessage.setMessage(m);
        return createdMessage;
    }

    @Override
    public void recycle() {
        MessagingMessage.super.recycle();
        sInstancePool.release(this);
    }

    public static void dropCache() {
        sInstancePool.clear();
    }

    @Override
    public int getMeasuredType() {
        boolean measuredTooSmall;
        boolean bl = measuredTooSmall = this.getMeasuredHeight() < this.getLayoutHeight() + this.getPaddingTop() + this.getPaddingBottom();
        if (measuredTooSmall && this.getLineCount() <= 1) {
            return 2;
        }
        Layout layout2 = this.getLayout();
        if (layout2 == null) {
            return 2;
        }
        if (layout2.getEllipsisCount(layout2.getLineCount() - 1) > 0) {
            return 1;
        }
        return 0;
    }

    @Override
    public void setMaxDisplayedLines(int lines) {
        this.setMaxLines(lines);
    }

    @Override
    public int getConsumedLines() {
        return this.getLineCount();
    }

    public int getLayoutHeight() {
        Layout layout2 = this.getLayout();
        if (layout2 == null) {
            return 0;
        }
        return layout2.getHeight();
    }

    @Override
    public void setColor(int color2) {
        this.setTextColor(color2);
    }
}

