/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.view.View;
import com.android.internal.widget.RecyclerView;

public abstract class SimpleItemAnimator
extends RecyclerView.ItemAnimator {
    private static final boolean DEBUG = false;
    private static final String TAG = "SimpleItemAnimator";
    boolean mSupportsChangeAnimations = true;

    public boolean getSupportsChangeAnimations() {
        return this.mSupportsChangeAnimations;
    }

    public void setSupportsChangeAnimations(boolean supportsChangeAnimations) {
        this.mSupportsChangeAnimations = supportsChangeAnimations;
    }

    @Override
    public boolean canReuseUpdatedViewHolder(RecyclerView.ViewHolder viewHolder) {
        return !this.mSupportsChangeAnimations || viewHolder.isInvalid();
    }

    @Override
    public boolean animateDisappearance(RecyclerView.ViewHolder viewHolder, RecyclerView.ItemAnimator.ItemHolderInfo preLayoutInfo, RecyclerView.ItemAnimator.ItemHolderInfo postLayoutInfo) {
        int newTop;
        int oldLeft = preLayoutInfo.left;
        int oldTop = preLayoutInfo.top;
        View disappearingItemView = viewHolder.itemView;
        int newLeft = postLayoutInfo == null ? disappearingItemView.getLeft() : postLayoutInfo.left;
        int n = newTop = postLayoutInfo == null ? disappearingItemView.getTop() : postLayoutInfo.top;
        if (!(viewHolder.isRemoved() || oldLeft == newLeft && oldTop == newTop)) {
            disappearingItemView.layout(newLeft, newTop, newLeft + disappearingItemView.getWidth(), newTop + disappearingItemView.getHeight());
            return this.animateMove(viewHolder, oldLeft, oldTop, newLeft, newTop);
        }
        return this.animateRemove(viewHolder);
    }

    @Override
    public boolean animateAppearance(RecyclerView.ViewHolder viewHolder, RecyclerView.ItemAnimator.ItemHolderInfo preLayoutInfo, RecyclerView.ItemAnimator.ItemHolderInfo postLayoutInfo) {
        if (preLayoutInfo != null && (preLayoutInfo.left != postLayoutInfo.left || preLayoutInfo.top != postLayoutInfo.top)) {
            return this.animateMove(viewHolder, preLayoutInfo.left, preLayoutInfo.top, postLayoutInfo.left, postLayoutInfo.top);
        }
        return this.animateAdd(viewHolder);
    }

    @Override
    public boolean animatePersistence(RecyclerView.ViewHolder viewHolder, RecyclerView.ItemAnimator.ItemHolderInfo preInfo, RecyclerView.ItemAnimator.ItemHolderInfo postInfo) {
        if (preInfo.left != postInfo.left || preInfo.top != postInfo.top) {
            return this.animateMove(viewHolder, preInfo.left, preInfo.top, postInfo.left, postInfo.top);
        }
        this.dispatchMoveFinished(viewHolder);
        return false;
    }

    @Override
    public boolean animateChange(RecyclerView.ViewHolder oldHolder, RecyclerView.ViewHolder newHolder, RecyclerView.ItemAnimator.ItemHolderInfo preInfo, RecyclerView.ItemAnimator.ItemHolderInfo postInfo) {
        int toTop;
        int toLeft;
        int fromLeft = preInfo.left;
        int fromTop = preInfo.top;
        if (newHolder.shouldIgnore()) {
            toLeft = preInfo.left;
            toTop = preInfo.top;
        } else {
            toLeft = postInfo.left;
            toTop = postInfo.top;
        }
        return this.animateChange(oldHolder, newHolder, fromLeft, fromTop, toLeft, toTop);
    }

    public abstract boolean animateRemove(RecyclerView.ViewHolder var1);

    public abstract boolean animateAdd(RecyclerView.ViewHolder var1);

    public abstract boolean animateMove(RecyclerView.ViewHolder var1, int var2, int var3, int var4, int var5);

    public abstract boolean animateChange(RecyclerView.ViewHolder var1, RecyclerView.ViewHolder var2, int var3, int var4, int var5, int var6);

    public void dispatchRemoveFinished(RecyclerView.ViewHolder item) {
        this.onRemoveFinished(item);
        this.dispatchAnimationFinished(item);
    }

    public void dispatchMoveFinished(RecyclerView.ViewHolder item) {
        this.onMoveFinished(item);
        this.dispatchAnimationFinished(item);
    }

    public void dispatchAddFinished(RecyclerView.ViewHolder item) {
        this.onAddFinished(item);
        this.dispatchAnimationFinished(item);
    }

    public void dispatchChangeFinished(RecyclerView.ViewHolder item, boolean oldItem) {
        this.onChangeFinished(item, oldItem);
        this.dispatchAnimationFinished(item);
    }

    public void dispatchRemoveStarting(RecyclerView.ViewHolder item) {
        this.onRemoveStarting(item);
    }

    public void dispatchMoveStarting(RecyclerView.ViewHolder item) {
        this.onMoveStarting(item);
    }

    public void dispatchAddStarting(RecyclerView.ViewHolder item) {
        this.onAddStarting(item);
    }

    public void dispatchChangeStarting(RecyclerView.ViewHolder item, boolean oldItem) {
        this.onChangeStarting(item, oldItem);
    }

    public void onRemoveStarting(RecyclerView.ViewHolder item) {
    }

    public void onRemoveFinished(RecyclerView.ViewHolder item) {
    }

    public void onAddStarting(RecyclerView.ViewHolder item) {
    }

    public void onAddFinished(RecyclerView.ViewHolder item) {
    }

    public void onMoveStarting(RecyclerView.ViewHolder item) {
    }

    public void onMoveFinished(RecyclerView.ViewHolder item) {
    }

    public void onChangeStarting(RecyclerView.ViewHolder item, boolean oldItem) {
    }

    public void onChangeFinished(RecyclerView.ViewHolder item, boolean oldItem) {
    }
}

