/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.floatingtoolbar;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.Icon;
import android.text.TextUtils;
import android.util.Log;
import android.view.MenuItem;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.view.selectiontoolbar.ISelectionToolbarCallback;
import android.view.selectiontoolbar.SelectionToolbarManager;
import android.view.selectiontoolbar.ShowInfo;
import android.view.selectiontoolbar.ToolbarMenuItem;
import android.view.selectiontoolbar.WidgetInfo;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import com.android.internal.widget.floatingtoolbar.FloatingToolbarPopup;
import com.android.internal.widget.floatingtoolbar.LocalFloatingToolbarPopup;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class RemoteFloatingToolbarPopup
implements FloatingToolbarPopup {
    private static final boolean DEBUG = Log.isLoggable("floating_toolbar", 2);
    private static final int TOOLBAR_STATE_SHOWN = 1;
    private static final int TOOLBAR_STATE_HIDDEN = 2;
    private static final int TOOLBAR_STATE_DISMISSED = 3;
    private final SelectionToolbarManager mSelectionToolbarManager;
    private final View mParent;
    private final PopupWindow mPopupWindow;
    private final SelectionToolbarCallbackImpl mSelectionToolbarCallback;
    private int mState;
    private long mFloatingToolbarToken;
    private final Rect mPreviousContentRect = new Rect();
    private List<MenuItem> mMenuItems;
    private MenuItem.OnMenuItemClickListener mMenuItemClickListener;
    private int mSuggestedWidth;
    private final Rect mScreenViewPort = new Rect();
    private boolean mWidthChanged = true;
    private final boolean mIsLightTheme;
    private final int[] mCoordsOnScreen = new int[2];
    private final int[] mCoordsOnWindow = new int[2];

    public RemoteFloatingToolbarPopup(Context context, View parent) {
        this.mParent = Objects.requireNonNull(parent);
        this.mPopupWindow = RemoteFloatingToolbarPopup.createPopupWindow(context);
        this.mSelectionToolbarManager = context.getSystemService(SelectionToolbarManager.class);
        this.mSelectionToolbarCallback = new SelectionToolbarCallbackImpl(this);
        this.mIsLightTheme = this.isLightTheme(context);
        this.mFloatingToolbarToken = 0L;
    }

    private boolean isLightTheme(Context context) {
        TypedArray a = context.obtainStyledAttributes(new int[]{16844176});
        boolean isLightTheme = a.getBoolean(0, true);
        a.recycle();
        return isLightTheme;
    }

    @Override
    public void show(List<MenuItem> menuItems, MenuItem.OnMenuItemClickListener menuItemClickListener, Rect contentRect) {
        boolean isLayoutRequired;
        Objects.requireNonNull(menuItems);
        Objects.requireNonNull(menuItemClickListener);
        if (this.isShowing() && Objects.equals(menuItems, this.mMenuItems) && Objects.equals(contentRect, this.mPreviousContentRect)) {
            if (DEBUG) {
                Log.v("floating_toolbar", "Ignore duplicate show() for the same content.");
            }
            return;
        }
        boolean bl = isLayoutRequired = this.mMenuItems == null || !MenuItemRepr.reprEquals(menuItems, this.mMenuItems) || this.mWidthChanged;
        if (isLayoutRequired) {
            this.mSelectionToolbarManager.dismissToolbar(this.mFloatingToolbarToken);
            this.doDismissPopupWindow();
        }
        this.mMenuItemClickListener = menuItemClickListener;
        this.mMenuItems = menuItems;
        this.mParent.getWindowVisibleDisplayFrame(this.mScreenViewPort);
        int suggestWidth = this.mSuggestedWidth > 0 ? this.mSuggestedWidth : this.mParent.getResources().getDimensionPixelSize(17105235);
        ShowInfo showInfo = new ShowInfo(this.mFloatingToolbarToken, isLayoutRequired, RemoteFloatingToolbarPopup.getToolbarMenuItems(this.mMenuItems), contentRect, suggestWidth, this.mScreenViewPort, this.mParent.getViewRootImpl().getInputToken(), this.mIsLightTheme);
        if (DEBUG) {
            Log.v("floating_toolbar", "RemoteFloatingToolbarPopup.show() for " + showInfo);
        }
        this.mSelectionToolbarManager.showToolbar(showInfo, this.mSelectionToolbarCallback);
        this.mPreviousContentRect.set(contentRect);
    }

    @Override
    public void dismiss() {
        if (this.mState == 3) {
            Log.w("floating_toolbar", "The floating toolbar already dismissed.");
            return;
        }
        if (DEBUG) {
            Log.v("floating_toolbar", "RemoteFloatingToolbarPopup.dismiss().");
        }
        this.mSelectionToolbarManager.dismissToolbar(this.mFloatingToolbarToken);
        this.doDismissPopupWindow();
    }

    @Override
    public void hide() {
        if (this.mState == 3 || this.mState == 2) {
            if (DEBUG) {
                Log.v("floating_toolbar", "The floating toolbar already dismissed or hidden.");
            }
            return;
        }
        if (DEBUG) {
            Log.v("floating_toolbar", "RemoteFloatingToolbarPopup.hide().");
        }
        this.mSelectionToolbarManager.hideToolbar(this.mFloatingToolbarToken);
        this.mState = 2;
        this.mPopupWindow.dismiss();
    }

    @Override
    public void setSuggestedWidth(int suggestedWidth) {
        int difference = Math.abs(suggestedWidth - this.mSuggestedWidth);
        this.mWidthChanged = (double)difference > (double)this.mSuggestedWidth * 0.2;
        this.mSuggestedWidth = suggestedWidth;
    }

    @Override
    public void setWidthChanged(boolean widthChanged) {
        this.mWidthChanged = widthChanged;
    }

    @Override
    public boolean isHidden() {
        return this.mState == 2;
    }

    @Override
    public boolean isShowing() {
        return this.mState == 1;
    }

    @Override
    public boolean setOutsideTouchable(boolean outsideTouchable, PopupWindow.OnDismissListener onDismiss) {
        if (this.mState == 3) {
            return false;
        }
        boolean ret = false;
        if (this.mPopupWindow.isOutsideTouchable() ^ outsideTouchable) {
            this.mPopupWindow.setOutsideTouchable(outsideTouchable);
            this.mPopupWindow.setFocusable(!outsideTouchable);
            this.mPopupWindow.update();
            ret = true;
        }
        this.mPopupWindow.setOnDismissListener(onDismiss);
        return ret;
    }

    private void updatePopupWindowContent(WidgetInfo widgetInfo) {
        if (DEBUG) {
            Log.v("floating_toolbar", "updatePopupWindowContent.");
        }
        ViewGroup contentContainer = (ViewGroup)this.mPopupWindow.getContentView();
        contentContainer.removeAllViews();
        SurfaceView surfaceView = new SurfaceView(this.mParent.getContext());
        surfaceView.setZOrderOnTop(true);
        surfaceView.getHolder().setFormat(-2);
        surfaceView.setChildSurfacePackage(widgetInfo.getSurfacePackage());
        contentContainer.addView(surfaceView);
    }

    private MenuItem getMenuItemByToolbarMenuItem(ToolbarMenuItem toolbarMenuItem) {
        for (MenuItem item : this.mMenuItems) {
            if (toolbarMenuItem.getItemId() != item.getItemId()) continue;
            return item;
        }
        return null;
    }

    private Point getCoordinatesInWindow(int x, int y) {
        this.mParent.getRootView().getLocationOnScreen(this.mCoordsOnScreen);
        this.mParent.getRootView().getLocationInWindow(this.mCoordsOnWindow);
        int windowLeftOnScreen = this.mCoordsOnScreen[0] - this.mCoordsOnWindow[0];
        int windowTopOnScreen = this.mCoordsOnScreen[1] - this.mCoordsOnWindow[1];
        return new Point(Math.max(0, x - windowLeftOnScreen), Math.max(0, y - windowTopOnScreen));
    }

    private static List<ToolbarMenuItem> getToolbarMenuItems(List<MenuItem> menuItems) {
        ArrayList<ToolbarMenuItem> list = new ArrayList<ToolbarMenuItem>(menuItems.size());
        for (MenuItem menuItem : menuItems) {
            ToolbarMenuItem toolbarMenuItem = new ToolbarMenuItem.Builder(menuItem.getItemId(), menuItem.getTitle(), menuItem.getContentDescription(), menuItem.getGroupId(), RemoteFloatingToolbarPopup.convertDrawableToIcon(menuItem.getIcon()), menuItem.getTooltipText(), ToolbarMenuItem.getPriorityFromMenuItem(menuItem)).build();
            list.add(toolbarMenuItem);
        }
        return list;
    }

    private static Icon convertDrawableToIcon(Drawable drawable2) {
        BitmapDrawable bitmapDrawable;
        if (drawable2 == null) {
            return null;
        }
        if (drawable2 instanceof BitmapDrawable && (bitmapDrawable = (BitmapDrawable)drawable2).getBitmap() != null) {
            return Icon.createWithBitmap(bitmapDrawable.getBitmap());
        }
        Bitmap bitmap = Bitmap.createBitmap(drawable2.getIntrinsicWidth(), drawable2.getIntrinsicHeight(), Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        drawable2.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        drawable2.draw(canvas);
        return Icon.createWithBitmap(bitmap);
    }

    private static PopupWindow createPopupWindow(Context content) {
        LinearLayout popupContentHolder = new LinearLayout(content);
        PopupWindow popupWindow = new PopupWindow(popupContentHolder);
        popupWindow.setClippingEnabled(false);
        popupWindow.setWindowLayoutType(1005);
        popupWindow.setAnimationStyle(0);
        popupWindow.setBackgroundDrawable(new ColorDrawable(0));
        return popupWindow;
    }

    private void doDismissPopupWindow() {
        if (DEBUG) {
            Log.v("floating_toolbar", "RemoteFloatingToolbarPopup.doDismiss().");
        }
        this.mState = 3;
        this.mMenuItems = null;
        this.mMenuItemClickListener = null;
        this.mFloatingToolbarToken = 0L;
        this.mSuggestedWidth = 0;
        this.mWidthChanged = true;
        this.resetCoords();
        this.mPreviousContentRect.setEmpty();
        this.mScreenViewPort.setEmpty();
        this.mPopupWindow.dismiss();
    }

    private void resetCoords() {
        this.mCoordsOnScreen[0] = 0;
        this.mCoordsOnScreen[1] = 0;
        this.mCoordsOnWindow[0] = 0;
        this.mCoordsOnWindow[1] = 0;
    }

    private void runOnUiThread(Runnable runnable) {
        this.mParent.post(runnable);
    }

    private void onShow(WidgetInfo info) {
        this.runOnUiThread(() -> {
            this.mFloatingToolbarToken = info.getWidgetToken();
            this.mState = 1;
            this.updatePopupWindowContent(info);
            Rect contentRect = info.getContentRect();
            this.mPopupWindow.setWidth(contentRect.width());
            this.mPopupWindow.setHeight(contentRect.height());
            Point coords = this.getCoordinatesInWindow(contentRect.left, contentRect.top);
            this.mPopupWindow.showAtLocation(this.mParent, 0, coords.x, coords.y);
        });
    }

    private void onWidgetUpdated(WidgetInfo info) {
        this.runOnUiThread(() -> {
            if (!this.isShowing()) {
                Log.w("floating_toolbar", "onWidgetUpdated(): The widget isn't showing.");
                return;
            }
            this.updatePopupWindowContent(info);
            Rect contentRect = info.getContentRect();
            Point coords = this.getCoordinatesInWindow(contentRect.left, contentRect.top);
            if (DEBUG) {
                Log.v("floating_toolbar", "PopupWindow x= " + coords.x + " y= " + coords.y + " w=" + contentRect.width() + " h=" + contentRect.height());
            }
            this.mPopupWindow.update(coords.x, coords.y, contentRect.width(), contentRect.height());
        });
    }

    private void onToolbarShowTimeout() {
        this.runOnUiThread(() -> {
            if (this.mState == 3) {
                return;
            }
            this.doDismissPopupWindow();
        });
    }

    private void onMenuItemClicked(ToolbarMenuItem toolbarMenuItem) {
        this.runOnUiThread(() -> {
            if (this.mMenuItems == null || this.mMenuItemClickListener == null) {
                return;
            }
            MenuItem item = this.getMenuItemByToolbarMenuItem(toolbarMenuItem);
            if (DEBUG) {
                Log.v("floating_toolbar", "SelectionToolbarCallbackImpl onMenuItemClicked. toolbarMenuItem=" + toolbarMenuItem + " item=" + item);
            }
            if (item != null) {
                this.mMenuItemClickListener.onMenuItemClick(item);
            } else {
                Log.e("floating_toolbar", "onMenuItemClicked: cannot find menu item.");
            }
        });
    }

    private static class SelectionToolbarCallbackImpl
    extends ISelectionToolbarCallback.Stub {
        private final WeakReference<RemoteFloatingToolbarPopup> mRemotePopup;

        SelectionToolbarCallbackImpl(RemoteFloatingToolbarPopup popup) {
            this.mRemotePopup = new WeakReference<RemoteFloatingToolbarPopup>(popup);
        }

        @Override
        public void onShown(WidgetInfo info) {
            RemoteFloatingToolbarPopup remoteFloatingToolbarPopup;
            if (DEBUG) {
                Log.v("floating_toolbar", "SelectionToolbarCallbackImpl onShown: " + info);
            }
            if ((remoteFloatingToolbarPopup = (RemoteFloatingToolbarPopup)this.mRemotePopup.get()) != null) {
                remoteFloatingToolbarPopup.onShow(info);
            } else {
                Log.w("floating_toolbar", "Lost remoteFloatingToolbarPopup reference for onShown.");
            }
        }

        @Override
        public void onWidgetUpdated(WidgetInfo info) {
            RemoteFloatingToolbarPopup remoteFloatingToolbarPopup;
            if (DEBUG) {
                Log.v("floating_toolbar", "SelectionToolbarCallbackImpl onWidgetUpdated: info = " + info);
            }
            if ((remoteFloatingToolbarPopup = (RemoteFloatingToolbarPopup)this.mRemotePopup.get()) != null) {
                remoteFloatingToolbarPopup.onWidgetUpdated(info);
            } else {
                Log.w("floating_toolbar", "Lost remoteFloatingToolbarPopup reference for onWidgetUpdated.");
            }
        }

        @Override
        public void onToolbarShowTimeout() {
            RemoteFloatingToolbarPopup remoteFloatingToolbarPopup = (RemoteFloatingToolbarPopup)this.mRemotePopup.get();
            if (remoteFloatingToolbarPopup != null) {
                remoteFloatingToolbarPopup.onToolbarShowTimeout();
            } else {
                Log.w("floating_toolbar", "Lost remoteFloatingToolbarPopup reference for onToolbarShowTimeout.");
            }
        }

        @Override
        public void onMenuItemClicked(ToolbarMenuItem toolbarMenuItem) {
            RemoteFloatingToolbarPopup remoteFloatingToolbarPopup = (RemoteFloatingToolbarPopup)this.mRemotePopup.get();
            if (remoteFloatingToolbarPopup != null) {
                remoteFloatingToolbarPopup.onMenuItemClicked(toolbarMenuItem);
            } else {
                Log.w("floating_toolbar", "Lost remoteFloatingToolbarPopup reference for onMenuItemClicked.");
            }
        }

        @Override
        public void onError(int errorCode) {
            if (DEBUG) {
                Log.v("floating_toolbar", "SelectionToolbarCallbackImpl onError: " + errorCode);
            }
        }
    }

    static class MenuItemRepr {
        public final int mItemId;
        public final int mGroupId;
        public final String mTitle;
        private final Drawable mIcon;

        private MenuItemRepr(int itemId, int groupId, CharSequence title, Drawable icon) {
            this.mItemId = itemId;
            this.mGroupId = groupId;
            this.mTitle = title == null ? null : title.toString();
            this.mIcon = icon;
        }

        public static MenuItemRepr of(MenuItem menuItem) {
            return new MenuItemRepr(menuItem.getItemId(), menuItem.getGroupId(), menuItem.getTitle(), menuItem.getIcon());
        }

        public int hashCode() {
            return Objects.hash(this.mItemId, this.mGroupId, this.mTitle, this.mIcon);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LocalFloatingToolbarPopup.MenuItemRepr)) {
                return false;
            }
            MenuItemRepr other = (MenuItemRepr)o;
            return this.mItemId == other.mItemId && this.mGroupId == other.mGroupId && TextUtils.equals(this.mTitle, other.mTitle) && Objects.equals(this.mIcon, other.mIcon);
        }

        public static boolean reprEquals(Collection<MenuItem> menuItems1, Collection<MenuItem> menuItems2) {
            if (menuItems1.size() != menuItems2.size()) {
                return false;
            }
            Iterator<MenuItem> menuItems2Iter = menuItems2.iterator();
            for (MenuItem menuItem1 : menuItems1) {
                MenuItem menuItem2 = menuItems2Iter.next();
                if (MenuItemRepr.of(menuItem1).equals(MenuItemRepr.of(menuItem2))) continue;
                return false;
            }
            return true;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ToolbarState {
    }
}

