/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.android;

import android.app.WallpaperColors;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import com.android.ide.common.rendering.api.ILayoutLog;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.ResourceValueImpl;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.internal.graphics.ColorUtils;
import com.android.resources.ResourceType;
import com.android.systemui.monet.ColorScheme;
import com.android.systemui.monet.TonalPalette;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DynamicRenderResources
extends RenderResources {
    private final RenderResources mBaseResources;
    private Map<String, Integer> mDynamicColorMap;

    public DynamicRenderResources(RenderResources baseResources) {
        this.mBaseResources = baseResources;
    }

    public void setLogger(ILayoutLog logger) {
        this.mBaseResources.setLogger(logger);
    }

    public StyleResourceValue getDefaultTheme() {
        return this.mBaseResources.getDefaultTheme();
    }

    public void applyStyle(StyleResourceValue theme, boolean useAsPrimary) {
        this.mBaseResources.applyStyle(theme, useAsPrimary);
    }

    public void clearStyles() {
        this.mBaseResources.clearStyles();
    }

    public List<StyleResourceValue> getAllThemes() {
        return this.mBaseResources.getAllThemes();
    }

    public ResourceValue findItemInTheme(ResourceReference attr2) {
        ResourceValue baseValue = this.mBaseResources.findItemInTheme(attr2);
        return this.resolveDynamicColors(baseValue);
    }

    public ResourceValue findItemInStyle(StyleResourceValue style2, ResourceReference attr2) {
        ResourceValue baseValue = this.mBaseResources.findItemInStyle(style2, attr2);
        return this.resolveDynamicColors(baseValue);
    }

    public ResourceValue findResValue(String reference, boolean forceFrameworkOnly) {
        ResourceValue baseValue = this.mBaseResources.findResValue(reference, forceFrameworkOnly);
        return this.resolveDynamicColors(baseValue);
    }

    public ResourceValue dereference(ResourceValue resourceValue) {
        ResourceValue baseValue = this.mBaseResources.dereference(resourceValue);
        return this.resolveDynamicColors(baseValue);
    }

    public ResourceValue getUnresolvedResource(ResourceReference reference) {
        ResourceValue baseValue = this.mBaseResources.getUnresolvedResource(reference);
        return this.resolveDynamicColors(baseValue);
    }

    public ResourceValue getResolvedResource(ResourceReference reference) {
        ResourceValue baseValue = this.mBaseResources.getResolvedResource(reference);
        return this.resolveDynamicColors(baseValue);
    }

    public ResourceValue resolveResValue(ResourceValue value) {
        ResourceValue baseValue = this.mBaseResources.resolveResValue(value);
        return this.resolveDynamicColors(baseValue);
    }

    public StyleResourceValue getParent(StyleResourceValue style2) {
        return this.mBaseResources.getParent(style2);
    }

    public StyleResourceValue getStyle(ResourceReference reference) {
        return this.mBaseResources.getStyle(reference);
    }

    private ResourceValue resolveDynamicColors(ResourceValue baseValue) {
        if (this.hasDynamicColors() && baseValue != null && DynamicRenderResources.isDynamicColor(baseValue)) {
            int dynamicColor = this.mDynamicColorMap.get(baseValue.getName());
            String colorHex = "#" + Integer.toHexString(dynamicColor).substring(2);
            return new ResourceValueImpl(baseValue.getNamespace(), baseValue.getResourceType(), baseValue.getName(), colorHex);
        }
        return baseValue;
    }

    public void setWallpaper(String wallpaperPath, boolean isNightMode) {
        if (wallpaperPath == null) {
            this.mDynamicColorMap = null;
            return;
        }
        this.mDynamicColorMap = DynamicRenderResources.createDynamicColorMap(wallpaperPath, isNightMode);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Map<String, Integer> createDynamicColorMap(String wallpaperPath, boolean isNightMode) {
        try (InputStream stream = DynamicRenderResources.class.getResourceAsStream(wallpaperPath);){
            Bitmap wallpaper = BitmapFactory.decodeStream(stream);
            if (wallpaper == null) {
                Map<String, Integer> map = null;
                return map;
            }
            WallpaperColors wallpaperColors = WallpaperColors.fromBitmap(wallpaper);
            int seed = ColorScheme.getSeedColor(wallpaperColors);
            ColorScheme scheme = new ColorScheme(seed, isNightMode);
            HashMap<String, Integer> dynamicColorMap = new HashMap<String, Integer>();
            DynamicRenderResources.extractPalette("accent1", dynamicColorMap, scheme.getAccent1());
            DynamicRenderResources.extractPalette("accent2", dynamicColorMap, scheme.getAccent2());
            DynamicRenderResources.extractPalette("accent3", dynamicColorMap, scheme.getAccent3());
            DynamicRenderResources.extractPalette("neutral1", dynamicColorMap, scheme.getNeutral1());
            DynamicRenderResources.extractPalette("neutral2", dynamicColorMap, scheme.getNeutral2());
            HashMap<String, Integer> hashMap = dynamicColorMap;
            return hashMap;
        }
        catch (IOException | IllegalArgumentException ignore) {
            return null;
        }
    }

    private static void extractPalette(String name, Map<String, Integer> colorMap, TonalPalette tonalPalette) {
        String resourcePrefix = "system_" + name;
        tonalPalette.getAllShadesMapped().forEach((key, value) -> {
            String resourceName = resourcePrefix + "_" + key;
            int colorValue = ColorUtils.setAlphaComponent(value, 255);
            colorMap.put(resourceName, colorValue);
        });
        colorMap.put(resourcePrefix + "_0", -1);
    }

    private static boolean isDynamicColor(ResourceValue resourceValue) {
        if (!resourceValue.isFramework() || resourceValue.getResourceType() != ResourceType.COLOR) {
            return false;
        }
        return resourceValue.getName().startsWith("system_accent") || resourceValue.getName().startsWith("system_neutral");
    }

    public boolean hasDynamicColors() {
        return this.mDynamicColorMap != null;
    }
}

