/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.bars;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.InflateException;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ActionMenuPresenter;
import android.widget.FrameLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.RelativeLayout;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.SessionParams;
import com.android.internal.R;
import com.android.internal.view.menu.MenuBuilder;
import com.android.internal.view.menu.MenuItemImpl;
import com.android.layoutlib.bridge.android.BridgeContext;
import com.android.layoutlib.bridge.bars.BridgeActionBar;
import com.android.layoutlib.bridge.bars.FrameworkActionBarWrapper;
import com.android.layoutlib.bridge.bars.OverflowMenuAdapter;
import com.android.layoutlib.bridge.impl.ResourceHelper;
import java.util.ArrayList;

public class FrameworkActionBar
extends BridgeActionBar {
    private static final String LAYOUT_ATTR_NAME = "windowActionBarFullscreenDecorLayout";
    private FrameworkActionBarWrapper mActionBar;
    private ViewGroup mMeasureParent;

    public FrameworkActionBar(BridgeContext context, SessionParams params) {
        super(context, params);
        View decorContent = this.getDecorContent();
        this.mActionBar = FrameworkActionBarWrapper.getActionBarWrapper(context, this.getCallBack(), decorContent);
        FrameLayout contentRoot = (FrameLayout)decorContent.findViewById(0x1020002);
        if (contentRoot == null) {
            contentRoot = new FrameLayout(context);
            FrameworkActionBar.setMatchParent(contentRoot);
            if (this.mEnclosingLayout != null) {
                this.mEnclosingLayout.addView(contentRoot);
            }
            this.setContentRoot(contentRoot);
        } else {
            this.setContentRoot(contentRoot);
            this.setupActionBar();
            this.mActionBar.inflateMenus();
        }
    }

    @Override
    protected ResourceValue getLayoutResource(BridgeContext context) {
        ResourceValue layoutName = context.getRenderResources().findItemInTheme(BridgeContext.createFrameworkAttrReference(LAYOUT_ATTR_NAME));
        if (layoutName != null) {
            layoutName = context.getRenderResources().dereference(layoutName);
        }
        if (layoutName == null) {
            throw new InflateException("Unable to find action bar layout (windowActionBarFullscreenDecorLayout) in the current theme.");
        }
        return layoutName;
    }

    @Override
    protected void setupActionBar() {
        super.setupActionBar();
        this.mActionBar.setupActionBar();
    }

    @Override
    protected void setHomeAsUp(boolean homeAsUp) {
        this.mActionBar.setHomeAsUp(homeAsUp);
    }

    @Override
    protected void setTitle(CharSequence title) {
        this.mActionBar.setTitle(title);
    }

    @Override
    protected void setSubtitle(CharSequence subtitle) {
        this.mActionBar.setSubTitle(subtitle);
    }

    @Override
    protected void setIcon(ResourceValue icon) {
        this.mActionBar.setIcon(icon);
    }

    @Override
    public void createMenuPopup() {
        if (!this.isOverflowPopupNeeded()) {
            return;
        }
        DisplayMetrics metrics = this.mBridgeContext.getMetrics();
        MenuBuilder menu2 = this.mActionBar.getMenuBuilder();
        OverflowMenuAdapter adapter = new OverflowMenuAdapter(menu2, this.mActionBar.getPopupContext());
        ListView listView = new ListView(this.mActionBar.getPopupContext(), null, 16842861);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(this.measureContentWidth(adapter), -2);
        layoutParams.addRule(21);
        if (this.mActionBar.isSplit()) {
            layoutParams.addRule(12);
            layoutParams.bottomMargin = this.getActionBarHeight() + this.mActionBar.getMenuPopupMargin();
        } else {
            layoutParams.addRule(10);
            layoutParams.topMargin = this.getActionBarHeight() + this.mActionBar.getMenuPopupMargin();
        }
        layoutParams.setMarginEnd(FrameworkActionBar.getPixelValue("5dp", metrics));
        listView.setLayoutParams(layoutParams);
        listView.setAdapter(adapter);
        TypedArray a = this.mActionBar.getPopupContext().obtainStyledAttributes(null, R.styleable.PopupWindow, 0x1010300, 0);
        listView.setBackground(a.getDrawable(0));
        listView.setDivider(a.getDrawable(16843675));
        a.recycle();
        listView.setElevation(this.mActionBar.getMenuPopupElevation());
        assert (this.mEnclosingLayout != null) : "Unable to find view to attach ActionMenuPopup.";
        this.mEnclosingLayout.addView(listView);
    }

    private boolean isOverflowPopupNeeded() {
        boolean needed = this.mActionBar.isOverflowPopupNeeded();
        if (!needed) {
            return false;
        }
        ArrayList<MenuItemImpl> menus = this.mActionBar.getMenuBuilder().getNonActionItems();
        ActionMenuPresenter presenter = this.mActionBar.getActionMenuPresenter();
        if (presenter == null) {
            assert (false) : "Failed to create a Presenter for Action Bar Menus.";
            return false;
        }
        if (presenter.isOverflowReserved() && menus != null) {
            int count = menus.size();
            needed = count == 1 ? !((MenuItemImpl)menus.get(0)).isActionViewExpanded() : count > 0;
        }
        return needed;
    }

    private int measureContentWidth(ListAdapter adapter) {
        int maxWidth = 0;
        View itemView = null;
        int itemType = 0;
        Context context = this.mActionBar.getPopupContext();
        int widthMeasureSpec = View.MeasureSpec.makeMeasureSpec(0, 0);
        int heightMeasureSpec = View.MeasureSpec.makeMeasureSpec(0, 0);
        int count = adapter.getCount();
        for (int i = 0; i < count; ++i) {
            int positionType = adapter.getItemViewType(i);
            if (positionType != itemType) {
                itemType = positionType;
                itemView = null;
            }
            if (this.mMeasureParent == null) {
                this.mMeasureParent = new FrameLayout(context);
            }
            itemView = adapter.getView(i, itemView, this.mMeasureParent);
            itemView.measure(widthMeasureSpec, heightMeasureSpec);
            int itemWidth = itemView.getMeasuredWidth();
            int popupMaxWidth = Math.max(this.mBridgeContext.getMetrics().widthPixels / 2, context.getResources().getDimensionPixelSize(17105103));
            if (itemWidth >= popupMaxWidth) {
                return popupMaxWidth;
            }
            if (itemWidth <= maxWidth) continue;
            maxWidth = itemWidth;
        }
        return maxWidth;
    }

    static int getPixelValue(String value, DisplayMetrics metrics) {
        TypedValue typedValue = ResourceHelper.getValue(null, value, false);
        return (int)typedValue.getDimension(metrics);
    }

    private int getActionBarHeight() {
        TypedValue typedValue;
        RenderResources resources = this.mBridgeContext.getRenderResources();
        DisplayMetrics metrics = this.mBridgeContext.getMetrics();
        ResourceValue value = resources.findItemInTheme(BridgeContext.createFrameworkAttrReference("actionBarSize"));
        if ((value = resources.resolveResValue(value)) != null && (typedValue = ResourceHelper.getValue("actionBarSize", value.getValue(), true)) != null) {
            return (int)typedValue.getDimension(metrics);
        }
        return 0;
    }
}

