/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.impl;

import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.AnimatedVectorDrawable_VectorDrawableAnimatorUI_Delegate;
import android.media.Image;
import android.media.ImageReader;
import android.os._Original_Build;
import android.preference.Preference_Delegate;
import android.util.DisplayMetrics;
import android.util.Pair;
import android.view.AttachInfo_Accessor;
import android.view.BridgeInflater;
import android.view.LayoutlibRenderer;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewRootImpl;
import android.view.ViewRootImpl_Accessor;
import android.view.WindowManagerImpl;
import android.widget.ActionMenuView;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.QuickContactBadge;
import android.widget.TabHost;
import android.widget.TabWidget;
import com.android.ide.common.rendering.api.HardwareConfig;
import com.android.ide.common.rendering.api.ILayoutPullParser;
import com.android.ide.common.rendering.api.LayoutlibCallback;
import com.android.ide.common.rendering.api.RenderSession;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.Result;
import com.android.ide.common.rendering.api.SessionParams;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.ide.common.rendering.api.ViewType;
import com.android.internal.R;
import com.android.internal.view.menu.ActionMenuItemView;
import com.android.internal.view.menu.BridgeMenuItemImpl;
import com.android.internal.view.menu.IconMenuItemView;
import com.android.internal.view.menu.ListMenuItemView;
import com.android.internal.view.menu.MenuItemImpl;
import com.android.internal.view.menu.MenuView;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.android.BridgeContext;
import com.android.layoutlib.bridge.android.BridgeXmlBlockParser;
import com.android.layoutlib.bridge.android.RenderParamsFlags;
import com.android.layoutlib.bridge.android.graphics.NopCanvas;
import com.android.layoutlib.bridge.android.support.DesignLibUtil;
import com.android.layoutlib.bridge.android.support.FragmentTabHostUtil;
import com.android.layoutlib.bridge.android.support.SupportPreferencesUtil;
import com.android.layoutlib.bridge.impl.Layout;
import com.android.layoutlib.bridge.impl.RenderAction;
import com.android.layoutlib.bridge.impl.SystemViewInfo;
import com.android.layoutlib.bridge.util.KeyEventHandling;
import com.android.layoutlib.common.util.ReflectionUtils;
import com.android.tools.idea.validator.LayoutValidator;
import com.android.tools.idea.validator.ValidatorHierarchy;
import com.android.tools.idea.validator.hierarchy.CustomHierarchyHelper;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.xmlpull.v1.XmlPullParser;

public class RenderSessionImpl
extends RenderAction<SessionParams> {
    private static final Canvas NOP_CANVAS = new NopCanvas();
    private static final String SIMULATED_SDK_TOO_HIGH = String.format("The current rendering only supports APIs up to %d. You may encounter crashes if using with higher APIs. To avoid, you can set a lower API for your previews.", _Original_Build.VERSION.SDK_INT);
    private RenderSession mScene;
    private BridgeXmlBlockParser mBlockParser;
    private BridgeInflater mInflater;
    private ViewGroup mViewRoot;
    private FrameLayout mContentRoot;
    private int mMeasuredScreenWidth = -1;
    private int mMeasuredScreenHeight = -1;
    private long mElapsedFrameTimeNanos = -1L;
    private boolean mFirstFrameExecuted = false;
    private BufferedImage mImage;
    private List<ViewInfo> mViewInfoList;
    private List<ViewInfo> mSystemViewInfoList;
    private Layout.Builder mLayoutBuilder;
    private boolean mNewRenderSize;
    private ImageReader mImageReader;
    private Image mNativeImage;
    private LayoutlibRenderer mRenderer;
    private final MotionEvent.PointerProperties[] mPointerProperties = MotionEvent.PointerProperties.createArray(1);
    private final MotionEvent.PointerCoords[] mPointerCoords = MotionEvent.PointerCoords.createArray(1);
    private long mLastActionDownTimeNanos = -1L;
    private ValidatorHierarchy mValidatorHierarchy = null;

    public RenderSessionImpl(SessionParams params) {
        super(new SessionParams(params));
    }

    @Override
    public Result init(long timeout) {
        Result result = super.init(timeout);
        if (!result.isSuccess()) {
            return result;
        }
        SessionParams params = (SessionParams)this.getParams();
        BridgeContext context = this.getContext();
        this.mLayoutBuilder = new Layout.Builder(params, context);
        this.mInflater = new BridgeInflater(context, params.getLayoutlibCallback());
        context.setBridgeInflater(this.mInflater);
        ILayoutPullParser layoutParser = params.getLayoutDescription();
        this.mBlockParser = new BridgeXmlBlockParser((XmlPullParser)layoutParser, context, layoutParser.getLayoutNamespace());
        Bitmap.setDefaultDensity(params.getHardwareConfig().getDensity().getDpiValue());
        ImageReader.nativeClassInit();
        return Result.Status.SUCCESS.createResult();
    }

    private void measureLayout(SessionParams params) {
        SessionParams.RenderingMode renderingMode;
        int previousWidth = this.mMeasuredScreenWidth;
        int previousHeight = this.mMeasuredScreenHeight;
        HardwareConfig hardwareConfig = params.getHardwareConfig();
        if (this.mMeasuredScreenWidth == -1) {
            this.mMeasuredScreenWidth = hardwareConfig.getScreenWidth();
            this.mMeasuredScreenHeight = hardwareConfig.getScreenHeight();
        }
        if ((renderingMode = params.getRenderingMode()) != SessionParams.RenderingMode.NORMAL) {
            int widthMeasureSpecMode = renderingMode.getHorizAction() == SessionParams.RenderingMode.SizeAction.EXPAND ? 0 : 0x40000000;
            int heightMeasureSpecMode = renderingMode.getVertAction() == SessionParams.RenderingMode.SizeAction.EXPAND ? 0 : 0x40000000;
            View measuredView = this.mContentRoot.getChildAt(0);
            if (measuredView == null) {
                return;
            }
            int maxWidth = hardwareConfig.getScreenWidth();
            int maxHeight = hardwareConfig.getScreenHeight();
            Pair<Integer, Integer> exactMeasure = RenderSessionImpl.measureView(this.mViewRoot, measuredView, maxWidth, 0x40000000, maxHeight, 0x40000000);
            Pair<Integer, Integer> neededMeasure = RenderSessionImpl.measureView(this.mContentRoot, measuredView, maxWidth, widthMeasureSpecMode, maxHeight, heightMeasureSpecMode);
            assert (exactMeasure != null && neededMeasure != null);
            this.mMeasuredScreenWidth = RenderSessionImpl.calcSize(this.mMeasuredScreenWidth, (Integer)neededMeasure.first, (Integer)exactMeasure.first, renderingMode.getHorizAction());
            this.mMeasuredScreenHeight = RenderSessionImpl.calcSize(this.mMeasuredScreenHeight, (Integer)neededMeasure.second, (Integer)exactMeasure.second, renderingMode.getVertAction());
        }
        this.mNewRenderSize = this.mMeasuredScreenWidth != previousWidth || this.mMeasuredScreenHeight != previousHeight;
    }

    private static int calcSize(int currentSize, int neededSize, int measuredSize, SessionParams.RenderingMode.SizeAction action) {
        if (action == SessionParams.RenderingMode.SizeAction.EXPAND) {
            if (neededSize > measuredSize) {
                currentSize += neededSize - measuredSize;
            }
            if (currentSize < measuredSize) {
                currentSize = measuredSize;
            }
        } else if (action == SessionParams.RenderingMode.SizeAction.SHRINK) {
            currentSize = neededSize;
        }
        return currentSize;
    }

    public Result inflate() {
        this.checkLock();
        try {
            View view;
            String rootTag;
            boolean isPreference;
            this.mViewRoot = new Layout(this.mLayoutBuilder);
            this.mLayoutBuilder = null;
            this.mContentRoot = ((Layout)this.mViewRoot).getContentRoot();
            SessionParams params = (SessionParams)this.getParams();
            BridgeContext context = this.getContext();
            int simulatedVersion = params.getSimulatedPlatformVersion();
            int n = sSimulatedSdk = simulatedVersion > 0 ? simulatedVersion : _Original_Build.VERSION.SDK_INT;
            if (sSimulatedSdk > _Original_Build.VERSION.SDK_INT) {
                Bridge.getLog().fidelityWarning("unsupported", SIMULATED_SDK_TOO_HIGH, null, null, null);
            }
            if (Bridge.isLocaleRtl(params.getLocale())) {
                if (!params.isRtlSupported()) {
                    Bridge.getLog().warning("rtl-not-enabled", "You are using a right-to-left (RTL) locale but RTL is not enabled", null, null);
                } else if (params.getSimulatedPlatformVersion() != 0 && params.getSimulatedPlatformVersion() < 17) {
                    Bridge.getLog().warning("rtl-not-supported", "You are using a right-to-left (RTL) locale but RTL is not supported for API level < 17", null, null);
                }
            }
            boolean bl = isPreference = "PreferenceScreen".equals(rootTag = (String)params.getFlag(RenderParamsFlags.FLAG_KEY_ROOT_TAG)) || SupportPreferencesUtil.isSupportRootTag(rootTag);
            if (isPreference) {
                view = SupportPreferencesUtil.inflatePreference(context, this.mBlockParser, this.mContentRoot);
                if (view == null) {
                    view = Preference_Delegate.inflatePreference(context, this.mBlockParser, this.mContentRoot);
                }
            } else {
                view = this.mInflater.inflate(this.mBlockParser, (ViewGroup)this.mContentRoot);
            }
            context.popParser();
            this.mRenderer = AttachInfo_Accessor.setAttachInfo(this.mViewRoot);
            this.postInflateProcess(view, params.getLayoutlibCallback(), isPreference ? view : null);
            this.mInflater.onDoneInflation();
            this.setActiveToolbar(view, context, params);
            this.measureLayout(params);
            RenderSessionImpl.measureView(this.mViewRoot, null, this.mMeasuredScreenWidth, 0x40000000, this.mMeasuredScreenHeight, 0x40000000);
            this.mViewRoot.layout(0, 0, this.mMeasuredScreenWidth, this.mMeasuredScreenHeight);
            this.mViewRoot.getViewRootImpl().mTmpFrames.displayFrame.set(this.mViewRoot.getLeft(), this.mViewRoot.getTop(), this.mViewRoot.getRight(), this.mViewRoot.getBottom());
            this.mSystemViewInfoList = this.visitAllChildren(this.mViewRoot, 0, 0, params, false);
            return Result.Status.SUCCESS.createResult();
        }
        catch (PostInflateException e) {
            return Result.Status.ERROR_INFLATION.createResult(e.getMessage(), (Throwable)e);
        }
        catch (Throwable e) {
            Throwable t = e;
            while (t.getCause() != null) {
                t = t.getCause();
            }
            return Result.Status.ERROR_INFLATION.createResult(t.getMessage(), t);
        }
    }

    public void setElapsedFrameTimeNanos(long nanos) {
        this.mElapsedFrameTimeNanos = nanos;
    }

    private static void doLayout(BridgeContext context, ViewGroup viewRoot, int width, int height) {
        RenderSessionImpl.measureView(viewRoot, null, width, 0x40000000, height, 0x40000000);
        viewRoot.layout(0, 0, width, height);
        RenderSessionImpl.handleScrolling(context, viewRoot);
    }

    public Result render(boolean freshRender) {
        return this.renderAndBuildResult(freshRender, false);
    }

    public Result measure() {
        return this.renderAndBuildResult(false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result renderAndBuildResult(boolean freshRender, boolean onlyMeasure) {
        this.checkLock();
        SessionParams params = (SessionParams)this.getParams();
        int simulatedVersion = params.getSimulatedPlatformVersion();
        int n = sSimulatedSdk = simulatedVersion > 0 ? simulatedVersion : _Original_Build.VERSION.SDK_INT;
        if (sSimulatedSdk > _Original_Build.VERSION.SDK_INT) {
            Bridge.getLog().fidelityWarning("unsupported", SIMULATED_SDK_TOO_HIGH, null, null, null);
        }
        try {
            if (this.mViewRoot == null || this.mRenderer == null) {
                return Result.Status.ERROR_NOT_INFLATED.createResult();
            }
            this.measureLayout(params);
            float scaleX = 1.0f;
            float scaleY = 1.0f;
            if (onlyMeasure) {
                this.mImage = null;
                this.disposeImageSurface();
                RenderSessionImpl.doLayout(this.getContext(), this.mViewRoot, this.mMeasuredScreenWidth, this.mMeasuredScreenHeight);
            } else {
                boolean disableBitmapCaching = Boolean.TRUE.equals(params.getFlag(RenderParamsFlags.FLAG_KEY_DISABLE_BITMAP_CACHING));
                if (this.mNewRenderSize || this.mImageReader == null || disableBitmapCaching) {
                    boolean enableImageResizing;
                    this.mImage = params.getImageFactory() != null ? params.getImageFactory().getImage(this.mMeasuredScreenWidth, this.mMeasuredScreenHeight) : new BufferedImage(this.mMeasuredScreenWidth, this.mMeasuredScreenHeight, 3);
                    assert (this.mImage.getType() == 3);
                    boolean bl = enableImageResizing = this.mImage.getWidth() != this.mMeasuredScreenWidth && this.mImage.getHeight() != this.mMeasuredScreenHeight && Boolean.TRUE.equals(params.getFlag(RenderParamsFlags.FLAG_KEY_RESULT_IMAGE_AUTO_SCALE));
                    if (enableImageResizing || this.mNewRenderSize) {
                        this.disposeImageSurface();
                    }
                    if (enableImageResizing) {
                        scaleX = (float)this.mImage.getWidth() * 1.0f / (float)this.mMeasuredScreenWidth;
                        scaleY = (float)this.mImage.getHeight() * 1.0f / (float)this.mMeasuredScreenHeight;
                        this.mRenderer.setScale(scaleX, scaleY);
                    } else {
                        this.mRenderer.setScale(1.0f, 1.0f);
                    }
                    if (this.mImageReader == null) {
                        this.mImageReader = ImageReader.newInstance(this.mImage.getWidth(), this.mImage.getHeight(), 1, 1);
                        this.mRenderer.setSurface(this.mImageReader.getSurface());
                        this.mNativeImage = this.mImageReader.acquireNextImage();
                    }
                    this.mNewRenderSize = false;
                }
                RenderSessionImpl.doLayout(this.getContext(), this.mViewRoot, this.mMeasuredScreenWidth, this.mMeasuredScreenHeight);
                if (this.mElapsedFrameTimeNanos >= 0L) {
                    if (!this.mFirstFrameExecuted) {
                        AttachInfo_Accessor.dispatchOnPreDraw(this.mViewRoot);
                        this.mViewRoot.draw(NOP_CANVAS);
                        this.mFirstFrameExecuted = true;
                    }
                    AnimatedVectorDrawable_VectorDrawableAnimatorUI_Delegate.sFrameTime = this.mElapsedFrameTimeNanos / 1000000L;
                }
                TypedArray a = this.getContext().obtainStyledAttributes(null, R.styleable.Lighting, 0, 0);
                float lightY = a.getDimension(3, 0.0f);
                float lightZ = a.getDimension(4, 0.0f);
                DisplayMetrics displayMetrics = this.getContext().getMetrics();
                float zRatio = (float)Math.min(displayMetrics.widthPixels, displayMetrics.heightPixels) / (450.0f * displayMetrics.density);
                float zWeightedAdjustment = (zRatio + 2.0f) / 3.0f;
                float lightRadius = a.getDimension(2, 0.0f);
                float ambientShadowAlpha = a.getFloat(0, 0.0f);
                float spotShadowAlpha = a.getFloat(1, 0.0f);
                a.recycle();
                this.mRenderer.setLightSourceGeometry(this.mMeasuredScreenWidth / 2, lightY, lightZ *= zWeightedAdjustment, lightRadius);
                this.mRenderer.setLightSourceAlpha(ambientShadowAlpha, spotShadowAlpha);
                this.mRenderer.draw(this.mViewRoot);
                int[] imageData = ((DataBufferInt)this.mImage.getRaster().getDataBuffer()).getData();
                Image.Plane[] planes = this.mNativeImage.getPlanes();
                IntBuffer buff = planes[0].getBuffer().asIntBuffer();
                int len = buff.remaining();
                buff.get(imageData, 0, len);
            }
            this.mSystemViewInfoList = this.visitAllChildren(this.mViewRoot, 0, 0, params, false);
            Consumer imageTransformation = ((SessionParams)this.getParams()).getImageTransformation();
            if (imageTransformation != null) {
                imageTransformation.accept(this.mImage);
            }
            boolean enableLayoutValidation = Boolean.TRUE.equals(params.getFlag(RenderParamsFlags.FLAG_ENABLE_LAYOUT_VALIDATOR));
            boolean enableLayoutValidationImageCheck = Boolean.TRUE.equals(params.getFlag(RenderParamsFlags.FLAG_ENABLE_LAYOUT_VALIDATOR_IMAGE_CHECK));
            try {
                if (enableLayoutValidation && !this.getViewInfos().isEmpty()) {
                    CustomHierarchyHelper.sLayoutlibCallback = this.getContext().getLayoutlibCallback();
                    BufferedImage imageToPass = enableLayoutValidationImageCheck ? this.getImage() : null;
                    ValidatorHierarchy hierarchy = LayoutValidator.buildHierarchy((View)this.getViewInfos().get(0).getViewObject(), imageToPass, scaleX, scaleY);
                    this.setValidatorHierarchy(hierarchy);
                }
            }
            catch (Throwable e) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                ValidatorHierarchy hierarchy = new ValidatorHierarchy();
                hierarchy.mErrorMessage = sw.toString();
                this.setValidatorHierarchy(hierarchy);
            }
            finally {
                CustomHierarchyHelper.sLayoutlibCallback = null;
            }
            return Result.Status.SUCCESS.createResult();
        }
        catch (Throwable e) {
            Throwable t = e;
            while (t.getCause() != null) {
                t = t.getCause();
            }
            return Result.Status.ERROR_UNKNOWN.createResult(t.getMessage(), t);
        }
    }

    private static Pair<Integer, Integer> measureView(ViewGroup viewToMeasure, View measuredView, int width, int widthMode, int height, int heightMode) {
        int w_spec = View.MeasureSpec.makeMeasureSpec(width, widthMode);
        int h_spec = View.MeasureSpec.makeMeasureSpec(height, heightMode);
        viewToMeasure.measure(w_spec, h_spec);
        if (measuredView != null) {
            return Pair.create(measuredView.getMeasuredWidth(), measuredView.getMeasuredHeight());
        }
        return null;
    }

    private void postInflateProcess(View view, LayoutlibCallback layoutlibCallback, View skip) throws PostInflateException {
        if (view == skip) {
            return;
        }
        if (view instanceof TabHost) {
            this.setupTabHost((TabHost)view, layoutlibCallback);
        } else if (view instanceof QuickContactBadge) {
            QuickContactBadge badge = (QuickContactBadge)view;
            badge.setImageToDefault();
        } else if (view instanceof ViewGroup) {
            this.mInflater.postInflateProcess(view);
            ViewGroup group = (ViewGroup)view;
            int count = group.getChildCount();
            for (int c = 0; c < count; ++c) {
                View child = group.getChildAt(c);
                this.postInflateProcess(child, layoutlibCallback, skip);
            }
        }
    }

    private void setActiveToolbar(View view, BridgeContext context, SessionParams params) {
        View coordinatorLayout = this.findChildView(view, DesignLibUtil.CN_COORDINATOR_LAYOUT);
        if (coordinatorLayout == null) {
            return;
        }
        View appBar = this.findChildView(coordinatorLayout, DesignLibUtil.CN_APPBAR_LAYOUT);
        if (appBar == null) {
            return;
        }
        ViewGroup collapsingToolbar = (ViewGroup)this.findChildView(appBar, DesignLibUtil.CN_COLLAPSING_TOOLBAR_LAYOUT);
        if (collapsingToolbar == null) {
            return;
        }
        if (!this.hasToolbar(collapsingToolbar)) {
            return;
        }
        String title = params.getAppLabel();
        DesignLibUtil.setTitle(collapsingToolbar, title);
    }

    private View findChildView(View view, String[] className) {
        if (!(view instanceof ViewGroup)) {
            return null;
        }
        ViewGroup group = (ViewGroup)view;
        for (int i = 0; i < group.getChildCount(); ++i) {
            if (!ReflectionUtils.isInstanceOf((Object)group.getChildAt(i), className)) continue;
            return group.getChildAt(i);
        }
        return null;
    }

    private boolean hasToolbar(View collapsingToolbar) {
        if (!(collapsingToolbar instanceof ViewGroup)) {
            return false;
        }
        ViewGroup group = (ViewGroup)collapsingToolbar;
        for (int i = 0; i < group.getChildCount(); ++i) {
            if (!ReflectionUtils.isInstanceOf((Object)group.getChildAt(i), DesignLibUtil.CN_TOOLBAR)) continue;
            return true;
        }
        return false;
    }

    private static void handleScrolling(BridgeContext context, View view) {
        int scrollPosX = context.getScrollXPos(view);
        int scrollPosY = context.getScrollYPos(view);
        if (scrollPosX != 0 || scrollPosY != 0) {
            if (view.isNestedScrollingEnabled()) {
                int[] consumed = new int[2];
                int axis = scrollPosX != 0 ? 1 : 0;
                if (view.startNestedScroll(axis |= scrollPosY != 0 ? 2 : 0)) {
                    view.dispatchNestedPreScroll(scrollPosX, scrollPosY, consumed, null);
                    view.dispatchNestedScroll(consumed[0], consumed[1], scrollPosX, scrollPosY, null);
                    view.stopNestedScroll();
                    scrollPosX -= consumed[0];
                    scrollPosY -= consumed[1];
                }
            }
            if (scrollPosX != 0 || scrollPosY != 0) {
                view.scrollTo(scrollPosX, scrollPosY);
            }
        }
        if (!(view instanceof ViewGroup)) {
            return;
        }
        ViewGroup group = (ViewGroup)view;
        for (int i = 0; i < group.getChildCount(); ++i) {
            View child = group.getChildAt(i);
            RenderSessionImpl.handleScrolling(context, child);
        }
    }

    private void setupTabHost(TabHost tabHost, LayoutlibCallback layoutlibCallback) throws PostInflateException {
        Object v = tabHost.findViewById(16908307);
        if (v == null) {
            throw new PostInflateException("TabHost requires a TabWidget with id \"android:id/tabs\".\n");
        }
        if (!(v instanceof TabWidget)) {
            throw new PostInflateException(String.format("TabHost requires a TabWidget with id \"android:id/tabs\".\nView found with id 'tabs' is '%s'", v.getClass().getCanonicalName()));
        }
        v = tabHost.findViewById(0x1020011);
        if (v == null) {
            throw new PostInflateException("TabHost requires a FrameLayout with id \"android:id/tabcontent\".");
        }
        if (!(v instanceof FrameLayout)) {
            throw new PostInflateException(String.format("TabHost requires a FrameLayout with id \"android:id/tabcontent\".\nView found with id 'tabcontent' is '%s'", v.getClass().getCanonicalName()));
        }
        FrameLayout content = (FrameLayout)v;
        int count = content.getChildCount();
        if (ReflectionUtils.isInstanceOf((Object)tabHost, FragmentTabHostUtil.CN_FRAGMENT_TAB_HOST)) {
            FragmentTabHostUtil.setup(tabHost, this.getContext());
        } else {
            tabHost.setup();
        }
        if (count == 0) {
            TabHost.TabSpec spec = tabHost.newTabSpec("tag").setIndicator("Tab Label", tabHost.getResources().getDrawable(17301569, null)).setContent(tag -> new LinearLayout(this.getContext()));
            tabHost.addTab(spec);
        } else {
            for (int i = 0; i < count; ++i) {
                View child = content.getChildAt(i);
                String tabSpec = String.format("tab_spec%d", i + 1);
                int id2 = child.getId();
                ResourceReference resource = layoutlibCallback.resolveResourceId(id2);
                String name = resource != null ? resource.getName() : String.format("Tab %d", i + 1);
                tabHost.addTab(tabHost.newTabSpec(tabSpec).setIndicator(name).setContent(id2));
            }
        }
    }

    private ViewInfo visit(View view, int hOffset, int vOffset, SessionParams params, boolean isContentFrame) {
        ViewInfo result = this.createViewInfo(view, hOffset, vOffset, params.getExtendedViewInfoMode(), isContentFrame);
        if (view instanceof ViewGroup) {
            ViewGroup group = (ViewGroup)view;
            result.setChildren(this.visitAllChildren(group, isContentFrame ? 0 : hOffset, isContentFrame ? 0 : vOffset, params, isContentFrame));
        }
        return result;
    }

    private List<ViewInfo> visitAllChildren(ViewGroup viewGroup, int hOffset, int vOffset, SessionParams params, boolean isContentFrame) {
        if (viewGroup == null) {
            return null;
        }
        if (!isContentFrame) {
            vOffset += viewGroup.getTop();
            hOffset += viewGroup.getLeft();
        }
        int childCount = viewGroup.getChildCount();
        if (viewGroup == this.mContentRoot) {
            ArrayList<ViewInfo> childrenWithoutOffset = new ArrayList<ViewInfo>(childCount);
            ArrayList<ViewInfo> childrenWithOffset = new ArrayList<ViewInfo>(childCount);
            for (int i = 0; i < childCount; ++i) {
                ViewInfo[] childViewInfo = this.visitContentRoot(viewGroup.getChildAt(i), hOffset, vOffset, params);
                childrenWithoutOffset.add(childViewInfo[0]);
                childrenWithOffset.add(childViewInfo[1]);
            }
            this.mViewInfoList = childrenWithOffset;
            return childrenWithoutOffset;
        }
        ArrayList<ViewInfo> children = new ArrayList<ViewInfo>(childCount);
        for (int i = 0; i < childCount; ++i) {
            children.add(this.visit(viewGroup.getChildAt(i), hOffset, vOffset, params, isContentFrame));
        }
        return children;
    }

    private ViewInfo[] visitContentRoot(View view, int hOffset, int vOffset, SessionParams params) {
        ViewInfo[] result = new ViewInfo[2];
        if (view == null) {
            return result;
        }
        boolean setExtendedInfo = params.getExtendedViewInfoMode();
        result[0] = this.createViewInfo(view, 0, 0, setExtendedInfo, true);
        result[1] = this.createViewInfo(view, hOffset, vOffset, setExtendedInfo, true);
        Function customParser = params.getCustomContentHierarchyParser();
        List<ViewInfo> children = null;
        if (customParser != null) {
            children = (List<ViewInfo>)customParser.apply(view);
        } else if (view instanceof ViewGroup) {
            children = this.visitAllChildren((ViewGroup)view, 0, 0, params, true);
        }
        result[0].setChildren((List)children);
        result[1].setChildren(children);
        return result;
    }

    private ViewInfo createViewInfo(View view, int hOffset, int vOffset, boolean setExtendedInfo, boolean isContentFrame) {
        SystemViewInfo result;
        if (view == null) {
            return null;
        }
        if (isContentFrame) {
            int scrollX = parent != null ? ((View)((Object)parent)).getScrollX() : 0;
            int scrollY = parent != null ? ((View)((Object)parent)).getScrollY() : 0;
            int shiftX = -scrollX + Math.round(view.getTranslationX()) + hOffset;
            int shiftY = -scrollY + Math.round(view.getTranslationY()) + vOffset;
            result = new ViewInfo(view.getClass().getName(), this.getViewKey(view), shiftX + view.getLeft(), shiftY + view.getTop(), shiftX + view.getRight(), shiftY + view.getBottom(), (Object)view, null, (Object)view.getLayoutParams());
        } else {
            SystemViewInfo r;
            result = r = new SystemViewInfo(view.getClass().getName(), this.getViewKey(view), view.getLeft(), view.getTop(), view.getRight(), view.getBottom(), view, null, view.getLayoutParams());
            if (view instanceof ListMenuItemView) {
                r.setViewType(ViewType.ACTION_BAR_OVERFLOW_MENU);
            } else {
                ViewGroup.LayoutParams lp = view.getLayoutParams();
                if (lp instanceof ActionMenuView.LayoutParams && ((ActionMenuView.LayoutParams)lp).isOverflowButton) {
                    r.setViewType(ViewType.ACTION_BAR_OVERFLOW);
                } else {
                    for (parent = view.getParent(); parent != this.mViewRoot && parent instanceof ViewGroup; parent = parent.getParent()) {
                        if (!(parent instanceof ActionMenuView)) continue;
                        r.setViewType(ViewType.ACTION_BAR_MENU);
                        break;
                    }
                }
            }
        }
        if (setExtendedInfo) {
            ViewGroup.MarginLayoutParams marginParams = null;
            ViewGroup.LayoutParams params = view.getLayoutParams();
            if (params instanceof ViewGroup.MarginLayoutParams) {
                marginParams = (ViewGroup.MarginLayoutParams)params;
            }
            result.setExtendedInfo(view.getBaseline(), marginParams != null ? marginParams.leftMargin : 0, marginParams != null ? marginParams.topMargin : 0, marginParams != null ? marginParams.rightMargin : 0, marginParams != null ? marginParams.bottomMargin : 0);
        }
        return result;
    }

    private Object getViewKey(View view) {
        ViewGroup tabView;
        BridgeContext context = this.getContext();
        if ("com.google.android.material.tabs.TabLayout.TabView".equals(view.getClass().getCanonicalName()) && (tabView = (ViewGroup)view).getChildCount() > 0) {
            return context.getViewKey(tabView.getChildAt(0));
        }
        if (!(view instanceof MenuView.ItemView)) {
            return context.getViewKey(view);
        }
        MenuItemImpl menuItem = view instanceof ActionMenuItemView ? ((ActionMenuItemView)view).getItemData() : (view instanceof ListMenuItemView ? ((ListMenuItemView)view).getItemData() : (view instanceof IconMenuItemView ? ((IconMenuItemView)view).getItemData() : null));
        if (menuItem instanceof BridgeMenuItemImpl) {
            return ((BridgeMenuItemImpl)menuItem).getViewCookie();
        }
        return null;
    }

    public void invalidateRenderingSize() {
        this.mMeasuredScreenHeight = -1;
        this.mMeasuredScreenWidth = -1;
    }

    public BufferedImage getImage() {
        return this.mImage;
    }

    public List<ViewInfo> getViewInfos() {
        return this.mViewInfoList;
    }

    public List<ViewInfo> getSystemViewInfos() {
        return this.mSystemViewInfoList;
    }

    public Map<Object, Map<ResourceReference, ResourceValue>> getDefaultNamespacedProperties() {
        return this.getContext().getDefaultProperties();
    }

    public Map<Object, String> getDefaultStyles() {
        IdentityHashMap<Object, String> defaultStyles = new IdentityHashMap<Object, String>();
        Map<Object, ResourceReference> namespacedStyles = this.getDefaultNamespacedStyles();
        for (Object key : namespacedStyles.keySet()) {
            ResourceReference style2 = namespacedStyles.get(key);
            defaultStyles.put(key, style2.getQualifiedName());
        }
        return defaultStyles;
    }

    public Map<Object, ResourceReference> getDefaultNamespacedStyles() {
        return this.getContext().getDefaultNamespacedStyles();
    }

    public ValidatorHierarchy getValidatorHierarchy() {
        return this.mValidatorHierarchy;
    }

    public void setValidatorHierarchy(ValidatorHierarchy validatorHierarchy) {
        this.mValidatorHierarchy = validatorHierarchy;
    }

    public void setScene(RenderSession session) {
        this.mScene = session;
    }

    public RenderSession getSession() {
        return this.mScene;
    }

    public void dispatchTouchEvent(int motionEventType, long currentTimeNanos, float x, float y) {
        WindowManagerImpl wm = (WindowManagerImpl)this.getContext().getSystemService("window");
        ViewGroup root = wm.getCurrentRootView();
        if (root == null) {
            root = this.mViewRoot;
        }
        if (root == null) {
            return;
        }
        if (motionEventType == 0) {
            this.mLastActionDownTimeNanos = currentTimeNanos;
        }
        if (this.mLastActionDownTimeNanos == -1L) {
            return;
        }
        this.mPointerProperties[0].id = 0;
        this.mPointerProperties[0].toolType = 1;
        this.mPointerCoords[0].clear();
        this.mPointerCoords[0].x = x;
        this.mPointerCoords[0].y = y;
        this.mPointerCoords[0].pressure = 1.0f;
        this.mPointerCoords[0].size = 1.0f;
        MotionEvent event = MotionEvent.obtain(this.mLastActionDownTimeNanos / 1000000L, currentTimeNanos / 1000000L, motionEventType, 1, this.mPointerProperties, this.mPointerCoords, 0, 0, 1.0f, 1.0f, 0, 0, 4098, 0);
        root.dispatchTouchEvent(event);
    }

    public void dispatchKeyEvent(KeyEvent event, long currentTimeNanos) {
        WindowManagerImpl wm = (WindowManagerImpl)this.getContext().getSystemService("window");
        ViewGroup root = wm.getCurrentRootView();
        if (root == null) {
            root = this.mViewRoot;
        }
        if (root == null) {
            return;
        }
        if (event.getID() == 401) {
            this.mLastActionDownTimeNanos = currentTimeNanos;
        }
        if (this.mLastActionDownTimeNanos == -1L) {
            return;
        }
        android.view.KeyEvent androidEvent = KeyEventHandling.javaToAndroidKeyEvent(event, this.mLastActionDownTimeNanos, currentTimeNanos);
        boolean success = root.dispatchKeyEvent(androidEvent);
        if (!success && root != this.mViewRoot) {
            this.mViewRoot.dispatchKeyEvent(androidEvent);
        }
    }

    @Override
    public void release() {
        super.release();
        if (this.mViewRoot == null) {
            return;
        }
        ViewRootImpl viewRootImpl = this.mViewRoot.getViewRootImpl();
        if (viewRootImpl == null) {
            return;
        }
        ViewRootImpl_Accessor.detachFromWindow(viewRootImpl);
    }

    private void disposeImageSurface() {
        if (this.mImageReader != null) {
            this.mImageReader.close();
            this.mImageReader = null;
        }
    }

    @Override
    public void dispose() {
        try {
            if (this.mRenderer != null) {
                this.mRenderer.destroy();
            }
            this.disposeImageSurface();
            this.mImage = null;
            AttachInfo_Accessor.detachFromWindow(this.mViewRoot);
            this.getContext().getSessionInteractiveData().dispose();
            if (this.mViewInfoList != null) {
                this.mViewInfoList.clear();
            }
            if (this.mSystemViewInfoList != null) {
                this.mSystemViewInfoList.clear();
            }
            this.mValidatorHierarchy = null;
            this.mViewRoot = null;
            this.mContentRoot = null;
        }
        catch (Throwable t) {
            this.getContext().error("Error while disposing a RenderSession", t);
        }
        super.dispose();
    }

    private static final class PostInflateException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private PostInflateException(String message) {
            super(message);
        }
    }
}

