/*
 * Decompiled with CFR 0.152.
 */
package com.android.modules.utils;

import com.android.modules.utils.ModifiedUtf8;
import dalvik.system.VMRuntime;
import java.io.Closeable;
import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Objects;

public class FastDataInput
implements DataInput,
Closeable {
    protected static final int MAX_UNSIGNED_SHORT = 65535;
    protected static final int DEFAULT_BUFFER_SIZE = 32768;
    protected final VMRuntime mRuntime;
    protected final byte[] mBuffer;
    protected final int mBufferCap;
    private InputStream mIn;
    protected int mBufferPos;
    protected int mBufferLim;
    private int mStringRefCount = 0;
    private String[] mStringRefs = new String[32];

    public FastDataInput(InputStream in, int bufferSize) {
        this.mRuntime = VMRuntime.getRuntime();
        this.mIn = Objects.requireNonNull(in);
        if (bufferSize < 8) {
            throw new IllegalArgumentException();
        }
        this.mBuffer = (byte[])this.mRuntime.newNonMovableArray(Byte.TYPE, bufferSize);
        this.mBufferCap = this.mBuffer.length;
    }

    public static FastDataInput obtain(InputStream in) {
        return new FastDataInput(in, 32768);
    }

    public void release() {
        this.mIn = null;
        this.mBufferPos = 0;
        this.mBufferLim = 0;
        this.mStringRefCount = 0;
    }

    protected void setInput(InputStream in) {
        if (this.mIn != null) {
            throw new IllegalStateException("setInput() called before calling release()");
        }
        this.mIn = Objects.requireNonNull(in);
        this.mBufferPos = 0;
        this.mBufferLim = 0;
        this.mStringRefCount = 0;
    }

    protected void fill(int need) throws IOException {
        int remain = this.mBufferLim - this.mBufferPos;
        System.arraycopy(this.mBuffer, this.mBufferPos, this.mBuffer, 0, remain);
        this.mBufferPos = 0;
        this.mBufferLim = remain;
        need -= remain;
        while (need > 0) {
            int c = this.mIn.read(this.mBuffer, this.mBufferLim, this.mBufferCap - this.mBufferLim);
            if (c == -1) {
                throw new EOFException();
            }
            this.mBufferLim += c;
            need -= c;
        }
    }

    @Override
    public void close() throws IOException {
        this.mIn.close();
        this.release();
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        if (this.mBufferCap >= len) {
            if (this.mBufferLim - this.mBufferPos < len) {
                this.fill(len);
            }
            System.arraycopy(this.mBuffer, this.mBufferPos, b, off, len);
            this.mBufferPos += len;
        } else {
            int remain = this.mBufferLim - this.mBufferPos;
            System.arraycopy(this.mBuffer, this.mBufferPos, b, off, remain);
            this.mBufferPos += remain;
            off += remain;
            len -= remain;
            while (len > 0) {
                int c = this.mIn.read(b, off, len);
                if (c == -1) {
                    throw new EOFException();
                }
                off += c;
                len -= c;
            }
        }
    }

    @Override
    public String readUTF() throws IOException {
        int len = this.readUnsignedShort();
        if (this.mBufferCap > len) {
            if (this.mBufferLim - this.mBufferPos < len) {
                this.fill(len);
            }
            String res = ModifiedUtf8.decode(this.mBuffer, new char[len], this.mBufferPos, len);
            this.mBufferPos += len;
            return res;
        }
        byte[] tmp = (byte[])this.mRuntime.newNonMovableArray(Byte.TYPE, len + 1);
        this.readFully(tmp, 0, len);
        return ModifiedUtf8.decode(tmp, new char[len], 0, len);
    }

    public String readInternedUTF() throws IOException {
        int ref = this.readUnsignedShort();
        if (ref == 65535) {
            String s = this.readUTF();
            if (this.mStringRefCount < 65535) {
                if (this.mStringRefCount == this.mStringRefs.length) {
                    this.mStringRefs = Arrays.copyOf(this.mStringRefs, this.mStringRefCount + (this.mStringRefCount >> 1));
                }
                this.mStringRefs[this.mStringRefCount++] = s;
            }
            return s;
        }
        return this.mStringRefs[ref];
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.readByte() != 0;
    }

    public byte peekByte() throws IOException {
        if (this.mBufferLim - this.mBufferPos < 1) {
            this.fill(1);
        }
        return this.mBuffer[this.mBufferPos];
    }

    @Override
    public byte readByte() throws IOException {
        if (this.mBufferLim - this.mBufferPos < 1) {
            this.fill(1);
        }
        return this.mBuffer[this.mBufferPos++];
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return Byte.toUnsignedInt(this.readByte());
    }

    @Override
    public short readShort() throws IOException {
        if (this.mBufferLim - this.mBufferPos < 2) {
            this.fill(2);
        }
        return (short)((this.mBuffer[this.mBufferPos++] & 0xFF) << 8 | (this.mBuffer[this.mBufferPos++] & 0xFF) << 0);
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return Short.toUnsignedInt(this.readShort());
    }

    @Override
    public char readChar() throws IOException {
        return (char)this.readShort();
    }

    @Override
    public int readInt() throws IOException {
        if (this.mBufferLim - this.mBufferPos < 4) {
            this.fill(4);
        }
        return (this.mBuffer[this.mBufferPos++] & 0xFF) << 24 | (this.mBuffer[this.mBufferPos++] & 0xFF) << 16 | (this.mBuffer[this.mBufferPos++] & 0xFF) << 8 | (this.mBuffer[this.mBufferPos++] & 0xFF) << 0;
    }

    @Override
    public long readLong() throws IOException {
        if (this.mBufferLim - this.mBufferPos < 8) {
            this.fill(8);
        }
        int h = (this.mBuffer[this.mBufferPos++] & 0xFF) << 24 | (this.mBuffer[this.mBufferPos++] & 0xFF) << 16 | (this.mBuffer[this.mBufferPos++] & 0xFF) << 8 | (this.mBuffer[this.mBufferPos++] & 0xFF) << 0;
        int l = (this.mBuffer[this.mBufferPos++] & 0xFF) << 24 | (this.mBuffer[this.mBufferPos++] & 0xFF) << 16 | (this.mBuffer[this.mBufferPos++] & 0xFF) << 8 | (this.mBuffer[this.mBufferPos++] & 0xFF) << 0;
        return (long)h << 32 | (long)l & 0xFFFFFFFFL;
    }

    @Override
    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public int skipBytes(int n) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String readLine() throws IOException {
        throw new UnsupportedOperationException();
    }
}

