/*
 * Decompiled with CFR 0.152.
 */
package com.android.systemui.monet;

import com.android.internal.graphics.cam.Cam;
import com.android.systemui.monet.Chroma;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\n\u00a8\u0006\u000f"}, d2={"Lcom/android/systemui/monet/ChromaBound;", "Lcom/android/systemui/monet/Chroma;", "baseChroma", "minVal", "", "maxVal", "(Lcom/android/systemui/monet/Chroma;DD)V", "getBaseChroma", "()Lcom/android/systemui/monet/Chroma;", "getMaxVal", "()D", "getMinVal", "get", "sourceColor", "Lcom/android/internal/graphics/cam/Cam;", "frameworks__base__packages__SystemUI__monet__android_common__monet"})
public class ChromaBound
implements Chroma {
    @NotNull
    private final Chroma baseChroma;
    private final double minVal;
    private final double maxVal;

    public ChromaBound(@NotNull Chroma baseChroma, double minVal, double maxVal) {
        Intrinsics.checkNotNullParameter((Object)baseChroma, (String)"baseChroma");
        this.baseChroma = baseChroma;
        this.minVal = minVal;
        this.maxVal = maxVal;
    }

    @NotNull
    public Chroma getBaseChroma() {
        return this.baseChroma;
    }

    public double getMinVal() {
        return this.minVal;
    }

    public double getMaxVal() {
        return this.maxVal;
    }

    @Override
    public double get(@NotNull Cam sourceColor) {
        Intrinsics.checkNotNullParameter((Object)sourceColor, (String)"sourceColor");
        double result = this.baseChroma.get(sourceColor);
        return Math.min(Math.max(result, this.minVal), this.maxVal);
    }
}

