/*
 * Decompiled with CFR 0.152.
 */
package com.android.systemui.monet;

import android.app.WallpaperColors;
import android.graphics.Color;
import com.android.internal.graphics.ColorUtils;
import com.android.internal.graphics.cam.Cam;
import com.android.internal.graphics.cam.CamUtils;
import com.android.systemui.monet.ColorScheme;
import com.android.systemui.monet.Style;
import com.android.systemui.monet.TonalPalette;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010 \n\u0002\b\u0010\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 32\u00020\u0001:\u00013B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B!\b\u0017\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\fJ\b\u00101\u001a\u000202H\u0016R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u0011\u0010\u0013\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010R\u0011\u0010\u0015\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00030\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0017\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001bR\u0017\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00030\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u001bR\u0011\u0010 \u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0017R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0011\u0010$\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u0010R\u0011\u0010&\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u0017R\u0011\u0010)\u001a\u00020*8F\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u0011\u0010-\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b.\u0010\u0017R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100\u00a8\u00064"}, d2={"Lcom/android/systemui/monet/ColorScheme;", "", "seed", "", "darkTheme", "", "(IZ)V", "wallpaperColors", "Landroid/app/WallpaperColors;", "style", "Lcom/android/systemui/monet/Style;", "(Landroid/app/WallpaperColors;ZLcom/android/systemui/monet/Style;)V", "(IZLcom/android/systemui/monet/Style;)V", "accent1", "Lcom/android/systemui/monet/TonalPalette;", "getAccent1", "()Lcom/android/systemui/monet/TonalPalette;", "accent2", "getAccent2", "accent3", "getAccent3", "accentColor", "getAccentColor", "()I", "allAccentColors", "", "getAllAccentColors", "()Ljava/util/List;", "allHues", "getAllHues", "allNeutralColors", "getAllNeutralColors", "backgroundColor", "getBackgroundColor", "getDarkTheme", "()Z", "neutral1", "getNeutral1", "neutral2", "getNeutral2", "getSeed", "seedTone", "", "getSeedTone", "()F", "shadeCount", "getShadeCount", "getStyle", "()Lcom/android/systemui/monet/Style;", "toString", "", "Companion", "frameworks__base__packages__SystemUI__monet__android_common__monet"})
public class ColorScheme {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int seed;
    private final boolean darkTheme;
    @NotNull
    private final Style style;
    @NotNull
    private final TonalPalette accent1;
    @NotNull
    private final TonalPalette accent2;
    @NotNull
    private final TonalPalette accent3;
    @NotNull
    private final TonalPalette neutral1;
    @NotNull
    private final TonalPalette neutral2;

    public ColorScheme(int seed, boolean darkTheme, @NotNull Style style2) {
        Intrinsics.checkNotNullParameter((Object)((Object)style2), (String)"style");
        this.seed = seed;
        this.darkTheme = darkTheme;
        this.style = style2;
        Cam proposedSeedCam = Cam.fromInt(this.seed);
        int seedArgb = this.seed == 0 ? -14979341 : (this.style != Style.CONTENT && proposedSeedCam.getChroma() < 5.0f ? -14979341 : this.seed);
        this.accent1 = new TonalPalette(this.style.getCoreSpec$frameworks__base__packages__SystemUI__monet__android_common__monet().getA1(), seedArgb);
        this.accent2 = new TonalPalette(this.style.getCoreSpec$frameworks__base__packages__SystemUI__monet__android_common__monet().getA2(), seedArgb);
        this.accent3 = new TonalPalette(this.style.getCoreSpec$frameworks__base__packages__SystemUI__monet__android_common__monet().getA3(), seedArgb);
        this.neutral1 = new TonalPalette(this.style.getCoreSpec$frameworks__base__packages__SystemUI__monet__android_common__monet().getN1(), seedArgb);
        this.neutral2 = new TonalPalette(this.style.getCoreSpec$frameworks__base__packages__SystemUI__monet__android_common__monet().getN2(), seedArgb);
    }

    public /* synthetic */ ColorScheme(int n, boolean bl, Style style2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            style2 = Style.TONAL_SPOT;
        }
        this(n, bl, style2);
    }

    public int getSeed() {
        return this.seed;
    }

    public boolean getDarkTheme() {
        return this.darkTheme;
    }

    @NotNull
    public Style getStyle() {
        return this.style;
    }

    @NotNull
    public TonalPalette getAccent1() {
        return this.accent1;
    }

    @NotNull
    public TonalPalette getAccent2() {
        return this.accent2;
    }

    @NotNull
    public TonalPalette getAccent3() {
        return this.accent3;
    }

    @NotNull
    public TonalPalette getNeutral1() {
        return this.neutral1;
    }

    @NotNull
    public TonalPalette getNeutral2() {
        return this.neutral2;
    }

    public ColorScheme(int seed, boolean darkTheme) {
        this(seed, darkTheme, Style.TONAL_SPOT);
    }

    @JvmOverloads
    public ColorScheme(@NotNull WallpaperColors wallpaperColors, boolean darkTheme, @NotNull Style style2) {
        Intrinsics.checkNotNullParameter((Object)wallpaperColors, (String)"wallpaperColors");
        Intrinsics.checkNotNullParameter((Object)((Object)style2), (String)"style");
        this(Companion.getSeedColor(wallpaperColors, style2 != Style.CONTENT), darkTheme, style2);
    }

    public /* synthetic */ ColorScheme(WallpaperColors wallpaperColors, boolean bl, Style style2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            style2 = Style.TONAL_SPOT;
        }
        this(wallpaperColors, bl, style2);
    }

    @NotNull
    public List<TonalPalette> getAllHues() {
        Object[] objectArray = new TonalPalette[]{this.accent1, this.accent2, this.accent3, this.neutral1, this.neutral2};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public List<Integer> getAllAccentColors() {
        List allColors = new ArrayList();
        allColors.addAll((Collection)this.accent1.getAllShades());
        allColors.addAll((Collection)this.accent2.getAllShades());
        allColors.addAll((Collection)this.accent3.getAllShades());
        return allColors;
    }

    @NotNull
    public List<Integer> getAllNeutralColors() {
        List allColors = new ArrayList();
        allColors.addAll((Collection)this.neutral1.getAllShades());
        allColors.addAll((Collection)this.neutral2.getAllShades());
        return allColors;
    }

    public int getBackgroundColor() {
        return ColorUtils.setAlphaComponent(this.darkTheme ? this.neutral1.getS700() : this.neutral1.getS10(), 255);
    }

    public int getAccentColor() {
        return ColorUtils.setAlphaComponent(this.darkTheme ? this.accent1.getS100() : this.accent1.getS500(), 255);
    }

    public int getShadeCount() {
        return this.accent1.getAllShades().size();
    }

    public float getSeedTone() {
        return 1000.0f - CamUtils.lstarFromInt(this.seed) * 10.0f;
    }

    @NotNull
    public String toString() {
        return "ColorScheme {\n  seed color: " + ColorScheme.Companion.stringForColor(this.seed) + "\n  style: " + this.style + "\n  palettes: \n  " + ColorScheme.Companion.humanReadable("PRIMARY", this.accent1.getAllShades()) + "\n  " + ColorScheme.Companion.humanReadable("SECONDARY", this.accent2.getAllShades()) + "\n  " + ColorScheme.Companion.humanReadable("TERTIARY", this.accent3.getAllShades()) + "\n  " + ColorScheme.Companion.humanReadable("NEUTRAL", this.neutral1.getAllShades()) + "\n  " + ColorScheme.Companion.humanReadable("NEUTRAL VARIANT", this.neutral2.getAllShades()) + "\n}";
    }

    @JvmOverloads
    public ColorScheme(@NotNull WallpaperColors wallpaperColors, boolean darkTheme) {
        Intrinsics.checkNotNullParameter((Object)wallpaperColors, (String)"wallpaperColors");
        this(wallpaperColors, darkTheme, null, 4, null);
    }

    @JvmStatic
    @JvmOverloads
    public static int getSeedColor(@NotNull WallpaperColors wallpaperColors, boolean filter) {
        return Companion.getSeedColor(wallpaperColors, filter);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static List<Integer> getSeedColors(@NotNull WallpaperColors wallpaperColors, boolean filter) {
        return Companion.getSeedColors(wallpaperColors, filter);
    }

    @JvmStatic
    @JvmOverloads
    public static int getSeedColor(@NotNull WallpaperColors wallpaperColors) {
        return Companion.getSeedColor(wallpaperColors);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static List<Integer> getSeedColors(@NotNull WallpaperColors wallpaperColors) {
        return Companion.getSeedColors(wallpaperColors);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u0007J \u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\n2\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u0007J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fH\u0002J@\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\n2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00130\u00122\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00100\u00122\b\b\u0002\u0010\u0007\u001a\u00020\bH\u0002J\u001e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00040\nH\u0002J\u0018\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u0010H\u0002J\u0010\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u0004H\u0002J\u0010\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u0004H\u0002J\u000e\u0010 \u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\u0010\u00a8\u0006!"}, d2={"Lcom/android/systemui/monet/ColorScheme$Companion;", "", "()V", "getSeedColor", "", "wallpaperColors", "Landroid/app/WallpaperColors;", "filter", "", "getSeedColors", "", "hueDiff", "", "a", "b", "huePopulations", "", "camByColor", "", "Lcom/android/internal/graphics/cam/Cam;", "populationByColor", "humanReadable", "", "paletteName", "colors", "score", "cam", "proportion", "stringForColor", "color", "wrapDegrees", "degrees", "wrapDegreesDouble", "frameworks__base__packages__SystemUI__monet__android_common__monet"})
    @SourceDebugExtension(value={"SMAP\nColorScheme.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ColorScheme.kt\ncom/android/systemui/monet/ColorScheme$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,663:1\n2661#2,7:664\n1549#2:671\n1620#2,3:672\n766#2:675\n857#2,2:676\n1238#2,4:680\n1238#2,4:686\n1238#2,4:692\n1238#2,4:705\n1011#2,2:709\n1549#2:711\n1620#2,3:712\n442#3:678\n392#3:679\n442#3:684\n392#3:685\n442#3:690\n392#3:691\n515#3:696\n500#3,6:697\n442#3:703\n392#3:704\n1#4:715\n*S KotlinDebug\n*F\n+ 1 ColorScheme.kt\ncom/android/systemui/monet/ColorScheme$Companion\n*L\n492#1:664,7\n502#1:671\n502#1:672,3\n504#1:675\n504#1:676,2\n519#1:680,4\n520#1:686,4\n526#1:692,4\n549#1:705,4\n551#1:709,2\n631#1:711\n631#1:712,3\n519#1:678\n519#1:679\n520#1:684\n520#1:685\n526#1:690\n526#1:691\n541#1:696\n541#1:697,6\n549#1:703\n549#1:704\n*E\n"})
    public static class Companion {
        private Companion() {
        }

        @JvmStatic
        @JvmOverloads
        public int getSeedColor(@NotNull WallpaperColors wallpaperColors, boolean filter) {
            Intrinsics.checkNotNullParameter((Object)wallpaperColors, (String)"wallpaperColors");
            return ((Number)CollectionsKt.first(this.getSeedColors(wallpaperColors, filter))).intValue();
        }

        public static /* synthetic */ int getSeedColor$default(Companion companion, WallpaperColors wallpaperColors, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = true;
            }
            return companion.getSeedColor(wallpaperColors, bl);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @JvmOverloads
        @NotNull
        public List<Integer> getSeedColors(@NotNull WallpaperColors wallpaperColors, boolean filter) {
            List intToScore;
            void $this$mapValuesTo$iv$iv;
            Map filteredIntToCam;
            Map map;
            Object cam;
            Iterator iterator;
            void $this$mapValuesTo$iv$iv2;
            void $this$mapValuesTo$iv$iv3;
            Object object;
            Object object2;
            Object k;
            Object object3;
            void $this$mapValuesTo$iv$iv4;
            Map<Integer, Integer> $this$filterTo$iv$iv;
            Map destination$iv$iv;
            boolean totalPopulationMeaningless;
            void b;
            Intrinsics.checkNotNullParameter((Object)wallpaperColors, (String)"wallpaperColors");
            Iterable $this$reduce$iv = wallpaperColors.getAllColors().values();
            boolean $i$f$reduce = false;
            Object iterator$iv = $this$reduce$iv.iterator();
            if (!iterator$iv.hasNext()) {
                throw new UnsupportedOperationException("Empty collection can't be reduced.");
            }
            Object accumulator$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                Integer n = (Integer)iterator$iv.next();
                Integer a = (Integer)accumulator$iv;
                boolean bl = false;
                int n2 = a;
                Intrinsics.checkNotNullExpressionValue((Object)b, (String)"b");
                accumulator$iv = n2 + b.intValue();
            }
            double totalPopulation = ((Number)accumulator$iv).intValue();
            boolean bl = totalPopulationMeaningless = totalPopulation == 0.0;
            if (totalPopulationMeaningless) {
                void $this$filter$iv;
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                List<Color> list = wallpaperColors.getMainColors();
                Intrinsics.checkNotNullExpressionValue(list, (String)"wallpaperColors.mainColors");
                iterator$iv = list;
                boolean $i$f$map = false;
                b = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Color color2 = (Color)item$iv$iv;
                    Map map2 = destination$iv$iv;
                    boolean bl2 = false;
                    map2.add(it.toArgb());
                }
                $this$map$iv = CollectionsKt.distinct((Iterable)((List)((Object)destination$iv$iv)));
                boolean $i$f$filter = false;
                $this$mapTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                Iterator iterator2 = $this$filterTo$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    Object element$iv$iv = iterator2.next();
                    int it = ((Number)element$iv$iv).intValue();
                    boolean bl3 = false;
                    boolean bl4 = !filter ? true : Cam.fromInt(it).getChroma() >= 5.0f;
                    if (!bl4) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List distinctColors = CollectionsKt.toList((Iterable)((List)((Object)destination$iv$iv)));
                if (distinctColors.isEmpty()) {
                    return CollectionsKt.listOf((Object)-14979341);
                }
                return distinctColors;
            }
            Map<Integer, Integer> map3 = wallpaperColors.getAllColors();
            Intrinsics.checkNotNullExpressionValue(map3, (String)"wallpaperColors.allColors");
            Map<Integer, Integer> $this$mapValues$iv = map3;
            boolean $i$f$mapValues = false;
            $this$filterTo$iv$iv = $this$mapValues$iv;
            destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv4.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it;
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                object3 = destination$iv$iv;
                boolean bl5 = false;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                k = it$iv$iv.getKey();
                object2 = object3;
                boolean bl6 = false;
                object = (double)((Number)it.getValue()).intValue() / totalPopulation;
                object2.put(k, (Integer)object);
            }
            Map intToProportion = destination$iv$iv;
            Map map4 = wallpaperColors.getAllColors();
            Intrinsics.checkNotNullExpressionValue(map4, (String)"wallpaperColors.allColors");
            Map $this$mapValues$iv2 = map4;
            boolean $i$f$mapValues2 = false;
            destination$iv$iv = $this$mapValues$iv2;
            Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv2.size()));
            boolean $i$f$mapValuesTo22 = false;
            Iterable $this$associateByTo$iv$iv$iv2 = $this$mapValuesTo$iv$iv3.entrySet();
            boolean $i$f$associateByTo2 = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv2) {
                void it2;
                Iterator it$iv$iv;
                object3 = (Map.Entry)element$iv$iv$iv;
                Map bl5 = destination$iv$iv2;
                boolean $i$a$-associateByTo-MapsKt__MapsKt$mapValuesTo$1$iv$iv2 = false;
                Map.Entry bl6 = (Map.Entry)element$iv$iv$iv;
                k = it$iv$iv.getKey();
                object2 = bl5;
                boolean bl7 = false;
                Object k2 = it2.getKey();
                Intrinsics.checkNotNullExpressionValue(k2, (String)"it.key");
                object = Cam.fromInt(((Number)k2).intValue());
                object2.put(k, object);
            }
            Map intToCam = destination$iv$iv2;
            List<Double> hueProportions = this.huePopulations(intToCam, intToProportion, filter);
            Map<Integer, Integer> map5 = wallpaperColors.getAllColors();
            Intrinsics.checkNotNullExpressionValue(map5, (String)"wallpaperColors.allColors");
            Map<Integer, Integer> $this$mapValues$iv3 = map5;
            boolean $i$f$mapValues3 = false;
            Map<Integer, Integer> $i$f$mapValuesTo22 = $this$mapValues$iv3;
            Map destination$iv$iv3 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv3.size()));
            boolean $i$f$mapValuesTo3 = false;
            Iterable $this$associateByTo$iv$iv$iv3 = $this$mapValuesTo$iv$iv2.entrySet();
            boolean $i$f$associateByTo32 = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv3) {
                void it;
                void it$iv$iv;
                Map.Entry $i$a$-associateByTo-MapsKt__MapsKt$mapValuesTo$1$iv$iv2 = (Map.Entry)element$iv$iv$iv;
                Map it2 = destination$iv$iv3;
                boolean $i$a$-associateByTo-MapsKt__MapsKt$mapValuesTo$1$iv$iv3 = false;
                iterator = (Map.Entry)element$iv$iv$iv;
                k = it$iv$iv.getKey();
                object2 = it2;
                boolean bl8 = false;
                Object v = intToCam.get(it.getKey());
                Intrinsics.checkNotNull(v);
                cam = (Cam)v;
                int hue = MathKt.roundToInt((float)((Cam)cam).getHue());
                double proportion = 0.0;
                int i = hue - 15;
                int n = hue + 15;
                if (i <= n) {
                    while (true) {
                        proportion += ((Number)hueProportions.get(Companion.wrapDegrees(i))).doubleValue();
                        if (i == n) break;
                        ++i;
                    }
                }
                object = proportion;
                object2.put(k, object);
            }
            Map intToHueProportion = destination$iv$iv3;
            if (!filter) {
                map = intToCam;
            } else {
                void $this$filterTo$iv$iv2;
                Map $this$filter$iv = intToCam;
                boolean $i$f$filter = false;
                destination$iv$iv3 = $this$filter$iv;
                Map destination$iv$iv4 = new LinkedHashMap();
                boolean $i$f$filterTo = false;
                Iterator $i$f$associateByTo32 = $this$filterTo$iv$iv2.entrySet().iterator();
                while ($i$f$associateByTo32.hasNext()) {
                    Map.Entry element$iv$iv;
                    Map.Entry it = element$iv$iv = $i$f$associateByTo32.next();
                    boolean bl9 = false;
                    Cam cam2 = (Cam)it.getValue();
                    Object v = intToHueProportion.get(it.getKey());
                    Intrinsics.checkNotNull(v);
                    double proportion = ((Number)v).doubleValue();
                    boolean bl10 = cam2.getChroma() >= 5.0f && (totalPopulationMeaningless || proportion > 0.01);
                    if (!bl10) continue;
                    destination$iv$iv4.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                }
                map = destination$iv$iv4;
            }
            Map $this$mapValues$iv4 = filteredIntToCam = map;
            boolean $i$f$mapValues4 = false;
            Map destination$iv$iv4 = $this$mapValues$iv4;
            Map destination$iv$iv5 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv4.size()));
            boolean $i$f$mapValuesTo4 = false;
            Iterable $this$associateByTo$iv$iv$iv4 = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo4 = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv4) {
                void it;
                void it$iv$iv;
                Map.Entry proportion = (Map.Entry)element$iv$iv$iv;
                iterator = destination$iv$iv5;
                boolean $i$a$-associateByTo-MapsKt__MapsKt$mapValuesTo$1$iv$iv4 = false;
                cam = (Map.Entry)element$iv$iv$iv;
                k = it$iv$iv.getKey();
                object2 = iterator;
                boolean bl11 = false;
                Object v = it.getValue();
                Intrinsics.checkNotNullExpressionValue(v, (String)"it.value");
                Cam cam3 = (Cam)v;
                Object v2 = intToHueProportion.get(it.getKey());
                Intrinsics.checkNotNull(v2);
                object = Companion.score(cam3, ((Number)v2).doubleValue());
                object2.put(k, object);
            }
            Map intToScoreIntermediate = destination$iv$iv5;
            List $this$sortByDescending$iv = intToScore = CollectionsKt.toMutableList((Collection)intToScoreIntermediate.entrySet());
            boolean $i$f$sortByDescending = false;
            if ($this$sortByDescending$iv.size() > 1) {
                CollectionsKt.sortWith((List)$this$sortByDescending$iv, (Comparator)new Comparator(){

                    public int compare(T a, T b) {
                        Map.Entry it = (Map.Entry)b;
                        boolean bl = false;
                        Comparable comparable = (Double)it.getValue();
                        it = (Map.Entry)a;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Double)it.getValue()));
                    }
                });
            }
            int minimumHueDistance = 15;
            List seeds = new ArrayList();
            int i = 90;
            block9: while (true) {
                seeds.clear();
                for (Map.Entry entry : intToScore) {
                    boolean existingSeedNearby;
                    Object v17;
                    Integer n;
                    block20: {
                        n = (Integer)entry.getKey();
                        Iterable iterable = seeds;
                        for (Object t : iterable) {
                            int it = ((Number)t).intValue();
                            boolean bl12 = false;
                            Object v = intToCam.get(n);
                            Intrinsics.checkNotNull(v);
                            float hueA = ((Cam)v).getHue();
                            Object v3 = intToCam.get(it);
                            Intrinsics.checkNotNull(v3);
                            float hueB = ((Cam)v3).getHue();
                            if (!(Companion.hueDiff(hueA, hueB) < (float)i)) continue;
                            v17 = t;
                            break block20;
                        }
                        v17 = null;
                    }
                    boolean bl13 = existingSeedNearby = v17 != null;
                    if (existingSeedNearby) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)n, (String)"int");
                    seeds.add(n);
                    if (seeds.size() < 4) continue;
                    break block9;
                }
                if (i == minimumHueDistance) break;
                --i;
            }
            if (seeds.isEmpty()) {
                seeds.add(-14979341);
            }
            return seeds;
        }

        public static /* synthetic */ List getSeedColors$default(Companion companion, WallpaperColors wallpaperColors, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = true;
            }
            return companion.getSeedColors(wallpaperColors, bl);
        }

        private int wrapDegrees(int degrees) {
            return degrees < 0 ? degrees % 360 + 360 : (degrees >= 360 ? degrees % 360 : degrees);
        }

        public double wrapDegreesDouble(double degrees) {
            return degrees < 0.0 ? degrees % (double)360 + (double)360 : (degrees >= 360.0 ? degrees % (double)360 : degrees);
        }

        private float hueDiff(float a, float b) {
            return 180.0f - Math.abs(Math.abs(a - b) - 180.0f);
        }

        private String stringForColor(int color2) {
            int width = 4;
            Cam hct = Cam.fromInt(color2);
            String h = "H" + StringsKt.padEnd$default((String)String.valueOf(MathKt.roundToInt((float)hct.getHue())), (int)width, (char)'\u0000', (int)2, null);
            String c = "C" + StringsKt.padEnd$default((String)String.valueOf(MathKt.roundToInt((float)hct.getChroma())), (int)width, (char)'\u0000', (int)2, null);
            String t = "T" + StringsKt.padEnd$default((String)String.valueOf(MathKt.roundToInt((float)CamUtils.lstarFromInt(color2))), (int)width, (char)'\u0000', (int)2, null);
            String string2 = Integer.toHexString(color2 & 0xFFFFFF);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toHexString(color and 0xffffff)");
            String string3 = StringsKt.padStart((String)string2, (int)6, (char)'0').toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
            String hex = string3;
            return h + c + t + " = #" + hex;
        }

        /*
         * WARNING - void declaration
         */
        private String humanReadable(String paletteName, List<Integer> colors) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = colors;
            String string2 = paletteName;
            boolean $i$f$map = false;
            void var5_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                int n = ((Number)item$iv$iv).intValue();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Companion.stringForColor((int)it));
            }
            return string2 + "\n" + CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n", null, null, (int)0, null, (Function1)humanReadable.2.INSTANCE, (int)30, null);
        }

        private double score(Cam cam, double proportion) {
            double proportionScore = 70.0 * proportion;
            double chromaScore = cam.getChroma() < 48.0f ? 0.1 * (double)(cam.getChroma() - 48.0f) : 0.3 * (double)(cam.getChroma() - 48.0f);
            return chromaScore + proportionScore;
        }

        private List<Double> huePopulations(Map<Integer, ? extends Cam> camByColor, Map<Integer, Double> populationByColor, boolean filter) {
            int n = 360;
            ArrayList<Double> arrayList = new ArrayList<Double>(n);
            int n2 = 0;
            while (n2 < n) {
                int n3;
                int n4 = n3 = n2++;
                ArrayList<Double> arrayList2 = arrayList;
                boolean bl = false;
                arrayList2.add(0.0);
            }
            List huePopulation = CollectionsKt.toMutableList((Collection)arrayList);
            for (Map.Entry<Integer, Double> entry : populationByColor.entrySet()) {
                Cam cam;
                Double d = populationByColor.get(entry.getKey());
                Intrinsics.checkNotNull((Object)d);
                double population = ((Number)d).doubleValue();
                Intrinsics.checkNotNull((Object)camByColor.get(entry.getKey()));
                int hue = MathKt.roundToInt((float)cam.getHue()) % 360;
                if (filter && cam.getChroma() <= 5.0f) continue;
                huePopulation.set(hue, ((Number)huePopulation.get(hue)).doubleValue() + population);
            }
            return huePopulation;
        }

        static /* synthetic */ List huePopulations$default(Companion companion, Map map, Map map2, boolean bl, int n, Object object) {
            if ((n & 4) != 0) {
                bl = true;
            }
            return companion.huePopulations(map, map2, bl);
        }

        @JvmStatic
        @JvmOverloads
        public int getSeedColor(@NotNull WallpaperColors wallpaperColors) {
            Intrinsics.checkNotNullParameter((Object)wallpaperColors, (String)"wallpaperColors");
            return com.android.systemui.monet.ColorScheme$Companion.getSeedColor$default(this, wallpaperColors, false, 2, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public List<Integer> getSeedColors(@NotNull WallpaperColors wallpaperColors) {
            Intrinsics.checkNotNullParameter((Object)wallpaperColors, (String)"wallpaperColors");
            return com.android.systemui.monet.ColorScheme$Companion.getSeedColors$default(this, wallpaperColors, false, 2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

