/*
 * Decompiled with CFR 0.152.
 */
package com.android.systemui.monet;

import com.android.internal.graphics.ColorUtils;
import com.android.internal.graphics.cam.Cam;
import com.android.internal.graphics.cam.CamUtils;
import com.android.systemui.monet.TonalSpec;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0002\u0018\u0000 12\u00020\u0001:\u00011B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010.\u001a\u00020\u00052\u0006\u0010/\u001a\u000200R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001d\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011R\u0011\u0010\u0014\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0011R\u0011\u0010\u0016\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0011R\u0011\u0010\u0018\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0011R\u0011\u0010\u001a\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0011R\u0011\u0010\u001c\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0011R\u0011\u0010\u001e\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0011R\u0011\u0010 \u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0011R\u0011\u0010\"\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0011R\u0011\u0010$\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u0011R\u0011\u0010&\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u0011R\u0011\u0010(\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u0011R\u0011\u0010*\u001a\u00020+\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/android/systemui/monet/TonalPalette;", "", "spec", "Lcom/android/systemui/monet/TonalSpec;", "seedColor", "", "(Lcom/android/systemui/monet/TonalSpec;I)V", "allShades", "", "getAllShades", "()Ljava/util/List;", "allShadesMapped", "", "getAllShadesMapped", "()Ljava/util/Map;", "baseColor", "getBaseColor", "()I", "s10", "getS10", "s100", "getS100", "s1000", "getS1000", "s200", "getS200", "s300", "getS300", "s400", "getS400", "s50", "getS50", "s500", "getS500", "s600", "getS600", "s700", "getS700", "s800", "getS800", "s900", "getS900", "seedCam", "Lcom/android/internal/graphics/cam/Cam;", "getSeedCam", "()Lcom/android/internal/graphics/cam/Cam;", "getAtTone", "tone", "", "Companion", "frameworks__base__packages__SystemUI__monet__android_common__monet"})
public class TonalPalette {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TonalSpec spec;
    @NotNull
    private final Cam seedCam;
    @NotNull
    private final List<Integer> allShades;
    @NotNull
    private final Map<Integer, Integer> allShadesMapped;
    private final int baseColor;
    @NotNull
    private static final List<Integer> SHADE_KEYS;

    public TonalPalette(@NotNull TonalSpec spec, int seedColor) {
        Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
        this.spec = spec;
        Cam cam = Cam.fromInt(seedColor);
        Intrinsics.checkNotNullExpressionValue((Object)cam, (String)"fromInt(seedColor)");
        this.seedCam = cam;
        this.allShades = this.spec.shades(this.seedCam);
        this.allShadesMapped = MapsKt.toMap((Iterable)CollectionsKt.zip((Iterable)SHADE_KEYS, (Iterable)this.allShades));
        float h = (float)this.spec.getHue().get(this.seedCam);
        float c = (float)this.spec.getChroma().get(this.seedCam);
        this.baseColor = ColorUtils.CAMToColor(h, c, CamUtils.lstarFromInt(seedColor));
    }

    @NotNull
    public Cam getSeedCam() {
        return this.seedCam;
    }

    @NotNull
    public List<Integer> getAllShades() {
        return this.allShades;
    }

    @NotNull
    public Map<Integer, Integer> getAllShadesMapped() {
        return this.allShadesMapped;
    }

    public int getBaseColor() {
        return this.baseColor;
    }

    public int getAtTone(float tone) {
        return this.spec.getAtTone(this.seedCam, tone);
    }

    public int getS10() {
        return ((Number)this.allShades.get(0)).intValue();
    }

    public int getS50() {
        return ((Number)this.allShades.get(1)).intValue();
    }

    public int getS100() {
        return ((Number)this.allShades.get(2)).intValue();
    }

    public int getS200() {
        return ((Number)this.allShades.get(3)).intValue();
    }

    public int getS300() {
        return ((Number)this.allShades.get(4)).intValue();
    }

    public int getS400() {
        return ((Number)this.allShades.get(5)).intValue();
    }

    public int getS500() {
        return ((Number)this.allShades.get(6)).intValue();
    }

    public int getS600() {
        return ((Number)this.allShades.get(7)).intValue();
    }

    public int getS700() {
        return ((Number)this.allShades.get(8)).intValue();
    }

    public int getS800() {
        return ((Number)this.allShades.get(9)).intValue();
    }

    public int getS900() {
        return ((Number)this.allShades.get(10)).intValue();
    }

    public int getS1000() {
        return ((Number)this.allShades.get(11)).intValue();
    }

    static {
        Object[] objectArray = new Integer[]{10, 50, 100, 200, 300, 400, 500, 600, 700, 800, 900, 1000};
        SHADE_KEYS = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/android/systemui/monet/TonalPalette$Companion;", "", "()V", "SHADE_KEYS", "", "", "getSHADE_KEYS", "()Ljava/util/List;", "frameworks__base__packages__SystemUI__monet__android_common__monet"})
    public static class Companion {
        private Companion() {
        }

        @NotNull
        public List<Integer> getSHADE_KEYS() {
            return SHADE_KEYS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

