/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.validator;

import com.android.tools.idea.validator.LayoutValidator;
import com.android.tools.idea.validator.ValidatorResult;
import com.google.android.apps.common.testing.accessibility.framework.utils.contrast.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class AtfBufferedImage
implements Image {
    private final BufferedImage mImage;
    private final ValidatorResult.Metric mMetric;
    private final int mLeft;
    private final int mTop;
    private final int mWidth;
    private final int mHeight;
    private final float mScaleX;
    private final float mScaleY;
    private static int SAVE_IMAGE_COUNTER = 0;

    AtfBufferedImage(BufferedImage image, ValidatorResult.Metric metric, float scaleX, float scaleY) {
        this(image, metric, 0, 0, (int)((float)image.getWidth() * 1.0f / scaleX), (int)((float)image.getHeight() * 1.0f / scaleY), scaleX, scaleY);
        if (LayoutValidator.shouldSaveCroppedImages()) {
            this.saveImage(image);
        }
    }

    private AtfBufferedImage(BufferedImage image, ValidatorResult.Metric metric, int left, int top, int width, int height, float scaleX, float scaleY) {
        this.mImage = image;
        this.mMetric = metric;
        this.mLeft = left;
        this.mTop = top;
        this.mWidth = width;
        this.mHeight = height;
        this.mScaleX = scaleX;
        this.mScaleY = scaleY;
    }

    @Override
    public int getHeight() {
        return this.mHeight;
    }

    @Override
    public int getWidth() {
        return this.mWidth;
    }

    @Override
    public Image crop(int left, int top, int width, int height) {
        return new AtfBufferedImage(this.mImage, this.mMetric, left, top, width, height, this.mScaleX, this.mScaleY);
    }

    @Override
    public int[] getPixels() {
        int scaledLeft = (int)((float)this.mLeft * this.mScaleX);
        int scaledTop = (int)((float)this.mTop * this.mScaleY);
        int scaledWidth = (int)((float)this.mWidth * this.mScaleX);
        int scaledHeight = (int)((float)this.mHeight * this.mScaleY);
        if (scaledWidth <= 0 || scaledHeight <= 0) {
            return new int[0];
        }
        return this.mImage.getRGB(scaledLeft, scaledTop, scaledWidth, scaledHeight, null, 0, scaledWidth);
    }

    private void saveImage(BufferedImage image) {
        try {
            String name = SAVE_IMAGE_COUNTER + "_img_for_atf_LxT:WxH_" + this.mLeft + "x" + this.mTop + ":" + this.mWidth + "x" + this.mHeight;
            this.mMetric.mImageSizes.add(new ValidatorResult.ImageSize(this.mLeft, this.mTop, this.mWidth, this.mHeight));
            File output = new File(this.getDebugDir(), name);
            if (output.exists()) {
                output.delete();
            }
            ImageIO.write((RenderedImage)image, "PNG", output);
            ++SAVE_IMAGE_COUNTER;
        }
        catch (IOException ioe) {
            this.mMetric.mErrorMessage = ioe.getMessage();
        }
    }

    private File getDebugDir() {
        File failureDir;
        String failureDirString = System.getProperty("debug.dir");
        if (failureDirString != null) {
            failureDir = new File(failureDirString);
        } else {
            String workingDirString = System.getProperty("user.dir");
            failureDir = new File(workingDirString, "out/debugs");
        }
        failureDir.mkdirs();
        return failureDir;
    }
}

