/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework.checks;

import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheck;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityHierarchyCheck;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityHierarchyCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.Parameters;
import com.google.android.apps.common.testing.accessibility.framework.ResultMetadata;
import com.google.android.apps.common.testing.accessibility.framework.ViewHierarchyElementUtils;
import com.google.android.apps.common.testing.accessibility.framework.replacements.TextUtils;
import com.google.android.apps.common.testing.accessibility.framework.strings.StringManager;
import com.google.android.apps.common.testing.accessibility.framework.uielement.AccessibilityHierarchy;
import com.google.android.apps.common.testing.accessibility.framework.uielement.AccessibilityHierarchyOrigin;
import com.google.android.apps.common.testing.accessibility.framework.uielement.ViewHierarchyElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SpeakableTextPresentCheck
extends AccessibilityHierarchyCheck {
    public static final int RESULT_ID_NOT_VISIBLE = 1;
    public static final int RESULT_ID_NOT_IMPORTANT_FOR_ACCESSIBILITY = 2;
    public static final int RESULT_ID_SHOULD_NOT_FOCUS = 3;
    public static final int RESULT_ID_MISSING_SPEAKABLE_TEXT = 4;
    public static final int RESULT_ID_WEB_CONTENT = 5;
    private static final int RESULT_ID_UNSUPPORTED_COMPOSE_CONTENT = 6;
    private static final int RESULT_ID_UNSUPPORTED_FLUTTER_CONTENT = 7;

    @Override
    protected String getHelpTopic() {
        return "7158690";
    }

    @Override
    public AccessibilityCheck.Category getCategory() {
        return AccessibilityCheck.Category.CONTENT_LABELING;
    }

    @Override
    public List<AccessibilityHierarchyCheckResult> runCheckOnHierarchy(AccessibilityHierarchy hierarchy, @Nullable ViewHierarchyElement fromRoot, @Nullable Parameters parameters) {
        ArrayList<AccessibilityHierarchyCheckResult> results = new ArrayList<AccessibilityHierarchyCheckResult>();
        List<? extends ViewHierarchyElement> viewsToEval = SpeakableTextPresentCheck.getElementsToEvaluate(fromRoot, hierarchy);
        for (ViewHierarchyElement viewHierarchyElement : viewsToEval) {
            if (!Boolean.TRUE.equals(viewHierarchyElement.isVisibleToUser())) {
                results.add(new AccessibilityHierarchyCheckResult(this.getClass(), AccessibilityCheckResult.AccessibilityCheckResultType.NOT_RUN, viewHierarchyElement, 1, null));
                continue;
            }
            if (!viewHierarchyElement.isImportantForAccessibility()) {
                results.add(new AccessibilityHierarchyCheckResult(this.getClass(), AccessibilityCheckResult.AccessibilityCheckResultType.NOT_RUN, viewHierarchyElement, 2, null));
                continue;
            }
            if (viewHierarchyElement.checkInstanceOf("android.webkit.WebView") && viewHierarchyElement.getChildViewCount() == 0) {
                results.add(new AccessibilityHierarchyCheckResult(this.getClass(), AccessibilityCheckResult.AccessibilityCheckResultType.NOT_RUN, viewHierarchyElement, 5, null));
                continue;
            }
            CharSequence className = viewHierarchyElement.getClassName();
            if (hierarchy.getOrigin() == AccessibilityHierarchyOrigin.VIEWS && hierarchy.getDeviceState().getSdkVersion() < 34) {
                if (TextUtils.equals(className, "androidx.compose.ui.platform.AndroidComposeView")) {
                    results.add(new AccessibilityHierarchyCheckResult(this.getClass(), AccessibilityCheckResult.AccessibilityCheckResultType.NOT_RUN, viewHierarchyElement, 6, null));
                    continue;
                }
                if (TextUtils.equals(className, "io.flutter.embedding.android.FlutterView")) {
                    results.add(new AccessibilityHierarchyCheckResult(this.getClass(), AccessibilityCheckResult.AccessibilityCheckResultType.NOT_RUN, viewHierarchyElement, 7, null));
                    continue;
                }
            }
            if (!ViewHierarchyElementUtils.shouldFocusView(viewHierarchyElement)) {
                results.add(new AccessibilityHierarchyCheckResult(this.getClass(), AccessibilityCheckResult.AccessibilityCheckResultType.NOT_RUN, viewHierarchyElement, 3, null));
                continue;
            }
            if (!TextUtils.isEmpty(ViewHierarchyElementUtils.getSpeakableTextForElement(viewHierarchyElement, hierarchy.getDeviceState().getLocale()))) continue;
            results.add(new AccessibilityHierarchyCheckResult(this.getClass(), AccessibilityCheckResult.AccessibilityCheckResultType.ERROR, viewHierarchyElement, 4, null));
        }
        return results;
    }

    @Override
    public String getMessageForResultData(Locale locale, int resultId, @Nullable ResultMetadata metadata) {
        return SpeakableTextPresentCheck.generateMessageForResultId(locale, resultId);
    }

    @Override
    public String getShortMessageForResultData(Locale locale, int resultId, @Nullable ResultMetadata metadata) {
        return SpeakableTextPresentCheck.generateMessageForResultId(locale, resultId);
    }

    @Override
    public String getTitleMessage(Locale locale) {
        return StringManager.getString(locale, "check_title_speakable_text_present");
    }

    private static String generateMessageForResultId(Locale locale, int resultId) {
        switch (resultId) {
            case 1: {
                return StringManager.getString(locale, "result_message_not_visible");
            }
            case 2: {
                return StringManager.getString(locale, "result_message_not_important_for_accessibility");
            }
            case 3: {
                return StringManager.getString(locale, "result_message_should_not_focus");
            }
            case 4: {
                return StringManager.getString(locale, "result_message_missing_speakable_text");
            }
            case 5: {
                return StringManager.getString(locale, "result_message_web_content");
            }
            case 6: {
                return StringManager.getString(locale, "result_message_unsupported_compose_content");
            }
            case 7: {
                return StringManager.getString(locale, "result_message_unsupported_flutter_content");
            }
        }
        throw new IllegalStateException("Unsupported result id: " + resultId);
    }
}

