/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework.checks;

import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheck;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityHierarchyCheck;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityHierarchyCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityHierarchyCheckResultWithImage;
import com.google.android.apps.common.testing.accessibility.framework.HashMapResultMetadata;
import com.google.android.apps.common.testing.accessibility.framework.Parameters;
import com.google.android.apps.common.testing.accessibility.framework.ResultMetadata;
import com.google.android.apps.common.testing.accessibility.framework.ViewHierarchyElementUtils;
import com.google.android.apps.common.testing.accessibility.framework.replacements.Rect;
import com.google.android.apps.common.testing.accessibility.framework.replacements.Span;
import com.google.android.apps.common.testing.accessibility.framework.replacements.SpannableString;
import com.google.android.apps.common.testing.accessibility.framework.replacements.Spans;
import com.google.android.apps.common.testing.accessibility.framework.replacements.TextUtils;
import com.google.android.apps.common.testing.accessibility.framework.strings.StringManager;
import com.google.android.apps.common.testing.accessibility.framework.uielement.AccessibilityHierarchy;
import com.google.android.apps.common.testing.accessibility.framework.uielement.ViewHierarchyElement;
import com.google.android.apps.common.testing.accessibility.framework.utils.contrast.Color;
import com.google.android.apps.common.testing.accessibility.framework.utils.contrast.ContrastSwatch;
import com.google.android.apps.common.testing.accessibility.framework.utils.contrast.ContrastUtils;
import com.google.android.apps.common.testing.accessibility.framework.utils.contrast.Image;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.checkerframework.checker.nullness.qual.Nullable;

public class TextContrastCheck
extends AccessibilityHierarchyCheck {
    public static final int RESULT_ID_NOT_VISIBLE = 1;
    public static final int RESULT_ID_NOT_TEXT_VIEW = 2;
    public static final int RESULT_ID_TEXTVIEW_EMPTY = 3;
    public static final int RESULT_ID_COULD_NOT_GET_TEXT_COLOR = 4;
    public static final int RESULT_ID_COULD_NOT_GET_BACKGROUND_COLOR = 5;
    public static final int RESULT_ID_TEXT_MUST_BE_OPAQUE = 6;
    public static final int RESULT_ID_BACKGROUND_MUST_BE_OPAQUE = 7;
    public static final int RESULT_ID_TEXTVIEW_CONTRAST_NOT_SUFFICIENT = 8;
    public static final int RESULT_ID_HEURISTIC_COULD_NOT_GET_SCREENCAPTURE = 9;
    public static final int RESULT_ID_VIEW_NOT_WITHIN_SCREENCAPTURE = 10;
    public static final int RESULT_ID_TEXTVIEW_HEURISTIC_CONTRAST_NOT_SUFFICIENT = 11;
    public static final int RESULT_ID_TEXTVIEW_HEURISTIC_CONTRAST_BORDERLINE = 12;
    public static final int RESULT_ID_NOT_ENABLED = 13;
    public static final int RESULT_ID_SCREENCAPTURE_DATA_HIDDEN = 14;
    public static final int RESULT_ID_CUSTOMIZED_TEXTVIEW_HEURISTIC_CONTRAST_NOT_SUFFICIENT = 15;
    public static final int RESULT_ID_SCREENCAPTURE_UNIFORM_COLOR = 16;
    public static final int RESULT_ID_CUSTOMIZED_TEXTVIEW_CONTRAST_NOT_SUFFICIENT = 22;
    public static final int RESULT_ID_TEXTVIEW_UPPER_BOUND_CONTRAST_NOT_SUFFICIENT = 23;
    public static final int RESULT_ID_TEXTVIEW_LOWER_BOUND_CONTRAST_NOT_SUFFICIENT = 24;
    public static final int RESULT_ID_CUSTOMIZED_TEXTVIEW_UPPER_BOUND_CONTRAST_NOT_SUFFICIENT = 25;
    public static final int RESULT_ID_CUSTOMIZED_TEXTVIEW_LOWER_BOUND_CONTRAST_NOT_SUFFICIENT = 26;
    public static final String KEY_BACKGROUND_COLOR = "KEY_BACKGROUND_COLOR";
    public static final String KEY_BACKGROUND_OPACITY = "KEY_BACKGROUND_OPACITY";
    public static final String KEY_CONTRAST_RATIO = "KEY_CONTRAST_RATIO";
    public static final String KEY_FOREGROUND_COLOR = "KEY_FOREGROUND_COLOR";
    public static final String KEY_RESULT_TEXT_SUBSTRING = "KEY_RESULT_TEXT_SUBSTRING";
    public static final String KEY_REQUIRED_CONTRAST_RATIO = "KEY_REQUIRED_CONTRAST_RATIO";
    public static final String KEY_CUSTOMIZED_HEURISTIC_CONTRAST_RATIO = "KEY_CUSTOMIZED_HEURISTIC_CONTRAST_RATIO";
    public static final String KEY_SCREENSHOT_BOUNDS_STRING = "KEY_SCREENSHOT_BOUNDS_STRING";
    public static final String KEY_TEXT_COLOR = "KEY_TEXT_COLOR";
    public static final String KEY_TEXT_OPACITY = "KEY_TEXT_OPACITY";
    public static final String KEY_TOLERANT_CONTRAST_RATIO = "KEY_TOLERANT_CONTRAST_RATIO";
    public static final String KEY_VIEW_BOUNDS_STRING = "KEY_VIEW_BOUNDS_STRING";
    public static final String KEY_IS_AGAINST_SCROLLABLE_EDGE = "KEY_IS_AGAINST_SCROLLABLE_EDGE";
    public static final String KEY_ADDITIONAL_FOREGROUND_COLORS = "KEY_ADDITIONAL_FOREGROUND_COLORS";
    public static final String KEY_ADDITIONAL_CONTRAST_RATIOS = "KEY_ADDITIONAL_CONTRAST_RATIOS";
    public static final String KEY_IS_POTENTIALLY_OBSCURED = "KEY_IS_POTENTIALLY_OBSCURED";
    public static final String KEY_IS_LARGE_TEXT = "KEY_IS_LARGE_TEXT";
    public static final double CONTRAST_TOLERANCE = 0.01;
    private static final Class<? extends AccessibilityHierarchyCheck> CHECK_CLASS = TextContrastCheck.class;
    private static final int TYPEFACE_NORMAL = 0;
    private static final int TYPEFACE_BOLD = 1;
    private static final int OPAQUE_ALPHA = 255;

    @Override
    protected String getHelpTopic() {
        return "7158390";
    }

    @Override
    public AccessibilityCheck.Category getCategory() {
        return AccessibilityCheck.Category.LOW_CONTRAST;
    }

    @Override
    public List<AccessibilityHierarchyCheckResult> runCheckOnHierarchy(AccessibilityHierarchy hierarchy, @Nullable ViewHierarchyElement fromRoot, @Nullable Parameters parameters) {
        ArrayList<AccessibilityHierarchyCheckResult> results = new ArrayList<AccessibilityHierarchyCheckResult>();
        List<? extends ViewHierarchyElement> viewsToEval = TextContrastCheck.getElementsToEvaluate(fromRoot, hierarchy);
        for (ViewHierarchyElement viewHierarchyElement : viewsToEval) {
            AccessibilityHierarchyCheckResult heavyweightResult;
            if (!Boolean.TRUE.equals(viewHierarchyElement.isVisibleToUser())) {
                results.add(new AccessibilityHierarchyCheckResult(CHECK_CLASS, AccessibilityCheckResult.AccessibilityCheckResultType.NOT_RUN, viewHierarchyElement, 1, null));
                continue;
            }
            if (!viewHierarchyElement.checkInstanceOf("android.widget.TextView") || viewHierarchyElement.checkInstanceOf("android.widget.Switch") && viewHierarchyElement.getTextCharacterLocations().isEmpty()) {
                results.add(new AccessibilityHierarchyCheckResult(CHECK_CLASS, AccessibilityCheckResult.AccessibilityCheckResultType.NOT_RUN, viewHierarchyElement, 2, null));
                continue;
            }
            if (TextUtils.isEmpty(viewHierarchyElement.getText()) && TextUtils.isEmpty(viewHierarchyElement.getHintText())) {
                results.add(new AccessibilityHierarchyCheckResult(CHECK_CLASS, AccessibilityCheckResult.AccessibilityCheckResultType.NOT_RUN, viewHierarchyElement, 3, null));
                continue;
            }
            if (!viewHierarchyElement.isEnabled()) {
                results.add(new AccessibilityHierarchyCheckResult(CHECK_CLASS, AccessibilityCheckResult.AccessibilityCheckResultType.NOT_RUN, viewHierarchyElement, 13, null));
                continue;
            }
            ImmutableList<AccessibilityHierarchyCheckResult> lightweightResults = this.attemptLightweightEval(viewHierarchyElement, parameters);
            boolean runHeavyWeightEval = false;
            for (AccessibilityHierarchyCheckResult lightweightResult : lightweightResults) {
                if (lightweightResult.getResultId() == 7) {
                    AccessibilityHierarchyCheckResult contrastRangeResult = this.attemptContrastRangeEval(viewHierarchyElement, parameters, lightweightResult);
                    if (contrastRangeResult == null) continue;
                    if (contrastRangeResult.getType().equals((Object)AccessibilityCheckResult.AccessibilityCheckResultType.WARNING)) {
                        runHeavyWeightEval = true;
                        continue;
                    }
                    results.add(contrastRangeResult);
                    continue;
                }
                if (lightweightResult.getType().equals((Object)AccessibilityCheckResult.AccessibilityCheckResultType.NOT_RUN)) {
                    results.add(lightweightResult);
                    runHeavyWeightEval = true;
                    continue;
                }
                results.add(lightweightResult);
            }
            if (!runHeavyWeightEval || (heavyweightResult = this.attemptHeavyweightEval(viewHierarchyElement, parameters)) == null) continue;
            results.add(heavyweightResult);
        }
        return results;
    }

    @Override
    public String getMessageForResultData(Locale locale, int resultId, @Nullable ResultMetadata metadata) {
        String generated = TextContrastCheck.generateMessageForResultId(locale, resultId);
        if (generated != null) {
            return generated;
        }
        Preconditions.checkNotNull((Object)metadata);
        switch (resultId) {
            case 6: {
                StringBuilder builder = new StringBuilder().append(StringManager.getString(locale, "result_message_text_must_be_opaque")).append(" ").append(String.format(locale, StringManager.getString(locale, "result_message_addendum_opacity_description"), Float.valueOf(metadata.getFloat(KEY_TEXT_OPACITY))));
                return builder.toString();
            }
            case 7: {
                StringBuilder builder = new StringBuilder().append(StringManager.getString(locale, "result_message_background_must_be_opaque")).append(" ").append(String.format(locale, StringManager.getString(locale, "result_message_addendum_opacity_description"), Float.valueOf(metadata.getFloat(KEY_BACKGROUND_OPACITY))));
                return builder.toString();
            }
            case 8: {
                StringBuilder builder = new StringBuilder(String.format(locale, StringManager.getString(locale, "result_message_textview_contrast_not_sufficient"), metadata.getDouble(KEY_CONTRAST_RATIO), ContrastUtils.colorToHexString(metadata.getInt(KEY_TEXT_COLOR)), ContrastUtils.colorToHexString(metadata.getInt(KEY_BACKGROUND_COLOR)), metadata.getDouble(KEY_REQUIRED_CONTRAST_RATIO)));
                TextContrastCheck.appendMetadataStringsToMessageIfNeeded(locale, metadata, builder);
                return builder.toString();
            }
            case 22: {
                StringBuilder builder = new StringBuilder(String.format(locale, StringManager.getString(locale, "result_message_customized_textview_contrast_not_sufficient"), metadata.getDouble(KEY_CONTRAST_RATIO), ContrastUtils.colorToHexString(metadata.getInt(KEY_TEXT_COLOR)), ContrastUtils.colorToHexString(metadata.getInt(KEY_BACKGROUND_COLOR)), metadata.getDouble(KEY_CUSTOMIZED_HEURISTIC_CONTRAST_RATIO)));
                TextContrastCheck.appendMetadataStringsToMessageIfNeeded(locale, metadata, builder);
                return builder.toString();
            }
            case 23: {
                StringBuilder builder = new StringBuilder(String.format(locale, StringManager.getString(locale, "result_message_textview_upper_bound_contrast_not_sufficient"), metadata.getDouble(KEY_CONTRAST_RATIO), ContrastUtils.colorToHexString(metadata.getInt(KEY_TEXT_COLOR)), ContrastUtils.colorToHexString(metadata.getInt(KEY_BACKGROUND_COLOR)), metadata.getDouble(KEY_REQUIRED_CONTRAST_RATIO)));
                TextContrastCheck.appendMetadataStringsToMessageIfNeeded(locale, metadata, builder);
                return builder.toString();
            }
            case 25: {
                StringBuilder builder = new StringBuilder(String.format(locale, StringManager.getString(locale, "result_message_customized_textview_upper_bound_contrast_not_sufficient"), metadata.getDouble(KEY_CONTRAST_RATIO), ContrastUtils.colorToHexString(metadata.getInt(KEY_TEXT_COLOR)), ContrastUtils.colorToHexString(metadata.getInt(KEY_BACKGROUND_COLOR)), metadata.getDouble(KEY_CUSTOMIZED_HEURISTIC_CONTRAST_RATIO)));
                TextContrastCheck.appendMetadataStringsToMessageIfNeeded(locale, metadata, builder);
                return builder.toString();
            }
            case 24: {
                StringBuilder builder = new StringBuilder(String.format(locale, StringManager.getString(locale, "result_message_textview_lower_bound_contrast_not_sufficient"), metadata.getDouble(KEY_CONTRAST_RATIO), ContrastUtils.colorToHexString(metadata.getInt(KEY_TEXT_COLOR)), ContrastUtils.colorToHexString(metadata.getInt(KEY_BACKGROUND_COLOR)), metadata.getDouble(KEY_REQUIRED_CONTRAST_RATIO)));
                TextContrastCheck.appendMetadataStringsToMessageIfNeeded(locale, metadata, builder);
                return builder.toString();
            }
            case 26: {
                StringBuilder builder = new StringBuilder(String.format(locale, StringManager.getString(locale, "result_message_customized_textview_lower_bound_contrast_not_sufficient"), metadata.getDouble(KEY_CONTRAST_RATIO), ContrastUtils.colorToHexString(metadata.getInt(KEY_TEXT_COLOR)), ContrastUtils.colorToHexString(metadata.getInt(KEY_BACKGROUND_COLOR)), metadata.getDouble(KEY_CUSTOMIZED_HEURISTIC_CONTRAST_RATIO)));
                TextContrastCheck.appendMetadataStringsToMessageIfNeeded(locale, metadata, builder);
                return builder.toString();
            }
            case 10: {
                return String.format(locale, StringManager.getString(locale, "result_message_view_not_within_screencapture"), metadata.getString(KEY_VIEW_BOUNDS_STRING), metadata.getString(KEY_SCREENSHOT_BOUNDS_STRING));
            }
            case 11: {
                StringBuilder builder = metadata.containsKey(KEY_IS_LARGE_TEXT) ? new StringBuilder(String.format(locale, StringManager.getString(locale, "result_message_textview_heuristic_contrast_not_sufficient_when_text_size_available"), metadata.getDouble(KEY_CONTRAST_RATIO), ContrastUtils.colorToHexString(metadata.getInt(KEY_FOREGROUND_COLOR)), ContrastUtils.colorToHexString(metadata.getInt(KEY_BACKGROUND_COLOR)), metadata.getDouble(KEY_REQUIRED_CONTRAST_RATIO))) : new StringBuilder(String.format(locale, StringManager.getString(locale, "result_message_textview_heuristic_contrast_not_sufficient"), metadata.getDouble(KEY_CONTRAST_RATIO), ContrastUtils.colorToHexString(metadata.getInt(KEY_FOREGROUND_COLOR)), ContrastUtils.colorToHexString(metadata.getInt(KEY_BACKGROUND_COLOR)), 4.5, 3.0));
                TextContrastCheck.appendMetadataStringsToMessageIfNeeded(locale, metadata, builder);
                return builder.toString();
            }
            case 12: {
                StringBuilder builder = new StringBuilder(String.format(locale, StringManager.getString(locale, "result_message_textview_heuristic_contrast_not_sufficient"), metadata.getDouble(KEY_CONTRAST_RATIO), ContrastUtils.colorToHexString(metadata.getInt(KEY_FOREGROUND_COLOR)), ContrastUtils.colorToHexString(metadata.getInt(KEY_BACKGROUND_COLOR)), metadata.getDouble(KEY_REQUIRED_CONTRAST_RATIO), metadata.getDouble(KEY_TOLERANT_CONTRAST_RATIO)));
                TextContrastCheck.appendMetadataStringsToMessageIfNeeded(locale, metadata, builder);
                return builder.toString();
            }
            case 15: {
                StringBuilder builder = new StringBuilder(String.format(locale, StringManager.getString(locale, "result_message_textview_heuristic_customized_contrast_not_sufficient"), metadata.getDouble(KEY_CONTRAST_RATIO), ContrastUtils.colorToHexString(metadata.getInt(KEY_FOREGROUND_COLOR)), ContrastUtils.colorToHexString(metadata.getInt(KEY_BACKGROUND_COLOR)), metadata.getDouble(KEY_CUSTOMIZED_HEURISTIC_CONTRAST_RATIO)));
                TextContrastCheck.appendMetadataStringsToMessageIfNeeded(locale, metadata, builder);
                return builder.toString();
            }
        }
        throw new IllegalStateException("Unsupported result id");
    }

    @Override
    public String getShortMessageForResultData(Locale locale, int resultId, @Nullable ResultMetadata metadata) {
        String generated = TextContrastCheck.generateMessageForResultId(locale, resultId);
        if (generated != null) {
            return generated;
        }
        switch (resultId) {
            case 6: {
                return StringManager.getString(locale, "result_message_text_must_be_opaque");
            }
            case 7: {
                return StringManager.getString(locale, "result_message_background_must_be_opaque");
            }
            case 10: {
                return StringManager.getString(locale, "result_message_no_screencapture");
            }
            case 8: 
            case 11: 
            case 12: 
            case 15: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                return StringManager.getString(locale, "result_message_brief_text_contrast_not_sufficient");
            }
        }
        throw new IllegalStateException("Unsupported result id");
    }

    @Override
    public @Nullable Double getSecondaryPriority(AccessibilityHierarchyCheckResult result) {
        ResultMetadata metadata = result.getMetadata();
        switch (result.getResultId()) {
            case 8: 
            case 11: 
            case 12: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                return ((ResultMetadata)Preconditions.checkNotNull((Object)metadata)).getDouble(KEY_REQUIRED_CONTRAST_RATIO, 0.0) - ((ResultMetadata)Preconditions.checkNotNull((Object)metadata)).getDouble(KEY_CONTRAST_RATIO, 0.0);
            }
            case 15: {
                return ((ResultMetadata)Preconditions.checkNotNull((Object)metadata)).getDouble(KEY_CUSTOMIZED_HEURISTIC_CONTRAST_RATIO, 0.0) - ((ResultMetadata)Preconditions.checkNotNull((Object)metadata)).getDouble(KEY_CONTRAST_RATIO, 0.0);
            }
        }
        return null;
    }

    @Override
    public String getTitleMessage(Locale locale) {
        return StringManager.getString(locale, "check_title_text_contrast");
    }

    private static @Nullable String generateMessageForResultId(Locale locale, int resultId) {
        switch (resultId) {
            case 1: {
                return StringManager.getString(locale, "result_message_not_visible");
            }
            case 2: {
                return StringManager.getString(locale, "result_message_not_text_view");
            }
            case 13: {
                return StringManager.getString(locale, "result_message_not_enabled");
            }
            case 3: {
                return StringManager.getString(locale, "result_message_textview_empty");
            }
            case 4: {
                return StringManager.getString(locale, "result_message_could_not_get_text_color");
            }
            case 5: {
                return StringManager.getString(locale, "result_message_could_not_get_background_color");
            }
            case 9: {
                return StringManager.getString(locale, "result_message_no_screencapture");
            }
            case 14: {
                return StringManager.getString(locale, "result_message_screencapture_data_hidden");
            }
            case 16: {
                return StringManager.getString(locale, "result_message_screencapture_uniform_color");
            }
        }
        return null;
    }

    private static boolean hasAnyForegroundColor(ViewHierarchyElement view, SpannableString text) {
        if (TextContrastCheck.getForegroundColor(view) != null) {
            return true;
        }
        if (text == null) {
            return false;
        }
        for (Span span : text.getSpans()) {
            if (!(span instanceof Spans.ForegroundColorSpan)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasAnyBackgroundColor(ViewHierarchyElement view, SpannableString text) {
        if (view.getBackgroundDrawableColor() != null) {
            return true;
        }
        if (text == null) {
            return false;
        }
        for (Span span : text.getSpans()) {
            if (!(span instanceof Spans.BackgroundColorSpan)) continue;
            return true;
        }
        return false;
    }

    private static ImmutableList<ColorRangeInfo> getForegroundColorRangeInfos(SpannableString text, @Nullable Integer textColor) {
        return TextContrastCheck.getColorRangeInfos(text, Spans.ForegroundColorSpan.class, textColor);
    }

    private static ImmutableList<ColorRangeInfo> getBackgroundColorRangeInfos(SpannableString text, @Nullable Integer backgroundDrawableColor) {
        return TextContrastCheck.getColorRangeInfos(text, Spans.BackgroundColorSpan.class, backgroundDrawableColor);
    }

    private static ImmutableList<ColorRangeInfo> getColorRangeInfos(SpannableString text, Class<? extends Span> clazz, @Nullable Integer defaultColor) {
        ArrayList colorRangeInfos = Lists.newArrayList((Object[])new ColorRangeInfo[]{new ColorRangeInfo(0, text.length(), defaultColor)});
        ArrayList filteredSpans = Lists.newArrayList((Iterable)Collections2.filter(text.getSpans(), clazz::isInstance));
        if (filteredSpans.isEmpty()) {
            return ImmutableList.copyOf((Collection)colorRangeInfos);
        }
        for (Span span : filteredSpans) {
            int start = span.getStart();
            int end = span.getEnd();
            int startPtr = 0;
            int endPtr = colorRangeInfos.size() - 1;
            while (((ColorRangeInfo)colorRangeInfos.get(startPtr)).getEnd() < start) {
                ++startPtr;
            }
            while (((ColorRangeInfo)colorRangeInfos.get(endPtr)).getStart() > end) {
                --endPtr;
            }
            ColorRangeInfo startRange = (ColorRangeInfo)colorRangeInfos.get(startPtr);
            ColorRangeInfo endRange = (ColorRangeInfo)colorRangeInfos.get(endPtr);
            for (int i = startPtr; i <= endPtr; ++i) {
                colorRangeInfos.remove(startPtr);
            }
            int ptr = startPtr;
            if (startRange.getStart() < start) {
                colorRangeInfos.add(ptr++, new ColorRangeInfo(startRange.getStart(), start, startRange.getColor()));
            }
            colorRangeInfos.add(ptr++, new ColorRangeInfo(start, end, TextContrastCheck.getSpanColor(span)));
            if (end >= endRange.getEnd()) continue;
            colorRangeInfos.add(ptr, new ColorRangeInfo(end, endRange.getEnd(), endRange.getColor()));
        }
        return ImmutableList.copyOf((Collection)colorRangeInfos);
    }

    private static int getSpanColor(Span span) {
        if (span instanceof Spans.ForegroundColorSpan) {
            return ((Spans.ForegroundColorSpan)span).getForegroundColor();
        }
        if (span instanceof Spans.BackgroundColorSpan) {
            return ((Spans.BackgroundColorSpan)span).getBackgroundColor();
        }
        throw new IllegalArgumentException("Unexpected Span type");
    }

    private static ImmutableList<ColorPair> getColorPairs(ImmutableList<ColorRangeInfo> foregroundColorRangeInfos, ImmutableList<ColorRangeInfo> backgroundColorRangeInfos) {
        ImmutableList.Builder colorPairs = new ImmutableList.Builder();
        int foregroundIndex = 0;
        int backgroundIndex = 0;
        while (foregroundIndex != foregroundColorRangeInfos.size() || backgroundIndex != backgroundColorRangeInfos.size()) {
            ColorRangeInfo foregroundInfo = (ColorRangeInfo)foregroundColorRangeInfos.get(foregroundIndex);
            ColorRangeInfo backgroundInfo = (ColorRangeInfo)backgroundColorRangeInfos.get(backgroundIndex);
            colorPairs.add((Object)new ColorPair(Math.max(foregroundInfo.getStart(), backgroundInfo.getStart()), Math.min(foregroundInfo.getEnd(), backgroundInfo.getEnd()), foregroundInfo.getColor(), backgroundInfo.getColor()));
            if (foregroundInfo.getEnd() == backgroundInfo.getEnd()) {
                ++foregroundIndex;
                ++backgroundIndex;
                continue;
            }
            if (foregroundInfo.getEnd() < backgroundInfo.getEnd()) {
                ++foregroundIndex;
                continue;
            }
            ++backgroundIndex;
        }
        return colorPairs.build();
    }

    private ImmutableList<AccessibilityHierarchyCheckResult> attemptLightweightEval(ViewHierarchyElement view, @Nullable Parameters parameters) {
        SpannableString text;
        SpannableString spannableString = text = TextUtils.isEmpty(view.getText()) ? view.getHintText() : view.getText();
        if (text == null) {
            return ImmutableList.of();
        }
        if (!TextContrastCheck.hasAnyForegroundColor(view, text)) {
            return ImmutableList.of((Object)new AccessibilityHierarchyCheckResult(CHECK_CLASS, AccessibilityCheckResult.AccessibilityCheckResultType.NOT_RUN, view, 4, null));
        }
        if (!TextContrastCheck.hasAnyBackgroundColor(view, text)) {
            return ImmutableList.of((Object)new AccessibilityHierarchyCheckResult(CHECK_CLASS, AccessibilityCheckResult.AccessibilityCheckResultType.NOT_RUN, view, 5, null));
        }
        ImmutableList<ColorPair> colorPairs = TextContrastCheck.getColorPairs(TextContrastCheck.getForegroundColorRangeInfos(text, TextContrastCheck.getForegroundColor(view)), TextContrastCheck.getBackgroundColorRangeInfos(text, view.getBackgroundDrawableColor()));
        ImmutableList.Builder results = ImmutableList.builder();
        for (ColorPair colorPair : colorPairs) {
            Double customizedHeuristicContrastRatio;
            int backgroundAlpha;
            Integer foregroundColor = colorPair.getForegroundColor();
            Integer backgroundColor = colorPair.getBackgroundColor();
            if (foregroundColor == null || backgroundColor == null) continue;
            HashMapResultMetadata resultMetadata = new HashMapResultMetadata();
            if (colorPair.getStart() > 0 || colorPair.getEnd() < text.length()) {
                String substringText = text.subSequence(colorPair.getStart(), colorPair.getEnd()).toString();
                resultMetadata.putString(KEY_RESULT_TEXT_SUBSTRING, substringText);
            }
            if ((backgroundAlpha = Color.alpha(backgroundColor)) < 255) {
                resultMetadata.putFloat(KEY_BACKGROUND_OPACITY, (float)backgroundAlpha * 100.0f / 255.0f);
                resultMetadata.putInt(KEY_TEXT_COLOR, foregroundColor);
                resultMetadata.putInt(KEY_BACKGROUND_COLOR, backgroundColor);
                results.add((Object)new AccessibilityHierarchyCheckResult(CHECK_CLASS, AccessibilityCheckResult.AccessibilityCheckResultType.NOT_RUN, view, 7, resultMetadata));
                continue;
            }
            int compositeTextColor = ContrastUtils.compositeColors(foregroundColor, backgroundColor);
            double contrastRatio = ContrastUtils.calculateContrastRatio(compositeTextColor, backgroundColor);
            double requiredContrast = Boolean.TRUE.equals(TextContrastCheck.isLargeText(view)) ? 3.0 : 4.5;
            Double d = customizedHeuristicContrastRatio = parameters == null ? null : parameters.getCustomTextContrastRatio();
            if (customizedHeuristicContrastRatio != null) {
                requiredContrast = customizedHeuristicContrastRatio;
            }
            if (!(requiredContrast - contrastRatio > 0.01)) continue;
            resultMetadata.putDouble(customizedHeuristicContrastRatio == null ? KEY_REQUIRED_CONTRAST_RATIO : KEY_CUSTOMIZED_HEURISTIC_CONTRAST_RATIO, requiredContrast);
            resultMetadata.putDouble(KEY_CONTRAST_RATIO, contrastRatio);
            resultMetadata.putInt(KEY_TEXT_COLOR, foregroundColor);
            resultMetadata.putInt(KEY_BACKGROUND_COLOR, backgroundColor);
            results.add((Object)new AccessibilityHierarchyCheckResult(CHECK_CLASS, AccessibilityCheckResult.AccessibilityCheckResultType.ERROR, view, customizedHeuristicContrastRatio == null ? 8 : 22, resultMetadata));
        }
        return results.build();
    }

    private @Nullable AccessibilityHierarchyCheckResult attemptHeavyweightEval(ViewHierarchyElement view, @Nullable Parameters parameters) {
        Double customizedHeuristicContrastRatio;
        Image screenCapture;
        Image image = screenCapture = parameters == null ? null : parameters.getScreenCapture();
        if (screenCapture == null) {
            return new AccessibilityHierarchyCheckResult(CHECK_CLASS, AccessibilityCheckResult.AccessibilityCheckResultType.NOT_RUN, view, 9, null);
        }
        Rect screenCaptureBounds = new Rect(0, 0, screenCapture.getWidth(), screenCapture.getHeight());
        Rect viewBounds = view.getBoundsInScreen();
        Rect textCharacterBounds = this.getTextCharacterBounds(view);
        if (!textCharacterBounds.isEmpty() && screenCaptureBounds.contains(textCharacterBounds) && Rect.intersects(viewBounds, textCharacterBounds)) {
            viewBounds = textCharacterBounds;
        }
        if (viewBounds.isEmpty() || !screenCaptureBounds.contains(viewBounds)) {
            HashMapResultMetadata resultMetadata = new HashMapResultMetadata();
            resultMetadata.putString(KEY_VIEW_BOUNDS_STRING, viewBounds.toShortString());
            resultMetadata.putString(KEY_SCREENSHOT_BOUNDS_STRING, screenCaptureBounds.toShortString());
            return new AccessibilityHierarchyCheckResult(CHECK_CLASS, AccessibilityCheckResult.AccessibilityCheckResultType.NOT_RUN, view, 10, resultMetadata);
        }
        Image viewImage = this.crop(screenCapture, viewBounds);
        ContrastSwatch contrastSwatch = this.getContrastSwatch(viewImage, parameters == null ? null : parameters.getEnableEnhancedContrastEvaluation());
        HashMapResultMetadata resultMetadata = new HashMapResultMetadata();
        if (view.isAgainstScrollableEdge()) {
            resultMetadata.putBoolean(KEY_IS_AGAINST_SCROLLABLE_EDGE, true);
        }
        int foreground = (Integer)contrastSwatch.getForegroundColors().get(0);
        int background = contrastSwatch.getBackgroundColor();
        if (background == foreground) {
            return new AccessibilityHierarchyCheckResult(CHECK_CLASS, AccessibilityCheckResult.AccessibilityCheckResultType.NOT_RUN, view, foreground == -16777216 ? 14 : 16, resultMetadata);
        }
        ImmutableList<Integer> foregroundColors = contrastSwatch.getForegroundColors();
        ImmutableList<Double> contrastRatios = contrastSwatch.getContrastRatios();
        ArrayList<Integer> lowForegroundColors = new ArrayList<Integer>();
        ArrayList<Double> lowContrastRatios = new ArrayList<Double>();
        Double d = customizedHeuristicContrastRatio = parameters == null ? null : parameters.getCustomTextContrastRatio();
        if (customizedHeuristicContrastRatio != null) {
            for (int i = 0; i < contrastRatios.size(); ++i) {
                if (!(customizedHeuristicContrastRatio - (Double)contrastRatios.get(i) > 0.01)) continue;
                lowForegroundColors.add((Integer)foregroundColors.get(i));
                lowContrastRatios.add((Double)contrastRatios.get(i));
            }
            if (!lowContrastRatios.isEmpty()) {
                if (ViewHierarchyElementUtils.isPotentiallyObscured(view)) {
                    resultMetadata.putBoolean(KEY_IS_POTENTIALLY_OBSCURED, true);
                }
                resultMetadata.putDouble(KEY_CUSTOMIZED_HEURISTIC_CONTRAST_RATIO, customizedHeuristicContrastRatio);
                this.storeColorsAndContrastRatios(resultMetadata, background, lowForegroundColors, lowContrastRatios);
                return this.resultPossiblyWithImage(AccessibilityCheckResult.AccessibilityCheckResultType.WARNING, view, 15, resultMetadata, parameters, viewImage);
            }
        } else {
            int i;
            boolean isTextSizeAvailable;
            double requiredContrastRatio = 3.0;
            boolean bl = isTextSizeAvailable = view.getTextSize() != null;
            if (isTextSizeAvailable) {
                resultMetadata.putBoolean(KEY_IS_LARGE_TEXT, (Boolean)Preconditions.checkNotNull((Object)TextContrastCheck.isLargeText(view)));
                requiredContrastRatio = (Boolean)Preconditions.checkNotNull((Object)TextContrastCheck.isLargeText(view)) != false ? 3.0 : 4.5;
            }
            for (i = 0; i < contrastRatios.size(); ++i) {
                if (!(requiredContrastRatio - (Double)contrastRatios.get(i) > 0.01)) continue;
                lowForegroundColors.add((Integer)foregroundColors.get(i));
                lowContrastRatios.add((Double)contrastRatios.get(i));
            }
            if (!lowContrastRatios.isEmpty()) {
                if (ViewHierarchyElementUtils.isPotentiallyObscured(view)) {
                    resultMetadata.putBoolean(KEY_IS_POTENTIALLY_OBSCURED, true);
                }
                resultMetadata.putDouble(KEY_REQUIRED_CONTRAST_RATIO, requiredContrastRatio);
                this.storeColorsAndContrastRatios(resultMetadata, background, lowForegroundColors, lowContrastRatios);
                return this.resultPossiblyWithImage(AccessibilityCheckResult.AccessibilityCheckResultType.WARNING, view, 11, resultMetadata, parameters, viewImage);
            }
            if (!isTextSizeAvailable) {
                for (i = 0; i < contrastRatios.size(); ++i) {
                    if (!(4.5 - (Double)contrastRatios.get(i) > 0.01)) continue;
                    lowForegroundColors.add((Integer)foregroundColors.get(i));
                    lowContrastRatios.add((Double)contrastRatios.get(i));
                }
                if (!lowContrastRatios.isEmpty()) {
                    if (ViewHierarchyElementUtils.isPotentiallyObscured(view)) {
                        resultMetadata.putBoolean(KEY_IS_POTENTIALLY_OBSCURED, true);
                    }
                    resultMetadata.putDouble(KEY_REQUIRED_CONTRAST_RATIO, 4.5);
                    resultMetadata.putDouble(KEY_TOLERANT_CONTRAST_RATIO, 3.0);
                    this.storeColorsAndContrastRatios(resultMetadata, background, lowForegroundColors, lowContrastRatios);
                    return this.resultPossiblyWithImage(AccessibilityCheckResult.AccessibilityCheckResultType.WARNING, view, 12, resultMetadata, parameters, viewImage);
                }
            }
        }
        return null;
    }

    private @Nullable AccessibilityHierarchyCheckResult attemptContrastRangeEval(ViewHierarchyElement view, @Nullable Parameters parameters, AccessibilityHierarchyCheckResult lightweightResult) {
        Double customizedHeuristicContrastRatio;
        if (lightweightResult.getMetadata() == null) {
            return null;
        }
        int textColor = lightweightResult.getMetadata().getInt(KEY_TEXT_COLOR);
        int backgroundDrawableColor = lightweightResult.getMetadata().getInt(KEY_BACKGROUND_COLOR);
        String substringText = lightweightResult.getMetadata().getString(KEY_RESULT_TEXT_SUBSTRING, "");
        HashMapResultMetadata resultMetadata = new HashMapResultMetadata();
        resultMetadata.putInt(KEY_TEXT_COLOR, textColor);
        resultMetadata.putInt(KEY_BACKGROUND_COLOR, backgroundDrawableColor);
        if (!substringText.isEmpty()) {
            resultMetadata.putString(KEY_RESULT_TEXT_SUBSTRING, substringText);
        }
        double requiredContrast = Boolean.TRUE.equals(TextContrastCheck.isLargeText(view)) ? 3.0 : 4.5;
        Double d = customizedHeuristicContrastRatio = parameters == null ? null : parameters.getCustomTextContrastRatio();
        if (customizedHeuristicContrastRatio != null) {
            requiredContrast = customizedHeuristicContrastRatio;
        }
        resultMetadata.putDouble(customizedHeuristicContrastRatio == null ? KEY_REQUIRED_CONTRAST_RATIO : KEY_CUSTOMIZED_HEURISTIC_CONTRAST_RATIO, requiredContrast);
        Range<Double> contrastRange = ContrastUtils.calculateContrastRatioRange(textColor, backgroundDrawableColor);
        double upperBound = (Double)contrastRange.upperEndpoint();
        double lowerBound = (Double)contrastRange.lowerEndpoint();
        if (requiredContrast - upperBound > 0.01) {
            resultMetadata.putDouble(KEY_CONTRAST_RATIO, upperBound);
            return new AccessibilityHierarchyCheckResult(CHECK_CLASS, AccessibilityCheckResult.AccessibilityCheckResultType.ERROR, view, customizedHeuristicContrastRatio == null ? 23 : 25, resultMetadata);
        }
        if (requiredContrast - lowerBound > 0.01) {
            resultMetadata.putDouble(KEY_CONTRAST_RATIO, lowerBound);
            return new AccessibilityHierarchyCheckResult(CHECK_CLASS, AccessibilityCheckResult.AccessibilityCheckResultType.WARNING, view, customizedHeuristicContrastRatio == null ? 24 : 26, resultMetadata);
        }
        return null;
    }

    @VisibleForTesting
    ContrastSwatch getContrastSwatch(Image image, @Nullable Boolean enableEnhancedContrastEvaluation) {
        return new ContrastSwatch(image, Boolean.TRUE.equals(enableEnhancedContrastEvaluation));
    }

    private Rect getTextCharacterBounds(ViewHierarchyElement view) {
        List<Rect> characterLocations = view.getTextCharacterLocations();
        if (characterLocations.isEmpty()) {
            return Rect.EMPTY;
        }
        int minLeft = Integer.MAX_VALUE;
        int minTop = Integer.MAX_VALUE;
        int maxRight = Integer.MIN_VALUE;
        int maxBottom = Integer.MIN_VALUE;
        for (Rect rect : characterLocations) {
            minLeft = Math.min(minLeft, rect.getLeft());
            minTop = Math.min(minTop, rect.getTop());
            maxRight = Math.max(maxRight, rect.getRight());
            maxBottom = Math.max(maxBottom, rect.getBottom());
        }
        return new Rect(minLeft, minTop, maxRight, maxBottom);
    }

    private Image crop(Image screenCapture, Rect viewBounds) {
        return screenCapture.crop(viewBounds.getLeft(), viewBounds.getTop(), viewBounds.getWidth(), viewBounds.getHeight());
    }

    private AccessibilityHierarchyCheckResult resultPossiblyWithImage(AccessibilityCheckResult.AccessibilityCheckResultType type, ViewHierarchyElement view, int resultId, ResultMetadata metadata, @Nullable Parameters parameters, @Nullable Image viewImage) {
        if (viewImage != null && parameters != null && Boolean.TRUE.equals(parameters.getSaveViewImages())) {
            return new AccessibilityHierarchyCheckResultWithImage(CHECK_CLASS, type, view, resultId, metadata, viewImage);
        }
        return new AccessibilityHierarchyCheckResult(CHECK_CLASS, type, view, resultId, metadata);
    }

    private void storeColorsAndContrastRatios(ResultMetadata resultMetadata, int background, List<Integer> foregroundColors, List<Double> contrastRatios) {
        resultMetadata.putInt(KEY_BACKGROUND_COLOR, background);
        this.storeForegroundColors(resultMetadata, foregroundColors);
        this.storeContrastRatios(resultMetadata, contrastRatios);
    }

    private void storeForegroundColors(ResultMetadata resultMetadata, List<Integer> foregroundColors) {
        resultMetadata.putInt(KEY_FOREGROUND_COLOR, foregroundColors.get(0));
        if (foregroundColors.size() > 1) {
            resultMetadata.putStringList(KEY_ADDITIONAL_FOREGROUND_COLORS, Lists.transform(foregroundColors.subList(1, foregroundColors.size()), integer2 -> integer2.toString()));
        }
    }

    private void storeContrastRatios(ResultMetadata resultMetadata, List<Double> contrastRatios) {
        resultMetadata.putDouble(KEY_CONTRAST_RATIO, contrastRatios.get(0));
        if (contrastRatios.size() > 1) {
            resultMetadata.putStringList(KEY_ADDITIONAL_CONTRAST_RATIOS, Lists.transform(contrastRatios.subList(1, contrastRatios.size()), ratio -> ratio.toString()));
        }
    }

    private static void appendMetadataStringsToMessageIfNeeded(Locale locale, ResultMetadata resultMetadata, StringBuilder builder) {
        if (resultMetadata.getBoolean(KEY_IS_POTENTIALLY_OBSCURED, false)) {
            builder.append(' ').append(StringManager.getString(locale, "result_message_addendum_view_potentially_obscured"));
        }
        if (resultMetadata.getBoolean(KEY_IS_AGAINST_SCROLLABLE_EDGE, false)) {
            builder.append(' ').append(StringManager.getString(locale, "result_message_addendum_against_scrollable_edge"));
        }
    }

    private static @Nullable Boolean isLargeText(ViewHierarchyElement view) {
        Float textSize = view.getTextSize();
        if (textSize == null) {
            return null;
        }
        float density = view.getWindow().getAccessibilityHierarchy().getDeviceState().getDefaultDisplayInfo().getMetricsWithoutDecoration().getScaledDensity();
        float dpSize = textSize.floatValue() / density;
        int style2 = view.getTypefaceStyle() != null ? view.getTypefaceStyle() : 0;
        return dpSize >= 18.0f || dpSize >= 14.0f && (style2 & 1) != 0;
    }

    private static @Nullable Integer getForegroundColor(ViewHierarchyElement view) {
        return TextUtils.isEmpty(view.getText()) ? view.getHintTextColor() : view.getTextColor();
    }

    static class ColorRangeInfo {
        private final int start;
        private final int end;
        private final @Nullable Integer color;

        ColorRangeInfo(int start, int end, @Nullable Integer color2) {
            this.start = start;
            this.end = end;
            this.color = color2;
            Preconditions.checkState((start <= end ? 1 : 0) != 0, (String)"start %s should be before end %s", (int)start, (int)end);
        }

        int getStart() {
            return this.start;
        }

        int getEnd() {
            return this.end;
        }

        @Nullable Integer getColor() {
            return this.color;
        }

        public String toString() {
            return String.format(Locale.ENGLISH, "ColorRangeInfo{range=[%d,%d] color=%s}", this.start, this.end, this.color == null ? null : ContrastUtils.colorToHexString(this.color));
        }
    }

    static class ColorPair {
        private final int start;
        private final int end;
        private final @Nullable Integer fgColor;
        private final @Nullable Integer bgColor;

        ColorPair(int start, int end, @Nullable Integer fgColor, @Nullable Integer bgColor) {
            this.start = start;
            this.end = end;
            this.fgColor = fgColor;
            this.bgColor = bgColor;
        }

        int getStart() {
            return this.start;
        }

        int getEnd() {
            return this.end;
        }

        @Nullable Integer getForegroundColor() {
            return this.fgColor;
        }

        @Nullable Integer getBackgroundColor() {
            return this.bgColor;
        }

        public String toString() {
            return String.format(Locale.ENGLISH, "ColorPair{range=[%d,%d] fg=%s bg=%s}", this.start, this.end, this.fgColor, this.bgColor);
        }
    }
}

