/*
 * Decompiled with CFR 0.152.
 */
package dalvik.system;

import android.annotation.SystemApi;
import android.compat.annotation.UnsupportedAppUsage;
import com.android.tools.layoutlib.create.OverrideMethod;
import dalvik.annotation.optimization.FastNative;
import java.io.FileDescriptor;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

@SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
public class VMDebug {
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final int TRACE_COUNT_ALLOCS = 1;
    private static final int KIND_ALLOCATED_OBJECTS = 1;
    private static final int KIND_ALLOCATED_BYTES = 2;
    private static final int KIND_FREED_OBJECTS = 4;
    private static final int KIND_FREED_BYTES = 8;
    private static final int KIND_GC_INVOCATIONS = 16;
    private static final int KIND_CLASS_INIT_COUNT = 32;
    private static final int KIND_CLASS_INIT_TIME = 64;
    private static final int KIND_EXT_ALLOCATED_OBJECTS = 4096;
    private static final int KIND_EXT_ALLOCATED_BYTES = 8192;
    private static final int KIND_EXT_FREED_OBJECTS = 16384;
    private static final int KIND_EXT_FREED_BYTES = 32768;
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final int KIND_GLOBAL_ALLOCATED_OBJECTS = 1;
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final int KIND_GLOBAL_ALLOCATED_BYTES = 2;
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final int KIND_GLOBAL_FREED_OBJECTS = 4;
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final int KIND_GLOBAL_FREED_BYTES = 8;
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final int KIND_GLOBAL_GC_INVOCATIONS = 16;
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final int KIND_GLOBAL_CLASS_INIT_COUNT = 32;
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final int KIND_GLOBAL_CLASS_INIT_TIME = 64;
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final int KIND_THREAD_ALLOCATED_OBJECTS = 65536;
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final int KIND_THREAD_ALLOCATED_BYTES = 131072;
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final int KIND_THREAD_GC_INVOCATIONS = 0x100000;
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final int KIND_ALL_COUNTS = -1;
    private static final HashMap<String, Integer> runtimeStatsMap = new HashMap();

    private VMDebug() {
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static void suspendAllAndSendVmStart() {
        OverrideMethod.invokeV("dalvik.system.VMDebug#suspendAllAndSendVmStart()V", true, null);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @FastNative
    public static long lastDebuggerActivity() {
        return OverrideMethod.invokeL("dalvik.system.VMDebug#lastDebuggerActivity()J", true, null);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @FastNative
    public static boolean isDebuggingEnabled() {
        return OverrideMethod.invokeI("dalvik.system.VMDebug#isDebuggingEnabled()Z", true, null) != 0;
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @UnsupportedAppUsage
    @FastNative
    public static boolean isDebuggerConnected() {
        return OverrideMethod.invokeI("dalvik.system.VMDebug#isDebuggerConnected()Z", true, null) != 0;
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static String[] getVmFeatureList() {
        return (String[])OverrideMethod.invokeA("dalvik.system.VMDebug#getVmFeatureList()[Ljava/lang/String;", true, null);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static void startMethodTracing(String traceFileName, int bufferSize, int flags, boolean samplingEnabled, int intervalUs) {
        VMDebug.startMethodTracingFilename(traceFileName, VMDebug.checkBufferSize(bufferSize), flags, samplingEnabled, intervalUs);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static void startMethodTracing(String traceFileName, FileDescriptor fd, int bufferSize, int flags, boolean samplingEnabled, int intervalUs, boolean streamingOutput) {
        if (fd == null) {
            throw new NullPointerException("fd == null");
        }
        VMDebug.startMethodTracingFd(traceFileName, fd.getInt$(), VMDebug.checkBufferSize(bufferSize), flags, samplingEnabled, intervalUs, streamingOutput);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static void startMethodTracingDdms(int bufferSize, int flags, boolean samplingEnabled, int intervalUs) {
        VMDebug.startMethodTracingDdmsImpl(VMDebug.checkBufferSize(bufferSize), flags, samplingEnabled, intervalUs);
    }

    private static int checkBufferSize(int bufferSize) {
        if (bufferSize == 0) {
            bufferSize = 0x800000;
        }
        if (bufferSize < 1024) {
            throw new IllegalArgumentException("buffer size < 1024: " + bufferSize);
        }
        return bufferSize;
    }

    private static void startMethodTracingDdmsImpl(int n, int n2, boolean bl, int n3) {
        OverrideMethod.invokeV("dalvik.system.VMDebug#startMethodTracingDdmsImpl(IIZI)V", true, null);
    }

    private static void startMethodTracingFd(String string2, int n, int n2, int n3, boolean bl, int n4, boolean bl2) {
        OverrideMethod.invokeV("dalvik.system.VMDebug#startMethodTracingFd(Ljava/lang/String;IIIZIZ)V", true, null);
    }

    private static void startMethodTracingFilename(String string2, int n, int n2, boolean bl, int n3) {
        OverrideMethod.invokeV("dalvik.system.VMDebug#startMethodTracingFilename(Ljava/lang/String;IIZI)V", true, null);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static int getMethodTracingMode() {
        return OverrideMethod.invokeI("dalvik.system.VMDebug#getMethodTracingMode()I", true, null);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static void stopMethodTracing() {
        OverrideMethod.invokeV("dalvik.system.VMDebug#stopMethodTracing()V", true, null);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @FastNative
    public static long threadCpuTimeNanos() {
        return OverrideMethod.invokeL("dalvik.system.VMDebug#threadCpuTimeNanos()J", true, null);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static void startAllocCounting() {
        OverrideMethod.invokeV("dalvik.system.VMDebug#startAllocCounting()V", true, null);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static void stopAllocCounting() {
        OverrideMethod.invokeV("dalvik.system.VMDebug#stopAllocCounting()V", true, null);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static int getAllocCount(int n) {
        return OverrideMethod.invokeI("dalvik.system.VMDebug#getAllocCount(I)I", true, null);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static void resetAllocCount(int n) {
        OverrideMethod.invokeV("dalvik.system.VMDebug#resetAllocCount(I)V", true, null);
    }

    @Deprecated
    public static int setAllocationLimit(int limit) {
        return -1;
    }

    @Deprecated
    public static int setGlobalAllocationLimit(int limit) {
        return -1;
    }

    @Deprecated
    public static void startInstructionCounting() {
    }

    @Deprecated
    public static void stopInstructionCounting() {
    }

    @Deprecated
    public static void getInstructionCount(int[] counts) {
    }

    @Deprecated
    public static void resetInstructionCount() {
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @FastNative
    public static void printLoadedClasses(int n) {
        OverrideMethod.invokeV("dalvik.system.VMDebug#printLoadedClasses(I)V", true, null);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @FastNative
    public static int getLoadedClassCount() {
        return OverrideMethod.invokeI("dalvik.system.VMDebug#getLoadedClassCount()I", true, null);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static void dumpHprofData(String filename) throws IOException {
        if (filename == null) {
            throw new NullPointerException("filename == null");
        }
        VMDebug.dumpHprofData(filename, null);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static void dumpHprofDataDdms() {
        OverrideMethod.invokeV("dalvik.system.VMDebug#dumpHprofDataDdms()V", true, null);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static void dumpHprofData(String fileName, FileDescriptor fd) throws IOException {
        VMDebug.dumpHprofData(fileName, fd != null ? fd.getInt$() : -1);
    }

    private static void dumpHprofData(String string2, int n) throws IOException {
        OverrideMethod.invokeV("dalvik.system.VMDebug#dumpHprofData(Ljava/lang/String;I)V", true, null);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @UnsupportedAppUsage
    public static void dumpReferenceTables() {
        OverrideMethod.invokeV("dalvik.system.VMDebug#dumpReferenceTables()V", true, null);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static long countInstancesOfClass(Class clazz, boolean bl) {
        return OverrideMethod.invokeL("dalvik.system.VMDebug#countInstancesOfClass(Ljava/lang/Class;Z)J", true, null);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static long[] countInstancesOfClasses(Class[] classArray, boolean bl) {
        return (long[])OverrideMethod.invokeA("dalvik.system.VMDebug#countInstancesOfClasses([Ljava/lang/Class;Z)[J", true, null);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static String getRuntimeStat(String statName) {
        if (statName == null) {
            throw new NullPointerException("statName == null");
        }
        Integer statId = runtimeStatsMap.get(statName);
        if (statId != null) {
            return VMDebug.getRuntimeStatInternal(statId);
        }
        return null;
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static Map<String, String> getRuntimeStats() {
        HashMap<String, String> map = new HashMap<String, String>();
        String[] values = VMDebug.getRuntimeStatsInternal();
        for (String name : runtimeStatsMap.keySet()) {
            int id2 = runtimeStatsMap.get(name);
            String value = values[id2];
            map.put(name, value);
        }
        return map;
    }

    private static String getRuntimeStatInternal(int n) {
        return (String)OverrideMethod.invokeA("dalvik.system.VMDebug#getRuntimeStatInternal(I)Ljava/lang/String;", true, null);
    }

    private static String[] getRuntimeStatsInternal() {
        return (String[])OverrideMethod.invokeA("dalvik.system.VMDebug#getRuntimeStatsInternal()[Ljava/lang/String;", true, null);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static void attachAgent(String agent, ClassLoader classLoader) throws IOException {
        VMDebug.nativeAttachAgent(agent, classLoader);
    }

    private static void nativeAttachAgent(String string2, ClassLoader classLoader) throws IOException {
        OverrideMethod.invokeV("dalvik.system.VMDebug#nativeAttachAgent(Ljava/lang/String;Ljava/lang/ClassLoader;)V", true, null);
    }

    @UnsupportedAppUsage
    public static void allowHiddenApiReflectionFrom(Class<?> clazz) {
        OverrideMethod.invokeV("dalvik.system.VMDebug#allowHiddenApiReflectionFrom(Ljava/lang/Class;)V", true, null);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static void setAllocTrackerStackDepth(int n) {
        OverrideMethod.invokeV("dalvik.system.VMDebug#setAllocTrackerStackDepth(I)V", true, null);
    }

    static {
        runtimeStatsMap.put("art.gc.gc-count", 0);
        runtimeStatsMap.put("art.gc.gc-time", 1);
        runtimeStatsMap.put("art.gc.bytes-allocated", 2);
        runtimeStatsMap.put("art.gc.bytes-freed", 3);
        runtimeStatsMap.put("art.gc.blocking-gc-count", 4);
        runtimeStatsMap.put("art.gc.blocking-gc-time", 5);
        runtimeStatsMap.put("art.gc.gc-count-rate-histogram", 6);
        runtimeStatsMap.put("art.gc.blocking-gc-count-rate-histogram", 7);
        runtimeStatsMap.put("art.gc.objects-allocated", 8);
        runtimeStatsMap.put("art.gc.total-time-waiting-for-gc", 9);
        runtimeStatsMap.put("art.gc.pre-oome-gc-count", 10);
    }
}

