/*
 * Decompiled with CFR 0.152.
 */
package libcore.icu;

import android.compat.annotation.UnsupportedAppUsage;
import android.icu.text.DateTimePatternGenerator;
import android.icu.text.TimeZoneFormat;
import android.icu.util.Currency;
import android.icu.util.IllformedLocaleException;
import android.icu.util.ULocale;
import com.android.icu.util.ExtendedCalendar;
import com.android.icu.util.LocaleNative;
import com.android.layoutlib.bridge.android.AndroidLocale;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import libcore.icu.ICU_Delegate;
import libcore.util.BasicLruCache;

public class ICU {
    @UnsupportedAppUsage
    private static final BasicLruCache<String, String> CACHED_PATTERNS = new BasicLruCache(8);
    private static Locale[] availableLocalesCache;
    private static String[] isoCountries;
    private static Set<String> isoCountriesSet;
    private static String[] isoLanguages;
    private static final int IDX_LANGUAGE = 0;
    private static final int IDX_SCRIPT = 1;
    private static final int IDX_REGION = 2;
    private static final int IDX_VARIANT = 3;

    private ICU() {
    }

    public static void initializeCacheInZygote() {
        for (Locale locale : new Locale[]{Locale.US, AndroidLocale.getDefault()}) {
            ICU.getTimePattern(locale, false, false);
            ICU.getTimePattern(locale, false, true);
            ICU.getTimePattern(locale, true, false);
            ICU.getTimePattern(locale, true, true);
        }
    }

    public static String[] getISOLanguages() {
        if (isoLanguages == null) {
            isoLanguages = ICU.getISOLanguagesNative();
        }
        return (String[])isoLanguages.clone();
    }

    public static String[] getISOCountries() {
        return (String[])ICU.getISOCountriesInternal().clone();
    }

    public static boolean isIsoCountry(String country) {
        if (isoCountriesSet == null) {
            String[] isoCountries = ICU.getISOCountriesInternal();
            HashSet<String> newSet = new HashSet<String>(isoCountries.length);
            for (String isoCountry : isoCountries) {
                newSet.add(isoCountry);
            }
            isoCountriesSet = newSet;
        }
        return country != null && isoCountriesSet.contains(country);
    }

    private static String[] getISOCountriesInternal() {
        if (isoCountries == null) {
            isoCountries = ICU.getISOCountriesNative();
        }
        return isoCountries;
    }

    private static void parseLangScriptRegionAndVariants(String string2, String[] outputArray) {
        int first = string2.indexOf(95);
        int second = string2.indexOf(95, first + 1);
        int third = string2.indexOf(95, second + 1);
        if (first == -1) {
            outputArray[0] = string2;
        } else if (second == -1) {
            outputArray[0] = string2.substring(0, first);
            String secondString = string2.substring(first + 1);
            if (secondString.length() == 4) {
                outputArray[1] = secondString;
            } else if (secondString.length() == 2 || secondString.length() == 3) {
                outputArray[2] = secondString;
            } else {
                outputArray[3] = secondString;
            }
        } else if (third == -1) {
            outputArray[0] = string2.substring(0, first);
            String secondString = string2.substring(first + 1, second);
            String thirdString = string2.substring(second + 1);
            if (secondString.length() == 4) {
                outputArray[1] = secondString;
                if (thirdString.length() == 2 || thirdString.length() == 3 || thirdString.isEmpty()) {
                    outputArray[2] = thirdString;
                } else {
                    outputArray[3] = thirdString;
                }
            } else if (secondString.isEmpty() || secondString.length() == 2 || secondString.length() == 3) {
                outputArray[2] = secondString;
                outputArray[3] = thirdString;
            } else {
                outputArray[3] = string2.substring(first + 1);
            }
        } else {
            outputArray[0] = string2.substring(0, first);
            String secondString = string2.substring(first + 1, second);
            if (secondString.length() == 4) {
                outputArray[1] = secondString;
                outputArray[2] = string2.substring(second + 1, third);
                outputArray[3] = string2.substring(third + 1);
            } else {
                outputArray[2] = secondString;
                outputArray[3] = string2.substring(second + 1);
            }
        }
    }

    public static Locale localeFromIcuLocaleId(String localeId) {
        int extensionsIndex = localeId.indexOf(64);
        HashMap<Character, String> extensionsMap = Collections.EMPTY_MAP;
        HashMap<String, String> unicodeKeywordsMap = Collections.EMPTY_MAP;
        HashSet<String> unicodeAttributeSet = Collections.EMPTY_SET;
        if (extensionsIndex != -1) {
            extensionsMap = new HashMap<Character, String>();
            unicodeKeywordsMap = new HashMap<String, String>();
            unicodeAttributeSet = new HashSet<String>();
            String extensionsString = localeId.substring(extensionsIndex + 1);
            String[] extensions = extensionsString.split(";");
            for (String extension : extensions) {
                if (extension.startsWith("attribute=")) {
                    String unicodeAttributeValues = extension.substring("attribute=".length());
                    for (String unicodeAttribute : unicodeAttributeValues.split("-")) {
                        unicodeAttributeSet.add(unicodeAttribute);
                    }
                    continue;
                }
                int separatorIndex = extension.indexOf(61);
                if (separatorIndex == 1) {
                    String value = extension.substring(2);
                    char extensionId = extension.charAt(0);
                    extensionsMap.put(Character.valueOf(extensionId), value);
                    continue;
                }
                unicodeKeywordsMap.put(extension.substring(0, separatorIndex), extension.substring(separatorIndex + 1));
            }
        }
        String[] outputArray = new String[]{"", "", "", ""};
        if (extensionsIndex == -1) {
            ICU.parseLangScriptRegionAndVariants(localeId, outputArray);
        } else {
            ICU.parseLangScriptRegionAndVariants(localeId.substring(0, extensionsIndex), outputArray);
        }
        Locale.Builder builder = new Locale.Builder();
        builder.setLanguage(outputArray[0]);
        builder.setRegion(outputArray[2]);
        builder.setVariant(outputArray[3]);
        builder.setScript(outputArray[1]);
        for (String string2 : unicodeAttributeSet) {
            builder.addUnicodeLocaleAttribute(string2);
        }
        for (Map.Entry entry : unicodeKeywordsMap.entrySet()) {
            builder.setUnicodeLocaleKeyword((String)entry.getKey(), (String)entry.getValue());
        }
        for (Map.Entry entry : extensionsMap.entrySet()) {
            builder.setExtension(((Character)entry.getKey()).charValue(), (String)entry.getValue());
        }
        return builder.build();
    }

    public static Locale[] localesFromStrings(String[] localeNames) {
        LinkedHashSet<Locale> set = new LinkedHashSet<Locale>();
        for (String localeName : localeNames) {
            set.add(ICU.localeFromIcuLocaleId(localeName));
        }
        return set.toArray(new Locale[set.size()]);
    }

    public static Locale[] getAvailableLocales() {
        if (availableLocalesCache == null) {
            availableLocalesCache = ICU.localesFromStrings(ICU.getAvailableLocalesNative());
        }
        return (Locale[])availableLocalesCache.clone();
    }

    static String getTimePattern(Locale locale, boolean is24Hour, boolean withSecond) {
        String skeleton = withSecond ? (is24Hour ? "Hms" : "hms") : (is24Hour ? "Hm" : "hm");
        return ICU.getBestDateTimePattern(skeleton, locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public static String getBestDateTimePattern(String skeleton, Locale locale) {
        String languageTag = locale.toLanguageTag();
        String key = skeleton + "\t" + languageTag;
        BasicLruCache<String, String> basicLruCache = CACHED_PATTERNS;
        synchronized (basicLruCache) {
            String pattern = CACHED_PATTERNS.get(key);
            if (pattern == null) {
                pattern = ICU.getBestDateTimePattern0(skeleton, locale);
                CACHED_PATTERNS.put(key, pattern);
            }
            return pattern;
        }
    }

    private static String getBestDateTimePattern0(String skeleton, Locale locale) {
        DateTimePatternGenerator dtpg = DateTimePatternGenerator.getInstance(locale);
        return dtpg.getBestPattern(skeleton);
    }

    @UnsupportedAppUsage
    private static String getBestDateTimePatternNative(String skeleton, String languageTag) {
        return ICU.getBestDateTimePattern0(skeleton, Locale.forLanguageTag(languageTag));
    }

    @UnsupportedAppUsage
    public static char[] getDateFormatOrder(String pattern) {
        char[] result = new char[3];
        int resultIndex = 0;
        boolean sawDay = false;
        boolean sawMonth = false;
        boolean sawYear = false;
        for (int i = 0; i < pattern.length(); ++i) {
            char ch = pattern.charAt(i);
            if (ch == 'd' || ch == 'L' || ch == 'M' || ch == 'y') {
                if (ch == 'd' && !sawDay) {
                    result[resultIndex++] = 100;
                    sawDay = true;
                    continue;
                }
                if (!(ch != 'L' && ch != 'M' || sawMonth)) {
                    result[resultIndex++] = 77;
                    sawMonth = true;
                    continue;
                }
                if (ch != 'y' || sawYear) continue;
                result[resultIndex++] = 121;
                sawYear = true;
                continue;
            }
            if (ch == 'G') continue;
            if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z') {
                throw new IllegalArgumentException("Bad pattern character '" + ch + "' in " + pattern);
            }
            if (ch != '\'') continue;
            if (i < pattern.length() - 1 && pattern.charAt(i + 1) == '\'') {
                ++i;
                continue;
            }
            if ((i = pattern.indexOf(39, i + 1)) == -1) {
                throw new IllegalArgumentException("Bad quoting in " + pattern);
            }
            ++i;
        }
        return result;
    }

    public static String transformIcuDateTimePattern_forJavaTime(String pattern) {
        return ICU.transformIcuDateTimePattern(pattern);
    }

    public static String transformIcuDateTimePattern_forJavaText(String pattern) {
        return ICU.transformIcuDateTimePattern(pattern);
    }

    private static String transformIcuDateTimePattern(String pattern) {
        boolean remove_B_and_b;
        if (pattern == null) {
            return null;
        }
        boolean contains_B = pattern.indexOf(66) != -1;
        boolean contains_b = pattern.indexOf(98) != -1;
        boolean bl = remove_B_and_b = (contains_B || contains_b) && pattern.indexOf(72) != -1;
        if (remove_B_and_b) {
            return ICU.removeBFromDateTimePattern(pattern);
        }
        if (pattern.indexOf(104) != -1) {
            if (contains_b) {
                pattern = pattern.replace('b', 'a');
            }
            if (contains_B) {
                pattern = pattern.replace('B', 'a');
            }
        }
        return pattern;
    }

    private static String removeBFromDateTimePattern(String pattern) {
        StringBuilder sb = new StringBuilder(pattern.length());
        int prev = 32;
        for (int i = 0; i < pattern.length(); ++i) {
            char curr = pattern.charAt(i);
            switch (curr) {
                case 'B': 
                case 'b': {
                    break;
                }
                case ' ': {
                    if (i != 0 && (prev == 66 || prev == 98)) break;
                    sb.append(curr);
                    break;
                }
                default: {
                    sb.append(curr);
                }
            }
            prev = curr;
        }
        int lastIndex = sb.length() - 1;
        if (lastIndex >= 0 && sb.charAt(lastIndex) == ' ') {
            sb.deleteCharAt(lastIndex);
        }
        return sb.toString();
    }

    @LayoutlibDelegate
    public static String getCldrVersion() {
        return ICU_Delegate.getCldrVersion();
    }

    @LayoutlibDelegate
    public static String getIcuVersion() {
        return ICU_Delegate.getIcuVersion();
    }

    @LayoutlibDelegate
    public static String getUnicodeVersion() {
        return ICU_Delegate.getUnicodeVersion();
    }

    @LayoutlibDelegate
    private static String[] getAvailableLocalesNative() {
        return ICU_Delegate.getAvailableLocalesNative();
    }

    public static String getCurrencyCode(String countryCode) {
        ULocale countryLocale;
        if (countryCode == null || countryCode.length() == 0) {
            return null;
        }
        try {
            countryLocale = new ULocale.Builder().setRegion(countryCode).build();
        }
        catch (IllformedLocaleException e) {
            return null;
        }
        String[] isoCodes = Currency.getAvailableCurrencyCodes(countryLocale, new Date());
        if (isoCodes == null || isoCodes.length == 0) {
            return null;
        }
        return isoCodes[0];
    }

    @LayoutlibDelegate
    public static String getISO3Country(String string2) {
        return ICU_Delegate.getISO3Country(string2);
    }

    @LayoutlibDelegate
    public static String getISO3Language(String string2) {
        return ICU_Delegate.getISO3Language(string2);
    }

    @Deprecated
    @UnsupportedAppUsage
    public static Locale addLikelySubtags(Locale locale) {
        return ULocale.addLikelySubtags(ULocale.forLocale(locale)).toLocale();
    }

    @Deprecated
    @UnsupportedAppUsage
    public static String addLikelySubtags(String locale) {
        return ULocale.addLikelySubtags(new ULocale(locale)).getName();
    }

    @LayoutlibDelegate
    @Deprecated
    @UnsupportedAppUsage
    public static String getScript(String string2) {
        return ICU_Delegate.getScript(string2);
    }

    @LayoutlibDelegate
    private static String[] getISOLanguagesNative() {
        return ICU_Delegate.getISOLanguagesNative();
    }

    @LayoutlibDelegate
    private static String[] getISOCountriesNative() {
        return ICU_Delegate.getISOCountriesNative();
    }

    public static void setDefaultLocale(String languageTag) {
        LocaleNative.setDefault(languageTag);
    }

    @LayoutlibDelegate
    public static String getDefaultLocale() {
        return ICU_Delegate.getDefaultLocale();
    }

    public static ExtendedCalendar getExtendedCalendar(Locale locale, String calendarType) {
        ULocale uLocale = ULocale.forLocale(locale).setKeywordValue("calendar", calendarType);
        return ExtendedCalendar.getInstance(uLocale);
    }

    public static String convertToTzId(String cldrShortTzId) {
        if (cldrShortTzId == null) {
            return null;
        }
        String tzid = ULocale.toLegacyType("tz", cldrShortTzId);
        if (tzid == null || tzid.equals(cldrShortTzId.toLowerCase(Locale.ROOT))) {
            return null;
        }
        return tzid;
    }

    public static String getGMTZeroFormatString(Locale locale) {
        return TimeZoneFormat.getInstance(locale).getGMTZeroFormat();
    }
}

