/*
 * Decompiled with CFR 0.152.
 */
package libcore.util;

import android.annotation.SystemApi;
import com.android.layoutlib.bridge.libcore.util.Cleaner;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import dalvik.system.VMRuntime;
import java.lang.ref.Reference;
import libcore.util.NativeAllocationRegistry_Delegate;

@SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
public class NativeAllocationRegistry {
    private final ClassLoader classLoader;
    private final long freeFunction;
    private final long size;
    private static final long IS_MALLOCED = 1L;
    private static final long DEFAULT_SIZE = 98L;

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static NativeAllocationRegistry createNonmalloced(ClassLoader classLoader, long freeFunction, long size) {
        return new NativeAllocationRegistry(classLoader, freeFunction, size, false);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static NativeAllocationRegistry createMalloced(ClassLoader classLoader, long freeFunction, long size) {
        return new NativeAllocationRegistry(classLoader, freeFunction, size, true);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static NativeAllocationRegistry createMalloced(ClassLoader classLoader, long freeFunction) {
        return new NativeAllocationRegistry(classLoader, freeFunction, 98L, true);
    }

    private NativeAllocationRegistry(ClassLoader classLoader, long freeFunction, long size, boolean mallocAllocation) {
        if (size < 0L) {
            throw new IllegalArgumentException("Invalid native allocation size: " + size);
        }
        this.classLoader = classLoader;
        this.freeFunction = freeFunction;
        this.size = mallocAllocation ? size | 1L : size & 0xFFFFFFFFFFFFFFFEL;
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public NativeAllocationRegistry(ClassLoader classLoader, long freeFunction, long size) {
        this(classLoader, freeFunction, size, size == 0L);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public Runnable registerNativeAllocation(Object referent, long nativePtr) {
        CleanerRunner result;
        CleanerThunk thunk;
        if (referent == null) {
            throw new IllegalArgumentException("referent is null");
        }
        if (nativePtr == 0L) {
            throw new IllegalArgumentException("nativePtr is null");
        }
        try {
            thunk = new CleanerThunk();
            Cleaner cleaner = Cleaner.create(referent, thunk);
            result = new CleanerRunner(cleaner);
            NativeAllocationRegistry.registerNativeAllocation(this.size);
        }
        catch (VirtualMachineError vme) {
            NativeAllocationRegistry.applyFreeFunction(this.freeFunction, nativePtr);
            throw vme;
        }
        thunk.setNativePtr(nativePtr);
        Reference.reachabilityFence(referent);
        return result;
    }

    private static void registerNativeAllocation(long size) {
        VMRuntime runtime = VMRuntime.getRuntime();
        if ((size & 1L) != 0L) {
            long notifyImmediateThreshold = 300000L;
            if (size >= 300000L) {
                runtime.notifyNativeAllocationsInternal();
            } else {
                runtime.notifyNativeAllocation();
            }
        } else {
            runtime.registerNativeAllocation(size);
        }
    }

    private static void registerNativeFree(long size) {
        if ((size & 1L) == 0L) {
            VMRuntime.getRuntime().registerNativeFree(size);
        }
    }

    @LayoutlibDelegate
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static void applyFreeFunction(long l, long l2) {
        NativeAllocationRegistry_Delegate.applyFreeFunction(l, l2);
    }

    private class CleanerThunk
    implements Runnable {
        private long nativePtr = 0L;

        @Override
        public void run() {
            if (this.nativePtr != 0L) {
                NativeAllocationRegistry.applyFreeFunction(NativeAllocationRegistry.this.freeFunction, this.nativePtr);
                NativeAllocationRegistry.registerNativeFree(NativeAllocationRegistry.this.size);
            }
        }

        public void setNativePtr(long nativePtr) {
            this.nativePtr = nativePtr;
        }

        public String toString() {
            return super.toString() + "(freeFunction = 0x" + Long.toHexString(NativeAllocationRegistry.this.freeFunction) + ", nativePtr = 0x" + Long.toHexString(this.nativePtr) + ", size = " + NativeAllocationRegistry.this.size + ")";
        }
    }

    private static class CleanerRunner
    implements Runnable {
        private final Cleaner cleaner;

        public CleanerRunner(Cleaner cleaner) {
            this.cleaner = cleaner;
        }

        @Override
        public void run() {
            this.cleaner.clean();
        }
    }
}

