/*
 * Decompiled with CFR 0.152.
 */
package android.accessibilityservice.util;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.util.TypedValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;

public class AccessibilityUtils {
    private static final String IMG_PREFIX = "R.drawable.";
    private static final String ANCHOR_TAG = "a";
    private static final List<String> UNSUPPORTED_TAG_LIST = new ArrayList<String>(Collections.singletonList("a"));

    private AccessibilityUtils() {
    }

    public static String getFilteredHtmlText(String text) {
        String replacementStart = "<invalidtag ";
        String replacementEnd = "</invalidtag>";
        for (String tag : UNSUPPORTED_TAG_LIST) {
            String regexStart = "(?i)<" + tag + "(\\s+|>)";
            String regexEnd = "(?i)</" + tag + "\\s*>";
            text = Pattern.compile(regexStart).matcher(text).replaceAll("<invalidtag ");
            text = Pattern.compile(regexEnd).matcher(text).replaceAll("</invalidtag>");
        }
        String regexInvalidImgTag = "(?i)<img\\s+(?!src\\s*=\\s*\"(?-i)R.drawable.)";
        text = Pattern.compile("(?i)<img\\s+(?!src\\s*=\\s*\"(?-i)R.drawable.)").matcher(text).replaceAll("<invalidtag ");
        return text;
    }

    public static Drawable loadSafeAnimatedImage(Context context, ApplicationInfo applicationInfo, int resId) {
        String packageName;
        if (resId == 0) {
            return null;
        }
        PackageManager packageManager = context.getPackageManager();
        Drawable bannerDrawable = packageManager.getDrawable(packageName = applicationInfo.packageName, resId, applicationInfo);
        if (bannerDrawable == null) {
            return null;
        }
        boolean isImageWidthOverScreenLength = bannerDrawable.getIntrinsicWidth() > AccessibilityUtils.getScreenWidthPixels(context);
        boolean isImageHeightOverScreenLength = bannerDrawable.getIntrinsicHeight() > AccessibilityUtils.getScreenHeightPixels(context);
        return isImageWidthOverScreenLength || isImageHeightOverScreenLength ? null : bannerDrawable;
    }

    private static int getScreenWidthPixels(Context context) {
        Resources resources = context.getResources();
        int screenWidthDp = resources.getConfiguration().screenWidthDp;
        return Math.round(TypedValue.applyDimension(1, screenWidthDp, resources.getDisplayMetrics()));
    }

    private static int getScreenHeightPixels(Context context) {
        Resources resources = context.getResources();
        int screenHeightDp = resources.getConfiguration().screenHeightDp;
        return Math.round(TypedValue.applyDimension(1, screenHeightDp, resources.getDisplayMetrics()));
    }
}

