/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.FastPrintWriter;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicLong;

public abstract class PropertyInvalidatedCache<Query, Result> {
    private static final long NONCE_UNSET = 0L;
    private static final long NONCE_DISABLED = -1L;
    private static final String TAG = "PropertyInvalidatedCache";
    private static final boolean DEBUG = false;
    private static final boolean VERIFY = false;
    @GuardedBy(value={"mLock"})
    private long mHits = 0L;
    @GuardedBy(value={"mLock"})
    private long mMisses = 0L;
    @GuardedBy(value={"sCorkLock"})
    private static final HashMap<String, Long> sInvalidates = new HashMap();
    private static boolean sEnabled = true;
    private static final Object sCorkLock = new Object();
    @GuardedBy(value={"sCorkLock"})
    private static final HashMap<String, Integer> sCorks = new HashMap();
    @GuardedBy(value={"sCorkLock"})
    private static final WeakHashMap<PropertyInvalidatedCache, Void> sCaches = new WeakHashMap();
    private final Object mLock = new Object();
    private final String mPropertyName;
    private volatile SystemProperties.Handle mPropertyHandle;
    @GuardedBy(value={"mLock"})
    private final LinkedHashMap<Query, Result> mCache;
    @GuardedBy(value={"mLock"})
    private long mLastSeenNonce = 0L;
    private boolean mDisabled = false;
    private final int mMaxEntries;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertyInvalidatedCache(final int maxEntries, String propertyName) {
        this.mPropertyName = propertyName;
        this.mMaxEntries = maxEntries;
        this.mCache = new LinkedHashMap<Query, Result>(2, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry eldest) {
                return this.size() > maxEntries;
            }
        };
        Object object = sCorkLock;
        synchronized (object) {
            sCaches.put(this, null);
            sInvalidates.put(propertyName, 0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.mLock;
        synchronized (object) {
            this.mCache.clear();
        }
    }

    protected abstract Result recompute(Query var1);

    protected boolean debugCompareQueryResults(Result cachedResult, Result fetchedResult) {
        if (fetchedResult != null) {
            return Objects.equals(cachedResult, fetchedResult);
        }
        return true;
    }

    protected Result refresh(Result oldResult, Query query) {
        return oldResult;
    }

    private long getCurrentNonce() {
        SystemProperties.Handle handle = this.mPropertyHandle;
        if (handle == null) {
            handle = SystemProperties.find(this.mPropertyName);
            if (handle == null) {
                return 0L;
            }
            this.mPropertyHandle = handle;
        }
        return handle.getLong(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableLocal() {
        Object object = this.mLock;
        synchronized (object) {
            this.mDisabled = true;
            this.mCache.clear();
        }
    }

    public boolean isDisabledLocal() {
        return this.mDisabled || !sEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result query(Query query) {
        long currentNonce;
        block18: {
            Result cachedResult;
            block19: {
                Result refreshedResult;
                long l = currentNonce = !this.isDisabledLocal() ? this.getCurrentNonce() : -1L;
                while (true) {
                    if (currentNonce == -1L || currentNonce == 0L) {
                        return this.recompute(query);
                    }
                    Object object = this.mLock;
                    synchronized (object) {
                        if (currentNonce == this.mLastSeenNonce) {
                            cachedResult = this.mCache.get(query);
                            if (cachedResult != null) {
                                ++this.mHits;
                            }
                        } else {
                            this.mCache.clear();
                            this.mLastSeenNonce = currentNonce;
                            cachedResult = null;
                        }
                    }
                    if (cachedResult == null) break block18;
                    refreshedResult = this.refresh(cachedResult, query);
                    if (refreshedResult == cachedResult) break block19;
                    long afterRefreshNonce = this.getCurrentNonce();
                    if (currentNonce == afterRefreshNonce) break;
                    currentNonce = afterRefreshNonce;
                }
                Object object = this.mLock;
                synchronized (object) {
                    if (currentNonce == this.mLastSeenNonce) {
                        if (refreshedResult == null) {
                            this.mCache.remove(query);
                        } else {
                            this.mCache.put(query, refreshedResult);
                        }
                    }
                }
                return this.maybeCheckConsistency(query, refreshedResult);
            }
            return this.maybeCheckConsistency(query, cachedResult);
        }
        Result result = this.recompute(query);
        Object object = this.mLock;
        synchronized (object) {
            if (this.mLastSeenNonce == currentNonce && result != null) {
                this.mCache.put(query, result);
            }
            ++this.mMisses;
        }
        return this.maybeCheckConsistency(query, result);
    }

    public void disableSystemWide() {
        PropertyInvalidatedCache.disableSystemWide(this.mPropertyName);
    }

    public static void disableSystemWide(String name) {
        if (!sEnabled) {
            return;
        }
        SystemProperties.set(name, Long.toString(-1L));
    }

    public void invalidateCache() {
        PropertyInvalidatedCache.invalidateCache(this.mPropertyName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invalidateCache(String name) {
        if (!sEnabled) {
            return;
        }
        Object object = sCorkLock;
        synchronized (object) {
            Integer numberCorks = sCorks.get(name);
            if (numberCorks != null && numberCorks > 0) {
                return;
            }
            PropertyInvalidatedCache.invalidateCacheLocked(name);
        }
    }

    @GuardedBy(value={"sCorkLock"})
    private static void invalidateCacheLocked(String name) {
        long newValue;
        long nonce = SystemProperties.getLong(name, 0L);
        if (nonce == -1L) {
            return;
        }
        while ((newValue = NoPreloadHolder.next()) == 0L || newValue == -1L) {
        }
        String newValueString = Long.toString(newValue);
        SystemProperties.set(name, newValueString);
        long invalidateCount = sInvalidates.getOrDefault(name, 0L);
        sInvalidates.put(name, ++invalidateCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void corkInvalidations(String name) {
        Object object = sCorkLock;
        synchronized (object) {
            long nonce;
            int numberCorks = sCorks.getOrDefault(name, 0);
            if (numberCorks == 0 && (nonce = SystemProperties.getLong(name, 0L)) != 0L && nonce != -1L) {
                SystemProperties.set(name, Long.toString(0L));
            }
            sCorks.put(name, numberCorks + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void uncorkInvalidations(String name) {
        Object object = sCorkLock;
        synchronized (object) {
            int numberCorks = sCorks.getOrDefault(name, 0);
            if (numberCorks < 1) {
                throw new AssertionError((Object)("cork underflow: " + name));
            }
            if (numberCorks == 1) {
                sCorks.remove(name);
                PropertyInvalidatedCache.invalidateCacheLocked(name);
            } else {
                sCorks.put(name, numberCorks - 1);
            }
        }
    }

    protected Result maybeCheckConsistency(Query query, Result proposedResult) {
        return proposedResult;
    }

    public String cacheName() {
        return this.mPropertyName;
    }

    public String queryToString(Query query) {
        return Objects.toString(query);
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public static void disableForTestMode() {
        Log.d(TAG, "disabling all caches in the process");
        sEnabled = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<PropertyInvalidatedCache> getActiveCaches() {
        Object object = sCorkLock;
        synchronized (object) {
            return new ArrayList<PropertyInvalidatedCache>(sCaches.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<Map.Entry<String, Integer>> getActiveCorks() {
        Object object = sCorkLock;
        synchronized (object) {
            return new ArrayList<Map.Entry<String, Integer>>(sCorks.entrySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpContents(PrintWriter pw, String[] args) {
        long invalidateCount;
        Object object = sCorkLock;
        synchronized (object) {
            invalidateCount = sInvalidates.getOrDefault(this.mPropertyName, 0L);
        }
        object = this.mLock;
        synchronized (object) {
            pw.println(String.format("  Cache Property Name: %s", this.cacheName()));
            pw.println(String.format("    Hits: %d, Misses: %d, Invalidates: %d", this.mHits, this.mMisses, invalidateCount));
            pw.println(String.format("    Last Observed Nonce: %d", this.mLastSeenNonce));
            pw.println(String.format("    Current Size: %d, Max Size: %d", this.mCache.entrySet().size(), this.mMaxEntries));
            pw.println(String.format("    Enabled: %s", this.mDisabled ? "false" : "true"));
            Set<Map.Entry<Query, Result>> cacheEntries = this.mCache.entrySet();
            if (cacheEntries.size() == 0) {
                pw.println("");
                return;
            }
            pw.println("");
            pw.println("    Contents:");
            for (Map.Entry<Query, Result> entry : cacheEntries) {
                String key = Objects.toString(entry.getKey());
                String value = Objects.toString(entry.getValue());
                pw.println(String.format("      Key: %s\n      Value: %s\n", key, value));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpCacheInfo(FileDescriptor fd, String[] args) {
        try (FileOutputStream fout = new FileOutputStream(fd);
             FastPrintWriter pw = new FastPrintWriter(fout);){
            ArrayList<PropertyInvalidatedCache> activeCaches;
            if (!sEnabled) {
                pw.println("  Caching is disabled in this process.");
                return;
            }
            Object object = sCorkLock;
            synchronized (object) {
                activeCaches = PropertyInvalidatedCache.getActiveCaches();
                ArrayList<Map.Entry<String, Integer>> activeCorks = PropertyInvalidatedCache.getActiveCorks();
                if (activeCorks.size() > 0) {
                    pw.println("  Corking Status:");
                    for (int i = 0; i < activeCorks.size(); ++i) {
                        Map.Entry<String, Integer> entry = activeCorks.get(i);
                        pw.println(String.format("    Property Name: %s Count: %d", entry.getKey(), entry.getValue()));
                    }
                }
            }
            for (int i = 0; i < activeCaches.size(); ++i) {
                PropertyInvalidatedCache currentCache = activeCaches.get(i);
                currentCache.dumpContents(pw, args);
                ((PrintWriter)pw).flush();
            }
        }
        catch (IOException e) {
            Log.e(TAG, "Failed to dump PropertyInvalidatedCache instances");
        }
    }

    public static class AutoCorker {
        public static final int DEFAULT_AUTO_CORK_DELAY_MS = 2000;
        private final String mPropertyName;
        private final int mAutoCorkDelayMs;
        private final Object mLock = new Object();
        @GuardedBy(value={"mLock"})
        private long mUncorkDeadlineMs = -1L;
        @GuardedBy(value={"mLock"})
        private Handler mHandler;

        public AutoCorker(String propertyName) {
            this(propertyName, 2000);
        }

        public AutoCorker(String propertyName, int autoCorkDelayMs) {
            this.mPropertyName = propertyName;
            this.mAutoCorkDelayMs = autoCorkDelayMs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void autoCork() {
            if (Looper.getMainLooper() == null) {
                PropertyInvalidatedCache.invalidateCache(this.mPropertyName);
                return;
            }
            Object object = this.mLock;
            synchronized (object) {
                boolean alreadyQueued = this.mUncorkDeadlineMs >= 0L;
                this.mUncorkDeadlineMs = SystemClock.uptimeMillis() + (long)this.mAutoCorkDelayMs;
                if (!alreadyQueued) {
                    this.getHandlerLocked().sendEmptyMessageAtTime(0, this.mUncorkDeadlineMs);
                    PropertyInvalidatedCache.corkInvalidations(this.mPropertyName);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleMessage(Message msg) {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mUncorkDeadlineMs < 0L) {
                    return;
                }
                long nowMs = SystemClock.uptimeMillis();
                if (this.mUncorkDeadlineMs > nowMs) {
                    this.mUncorkDeadlineMs = nowMs + (long)this.mAutoCorkDelayMs;
                    this.getHandlerLocked().sendEmptyMessageAtTime(0, this.mUncorkDeadlineMs);
                    return;
                }
                this.mUncorkDeadlineMs = -1L;
                PropertyInvalidatedCache.uncorkInvalidations(this.mPropertyName);
            }
        }

        @GuardedBy(value={"mLock"})
        private Handler getHandlerLocked() {
            if (this.mHandler == null) {
                this.mHandler = new Handler(Looper.getMainLooper()){

                    @Override
                    public void handleMessage(Message msg) {
                        this.handleMessage(msg);
                    }
                };
            }
            return this.mHandler;
        }
    }

    private static class NoPreloadHolder {
        private static final AtomicLong sNextNonce = new AtomicLong(new Random().nextLong());

        private NoPreloadHolder() {
        }

        public static long next() {
            return sNextNonce.getAndIncrement();
        }
    }
}

