/*
 * Decompiled with CFR 0.152.
 */
package android.app.blob;

import android.app.AppGlobals;
import android.app.blob.LeaseInfo;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.format.Formatter;
import java.util.Collections;
import java.util.List;

public class BlobInfo
implements Parcelable {
    private final long mId;
    private final long mExpiryTimeMs;
    private final CharSequence mLabel;
    private final long mSizeBytes;
    private final List<LeaseInfo> mLeaseInfos;
    public static final Parcelable.Creator<BlobInfo> CREATOR = new Parcelable.Creator<BlobInfo>(){

        @Override
        public BlobInfo createFromParcel(Parcel source) {
            return new BlobInfo(source);
        }

        public BlobInfo[] newArray(int size) {
            return new BlobInfo[size];
        }
    };

    public BlobInfo(long id2, long expiryTimeMs, CharSequence label, long sizeBytes, List<LeaseInfo> leaseInfos) {
        this.mId = id2;
        this.mExpiryTimeMs = expiryTimeMs;
        this.mLabel = label;
        this.mSizeBytes = sizeBytes;
        this.mLeaseInfos = leaseInfos;
    }

    private BlobInfo(Parcel in) {
        this.mId = in.readLong();
        this.mExpiryTimeMs = in.readLong();
        this.mLabel = in.readCharSequence();
        this.mSizeBytes = in.readLong();
        this.mLeaseInfos = in.readArrayList(null);
    }

    public long getId() {
        return this.mId;
    }

    public long getExpiryTimeMs() {
        return this.mExpiryTimeMs;
    }

    public CharSequence getLabel() {
        return this.mLabel;
    }

    public long getSizeBytes() {
        return this.mSizeBytes;
    }

    public List<LeaseInfo> getLeases() {
        return Collections.unmodifiableList(this.mLeaseInfos);
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.mId);
        dest.writeLong(this.mExpiryTimeMs);
        dest.writeCharSequence(this.mLabel);
        dest.writeLong(this.mSizeBytes);
        dest.writeList(this.mLeaseInfos);
    }

    public String toString() {
        return this.toShortString();
    }

    private String toShortString() {
        return "BlobInfo {id: " + this.mId + ",expiryMs: " + this.mExpiryTimeMs + ",label: " + this.mLabel + ",size: " + BlobInfo.formatBlobSize(this.mSizeBytes) + ",leases: " + LeaseInfo.toShortString(this.mLeaseInfos) + ",}";
    }

    private static String formatBlobSize(long sizeBytes) {
        return Formatter.formatFileSize(AppGlobals.getInitialApplication(), sizeBytes, 8);
    }

    @Override
    public int describeContents() {
        return 0;
    }
}

