/*
 * Decompiled with CFR 0.152.
 */
package android.app.compat;

import com.android.internal.annotations.Immutable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

@Immutable
class ChangeIdStateQuery {
    static final int QUERY_BY_PACKAGE_NAME = 0;
    static final int QUERY_BY_UID = 1;
    public int type;
    public long changeId;
    public String packageName;
    public int uid;
    public int userId;

    private ChangeIdStateQuery(int type, long changeId, String packageName, int uid, int userId) {
        this.type = type;
        this.changeId = changeId;
        this.packageName = packageName;
        this.uid = uid;
        this.userId = userId;
    }

    static ChangeIdStateQuery byPackageName(long changeId, String packageName, int userId) {
        return new ChangeIdStateQuery(0, changeId, packageName, 0, userId);
    }

    static ChangeIdStateQuery byUid(long changeId, int uid) {
        return new ChangeIdStateQuery(1, changeId, null, uid, 0);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !(other instanceof ChangeIdStateQuery)) {
            return false;
        }
        ChangeIdStateQuery that = (ChangeIdStateQuery)other;
        return this.type == that.type && this.changeId == that.changeId && Objects.equals(this.packageName, that.packageName) && this.uid == that.uid && this.userId == that.userId;
    }

    public int hashCode() {
        return Objects.hash(this.type, this.changeId, this.packageName, this.uid, this.userId);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface QueryType {
    }
}

