/*
 * Decompiled with CFR 0.152.
 */
package android.app.compat;

import android.annotation.SystemApi;
import android.app.compat.ChangeIdStateCache;
import android.app.compat.ChangeIdStateQuery;
import android.compat.Compatibility;
import android.os.UserHandle;

@SystemApi
public class CompatChanges {
    private static final ChangeIdStateCache QUERY_CACHE = new ChangeIdStateCache();

    private CompatChanges() {
    }

    public static boolean isChangeEnabled(long changeId) {
        return Compatibility.isChangeEnabled(changeId);
    }

    public static boolean isChangeEnabled(long changeId, String packageName, UserHandle user) {
        return (Boolean)QUERY_CACHE.query(ChangeIdStateQuery.byPackageName(changeId, packageName, user.getIdentifier()));
    }

    public static boolean isChangeEnabled(long changeId, int uid) {
        return (Boolean)QUERY_CACHE.query(ChangeIdStateQuery.byUid(changeId, uid));
    }
}

