/*
 * Decompiled with CFR 0.152.
 */
package android.app.timedetector;

import android.os.Parcel;
import android.os.Parcelable;
import android.os.TimestampedValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class TelephonyTimeSuggestion
implements Parcelable {
    public static final Parcelable.Creator<TelephonyTimeSuggestion> CREATOR = new Parcelable.Creator<TelephonyTimeSuggestion>(){

        @Override
        public TelephonyTimeSuggestion createFromParcel(Parcel in) {
            return TelephonyTimeSuggestion.createFromParcel(in);
        }

        public TelephonyTimeSuggestion[] newArray(int size) {
            return new TelephonyTimeSuggestion[size];
        }
    };
    private final int mSlotIndex;
    private final TimestampedValue<Long> mUtcTime;
    private ArrayList<String> mDebugInfo;

    private TelephonyTimeSuggestion(Builder builder) {
        this.mSlotIndex = builder.mSlotIndex;
        this.mUtcTime = builder.mUtcTime;
        this.mDebugInfo = builder.mDebugInfo != null ? new ArrayList(builder.mDebugInfo) : null;
    }

    private static TelephonyTimeSuggestion createFromParcel(Parcel in) {
        int slotIndex = in.readInt();
        TelephonyTimeSuggestion suggestion = new Builder(slotIndex).setUtcTime((TimestampedValue)in.readParcelable(null)).build();
        ArrayList debugInfo = in.readArrayList(null);
        if (debugInfo != null) {
            suggestion.addDebugInfo(debugInfo);
        }
        return suggestion;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mSlotIndex);
        dest.writeParcelable(this.mUtcTime, 0);
        dest.writeList(this.mDebugInfo);
    }

    public int getSlotIndex() {
        return this.mSlotIndex;
    }

    public TimestampedValue<Long> getUtcTime() {
        return this.mUtcTime;
    }

    public List<String> getDebugInfo() {
        return this.mDebugInfo == null ? Collections.emptyList() : Collections.unmodifiableList(this.mDebugInfo);
    }

    public void addDebugInfo(String debugInfo) {
        if (this.mDebugInfo == null) {
            this.mDebugInfo = new ArrayList();
        }
        this.mDebugInfo.add(debugInfo);
    }

    public void addDebugInfo(List<String> debugInfo) {
        if (this.mDebugInfo == null) {
            this.mDebugInfo = new ArrayList(debugInfo.size());
        }
        this.mDebugInfo.addAll(debugInfo);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TelephonyTimeSuggestion that = (TelephonyTimeSuggestion)o;
        return this.mSlotIndex == that.mSlotIndex && Objects.equals(this.mUtcTime, that.mUtcTime);
    }

    public int hashCode() {
        return Objects.hash(this.mSlotIndex, this.mUtcTime);
    }

    public String toString() {
        return "TelephonyTimeSuggestion{mSlotIndex='" + this.mSlotIndex + '\'' + ", mUtcTime=" + this.mUtcTime + ", mDebugInfo=" + this.mDebugInfo + '}';
    }

    public static class Builder {
        private final int mSlotIndex;
        private TimestampedValue<Long> mUtcTime;
        private List<String> mDebugInfo;

        public Builder(int slotIndex) {
            this.mSlotIndex = slotIndex;
        }

        public Builder setUtcTime(TimestampedValue<Long> utcTime) {
            if (utcTime != null) {
                Objects.requireNonNull(utcTime.getValue());
            }
            this.mUtcTime = utcTime;
            return this;
        }

        public Builder addDebugInfo(String debugInfo) {
            if (this.mDebugInfo == null) {
                this.mDebugInfo = new ArrayList<String>();
            }
            this.mDebugInfo.add(debugInfo);
            return this;
        }

        public TelephonyTimeSuggestion build() {
            return new TelephonyTimeSuggestion(this);
        }
    }
}

