/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.annotation.SystemApi;
import android.app.ActivityThread;
import android.app.PropertyInvalidatedCache;
import android.bluetooth.BluetoothA2dp;
import android.bluetooth.BluetoothA2dpSink;
import android.bluetooth.BluetoothActivityEnergyInfo;
import android.bluetooth.BluetoothAvrcpController;
import android.bluetooth.BluetoothClass;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattServer;
import android.bluetooth.BluetoothHeadset;
import android.bluetooth.BluetoothHeadsetClient;
import android.bluetooth.BluetoothHearingAid;
import android.bluetooth.BluetoothHidDevice;
import android.bluetooth.BluetoothHidHost;
import android.bluetooth.BluetoothMap;
import android.bluetooth.BluetoothMapClient;
import android.bluetooth.BluetoothPan;
import android.bluetooth.BluetoothPbap;
import android.bluetooth.BluetoothPbapClient;
import android.bluetooth.BluetoothProfile;
import android.bluetooth.BluetoothSap;
import android.bluetooth.BluetoothServerSocket;
import android.bluetooth.IBluetooth;
import android.bluetooth.IBluetoothGatt;
import android.bluetooth.IBluetoothManager;
import android.bluetooth.IBluetoothManagerCallback;
import android.bluetooth.IBluetoothMetadataListener;
import android.bluetooth.IBluetoothStateChangeCallback;
import android.bluetooth.le.BluetoothLeAdvertiser;
import android.bluetooth.le.BluetoothLeScanner;
import android.bluetooth.le.PeriodicAdvertisingManager;
import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanFilter;
import android.bluetooth.le.ScanRecord;
import android.bluetooth.le.ScanResult;
import android.bluetooth.le.ScanSettings;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.os.Binder;
import android.os.IBinder;
import android.os.ParcelUuid;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.ServiceManager;
import android.os.SynchronousResultReceiver;
import android.os.SystemProperties;
import android.util.Log;
import android.util.Pair;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class BluetoothAdapter {
    private static final String TAG = "BluetoothAdapter";
    private static final boolean DBG = true;
    private static final boolean VDBG = false;
    public static final String DEFAULT_MAC_ADDRESS = "02:00:00:00:00:00";
    public static final int ERROR = Integer.MIN_VALUE;
    public static final String ACTION_STATE_CHANGED = "android.bluetooth.adapter.action.STATE_CHANGED";
    public static final String EXTRA_STATE = "android.bluetooth.adapter.extra.STATE";
    public static final String EXTRA_PREVIOUS_STATE = "android.bluetooth.adapter.extra.PREVIOUS_STATE";
    public static final int STATE_OFF = 10;
    public static final int STATE_TURNING_ON = 11;
    public static final int STATE_ON = 12;
    public static final int STATE_TURNING_OFF = 13;
    public static final int STATE_BLE_TURNING_ON = 14;
    public static final int STATE_BLE_ON = 15;
    public static final int STATE_BLE_TURNING_OFF = 16;
    public static final UUID LE_PSM_CHARACTERISTIC_UUID = UUID.fromString("2d410339-82b6-42aa-b34e-e2e01df8cc1a");
    public static final String ACTION_REQUEST_DISCOVERABLE = "android.bluetooth.adapter.action.REQUEST_DISCOVERABLE";
    public static final String EXTRA_DISCOVERABLE_DURATION = "android.bluetooth.adapter.extra.DISCOVERABLE_DURATION";
    public static final String ACTION_REQUEST_ENABLE = "android.bluetooth.adapter.action.REQUEST_ENABLE";
    public static final String ACTION_REQUEST_DISABLE = "android.bluetooth.adapter.action.REQUEST_DISABLE";
    @SystemApi
    public static final String ACTION_REQUEST_BLE_SCAN_ALWAYS_AVAILABLE = "android.bluetooth.adapter.action.REQUEST_BLE_SCAN_ALWAYS_AVAILABLE";
    public static final String ACTION_SCAN_MODE_CHANGED = "android.bluetooth.adapter.action.SCAN_MODE_CHANGED";
    public static final String EXTRA_SCAN_MODE = "android.bluetooth.adapter.extra.SCAN_MODE";
    public static final String EXTRA_PREVIOUS_SCAN_MODE = "android.bluetooth.adapter.extra.PREVIOUS_SCAN_MODE";
    public static final int SCAN_MODE_NONE = 20;
    public static final int SCAN_MODE_CONNECTABLE = 21;
    public static final int SCAN_MODE_CONNECTABLE_DISCOVERABLE = 23;
    public static final int IO_CAPABILITY_OUT = 0;
    public static final int IO_CAPABILITY_IO = 1;
    public static final int IO_CAPABILITY_IN = 2;
    public static final int IO_CAPABILITY_NONE = 3;
    public static final int IO_CAPABILITY_KBDISP = 4;
    public static final int IO_CAPABILITY_MAX = 5;
    public static final int IO_CAPABILITY_UNKNOWN = 255;
    @SystemApi
    public static final int ACTIVE_DEVICE_AUDIO = 0;
    @SystemApi
    public static final int ACTIVE_DEVICE_PHONE_CALL = 1;
    @SystemApi
    public static final int ACTIVE_DEVICE_ALL = 2;
    public static final String ACTION_DISCOVERY_STARTED = "android.bluetooth.adapter.action.DISCOVERY_STARTED";
    public static final String ACTION_DISCOVERY_FINISHED = "android.bluetooth.adapter.action.DISCOVERY_FINISHED";
    public static final String ACTION_LOCAL_NAME_CHANGED = "android.bluetooth.adapter.action.LOCAL_NAME_CHANGED";
    public static final String EXTRA_LOCAL_NAME = "android.bluetooth.adapter.extra.LOCAL_NAME";
    public static final String ACTION_CONNECTION_STATE_CHANGED = "android.bluetooth.adapter.action.CONNECTION_STATE_CHANGED";
    public static final String EXTRA_CONNECTION_STATE = "android.bluetooth.adapter.extra.CONNECTION_STATE";
    public static final String EXTRA_PREVIOUS_CONNECTION_STATE = "android.bluetooth.adapter.extra.PREVIOUS_CONNECTION_STATE";
    @SystemApi
    public static final String ACTION_BLE_STATE_CHANGED = "android.bluetooth.adapter.action.BLE_STATE_CHANGED";
    public static final String ACTION_BLUETOOTH_ADDRESS_CHANGED = "android.bluetooth.adapter.action.BLUETOOTH_ADDRESS_CHANGED";
    public static final String EXTRA_BLUETOOTH_ADDRESS = "android.bluetooth.adapter.extra.BLUETOOTH_ADDRESS";
    public static final String ACTION_BLE_ACL_CONNECTED = "android.bluetooth.adapter.action.BLE_ACL_CONNECTED";
    public static final String ACTION_BLE_ACL_DISCONNECTED = "android.bluetooth.adapter.action.BLE_ACL_DISCONNECTED";
    public static final int STATE_DISCONNECTED = 0;
    public static final int STATE_CONNECTING = 1;
    public static final int STATE_CONNECTED = 2;
    public static final int STATE_DISCONNECTING = 3;
    public static final String BLUETOOTH_MANAGER_SERVICE = "bluetooth_manager";
    private final IBinder mToken;
    public static final int SOCKET_CHANNEL_AUTO_STATIC_NO_SDP = -2;
    private static final int ADDRESS_LENGTH = 17;
    private static BluetoothAdapter sAdapter;
    private static BluetoothLeScanner sBluetoothLeScanner;
    private static BluetoothLeAdvertiser sBluetoothLeAdvertiser;
    private static PeriodicAdvertisingManager sPeriodicAdvertisingManager;
    private final IBluetoothManager mManagerService;
    @UnsupportedAppUsage
    private IBluetooth mService;
    private Context mContext;
    private final ReentrantReadWriteLock mServiceLock = new ReentrantReadWriteLock();
    private final Object mLock = new Object();
    private final Map<LeScanCallback, ScanCallback> mLeScanClients;
    private static final Map<BluetoothDevice, List<Pair<OnMetadataChangedListener, Executor>>> sMetadataListeners;
    private static final IBluetoothMetadataListener sBluetoothMetadataListener;
    private static final String BLUETOOTH_GET_STATE_CACHE_PROPERTY = "cache_key.bluetooth.get_state";
    private final PropertyInvalidatedCache<Void, Integer> mBluetoothGetStateCache = new PropertyInvalidatedCache<Void, Integer>(8, "cache_key.bluetooth.get_state"){

        @Override
        protected Integer recompute(Void query) {
            try {
                return BluetoothAdapter.this.mService.getState();
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    };
    private static final String BLUETOOTH_FILTERING_CACHE_PROPERTY = "cache_key.bluetooth.is_offloaded_filtering_supported";
    private final PropertyInvalidatedCache<Void, Boolean> mBluetoothFilteringCache = new PropertyInvalidatedCache<Void, Boolean>(8, "cache_key.bluetooth.is_offloaded_filtering_supported"){

        @Override
        protected Boolean recompute(Void query) {
            try {
                BluetoothAdapter.this.mServiceLock.readLock().lock();
                if (BluetoothAdapter.this.mService != null) {
                    Boolean bl = BluetoothAdapter.this.mService.isOffloadedFilteringSupported();
                    return bl;
                }
            }
            catch (RemoteException e) {
                Log.e(BluetoothAdapter.TAG, "failed to get isOffloadedFilteringSupported, error: ", e);
            }
            finally {
                BluetoothAdapter.this.mServiceLock.readLock().unlock();
            }
            return false;
        }
    };
    private static final String BLUETOOTH_PROFILE_CACHE_PROPERTY = "cache_key.bluetooth.get_profile_connection_state";
    private final PropertyInvalidatedCache<Integer, Integer> mGetProfileConnectionStateCache = new PropertyInvalidatedCache<Integer, Integer>(8, "cache_key.bluetooth.get_profile_connection_state"){

        @Override
        protected Integer recompute(Integer query) {
            try {
                BluetoothAdapter.this.mServiceLock.readLock().lock();
                if (BluetoothAdapter.this.mService != null) {
                    Integer n = BluetoothAdapter.this.mService.getProfileConnectionState(query);
                    return n;
                }
            }
            catch (RemoteException e) {
                Log.e(BluetoothAdapter.TAG, "getProfileConnectionState:", e);
            }
            finally {
                BluetoothAdapter.this.mServiceLock.readLock().unlock();
            }
            return 0;
        }

        @Override
        public String queryToString(Integer query) {
            return String.format("getProfileConnectionState(profile=\"%d\")", query);
        }
    };
    private final IBluetoothManagerCallback mManagerCallback = new IBluetoothManagerCallback.Stub(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onBluetoothServiceUp(IBluetooth bluetoothService) {
            Log.d(BluetoothAdapter.TAG, "onBluetoothServiceUp: " + bluetoothService);
            BluetoothAdapter.this.mServiceLock.writeLock().lock();
            BluetoothAdapter.this.mService = bluetoothService;
            BluetoothAdapter.this.mServiceLock.writeLock().unlock();
            Object object = BluetoothAdapter.this.mProxyServiceStateCallbacks;
            synchronized (object) {
                for (IBluetoothManagerCallback cb : BluetoothAdapter.this.mProxyServiceStateCallbacks) {
                    try {
                        if (cb != null) {
                            cb.onBluetoothServiceUp(bluetoothService);
                            continue;
                        }
                        Log.d(BluetoothAdapter.TAG, "onBluetoothServiceUp: cb is null!");
                    }
                    catch (Exception e) {
                        Log.e(BluetoothAdapter.TAG, "", e);
                    }
                }
            }
            object = sMetadataListeners;
            synchronized (object) {
                sMetadataListeners.forEach((device, pair) -> {
                    try {
                        BluetoothAdapter.this.mService.registerMetadataListener(sBluetoothMetadataListener, (BluetoothDevice)device);
                    }
                    catch (RemoteException e) {
                        Log.e(BluetoothAdapter.TAG, "Failed to register metadata listener", e);
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onBluetoothServiceDown() {
            Log.d(BluetoothAdapter.TAG, "onBluetoothServiceDown: " + BluetoothAdapter.this.mService);
            try {
                BluetoothAdapter.this.mServiceLock.writeLock().lock();
                BluetoothAdapter.this.mService = null;
                if (BluetoothAdapter.this.mLeScanClients != null) {
                    BluetoothAdapter.this.mLeScanClients.clear();
                }
                if (sBluetoothLeAdvertiser != null) {
                    sBluetoothLeAdvertiser.cleanup();
                }
                if (sBluetoothLeScanner != null) {
                    sBluetoothLeScanner.cleanup();
                }
            }
            finally {
                BluetoothAdapter.this.mServiceLock.writeLock().unlock();
            }
            ArrayList arrayList = BluetoothAdapter.this.mProxyServiceStateCallbacks;
            synchronized (arrayList) {
                for (IBluetoothManagerCallback cb : BluetoothAdapter.this.mProxyServiceStateCallbacks) {
                    try {
                        if (cb != null) {
                            cb.onBluetoothServiceDown();
                            continue;
                        }
                        Log.d(BluetoothAdapter.TAG, "onBluetoothServiceDown: cb is null!");
                    }
                    catch (Exception e) {
                        Log.e(BluetoothAdapter.TAG, "", e);
                    }
                }
            }
        }

        @Override
        public void onBrEdrDown() {
        }
    };
    private final ArrayList<IBluetoothManagerCallback> mProxyServiceStateCallbacks = new ArrayList();

    public static String nameForState(int state) {
        switch (state) {
            case 10: {
                return "OFF";
            }
            case 11: {
                return "TURNING_ON";
            }
            case 12: {
                return "ON";
            }
            case 13: {
                return "TURNING_OFF";
            }
            case 14: {
                return "BLE_TURNING_ON";
            }
            case 15: {
                return "BLE_ON";
            }
            case 16: {
                return "BLE_TURNING_OFF";
            }
        }
        return "?!?!? (" + state + ")";
    }

    public static synchronized BluetoothAdapter getDefaultAdapter() {
        if (sAdapter == null) {
            IBinder b = ServiceManager.getService(BLUETOOTH_MANAGER_SERVICE);
            if (b != null) {
                IBluetoothManager managerService = IBluetoothManager.Stub.asInterface(b);
                sAdapter = new BluetoothAdapter(managerService);
            } else {
                Log.e(TAG, "Bluetooth binder is null");
            }
        }
        return sAdapter;
    }

    BluetoothAdapter(IBluetoothManager managerService) {
        if (managerService == null) {
            throw new IllegalArgumentException("bluetooth manager service is null");
        }
        try {
            this.mServiceLock.writeLock().lock();
            this.mService = managerService.registerAdapter(this.mManagerCallback);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
        }
        finally {
            this.mServiceLock.writeLock().unlock();
        }
        this.mManagerService = managerService;
        this.mLeScanClients = new HashMap<LeScanCallback, ScanCallback>();
        this.mToken = new Binder();
    }

    public BluetoothDevice getRemoteDevice(String address) {
        return new BluetoothDevice(address);
    }

    public BluetoothDevice getRemoteDevice(byte[] address) {
        if (address == null || address.length != 6) {
            throw new IllegalArgumentException("Bluetooth address must have 6 bytes");
        }
        return new BluetoothDevice(String.format(Locale.US, "%02X:%02X:%02X:%02X:%02X:%02X", address[0], address[1], address[2], address[3], address[4], address[5]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BluetoothLeAdvertiser getBluetoothLeAdvertiser() {
        if (!this.getLeAccess()) {
            return null;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (sBluetoothLeAdvertiser == null) {
                sBluetoothLeAdvertiser = new BluetoothLeAdvertiser(this.mManagerService);
            }
        }
        return sBluetoothLeAdvertiser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PeriodicAdvertisingManager getPeriodicAdvertisingManager() {
        if (!this.getLeAccess()) {
            return null;
        }
        if (!this.isLePeriodicAdvertisingSupported()) {
            return null;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (sPeriodicAdvertisingManager == null) {
                sPeriodicAdvertisingManager = new PeriodicAdvertisingManager(this.mManagerService);
            }
        }
        return sPeriodicAdvertisingManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BluetoothLeScanner getBluetoothLeScanner() {
        if (!this.getLeAccess()) {
            return null;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (sBluetoothLeScanner == null) {
                sBluetoothLeScanner = new BluetoothLeScanner(this.mManagerService, this.getOpPackageName(), this.getAttributionTag());
            }
        }
        return sBluetoothLeScanner;
    }

    public boolean isEnabled() {
        return this.getState() == 12;
    }

    @SystemApi
    public boolean isLeEnabled() {
        int state = this.getLeState();
        Log.d(TAG, "isLeEnabled(): " + BluetoothAdapter.nameForState(state));
        return state == 12 || state == 15 || state == 11 || state == 13;
    }

    @SystemApi
    public boolean disableBLE() {
        if (!this.isBleScanAlwaysAvailable()) {
            return false;
        }
        String packageName = ActivityThread.currentPackageName();
        try {
            return this.mManagerService.disableBle(packageName, this.mToken);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
    }

    @SystemApi
    public boolean enableBLE() {
        if (!this.isBleScanAlwaysAvailable()) {
            return false;
        }
        String packageName = ActivityThread.currentPackageName();
        try {
            return this.mManagerService.enableBle(packageName, this.mToken);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
    }

    public void disableBluetoothGetStateCache() {
        this.mBluetoothGetStateCache.disableLocal();
    }

    public static void invalidateBluetoothGetStateCache() {
        PropertyInvalidatedCache.invalidateCache(BLUETOOTH_GET_STATE_CACHE_PROPERTY);
    }

    private int getStateInternal() {
        int state;
        block7: {
            state = 10;
            try {
                this.mServiceLock.readLock().lock();
                if (this.mService != null) {
                    state = this.mBluetoothGetStateCache.query(null);
                }
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof RemoteException) {
                    Log.e(TAG, "", e.getCause());
                    break block7;
                }
                throw e;
            }
            finally {
                this.mServiceLock.readLock().unlock();
            }
        }
        return state;
    }

    public int getState() {
        int state = this.getStateInternal();
        if (state == 15 || state == 14 || state == 16) {
            state = 10;
        }
        return state;
    }

    @UnsupportedAppUsage(publicAlternatives="Use {@link #getState()} instead to determine whether you can use BLE & BT classic.")
    public int getLeState() {
        int state = this.getStateInternal();
        return state;
    }

    boolean getLeAccess() {
        if (this.getLeState() == 12) {
            return true;
        }
        return this.getLeState() == 15;
    }

    public boolean enable() {
        if (this.isEnabled()) {
            Log.d(TAG, "enable(): BT already enabled!");
            return true;
        }
        try {
            return this.mManagerService.enable(ActivityThread.currentPackageName());
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
    }

    public boolean disable() {
        try {
            return this.mManagerService.disable(ActivityThread.currentPackageName(), true);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
    }

    @UnsupportedAppUsage
    public boolean disable(boolean persist) {
        try {
            return this.mManagerService.disable(ActivityThread.currentPackageName(), persist);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
    }

    public String getAddress() {
        try {
            return this.mManagerService.getAddress();
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return null;
        }
    }

    public String getName() {
        try {
            return this.mManagerService.getName();
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return null;
        }
    }

    @UnsupportedAppUsage
    public boolean factoryReset() {
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null && this.mService.factoryReset() && this.mManagerService != null && this.mManagerService.onFactoryReset()) {
                boolean bl = true;
                return bl;
            }
            Log.e(TAG, "factoryReset(): Setting persist.bluetooth.factoryreset to retry later");
            SystemProperties.set("persist.bluetooth.factoryreset", "true");
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return false;
    }

    @UnsupportedAppUsage
    public ParcelUuid[] getUuids() {
        if (this.getState() != 12) {
            return null;
        }
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null) {
                ParcelUuid[] parcelUuidArray = this.mService.getUuids();
                return parcelUuidArray;
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return null;
    }

    public boolean setName(String name) {
        if (this.getState() != 12) {
            return false;
        }
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null) {
                boolean bl = this.mService.setName(name);
                return bl;
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return false;
    }

    public BluetoothClass getBluetoothClass() {
        if (this.getState() != 12) {
            return null;
        }
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null) {
                BluetoothClass bluetoothClass = this.mService.getBluetoothClass();
                return bluetoothClass;
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return null;
    }

    public boolean setBluetoothClass(BluetoothClass bluetoothClass) {
        if (this.getState() != 12) {
            return false;
        }
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null) {
                boolean bl = this.mService.setBluetoothClass(bluetoothClass);
                return bl;
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return false;
    }

    public int getIoCapability() {
        if (this.getState() != 12) {
            return 255;
        }
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null) {
                int n = this.mService.getIoCapability();
                return n;
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, e.getMessage(), e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return 255;
    }

    public boolean setIoCapability(int capability) {
        if (this.getState() != 12) {
            return false;
        }
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null) {
                boolean bl = this.mService.setIoCapability(capability);
                return bl;
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, e.getMessage(), e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return false;
    }

    public int getLeIoCapability() {
        if (this.getState() != 12) {
            return 255;
        }
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null) {
                int n = this.mService.getLeIoCapability();
                return n;
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, e.getMessage(), e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return 255;
    }

    public boolean setLeIoCapability(int capability) {
        if (this.getState() != 12) {
            return false;
        }
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null) {
                boolean bl = this.mService.setLeIoCapability(capability);
                return bl;
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, e.getMessage(), e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return false;
    }

    public int getScanMode() {
        if (this.getState() != 12) {
            return 20;
        }
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null) {
                int n = this.mService.getScanMode();
                return n;
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return 20;
    }

    @UnsupportedAppUsage(publicAlternatives="Use {@link #ACTION_REQUEST_DISCOVERABLE}, which shows UI that confirms the user wants to go into discoverable mode.")
    public boolean setScanMode(int mode, long durationMillis) {
        if (this.getState() != 12) {
            return false;
        }
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null) {
                int durationSeconds = Math.toIntExact(durationMillis / 1000L);
                boolean bl = this.mService.setScanMode(mode, durationSeconds);
                return bl;
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
        }
        catch (ArithmeticException ex) {
            Log.e(TAG, "setScanMode: Duration in seconds outside of the bounds of an int");
            throw new IllegalArgumentException("Duration not in bounds. In seconds, the durationMillis must be in the range of an int");
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return false;
    }

    @UnsupportedAppUsage
    public boolean setScanMode(int mode) {
        if (this.getState() != 12) {
            return false;
        }
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null) {
                boolean bl = this.mService.setScanMode(mode, this.getDiscoverableTimeout());
                return bl;
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return false;
    }

    @UnsupportedAppUsage
    public int getDiscoverableTimeout() {
        if (this.getState() != 12) {
            return -1;
        }
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null) {
                int n = this.mService.getDiscoverableTimeout();
                return n;
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return -1;
    }

    @UnsupportedAppUsage
    public void setDiscoverableTimeout(int timeout) {
        if (this.getState() != 12) {
            return;
        }
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null) {
                this.mService.setDiscoverableTimeout(timeout);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
    }

    @SystemApi
    public long getDiscoveryEndMillis() {
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null) {
                long l = this.mService.getDiscoveryEndMillis();
                return l;
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return -1L;
    }

    public void setContext(Context context) {
        this.mContext = context;
    }

    private String getOpPackageName() {
        if (this.mContext != null) {
            return this.mContext.getOpPackageName();
        }
        return ActivityThread.currentOpPackageName();
    }

    private String getAttributionTag() {
        if (this.mContext != null) {
            return this.mContext.getAttributionTag();
        }
        return null;
    }

    public boolean startDiscovery() {
        if (this.getState() != 12) {
            return false;
        }
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null) {
                boolean bl = this.mService.startDiscovery(this.getOpPackageName(), this.getAttributionTag());
                return bl;
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return false;
    }

    public boolean cancelDiscovery() {
        if (this.getState() != 12) {
            return false;
        }
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null) {
                boolean bl = this.mService.cancelDiscovery();
                return bl;
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return false;
    }

    public boolean isDiscovering() {
        if (this.getState() != 12) {
            return false;
        }
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null) {
                boolean bl = this.mService.isDiscovering();
                return bl;
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return false;
    }

    @SystemApi
    public boolean removeActiveDevice(int profiles) {
        if (profiles != 0 && profiles != 1 && profiles != 2) {
            Log.e(TAG, "Invalid profiles param value in removeActiveDevice");
            throw new IllegalArgumentException("Profiles must be one of BluetoothAdapter.ACTIVE_DEVICE_AUDIO, BluetoothAdapter.ACTIVE_DEVICE_PHONE_CALL, or BluetoothAdapter.ACTIVE_DEVICE_ALL");
        }
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null) {
                boolean bl = this.mService.removeActiveDevice(profiles);
                return bl;
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    public boolean setActiveDevice(BluetoothDevice device, int profiles) {
        if (device == null) {
            Log.e(TAG, "setActiveDevice: Null device passed as parameter");
            throw new IllegalArgumentException("device cannot be null");
        }
        if (profiles != 0 && profiles != 1 && profiles != 2) {
            Log.e(TAG, "Invalid profiles param value in setActiveDevice");
            throw new IllegalArgumentException("Profiles must be one of BluetoothAdapter.ACTIVE_DEVICE_AUDIO, BluetoothAdapter.ACTIVE_DEVICE_PHONE_CALL, or BluetoothAdapter.ACTIVE_DEVICE_ALL");
        }
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null) {
                boolean bl = this.mService.setActiveDevice(device, profiles);
                return bl;
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return false;
    }

    public boolean connectAllEnabledProfiles(BluetoothDevice device) {
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null) {
                boolean bl = this.mService.connectAllEnabledProfiles(device);
                return bl;
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return false;
    }

    public boolean disconnectAllEnabledProfiles(BluetoothDevice device) {
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null) {
                boolean bl = this.mService.disconnectAllEnabledProfiles(device);
                return bl;
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return false;
    }

    public boolean isMultipleAdvertisementSupported() {
        if (this.getState() != 12) {
            return false;
        }
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null) {
                boolean bl = this.mService.isMultiAdvertisementSupported();
                return bl;
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "failed to get isMultipleAdvertisementSupported, error: ", e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return false;
    }

    @SystemApi
    public boolean isBleScanAlwaysAvailable() {
        try {
            return this.mManagerService.isBleScanAlwaysAvailable();
        }
        catch (RemoteException e) {
            Log.e(TAG, "remote expection when calling isBleScanAlwaysAvailable", e);
            return false;
        }
    }

    public void disableIsOffloadedFilteringSupportedCache() {
        this.mBluetoothFilteringCache.disableLocal();
    }

    public static void invalidateIsOffloadedFilteringSupportedCache() {
        PropertyInvalidatedCache.invalidateCache(BLUETOOTH_FILTERING_CACHE_PROPERTY);
    }

    public boolean isOffloadedFilteringSupported() {
        if (!this.getLeAccess()) {
            return false;
        }
        return this.mBluetoothFilteringCache.query(null);
    }

    public boolean isOffloadedScanBatchingSupported() {
        if (!this.getLeAccess()) {
            return false;
        }
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null) {
                boolean bl = this.mService.isOffloadedScanBatchingSupported();
                return bl;
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "failed to get isOffloadedScanBatchingSupported, error: ", e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return false;
    }

    public boolean isLe2MPhySupported() {
        if (!this.getLeAccess()) {
            return false;
        }
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null) {
                boolean bl = this.mService.isLe2MPhySupported();
                return bl;
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "failed to get isExtendedAdvertisingSupported, error: ", e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return false;
    }

    public boolean isLeCodedPhySupported() {
        if (!this.getLeAccess()) {
            return false;
        }
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null) {
                boolean bl = this.mService.isLeCodedPhySupported();
                return bl;
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "failed to get isLeCodedPhySupported, error: ", e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return false;
    }

    public boolean isLeExtendedAdvertisingSupported() {
        if (!this.getLeAccess()) {
            return false;
        }
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null) {
                boolean bl = this.mService.isLeExtendedAdvertisingSupported();
                return bl;
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "failed to get isLeExtendedAdvertisingSupported, error: ", e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return false;
    }

    public boolean isLePeriodicAdvertisingSupported() {
        if (!this.getLeAccess()) {
            return false;
        }
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null) {
                boolean bl = this.mService.isLePeriodicAdvertisingSupported();
                return bl;
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "failed to get isLePeriodicAdvertisingSupported, error: ", e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return false;
    }

    public int getLeMaximumAdvertisingDataLength() {
        if (!this.getLeAccess()) {
            return 0;
        }
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null) {
                int n = this.mService.getLeMaximumAdvertisingDataLength();
                return n;
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "failed to get getLeMaximumAdvertisingDataLength, error: ", e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return 0;
    }

    private boolean isHearingAidProfileSupported() {
        try {
            return this.mManagerService.isHearingAidProfileSupported();
        }
        catch (RemoteException e) {
            Log.e(TAG, "remote expection when calling isHearingAidProfileSupported", e);
            return false;
        }
    }

    public int getMaxConnectedAudioDevices() {
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null) {
                int n = this.mService.getMaxConnectedAudioDevices();
                return n;
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "failed to get getMaxConnectedAudioDevices, error: ", e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return 1;
    }

    public boolean isHardwareTrackingFiltersAvailable() {
        if (!this.getLeAccess()) {
            return false;
        }
        try {
            IBluetoothGatt iGatt = this.mManagerService.getBluetoothGatt();
            if (iGatt == null) {
                return false;
            }
            return iGatt.numHwTrackFiltersAvailable() != 0;
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
    }

    @Deprecated
    public BluetoothActivityEnergyInfo getControllerActivityEnergyInfo(int updateType) {
        SynchronousResultReceiver receiver = new SynchronousResultReceiver();
        this.requestControllerActivityEnergyInfo(receiver);
        try {
            SynchronousResultReceiver.Result result = receiver.awaitResult(1000L);
            if (result.bundle != null) {
                return (BluetoothActivityEnergyInfo)result.bundle.getParcelable("controller_activity");
            }
        }
        catch (TimeoutException e) {
            Log.e(TAG, "getControllerActivityEnergyInfo timed out");
        }
        return null;
    }

    public void requestControllerActivityEnergyInfo(ResultReceiver result) {
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null) {
                this.mService.requestActivityInfo(result);
                result = null;
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "getControllerActivityEnergyInfoCallback: " + e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
            if (result != null) {
                result.send(0, null);
            }
        }
    }

    public List<BluetoothDevice> getMostRecentlyConnectedDevices() {
        if (this.getState() != 12) {
            return new ArrayList<BluetoothDevice>();
        }
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null) {
                List<BluetoothDevice> list = this.mService.getMostRecentlyConnectedDevices();
                return list;
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return new ArrayList<BluetoothDevice>();
    }

    public Set<BluetoothDevice> getBondedDevices() {
        if (this.getState() != 12) {
            return this.toDeviceSet(new BluetoothDevice[0]);
        }
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null) {
                Set<BluetoothDevice> set = this.toDeviceSet(this.mService.getBondedDevices());
                return set;
            }
            Set<BluetoothDevice> set = this.toDeviceSet(new BluetoothDevice[0]);
            return set;
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Integer> getSupportedProfiles() {
        ArrayList<Integer> supportedProfiles = new ArrayList<Integer>();
        try {
            IBluetoothManagerCallback iBluetoothManagerCallback = this.mManagerCallback;
            synchronized (iBluetoothManagerCallback) {
                if (this.mService != null) {
                    long supportedProfilesBitMask = this.mService.getSupportedProfiles();
                    for (int i = 0; i <= 21; ++i) {
                        if ((supportedProfilesBitMask & (long)(1 << i)) == 0L) continue;
                        supportedProfiles.add(i);
                    }
                } else if (this.isHearingAidProfileSupported()) {
                    supportedProfiles.add(21);
                }
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "getSupportedProfiles:", e);
        }
        return supportedProfiles;
    }

    @UnsupportedAppUsage
    public int getConnectionState() {
        if (this.getState() != 12) {
            return 0;
        }
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null) {
                int n = this.mService.getAdapterConnectionState();
                return n;
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "getConnectionState:", e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return 0;
    }

    public void disableGetProfileConnectionStateCache() {
        this.mGetProfileConnectionStateCache.disableLocal();
    }

    public static void invalidateGetProfileConnectionStateCache() {
        PropertyInvalidatedCache.invalidateCache(BLUETOOTH_PROFILE_CACHE_PROPERTY);
    }

    public int getProfileConnectionState(int profile) {
        if (this.getState() != 12) {
            return 0;
        }
        return this.mGetProfileConnectionStateCache.query(new Integer(profile));
    }

    public BluetoothServerSocket listenUsingRfcommOn(int channel) throws IOException {
        return this.listenUsingRfcommOn(channel, false, false);
    }

    @UnsupportedAppUsage
    public BluetoothServerSocket listenUsingRfcommOn(int channel, boolean mitm, boolean min16DigitPin) throws IOException {
        BluetoothServerSocket socket = new BluetoothServerSocket(1, true, true, channel, mitm, min16DigitPin);
        int errno = socket.mSocket.bindListen();
        if (channel == -2) {
            socket.setChannel(socket.mSocket.getPort());
        }
        if (errno != 0) {
            throw new IOException("Error: " + errno);
        }
        return socket;
    }

    public BluetoothServerSocket listenUsingRfcommWithServiceRecord(String name, UUID uuid) throws IOException {
        return this.createNewRfcommSocketAndRecord(name, uuid, true, true);
    }

    public BluetoothServerSocket listenUsingInsecureRfcommWithServiceRecord(String name, UUID uuid) throws IOException {
        return this.createNewRfcommSocketAndRecord(name, uuid, false, false);
    }

    @UnsupportedAppUsage
    public BluetoothServerSocket listenUsingEncryptedRfcommWithServiceRecord(String name, UUID uuid) throws IOException {
        return this.createNewRfcommSocketAndRecord(name, uuid, false, true);
    }

    private BluetoothServerSocket createNewRfcommSocketAndRecord(String name, UUID uuid, boolean auth, boolean encrypt) throws IOException {
        BluetoothServerSocket socket = new BluetoothServerSocket(1, auth, encrypt, new ParcelUuid(uuid));
        socket.setServiceName(name);
        int errno = socket.mSocket.bindListen();
        if (errno != 0) {
            throw new IOException("Error: " + errno);
        }
        return socket;
    }

    public BluetoothServerSocket listenUsingInsecureRfcommOn(int port) throws IOException {
        BluetoothServerSocket socket = new BluetoothServerSocket(1, false, false, port);
        int errno = socket.mSocket.bindListen();
        if (port == -2) {
            socket.setChannel(socket.mSocket.getPort());
        }
        if (errno != 0) {
            throw new IOException("Error: " + errno);
        }
        return socket;
    }

    public BluetoothServerSocket listenUsingEncryptedRfcommOn(int port) throws IOException {
        BluetoothServerSocket socket = new BluetoothServerSocket(1, false, true, port);
        int errno = socket.mSocket.bindListen();
        if (port == -2) {
            socket.setChannel(socket.mSocket.getPort());
        }
        if (errno < 0) {
            throw new IOException("Error: " + errno);
        }
        return socket;
    }

    public static BluetoothServerSocket listenUsingScoOn() throws IOException {
        BluetoothServerSocket socket = new BluetoothServerSocket(2, false, false, -1);
        int errno = socket.mSocket.bindListen();
        if (errno < 0) {
            // empty if block
        }
        return socket;
    }

    public BluetoothServerSocket listenUsingL2capOn(int port, boolean mitm, boolean min16DigitPin) throws IOException {
        BluetoothServerSocket socket = new BluetoothServerSocket(3, true, true, port, mitm, min16DigitPin);
        int errno = socket.mSocket.bindListen();
        if (port == -2) {
            int assignedChannel = socket.mSocket.getPort();
            Log.d(TAG, "listenUsingL2capOn: set assigned channel to " + assignedChannel);
            socket.setChannel(assignedChannel);
        }
        if (errno != 0) {
            throw new IOException("Error: " + errno);
        }
        return socket;
    }

    public BluetoothServerSocket listenUsingL2capOn(int port) throws IOException {
        return this.listenUsingL2capOn(port, false, false);
    }

    public BluetoothServerSocket listenUsingInsecureL2capOn(int port) throws IOException {
        Log.d(TAG, "listenUsingInsecureL2capOn: port=" + port);
        BluetoothServerSocket socket = new BluetoothServerSocket(3, false, false, port, false, false);
        int errno = socket.mSocket.bindListen();
        if (port == -2) {
            int assignedChannel = socket.mSocket.getPort();
            Log.d(TAG, "listenUsingInsecureL2capOn: set assigned channel to " + assignedChannel);
            socket.setChannel(assignedChannel);
        }
        if (errno != 0) {
            throw new IOException("Error: " + errno);
        }
        return socket;
    }

    public Pair<byte[], byte[]> readOutOfBandData() {
        return null;
    }

    public boolean getProfileProxy(Context context, BluetoothProfile.ServiceListener listener, int profile) {
        if (context == null || listener == null) {
            return false;
        }
        if (profile == 1) {
            BluetoothHeadset headset = new BluetoothHeadset(context, listener);
            return true;
        }
        if (profile == 2) {
            BluetoothA2dp a2dp = new BluetoothA2dp(context, listener);
            return true;
        }
        if (profile == 11) {
            BluetoothA2dpSink a2dpSink = new BluetoothA2dpSink(context, listener);
            return true;
        }
        if (profile == 12) {
            BluetoothAvrcpController avrcp = new BluetoothAvrcpController(context, listener);
            return true;
        }
        if (profile == 4) {
            BluetoothHidHost iDev = new BluetoothHidHost(context, listener);
            return true;
        }
        if (profile == 5) {
            BluetoothPan pan = new BluetoothPan(context, listener);
            return true;
        }
        if (profile == 6) {
            BluetoothPbap pbap = new BluetoothPbap(context, listener);
            return true;
        }
        if (profile == 3) {
            Log.e(TAG, "getProfileProxy(): BluetoothHealth is deprecated");
            return false;
        }
        if (profile == 9) {
            BluetoothMap map = new BluetoothMap(context, listener);
            return true;
        }
        if (profile == 16) {
            BluetoothHeadsetClient headsetClient = new BluetoothHeadsetClient(context, listener);
            return true;
        }
        if (profile == 10) {
            BluetoothSap sap = new BluetoothSap(context, listener);
            return true;
        }
        if (profile == 17) {
            BluetoothPbapClient pbapClient = new BluetoothPbapClient(context, listener);
            return true;
        }
        if (profile == 18) {
            BluetoothMapClient mapClient = new BluetoothMapClient(context, listener);
            return true;
        }
        if (profile == 19) {
            BluetoothHidDevice hidDevice = new BluetoothHidDevice(context, listener);
            return true;
        }
        if (profile == 21) {
            if (this.isHearingAidProfileSupported()) {
                BluetoothHearingAid hearingAid = new BluetoothHearingAid(context, listener);
                return true;
            }
            return false;
        }
        return false;
    }

    public void closeProfileProxy(int profile, BluetoothProfile proxy) {
        if (proxy == null) {
            return;
        }
        switch (profile) {
            case 1: {
                BluetoothHeadset headset = (BluetoothHeadset)proxy;
                headset.close();
                break;
            }
            case 2: {
                BluetoothA2dp a2dp = (BluetoothA2dp)proxy;
                a2dp.close();
                break;
            }
            case 11: {
                BluetoothA2dpSink a2dpSink = (BluetoothA2dpSink)proxy;
                a2dpSink.close();
                break;
            }
            case 12: {
                BluetoothAvrcpController avrcp = (BluetoothAvrcpController)proxy;
                avrcp.close();
                break;
            }
            case 4: {
                BluetoothHidHost iDev = (BluetoothHidHost)proxy;
                iDev.close();
                break;
            }
            case 5: {
                BluetoothPan pan = (BluetoothPan)proxy;
                pan.close();
                break;
            }
            case 6: {
                BluetoothPbap pbap = (BluetoothPbap)proxy;
                pbap.close();
                break;
            }
            case 7: {
                BluetoothGatt gatt = (BluetoothGatt)proxy;
                gatt.close();
                break;
            }
            case 8: {
                BluetoothGattServer gattServer = (BluetoothGattServer)proxy;
                gattServer.close();
                break;
            }
            case 9: {
                BluetoothMap map = (BluetoothMap)proxy;
                map.close();
                break;
            }
            case 16: {
                BluetoothHeadsetClient headsetClient = (BluetoothHeadsetClient)proxy;
                headsetClient.close();
                break;
            }
            case 10: {
                BluetoothSap sap = (BluetoothSap)proxy;
                sap.close();
                break;
            }
            case 17: {
                BluetoothPbapClient pbapClient = (BluetoothPbapClient)proxy;
                pbapClient.close();
                break;
            }
            case 18: {
                BluetoothMapClient mapClient = (BluetoothMapClient)proxy;
                mapClient.close();
                break;
            }
            case 19: {
                BluetoothHidDevice hidDevice = (BluetoothHidDevice)proxy;
                hidDevice.close();
                break;
            }
            case 21: {
                BluetoothHearingAid hearingAid = (BluetoothHearingAid)proxy;
                hearingAid.close();
            }
        }
    }

    @SystemApi
    public boolean enableNoAutoConnect() {
        if (this.isEnabled()) {
            Log.d(TAG, "enableNoAutoConnect(): BT already enabled!");
            return true;
        }
        try {
            return this.mManagerService.enableNoAutoConnect(ActivityThread.currentPackageName());
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
    }

    public boolean changeApplicationBluetoothState(boolean on, BluetoothStateChangeCallback callback) {
        return false;
    }

    private Set<BluetoothDevice> toDeviceSet(BluetoothDevice[] devices) {
        HashSet<BluetoothDevice> deviceSet = new HashSet<BluetoothDevice>(Arrays.asList(devices));
        return Collections.unmodifiableSet(deviceSet);
    }

    protected void finalize() throws Throwable {
        try {
            this.mManagerService.unregisterAdapter(this.mManagerCallback);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
        }
        finally {
            super.finalize();
        }
    }

    public static boolean checkBluetoothAddress(String address) {
        if (address == null || address.length() != 17) {
            return false;
        }
        block4: for (int i = 0; i < 17; ++i) {
            char c = address.charAt(i);
            switch (i % 3) {
                case 0: 
                case 1: {
                    if (c >= '0' && c <= '9' || c >= 'A' && c <= 'F') continue block4;
                    return false;
                }
                case 2: {
                    if (c == ':') continue block4;
                    return false;
                }
            }
        }
        return true;
    }

    @UnsupportedAppUsage
    IBluetoothManager getBluetoothManager() {
        return this.mManagerService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    IBluetooth getBluetoothService(IBluetoothManagerCallback cb) {
        ArrayList<IBluetoothManagerCallback> arrayList = this.mProxyServiceStateCallbacks;
        synchronized (arrayList) {
            if (cb == null) {
                Log.w(TAG, "getBluetoothService() called with no BluetoothManagerCallback");
            } else if (!this.mProxyServiceStateCallbacks.contains(cb)) {
                this.mProxyServiceStateCallbacks.add(cb);
            }
        }
        return this.mService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeServiceStateCallback(IBluetoothManagerCallback cb) {
        ArrayList<IBluetoothManagerCallback> arrayList = this.mProxyServiceStateCallbacks;
        synchronized (arrayList) {
            this.mProxyServiceStateCallbacks.remove(cb);
        }
    }

    @Deprecated
    public boolean startLeScan(LeScanCallback callback) {
        return this.startLeScan(null, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public boolean startLeScan(final UUID[] serviceUuids, final LeScanCallback callback) {
        Log.d(TAG, "startLeScan(): " + Arrays.toString(serviceUuids));
        if (callback == null) {
            Log.e(TAG, "startLeScan: null callback");
            return false;
        }
        BluetoothLeScanner scanner = this.getBluetoothLeScanner();
        if (scanner == null) {
            Log.e(TAG, "startLeScan: cannot get BluetoothLeScanner");
            return false;
        }
        Map<LeScanCallback, ScanCallback> map = this.mLeScanClients;
        synchronized (map) {
            if (this.mLeScanClients.containsKey(callback)) {
                Log.e(TAG, "LE Scan has already started");
                return false;
            }
            try {
                IBluetoothGatt iGatt = this.mManagerService.getBluetoothGatt();
                if (iGatt == null) {
                    return false;
                }
                ScanCallback scanCallback = new ScanCallback(){

                    @Override
                    public void onScanResult(int callbackType, ScanResult result) {
                        if (callbackType != 1) {
                            Log.e(BluetoothAdapter.TAG, "LE Scan has already started");
                            return;
                        }
                        ScanRecord scanRecord = result.getScanRecord();
                        if (scanRecord == null) {
                            return;
                        }
                        if (serviceUuids != null) {
                            ArrayList<ParcelUuid> uuids = new ArrayList<ParcelUuid>();
                            for (UUID uuid : serviceUuids) {
                                uuids.add(new ParcelUuid(uuid));
                            }
                            List<ParcelUuid> scanServiceUuids = scanRecord.getServiceUuids();
                            if (scanServiceUuids == null || !scanServiceUuids.containsAll(uuids)) {
                                Log.d(BluetoothAdapter.TAG, "uuids does not match");
                                return;
                            }
                        }
                        callback.onLeScan(result.getDevice(), result.getRssi(), scanRecord.getBytes());
                    }
                };
                ScanSettings settings = new ScanSettings.Builder().setCallbackType(1).setScanMode(2).build();
                ArrayList<ScanFilter> filters = new ArrayList<ScanFilter>();
                if (serviceUuids != null && serviceUuids.length > 0) {
                    ScanFilter filter = new ScanFilter.Builder().setServiceUuid(new ParcelUuid(serviceUuids[0])).build();
                    filters.add(filter);
                }
                scanner.startScan(filters, settings, scanCallback);
                this.mLeScanClients.put(callback, scanCallback);
                return true;
            }
            catch (RemoteException e) {
                Log.e(TAG, "", e);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void stopLeScan(LeScanCallback callback) {
        Log.d(TAG, "stopLeScan()");
        BluetoothLeScanner scanner = this.getBluetoothLeScanner();
        if (scanner == null) {
            return;
        }
        Map<LeScanCallback, ScanCallback> map = this.mLeScanClients;
        synchronized (map) {
            ScanCallback scanCallback = this.mLeScanClients.remove(callback);
            if (scanCallback == null) {
                Log.d(TAG, "scan not started yet");
                return;
            }
            scanner.stopScan(scanCallback);
        }
    }

    public BluetoothServerSocket listenUsingL2capChannel() throws IOException {
        BluetoothServerSocket socket = new BluetoothServerSocket(4, true, true, -2, false, false);
        int errno = socket.mSocket.bindListen();
        if (errno != 0) {
            throw new IOException("Error: " + errno);
        }
        int assignedPsm = socket.mSocket.getPort();
        if (assignedPsm == 0) {
            throw new IOException("Error: Unable to assign PSM value");
        }
        Log.d(TAG, "listenUsingL2capChannel: set assigned PSM to " + assignedPsm);
        socket.setChannel(assignedPsm);
        return socket;
    }

    public BluetoothServerSocket listenUsingInsecureL2capChannel() throws IOException {
        BluetoothServerSocket socket = new BluetoothServerSocket(4, false, false, -2, false, false);
        int errno = socket.mSocket.bindListen();
        if (errno != 0) {
            throw new IOException("Error: " + errno);
        }
        int assignedPsm = socket.mSocket.getPort();
        if (assignedPsm == 0) {
            throw new IOException("Error: Unable to assign PSM value");
        }
        Log.d(TAG, "listenUsingInsecureL2capChannel: set assigned PSM to " + assignedPsm);
        socket.setChannel(assignedPsm);
        return socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    public boolean addOnMetadataChangedListener(BluetoothDevice device, Executor executor, OnMetadataChangedListener listener) {
        Log.d(TAG, "addOnMetadataChangedListener()");
        IBluetooth service = this.mService;
        if (service == null) {
            Log.e(TAG, "Bluetooth is not enabled. Cannot register metadata listener");
            return false;
        }
        if (listener == null) {
            throw new NullPointerException("listener is null");
        }
        if (device == null) {
            throw new NullPointerException("device is null");
        }
        if (executor == null) {
            throw new NullPointerException("executor is null");
        }
        Map<BluetoothDevice, List<Pair<OnMetadataChangedListener, Executor>>> map = sMetadataListeners;
        synchronized (map) {
            List<Pair<OnMetadataChangedListener, Executor>> listenerList = sMetadataListeners.get(device);
            if (listenerList == null) {
                listenerList = new ArrayList<Pair<OnMetadataChangedListener, Executor>>();
                sMetadataListeners.put(device, listenerList);
            } else if (listenerList.stream().anyMatch(pair -> ((OnMetadataChangedListener)pair.first).equals(listener))) {
                throw new IllegalArgumentException("listener was already regestered for the device");
            }
            Pair<OnMetadataChangedListener, Executor> listenerPair = new Pair<OnMetadataChangedListener, Executor>(listener, executor);
            listenerList.add(listenerPair);
            boolean ret = false;
            try {
                ret = service.registerMetadataListener(sBluetoothMetadataListener, device);
            }
            catch (RemoteException e) {
                Log.e(TAG, "registerMetadataListener fail", e);
            }
            finally {
                if (!ret) {
                    listenerList.remove(listenerPair);
                    if (listenerList.isEmpty()) {
                        sMetadataListeners.remove(device);
                    }
                }
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    public boolean removeOnMetadataChangedListener(BluetoothDevice device, OnMetadataChangedListener listener) {
        Log.d(TAG, "removeOnMetadataChangedListener()");
        if (device == null) {
            throw new NullPointerException("device is null");
        }
        if (listener == null) {
            throw new NullPointerException("listener is null");
        }
        Map<BluetoothDevice, List<Pair<OnMetadataChangedListener, Executor>>> map = sMetadataListeners;
        synchronized (map) {
            if (!sMetadataListeners.containsKey(device)) {
                throw new IllegalArgumentException("device was not registered");
            }
            sMetadataListeners.get(device).removeIf(pair -> ((OnMetadataChangedListener)pair.first).equals(listener));
            if (sMetadataListeners.get(device).isEmpty()) {
                sMetadataListeners.remove(device);
                IBluetooth service = this.mService;
                if (service == null) {
                    return true;
                }
                try {
                    return service.unregisterMetadataListener(device);
                }
                catch (RemoteException e) {
                    Log.e(TAG, "unregisterMetadataListener fail", e);
                    return false;
                }
            }
        }
        return true;
    }

    public static int priorityToConnectionPolicy(int priority) {
        switch (priority) {
            case 1000: {
                return 100;
            }
            case 100: {
                return 100;
            }
            case 0: {
                return 0;
            }
            case -1: {
                return -1;
            }
        }
        Log.e(TAG, "setPriority: Invalid priority: " + priority);
        return -1;
    }

    public static int connectionPolicyToPriority(int connectionPolicy) {
        switch (connectionPolicy) {
            case 100: {
                return 100;
            }
            case 0: {
                return 0;
            }
            case -1: {
                return -1;
            }
        }
        return -1;
    }

    static {
        sMetadataListeners = new HashMap<BluetoothDevice, List<Pair<OnMetadataChangedListener, Executor>>>();
        sBluetoothMetadataListener = new IBluetoothMetadataListener.Stub(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onMetadataChanged(BluetoothDevice device, int key, byte[] value) {
                Map map = sMetadataListeners;
                synchronized (map) {
                    if (sMetadataListeners.containsKey(device)) {
                        List list = (List)sMetadataListeners.get(device);
                        for (Pair pair : list) {
                            OnMetadataChangedListener listener = (OnMetadataChangedListener)pair.first;
                            Executor executor = (Executor)pair.second;
                            executor.execute(() -> listener.onMetadataChanged(device, key, value));
                        }
                    }
                }
            }
        };
    }

    @SystemApi
    public static interface OnMetadataChangedListener {
        public void onMetadataChanged(BluetoothDevice var1, int var2, byte[] var3);
    }

    public static interface LeScanCallback {
        public void onLeScan(BluetoothDevice var1, int var2, byte[] var3);
    }

    public class StateChangeCallbackWrapper
    extends IBluetoothStateChangeCallback.Stub {
        private BluetoothStateChangeCallback mCallback;

        StateChangeCallbackWrapper(BluetoothStateChangeCallback callback) {
            this.mCallback = callback;
        }

        @Override
        public void onBluetoothStateChange(boolean on) {
            this.mCallback.onBluetoothStateChange(on);
        }
    }

    public static interface BluetoothStateChangeCallback {
        public void onBluetoothStateChange(boolean var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ActiveDeviceUse {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface IoCapability {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ScanMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AdapterState {
    }
}

