/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.annotation.SystemApi;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothHidDeviceAppQosSettings;
import android.bluetooth.BluetoothHidDeviceAppSdpSettings;
import android.bluetooth.BluetoothProfile;
import android.bluetooth.BluetoothProfileConnector;
import android.bluetooth.IBluetoothHidDevice;
import android.bluetooth.IBluetoothHidDeviceCallback;
import android.content.Context;
import android.os.Binder;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;

public class BluetoothHidDevice
implements BluetoothProfile {
    private static final String TAG = BluetoothHidDevice.class.getSimpleName();
    private static final boolean DBG = false;
    public static final String ACTION_CONNECTION_STATE_CHANGED = "android.bluetooth.hiddevice.profile.action.CONNECTION_STATE_CHANGED";
    public static final byte SUBCLASS1_NONE = 0;
    public static final byte SUBCLASS1_KEYBOARD = 64;
    public static final byte SUBCLASS1_MOUSE = -128;
    public static final byte SUBCLASS1_COMBO = -64;
    public static final byte SUBCLASS2_UNCATEGORIZED = 0;
    public static final byte SUBCLASS2_JOYSTICK = 1;
    public static final byte SUBCLASS2_GAMEPAD = 2;
    public static final byte SUBCLASS2_REMOTE_CONTROL = 3;
    public static final byte SUBCLASS2_SENSING_DEVICE = 4;
    public static final byte SUBCLASS2_DIGITIZER_TABLET = 5;
    public static final byte SUBCLASS2_CARD_READER = 6;
    public static final byte REPORT_TYPE_INPUT = 1;
    public static final byte REPORT_TYPE_OUTPUT = 2;
    public static final byte REPORT_TYPE_FEATURE = 3;
    public static final byte ERROR_RSP_SUCCESS = 0;
    public static final byte ERROR_RSP_NOT_READY = 1;
    public static final byte ERROR_RSP_INVALID_RPT_ID = 2;
    public static final byte ERROR_RSP_UNSUPPORTED_REQ = 3;
    public static final byte ERROR_RSP_INVALID_PARAM = 4;
    public static final byte ERROR_RSP_UNKNOWN = 14;
    public static final byte PROTOCOL_BOOT_MODE = 0;
    public static final byte PROTOCOL_REPORT_MODE = 1;
    private BluetoothAdapter mAdapter;
    private final BluetoothProfileConnector<IBluetoothHidDevice> mProfileConnector = new BluetoothProfileConnector(this, 19, "BluetoothHidDevice", IBluetoothHidDevice.class.getName()){

        public IBluetoothHidDevice getServiceInterface(IBinder service) {
            return IBluetoothHidDevice.Stub.asInterface(Binder.allowBlocking(service));
        }
    };

    BluetoothHidDevice(Context context, BluetoothProfile.ServiceListener listener) {
        this.mAdapter = BluetoothAdapter.getDefaultAdapter();
        this.mProfileConnector.connect(context, listener);
    }

    void close() {
        this.mProfileConnector.disconnect();
    }

    private IBluetoothHidDevice getService() {
        return this.mProfileConnector.getService();
    }

    @Override
    public List<BluetoothDevice> getConnectedDevices() {
        IBluetoothHidDevice service = this.getService();
        if (service != null) {
            try {
                return service.getConnectedDevices();
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString());
            }
        } else {
            Log.w(TAG, "Proxy not attached to service");
        }
        return new ArrayList<BluetoothDevice>();
    }

    @Override
    public List<BluetoothDevice> getDevicesMatchingConnectionStates(int[] states) {
        IBluetoothHidDevice service = this.getService();
        if (service != null) {
            try {
                return service.getDevicesMatchingConnectionStates(states);
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString());
            }
        } else {
            Log.w(TAG, "Proxy not attached to service");
        }
        return new ArrayList<BluetoothDevice>();
    }

    @Override
    public int getConnectionState(BluetoothDevice device) {
        IBluetoothHidDevice service = this.getService();
        if (service != null) {
            try {
                return service.getConnectionState(device);
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString());
            }
        } else {
            Log.w(TAG, "Proxy not attached to service");
        }
        return 0;
    }

    public boolean registerApp(BluetoothHidDeviceAppSdpSettings sdp, BluetoothHidDeviceAppQosSettings inQos, BluetoothHidDeviceAppQosSettings outQos, Executor executor, Callback callback) {
        boolean result = false;
        if (sdp == null) {
            throw new IllegalArgumentException("sdp parameter cannot be null");
        }
        if (executor == null) {
            throw new IllegalArgumentException("executor parameter cannot be null");
        }
        if (callback == null) {
            throw new IllegalArgumentException("callback parameter cannot be null");
        }
        IBluetoothHidDevice service = this.getService();
        if (service != null) {
            try {
                CallbackWrapper cbw = new CallbackWrapper(executor, callback);
                result = service.registerApp(sdp, inQos, outQos, cbw);
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString());
            }
        } else {
            Log.w(TAG, "Proxy not attached to service");
        }
        return result;
    }

    public boolean unregisterApp() {
        boolean result = false;
        IBluetoothHidDevice service = this.getService();
        if (service != null) {
            try {
                result = service.unregisterApp();
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString());
            }
        } else {
            Log.w(TAG, "Proxy not attached to service");
        }
        return result;
    }

    public boolean sendReport(BluetoothDevice device, int id2, byte[] data) {
        boolean result = false;
        IBluetoothHidDevice service = this.getService();
        if (service != null) {
            try {
                result = service.sendReport(device, id2, data);
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString());
            }
        } else {
            Log.w(TAG, "Proxy not attached to service");
        }
        return result;
    }

    public boolean replyReport(BluetoothDevice device, byte type, byte id2, byte[] data) {
        boolean result = false;
        IBluetoothHidDevice service = this.getService();
        if (service != null) {
            try {
                result = service.replyReport(device, type, id2, data);
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString());
            }
        } else {
            Log.w(TAG, "Proxy not attached to service");
        }
        return result;
    }

    public boolean reportError(BluetoothDevice device, byte error) {
        boolean result = false;
        IBluetoothHidDevice service = this.getService();
        if (service != null) {
            try {
                result = service.reportError(device, error);
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString());
            }
        } else {
            Log.w(TAG, "Proxy not attached to service");
        }
        return result;
    }

    public String getUserAppName() {
        IBluetoothHidDevice service = this.getService();
        if (service != null) {
            try {
                return service.getUserAppName();
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString());
            }
        } else {
            Log.w(TAG, "Proxy not attached to service");
        }
        return "";
    }

    public boolean connect(BluetoothDevice device) {
        boolean result = false;
        IBluetoothHidDevice service = this.getService();
        if (service != null) {
            try {
                result = service.connect(device);
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString());
            }
        } else {
            Log.w(TAG, "Proxy not attached to service");
        }
        return result;
    }

    public boolean disconnect(BluetoothDevice device) {
        boolean result = false;
        IBluetoothHidDevice service = this.getService();
        if (service != null) {
            try {
                result = service.disconnect(device);
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString());
            }
        } else {
            Log.w(TAG, "Proxy not attached to service");
        }
        return result;
    }

    @SystemApi
    public boolean setConnectionPolicy(BluetoothDevice device, int connectionPolicy) {
        BluetoothHidDevice.log("setConnectionPolicy(" + device + ", " + connectionPolicy + ")");
        try {
            IBluetoothHidDevice service = this.getService();
            if (service != null && this.isEnabled() && this.isValidDevice(device)) {
                if (connectionPolicy != 0 && connectionPolicy != 100) {
                    return false;
                }
                return service.setConnectionPolicy(device, connectionPolicy);
            }
            if (service == null) {
                Log.w(TAG, "Proxy not attached to service");
            }
            return false;
        }
        catch (RemoteException e) {
            Log.e(TAG, "Stack:" + Log.getStackTraceString(new Throwable()));
            return false;
        }
    }

    private boolean isEnabled() {
        return this.mAdapter.getState() == 12;
    }

    private boolean isValidDevice(BluetoothDevice device) {
        if (device == null) {
            return false;
        }
        return BluetoothAdapter.checkBluetoothAddress(device.getAddress());
    }

    private static void log(String msg) {
    }

    private static class CallbackWrapper
    extends IBluetoothHidDeviceCallback.Stub {
        private final Executor mExecutor;
        private final Callback mCallback;

        CallbackWrapper(Executor executor, Callback callback) {
            this.mExecutor = executor;
            this.mCallback = callback;
        }

        @Override
        public void onAppStatusChanged(BluetoothDevice pluggedDevice, boolean registered) {
            CallbackWrapper.clearCallingIdentity();
            this.mExecutor.execute(() -> this.mCallback.onAppStatusChanged(pluggedDevice, registered));
        }

        @Override
        public void onConnectionStateChanged(BluetoothDevice device, int state) {
            CallbackWrapper.clearCallingIdentity();
            this.mExecutor.execute(() -> this.mCallback.onConnectionStateChanged(device, state));
        }

        @Override
        public void onGetReport(BluetoothDevice device, byte type, byte id2, int bufferSize) {
            CallbackWrapper.clearCallingIdentity();
            this.mExecutor.execute(() -> this.mCallback.onGetReport(device, type, id2, bufferSize));
        }

        @Override
        public void onSetReport(BluetoothDevice device, byte type, byte id2, byte[] data) {
            CallbackWrapper.clearCallingIdentity();
            this.mExecutor.execute(() -> this.mCallback.onSetReport(device, type, id2, data));
        }

        @Override
        public void onSetProtocol(BluetoothDevice device, byte protocol) {
            CallbackWrapper.clearCallingIdentity();
            this.mExecutor.execute(() -> this.mCallback.onSetProtocol(device, protocol));
        }

        @Override
        public void onInterruptData(BluetoothDevice device, byte reportId, byte[] data) {
            CallbackWrapper.clearCallingIdentity();
            this.mExecutor.execute(() -> this.mCallback.onInterruptData(device, reportId, data));
        }

        @Override
        public void onVirtualCableUnplug(BluetoothDevice device) {
            CallbackWrapper.clearCallingIdentity();
            this.mExecutor.execute(() -> this.mCallback.onVirtualCableUnplug(device));
        }
    }

    public static abstract class Callback {
        private static final String TAG = "BluetoothHidDevCallback";

        public void onAppStatusChanged(BluetoothDevice pluggedDevice, boolean registered) {
            Log.d(TAG, "onAppStatusChanged: pluggedDevice=" + pluggedDevice + " registered=" + registered);
        }

        public void onConnectionStateChanged(BluetoothDevice device, int state) {
            Log.d(TAG, "onConnectionStateChanged: device=" + device + " state=" + state);
        }

        public void onGetReport(BluetoothDevice device, byte type, byte id2, int bufferSize) {
            Log.d(TAG, "onGetReport: device=" + device + " type=" + type + " id=" + id2 + " bufferSize=" + bufferSize);
        }

        public void onSetReport(BluetoothDevice device, byte type, byte id2, byte[] data) {
            Log.d(TAG, "onSetReport: device=" + device + " type=" + type + " id=" + id2);
        }

        public void onSetProtocol(BluetoothDevice device, byte protocol) {
            Log.d(TAG, "onSetProtocol: device=" + device + " protocol=" + protocol);
        }

        public void onInterruptData(BluetoothDevice device, byte reportId, byte[] data) {
            Log.d(TAG, "onInterruptData: device=" + device + " reportId=" + reportId);
        }

        public void onVirtualCableUnplug(BluetoothDevice device) {
            Log.d(TAG, "onVirtualCableUnplug: device=" + device);
        }
    }
}

