/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.annotation.SystemApi;
import android.app.ActivityManager;
import android.app.IActivityManager;
import android.app.QueuedWork;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.UserHandle;
import android.util.Log;

public abstract class BroadcastReceiver {
    @UnsupportedAppUsage
    private PendingResult mPendingResult;
    private boolean mDebugUnregister;

    public abstract void onReceive(Context var1, Intent var2);

    public PendingResult goAsync() {
        PendingResult res = this.mPendingResult;
        this.mPendingResult = null;
        return res;
    }

    public IBinder peekService(Context myContext, Intent service) {
        IActivityManager am = ActivityManager.getService();
        IBinder binder = null;
        try {
            service.prepareToLeaveProcess(myContext);
            binder = am.peekService(service, service.resolveTypeIfNeeded(myContext.getContentResolver()), myContext.getOpPackageName());
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return binder;
    }

    public void setResultCode(int code) {
        this.checkSynchronousHint();
        this.mPendingResult.mResultCode = code;
    }

    public int getResultCode() {
        return this.mPendingResult != null ? this.mPendingResult.mResultCode : 0;
    }

    public void setResultData(String data) {
        this.checkSynchronousHint();
        this.mPendingResult.mResultData = data;
    }

    public String getResultData() {
        return this.mPendingResult != null ? this.mPendingResult.mResultData : null;
    }

    public void setResultExtras(Bundle extras) {
        this.checkSynchronousHint();
        this.mPendingResult.mResultExtras = extras;
    }

    public Bundle getResultExtras(boolean makeMap) {
        if (this.mPendingResult == null) {
            return null;
        }
        Bundle e = this.mPendingResult.mResultExtras;
        if (!makeMap) {
            return e;
        }
        if (e == null) {
            this.mPendingResult.mResultExtras = e = new Bundle();
        }
        return e;
    }

    public void setResult(int code, String data, Bundle extras) {
        this.checkSynchronousHint();
        this.mPendingResult.mResultCode = code;
        this.mPendingResult.mResultData = data;
        this.mPendingResult.mResultExtras = extras;
    }

    public boolean getAbortBroadcast() {
        return this.mPendingResult != null ? this.mPendingResult.mAbortBroadcast : false;
    }

    public void abortBroadcast() {
        this.checkSynchronousHint();
        this.mPendingResult.mAbortBroadcast = true;
    }

    public void clearAbortBroadcast() {
        if (this.mPendingResult != null) {
            this.mPendingResult.mAbortBroadcast = false;
        }
    }

    public boolean isOrderedBroadcast() {
        return this.mPendingResult != null ? this.mPendingResult.mOrderedHint : false;
    }

    public boolean isInitialStickyBroadcast() {
        return this.mPendingResult != null ? this.mPendingResult.mInitialStickyHint : false;
    }

    public void setOrderedHint(boolean isOrdered) {
    }

    @UnsupportedAppUsage
    public void setPendingResult(PendingResult result) {
        this.mPendingResult = result;
    }

    @UnsupportedAppUsage
    public PendingResult getPendingResult() {
        return this.mPendingResult;
    }

    @SystemApi
    public UserHandle getSendingUser() {
        return UserHandle.of(this.getSendingUserId());
    }

    public int getSendingUserId() {
        return this.mPendingResult.mSendingUser;
    }

    public void setDebugUnregister(boolean debug) {
        this.mDebugUnregister = debug;
    }

    public boolean getDebugUnregister() {
        return this.mDebugUnregister;
    }

    void checkSynchronousHint() {
        if (this.mPendingResult == null) {
            throw new IllegalStateException("Call while result is not pending");
        }
        if (this.mPendingResult.mOrderedHint || this.mPendingResult.mInitialStickyHint) {
            return;
        }
        RuntimeException e = new RuntimeException("BroadcastReceiver trying to return result during a non-ordered broadcast");
        e.fillInStackTrace();
        Log.e("BroadcastReceiver", e.getMessage(), e);
    }

    public static class PendingResult {
        public static final int TYPE_COMPONENT = 0;
        public static final int TYPE_REGISTERED = 1;
        public static final int TYPE_UNREGISTERED = 2;
        @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
        final int mType;
        @UnsupportedAppUsage
        final boolean mOrderedHint;
        @UnsupportedAppUsage
        final boolean mInitialStickyHint;
        @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
        final IBinder mToken;
        @UnsupportedAppUsage
        final int mSendingUser;
        @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
        final int mFlags;
        @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
        int mResultCode;
        @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
        String mResultData;
        @UnsupportedAppUsage
        Bundle mResultExtras;
        @UnsupportedAppUsage
        boolean mAbortBroadcast;
        @UnsupportedAppUsage
        boolean mFinished;

        @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
        public PendingResult(int resultCode, String resultData, Bundle resultExtras, int type, boolean ordered, boolean sticky, IBinder token, int userId, int flags) {
            this.mResultCode = resultCode;
            this.mResultData = resultData;
            this.mResultExtras = resultExtras;
            this.mType = type;
            this.mOrderedHint = ordered;
            this.mInitialStickyHint = sticky;
            this.mToken = token;
            this.mSendingUser = userId;
            this.mFlags = flags;
        }

        public void setResultCode(int code) {
            this.checkSynchronousHint();
            this.mResultCode = code;
        }

        public int getResultCode() {
            return this.mResultCode;
        }

        public void setResultData(String data) {
            this.checkSynchronousHint();
            this.mResultData = data;
        }

        public String getResultData() {
            return this.mResultData;
        }

        public void setResultExtras(Bundle extras) {
            this.checkSynchronousHint();
            this.mResultExtras = extras;
        }

        public Bundle getResultExtras(boolean makeMap) {
            Bundle e = this.mResultExtras;
            if (!makeMap) {
                return e;
            }
            if (e == null) {
                this.mResultExtras = e = new Bundle();
            }
            return e;
        }

        public void setResult(int code, String data, Bundle extras) {
            this.checkSynchronousHint();
            this.mResultCode = code;
            this.mResultData = data;
            this.mResultExtras = extras;
        }

        public boolean getAbortBroadcast() {
            return this.mAbortBroadcast;
        }

        public void abortBroadcast() {
            this.checkSynchronousHint();
            this.mAbortBroadcast = true;
        }

        public void clearAbortBroadcast() {
            this.mAbortBroadcast = false;
        }

        public void finish() {
            if (this.mType == 0) {
                final IActivityManager mgr = ActivityManager.getService();
                if (QueuedWork.hasPendingWork()) {
                    QueuedWork.queue(new Runnable(){

                        @Override
                        public void run() {
                            this.sendFinished(mgr);
                        }
                    }, false);
                } else {
                    this.sendFinished(mgr);
                }
            } else if (this.mOrderedHint && this.mType != 2) {
                IActivityManager mgr = ActivityManager.getService();
                this.sendFinished(mgr);
            }
        }

        public void setExtrasClassLoader(ClassLoader cl) {
            if (this.mResultExtras != null) {
                this.mResultExtras.setClassLoader(cl);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sendFinished(IActivityManager am) {
            PendingResult pendingResult = this;
            synchronized (pendingResult) {
                if (this.mFinished) {
                    throw new IllegalStateException("Broadcast already finished");
                }
                this.mFinished = true;
                try {
                    if (this.mResultExtras != null) {
                        this.mResultExtras.setAllowFds(false);
                    }
                    if (this.mOrderedHint) {
                        am.finishReceiver(this.mToken, this.mResultCode, this.mResultData, this.mResultExtras, this.mAbortBroadcast, this.mFlags);
                    } else {
                        am.finishReceiver(this.mToken, 0, null, null, false, this.mFlags);
                    }
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }

        public int getSendingUserId() {
            return this.mSendingUser;
        }

        void checkSynchronousHint() {
            if (this.mOrderedHint || this.mInitialStickyHint) {
                return;
            }
            RuntimeException e = new RuntimeException("BroadcastReceiver trying to return result during a non-ordered broadcast");
            e.fillInStackTrace();
            Log.e("BroadcastReceiver", e.getMessage(), e);
        }
    }
}

