/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.compat.annotation.UnsupportedAppUsage;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.ArrayMap;
import android.util.Log;
import com.android.internal.util.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class ContentValues
implements Parcelable {
    public static final String TAG = "ContentValues";
    @Deprecated
    @UnsupportedAppUsage
    private HashMap<String, Object> mValues;
    private final ArrayMap<String, Object> mMap;
    public static final Parcelable.Creator<ContentValues> CREATOR = new Parcelable.Creator<ContentValues>(){

        @Override
        public ContentValues createFromParcel(Parcel in) {
            return new ContentValues(in);
        }

        public ContentValues[] newArray(int size) {
            return new ContentValues[size];
        }
    };

    public ContentValues() {
        this.mMap = new ArrayMap();
    }

    public ContentValues(int size) {
        Preconditions.checkArgumentNonnegative(size);
        this.mMap = new ArrayMap(size);
    }

    public ContentValues(ContentValues from) {
        Objects.requireNonNull(from);
        this.mMap = new ArrayMap<String, Object>(from.mMap);
    }

    @Deprecated
    @UnsupportedAppUsage
    private ContentValues(HashMap<String, Object> from) {
        this.mMap = new ArrayMap();
        this.mMap.putAll(from);
    }

    private ContentValues(Parcel in) {
        this.mMap = new ArrayMap(in.readInt());
        in.readArrayMap(this.mMap, null);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ContentValues)) {
            return false;
        }
        return this.mMap.equals(((ContentValues)object).mMap);
    }

    public ArrayMap<String, Object> getValues() {
        return this.mMap;
    }

    public int hashCode() {
        return this.mMap.hashCode();
    }

    public void put(String key, String value) {
        this.mMap.put(key, value);
    }

    public void putAll(ContentValues other) {
        this.mMap.putAll(other.mMap);
    }

    public void put(String key, Byte value) {
        this.mMap.put(key, value);
    }

    public void put(String key, Short value) {
        this.mMap.put(key, value);
    }

    public void put(String key, Integer value) {
        this.mMap.put(key, value);
    }

    public void put(String key, Long value) {
        this.mMap.put(key, value);
    }

    public void put(String key, Float value) {
        this.mMap.put(key, value);
    }

    public void put(String key, Double value) {
        this.mMap.put(key, value);
    }

    public void put(String key, Boolean value) {
        this.mMap.put(key, value);
    }

    public void put(String key, byte[] value) {
        this.mMap.put(key, value);
    }

    public void putNull(String key) {
        this.mMap.put(key, null);
    }

    public void putObject(String key, Object value) {
        if (value == null) {
            this.putNull(key);
        } else if (value instanceof String) {
            this.put(key, (String)value);
        } else if (value instanceof Byte) {
            this.put(key, (Byte)value);
        } else if (value instanceof Short) {
            this.put(key, (Short)value);
        } else if (value instanceof Integer) {
            this.put(key, (Integer)value);
        } else if (value instanceof Long) {
            this.put(key, (Long)value);
        } else if (value instanceof Float) {
            this.put(key, (Float)value);
        } else if (value instanceof Double) {
            this.put(key, (Double)value);
        } else if (value instanceof Boolean) {
            this.put(key, (Boolean)value);
        } else if (value instanceof byte[]) {
            this.put(key, (byte[])value);
        } else {
            throw new IllegalArgumentException("Unsupported type " + value.getClass());
        }
    }

    public int size() {
        return this.mMap.size();
    }

    public boolean isEmpty() {
        return this.mMap.isEmpty();
    }

    public void remove(String key) {
        this.mMap.remove(key);
    }

    public void clear() {
        this.mMap.clear();
    }

    public boolean containsKey(String key) {
        return this.mMap.containsKey(key);
    }

    public Object get(String key) {
        return this.mMap.get(key);
    }

    public String getAsString(String key) {
        Object value = this.mMap.get(key);
        return value != null ? value.toString() : null;
    }

    public Long getAsLong(String key) {
        Object value = this.mMap.get(key);
        try {
            return value != null ? Long.valueOf(((Number)value).longValue()) : null;
        }
        catch (ClassCastException e) {
            if (value instanceof CharSequence) {
                try {
                    return Long.valueOf(value.toString());
                }
                catch (NumberFormatException e2) {
                    Log.e(TAG, "Cannot parse Long value for " + value + " at key " + key);
                    return null;
                }
            }
            Log.e(TAG, "Cannot cast value for " + key + " to a Long: " + value, e);
            return null;
        }
    }

    public Integer getAsInteger(String key) {
        Object value = this.mMap.get(key);
        try {
            return value != null ? Integer.valueOf(((Number)value).intValue()) : null;
        }
        catch (ClassCastException e) {
            if (value instanceof CharSequence) {
                try {
                    return Integer.valueOf(value.toString());
                }
                catch (NumberFormatException e2) {
                    Log.e(TAG, "Cannot parse Integer value for " + value + " at key " + key);
                    return null;
                }
            }
            Log.e(TAG, "Cannot cast value for " + key + " to a Integer: " + value, e);
            return null;
        }
    }

    public Short getAsShort(String key) {
        Object value = this.mMap.get(key);
        try {
            return value != null ? Short.valueOf(((Number)value).shortValue()) : null;
        }
        catch (ClassCastException e) {
            if (value instanceof CharSequence) {
                try {
                    return Short.valueOf(value.toString());
                }
                catch (NumberFormatException e2) {
                    Log.e(TAG, "Cannot parse Short value for " + value + " at key " + key);
                    return null;
                }
            }
            Log.e(TAG, "Cannot cast value for " + key + " to a Short: " + value, e);
            return null;
        }
    }

    public Byte getAsByte(String key) {
        Object value = this.mMap.get(key);
        try {
            return value != null ? Byte.valueOf(((Number)value).byteValue()) : null;
        }
        catch (ClassCastException e) {
            if (value instanceof CharSequence) {
                try {
                    return Byte.valueOf(value.toString());
                }
                catch (NumberFormatException e2) {
                    Log.e(TAG, "Cannot parse Byte value for " + value + " at key " + key);
                    return null;
                }
            }
            Log.e(TAG, "Cannot cast value for " + key + " to a Byte: " + value, e);
            return null;
        }
    }

    public Double getAsDouble(String key) {
        Object value = this.mMap.get(key);
        try {
            return value != null ? Double.valueOf(((Number)value).doubleValue()) : null;
        }
        catch (ClassCastException e) {
            if (value instanceof CharSequence) {
                try {
                    return Double.valueOf(value.toString());
                }
                catch (NumberFormatException e2) {
                    Log.e(TAG, "Cannot parse Double value for " + value + " at key " + key);
                    return null;
                }
            }
            Log.e(TAG, "Cannot cast value for " + key + " to a Double: " + value, e);
            return null;
        }
    }

    public Float getAsFloat(String key) {
        Object value = this.mMap.get(key);
        try {
            return value != null ? Float.valueOf(((Number)value).floatValue()) : null;
        }
        catch (ClassCastException e) {
            if (value instanceof CharSequence) {
                try {
                    return Float.valueOf(value.toString());
                }
                catch (NumberFormatException e2) {
                    Log.e(TAG, "Cannot parse Float value for " + value + " at key " + key);
                    return null;
                }
            }
            Log.e(TAG, "Cannot cast value for " + key + " to a Float: " + value, e);
            return null;
        }
    }

    public Boolean getAsBoolean(String key) {
        Object value = this.mMap.get(key);
        try {
            return (Boolean)value;
        }
        catch (ClassCastException e) {
            if (value instanceof CharSequence) {
                return Boolean.valueOf(value.toString()) != false || "1".equals(value);
            }
            if (value instanceof Number) {
                return ((Number)value).intValue() != 0;
            }
            Log.e(TAG, "Cannot cast value for " + key + " to a Boolean: " + value, e);
            return null;
        }
    }

    public byte[] getAsByteArray(String key) {
        Object value = this.mMap.get(key);
        if (value instanceof byte[]) {
            return (byte[])value;
        }
        return null;
    }

    public Set<Map.Entry<String, Object>> valueSet() {
        return this.mMap.entrySet();
    }

    public Set<String> keySet() {
        return this.mMap.keySet();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeInt(this.mMap.size());
        parcel.writeArrayMap(this.mMap);
    }

    @Deprecated
    @UnsupportedAppUsage
    public void putStringArrayList(String key, ArrayList<String> value) {
        this.mMap.put(key, value);
    }

    @Deprecated
    @UnsupportedAppUsage
    public ArrayList<String> getStringArrayList(String key) {
        return (ArrayList)this.mMap.get(key);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (String name : this.mMap.keySet()) {
            String value = this.getAsString(name);
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(name + "=" + value);
        }
        return sb.toString();
    }

    public static boolean isSupportedValue(Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof String) {
            return true;
        }
        if (value instanceof Byte) {
            return true;
        }
        if (value instanceof Short) {
            return true;
        }
        if (value instanceof Integer) {
            return true;
        }
        if (value instanceof Long) {
            return true;
        }
        if (value instanceof Float) {
            return true;
        }
        if (value instanceof Double) {
            return true;
        }
        if (value instanceof Boolean) {
            return true;
        }
        return value instanceof byte[];
    }
}

