/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.app.AppOpsManager;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.pm.PermissionInfo;
import android.os.Binder;
import android.os.Process;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class PermissionChecker {
    public static final int PERMISSION_GRANTED = 0;
    public static final int PERMISSION_HARD_DENIED = -1;
    public static final int PERMISSION_SOFT_DENIED = -2;
    public static final int PID_UNKNOWN = -1;

    private PermissionChecker() {
    }

    public static int checkPermissionForDataDelivery(Context context, String permission2, int pid, int uid, String packageName, String attributionTag, String message) {
        return PermissionChecker.checkPermissionCommon(context, permission2, pid, uid, packageName, attributionTag, message, true);
    }

    public static int checkPermissionForPreflight(Context context, String permission2, int pid, int uid, String packageName) {
        return PermissionChecker.checkPermissionCommon(context, permission2, pid, uid, packageName, null, null, false);
    }

    public static int checkSelfPermissionForDataDelivery(Context context, String permission2, String message) {
        return PermissionChecker.checkPermissionForDataDelivery(context, permission2, Process.myPid(), Process.myUid(), context.getPackageName(), context.getAttributionTag(), message);
    }

    public static int checkSelfPermissionForPreflight(Context context, String permission2) {
        return PermissionChecker.checkPermissionForPreflight(context, permission2, Process.myPid(), Process.myUid(), context.getPackageName());
    }

    public static int checkCallingPermissionForDataDelivery(Context context, String permission2, String packageName, String attributionTag, String message) {
        if (Binder.getCallingPid() == Process.myPid()) {
            return -1;
        }
        return PermissionChecker.checkPermissionForDataDelivery(context, permission2, Binder.getCallingPid(), Binder.getCallingUid(), packageName, attributionTag, message);
    }

    public static int checkCallingPermissionForPreflight(Context context, String permission2, String packageName) {
        if (Binder.getCallingPid() == Process.myPid()) {
            return -1;
        }
        return PermissionChecker.checkPermissionForPreflight(context, permission2, Binder.getCallingPid(), Binder.getCallingUid(), packageName);
    }

    public static int checkCallingOrSelfPermissionForDataDelivery(Context context, String permission2, String attributionTag, String message) {
        String packageName = Binder.getCallingPid() == Process.myPid() ? context.getPackageName() : null;
        attributionTag = Binder.getCallingPid() == Process.myPid() ? context.getAttributionTag() : attributionTag;
        return PermissionChecker.checkPermissionForDataDelivery(context, permission2, Binder.getCallingPid(), Binder.getCallingUid(), packageName, attributionTag, message);
    }

    public static int checkCallingOrSelfPermissionForPreflight(Context context, String permission2) {
        String packageName = Binder.getCallingPid() == Process.myPid() ? context.getPackageName() : null;
        return PermissionChecker.checkPermissionForPreflight(context, permission2, Binder.getCallingPid(), Binder.getCallingUid(), packageName);
    }

    static int checkPermissionCommon(Context context, String permission2, int pid, int uid, String packageName, String attributionTag, String message, boolean forDataDelivery) {
        String[] packageNames;
        PermissionInfo permissionInfo;
        try {
            permissionInfo = context.getPackageManager().getPermissionInfo(permission2, 0);
        }
        catch (PackageManager.NameNotFoundException ignored) {
            return -1;
        }
        if (packageName == null && (packageNames = context.getPackageManager().getPackagesForUid(uid)) != null && packageNames.length > 0) {
            packageName = packageNames[0];
        }
        if (permissionInfo.isAppOp()) {
            return PermissionChecker.checkAppOpPermission(context, permission2, pid, uid, packageName, attributionTag, message, forDataDelivery);
        }
        if (permissionInfo.isRuntime()) {
            return PermissionChecker.checkRuntimePermission(context, permission2, pid, uid, packageName, attributionTag, message, forDataDelivery);
        }
        return context.checkPermission(permission2, pid, uid);
    }

    private static int checkAppOpPermission(Context context, String permission2, int pid, int uid, String packageName, String attributionTag, String message, boolean forDataDelivery) {
        String op = AppOpsManager.permissionToOp(permission2);
        if (op == null || packageName == null) {
            return -1;
        }
        AppOpsManager appOpsManager = context.getSystemService(AppOpsManager.class);
        int opMode = forDataDelivery ? appOpsManager.noteProxyOpNoThrow(op, packageName, uid, attributionTag, message) : appOpsManager.unsafeCheckOpRawNoThrow(op, uid, packageName);
        switch (opMode) {
            case 0: 
            case 4: {
                return 0;
            }
            case 3: {
                return context.checkPermission(permission2, pid, uid) == 0 ? 0 : -1;
            }
        }
        return -1;
    }

    private static int checkRuntimePermission(Context context, String permission2, int pid, int uid, String packageName, String attributionTag, String message, boolean forDataDelivery) {
        if (context.checkPermission(permission2, pid, uid) == -1) {
            return -1;
        }
        String op = AppOpsManager.permissionToOp(permission2);
        if (op == null || packageName == null) {
            return 0;
        }
        AppOpsManager appOpsManager = context.getSystemService(AppOpsManager.class);
        int opMode = forDataDelivery ? appOpsManager.noteProxyOpNoThrow(op, packageName, uid, attributionTag, message) : appOpsManager.unsafeCheckOpRawNoThrow(op, uid, packageName);
        switch (opMode) {
            case 0: 
            case 4: {
                return 0;
            }
        }
        return -2;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PermissionResult {
    }
}

