/*
 * Decompiled with CFR 0.152.
 */
package android.database.sqlite;

import android.compat.annotation.UnsupportedAppUsage;
import android.database.sqlite.SQLiteDatabase;
import android.os.Process;
import android.os.SystemProperties;
import android.os._Original_Build;
import android.util.Log;
import android.util.Printer;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.util.ArrayList;

public class SQLiteDebug {
    private static void nativeGetPagerStats(PagerStats pagerStats) {
        OverrideMethod.invokeV("android.database.sqlite.SQLiteDebug#nativeGetPagerStats(Landroid/database/sqlite/SQLiteDebug$PagerStats;)V", true, null);
    }

    private SQLiteDebug() {
    }

    public static boolean shouldLogSlowQuery(long elapsedTimeMillis) {
        int slowQueryMillis = Math.min(SystemProperties.getInt("db.log.slow_query_threshold", Integer.MAX_VALUE), SystemProperties.getInt(NoPreloadHolder.SLOW_QUERY_THRESHOLD_UID_PROP, Integer.MAX_VALUE));
        return elapsedTimeMillis >= (long)slowQueryMillis;
    }

    @UnsupportedAppUsage
    public static PagerStats getDatabaseInfo() {
        PagerStats stats = new PagerStats();
        SQLiteDebug.nativeGetPagerStats(stats);
        stats.dbStats = SQLiteDatabase.getDbStats();
        return stats;
    }

    public static void dump(Printer printer, String[] args) {
        SQLiteDebug.dump(printer, args, false);
    }

    public static void dump(Printer printer, String[] args, boolean isSystem) {
        boolean verbose = false;
        for (String arg : args) {
            if (!arg.equals("-v")) continue;
            verbose = true;
        }
        SQLiteDatabase.dumpAll(printer, verbose, isSystem);
    }

    public static class DbStats {
        @UnsupportedAppUsage
        public String dbName;
        @UnsupportedAppUsage
        public long pageSize;
        @UnsupportedAppUsage
        public long dbSize;
        @UnsupportedAppUsage
        public int lookaside;
        public String cache;

        public DbStats(String dbName, long pageCount, long pageSize, int lookaside, int hits, int misses, int cachesize) {
            this.dbName = dbName;
            this.pageSize = pageSize / 1024L;
            this.dbSize = pageCount * pageSize / 1024L;
            this.lookaside = lookaside;
            this.cache = hits + "/" + misses + "/" + cachesize;
        }
    }

    public static class PagerStats {
        @UnsupportedAppUsage
        public int memoryUsed;
        @UnsupportedAppUsage
        public int pageCacheOverflow;
        @UnsupportedAppUsage
        public int largestMemAlloc;
        @UnsupportedAppUsage
        public ArrayList<DbStats> dbStats;

        @UnsupportedAppUsage
        public PagerStats() {
        }
    }

    public static class NoPreloadHolder {
        public static final boolean DEBUG_SQL_LOG = Log.isLoggable("SQLiteLog", 2);
        public static final boolean DEBUG_SQL_STATEMENTS = Log.isLoggable("SQLiteStatements", 2);
        public static final boolean DEBUG_SQL_TIME = Log.isLoggable("SQLiteTime", 2);
        public static final boolean DEBUG_LOG_SLOW_QUERIES = _Original_Build.IS_DEBUGGABLE;
        private static final String SLOW_QUERY_THRESHOLD_PROP = "db.log.slow_query_threshold";
        private static final String SLOW_QUERY_THRESHOLD_UID_PROP = "db.log.slow_query_threshold." + Process.myUid();
        public static final boolean DEBUG_LOG_DETAILED = _Original_Build.IS_DEBUGGABLE && SystemProperties.getBoolean("db.log.detailed", false);
    }
}

