/*
 * Decompiled with CFR 0.152.
 */
package android.database.sqlite;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;

public class SQLiteTokenizer {
    public static final int OPTION_NONE = 0;
    public static final int OPTION_TOKEN_ONLY = 1;

    private static boolean isAlpha(char ch) {
        return 'a' <= ch && ch <= 'z' || 'A' <= ch && ch <= 'Z' || ch == '_';
    }

    private static boolean isNum(char ch) {
        return '0' <= ch && ch <= '9';
    }

    private static boolean isAlNum(char ch) {
        return SQLiteTokenizer.isAlpha(ch) || SQLiteTokenizer.isNum(ch);
    }

    private static boolean isAnyOf(char ch, String set) {
        return set.indexOf(ch) >= 0;
    }

    private static IllegalArgumentException genException(String message, String sql) {
        throw new IllegalArgumentException(message + " in '" + sql + "'");
    }

    private static char peek(String s, int index) {
        return index < s.length() ? s.charAt(index) : (char)'\u0000';
    }

    public static List<String> tokenize(String sql, int options) {
        ArrayList<String> res = new ArrayList<String>();
        SQLiteTokenizer.tokenize(sql, options, res::add);
        return res;
    }

    public static void tokenize(String sql, int options, Consumer<String> checker) {
        if (sql == null) {
            return;
        }
        int pos = 0;
        int len = sql.length();
        while (pos < len) {
            int quoteEnd;
            int quoteStart;
            String token;
            char ch = SQLiteTokenizer.peek(sql, pos);
            if (SQLiteTokenizer.isAlpha(ch)) {
                int start = pos++;
                while (SQLiteTokenizer.isAlNum(SQLiteTokenizer.peek(sql, pos))) {
                    ++pos;
                }
                int end = pos;
                token = sql.substring(start, end);
                checker.accept(token);
                continue;
            }
            if (SQLiteTokenizer.isAnyOf(ch, "'\"`")) {
                quoteStart = pos++;
                while (true) {
                    if ((pos = sql.indexOf(ch, pos)) < 0) {
                        throw SQLiteTokenizer.genException("Unterminated quote", sql);
                    }
                    if (SQLiteTokenizer.peek(sql, pos + 1) != ch) break;
                    pos += 2;
                }
                quoteEnd = pos++;
                if (ch != '\'') {
                    String tokenUnquoted = sql.substring(quoteStart + 1, quoteEnd);
                    String token2 = tokenUnquoted.indexOf(ch) >= 0 ? tokenUnquoted.replaceAll(String.valueOf(ch) + ch, String.valueOf(ch)) : tokenUnquoted;
                    checker.accept(token2);
                    continue;
                }
                if ((options &= 1) == 0) continue;
                throw SQLiteTokenizer.genException("Non-token detected", sql);
            }
            if (ch == '[') {
                quoteStart = pos++;
                if ((pos = sql.indexOf(93, pos)) < 0) {
                    throw SQLiteTokenizer.genException("Unterminated quote", sql);
                }
                quoteEnd = pos++;
                token = sql.substring(quoteStart + 1, quoteEnd);
                checker.accept(token);
                continue;
            }
            if ((options &= 1) != 0) {
                throw SQLiteTokenizer.genException("Non-token detected", sql);
            }
            if (ch == '-' && SQLiteTokenizer.peek(sql, pos + 1) == '-') {
                pos += 2;
                if ((pos = sql.indexOf(10, pos)) < 0) {
                    throw SQLiteTokenizer.genException("Unterminated comment", sql);
                }
                ++pos;
                continue;
            }
            if (ch == '/' && SQLiteTokenizer.peek(sql, pos + 1) == '*') {
                pos += 2;
                if ((pos = sql.indexOf("*/", pos)) < 0) {
                    throw SQLiteTokenizer.genException("Unterminated comment", sql);
                }
                pos += 2;
                continue;
            }
            if (ch == ';') {
                throw SQLiteTokenizer.genException("Semicolon is not allowed", sql);
            }
            ++pos;
        }
    }

    public static boolean isKeyword(String token) {
        switch (token.toUpperCase(Locale.US)) {
            case "ABORT": 
            case "ACTION": 
            case "ADD": 
            case "AFTER": 
            case "ALL": 
            case "ALTER": 
            case "ANALYZE": 
            case "AND": 
            case "AS": 
            case "ASC": 
            case "ATTACH": 
            case "AUTOINCREMENT": 
            case "BEFORE": 
            case "BEGIN": 
            case "BETWEEN": 
            case "BINARY": 
            case "BY": 
            case "CASCADE": 
            case "CASE": 
            case "CAST": 
            case "CHECK": 
            case "COLLATE": 
            case "COLUMN": 
            case "COMMIT": 
            case "CONFLICT": 
            case "CONSTRAINT": 
            case "CREATE": 
            case "CROSS": 
            case "CURRENT": 
            case "CURRENT_DATE": 
            case "CURRENT_TIME": 
            case "CURRENT_TIMESTAMP": 
            case "DATABASE": 
            case "DEFAULT": 
            case "DEFERRABLE": 
            case "DEFERRED": 
            case "DELETE": 
            case "DESC": 
            case "DETACH": 
            case "DISTINCT": 
            case "DO": 
            case "DROP": 
            case "EACH": 
            case "ELSE": 
            case "END": 
            case "ESCAPE": 
            case "EXCEPT": 
            case "EXCLUDE": 
            case "EXCLUSIVE": 
            case "EXISTS": 
            case "EXPLAIN": 
            case "FAIL": 
            case "FILTER": 
            case "FOLLOWING": 
            case "FOR": 
            case "FOREIGN": 
            case "FROM": 
            case "FULL": 
            case "GLOB": 
            case "GROUP": 
            case "GROUPS": 
            case "HAVING": 
            case "IF": 
            case "IGNORE": 
            case "IMMEDIATE": 
            case "IN": 
            case "INDEX": 
            case "INDEXED": 
            case "INITIALLY": 
            case "INNER": 
            case "INSERT": 
            case "INSTEAD": 
            case "INTERSECT": 
            case "INTO": 
            case "IS": 
            case "ISNULL": 
            case "JOIN": 
            case "KEY": 
            case "LEFT": 
            case "LIKE": 
            case "LIMIT": 
            case "MATCH": 
            case "NATURAL": 
            case "NO": 
            case "NOCASE": 
            case "NOT": 
            case "NOTHING": 
            case "NOTNULL": 
            case "NULL": 
            case "OF": 
            case "OFFSET": 
            case "ON": 
            case "OR": 
            case "ORDER": 
            case "OTHERS": 
            case "OUTER": 
            case "OVER": 
            case "PARTITION": 
            case "PLAN": 
            case "PRAGMA": 
            case "PRECEDING": 
            case "PRIMARY": 
            case "QUERY": 
            case "RAISE": 
            case "RANGE": 
            case "RECURSIVE": 
            case "REFERENCES": 
            case "REGEXP": 
            case "REINDEX": 
            case "RELEASE": 
            case "RENAME": 
            case "REPLACE": 
            case "RESTRICT": 
            case "RIGHT": 
            case "ROLLBACK": 
            case "ROW": 
            case "ROWS": 
            case "RTRIM": 
            case "SAVEPOINT": 
            case "SELECT": 
            case "SET": 
            case "TABLE": 
            case "TEMP": 
            case "TEMPORARY": 
            case "THEN": 
            case "TIES": 
            case "TO": 
            case "TRANSACTION": 
            case "TRIGGER": 
            case "UNBOUNDED": 
            case "UNION": 
            case "UNIQUE": 
            case "UPDATE": 
            case "USING": 
            case "VACUUM": 
            case "VALUES": 
            case "VIEW": 
            case "VIRTUAL": 
            case "WHEN": 
            case "WHERE": 
            case "WINDOW": 
            case "WITH": 
            case "WITHOUT": {
                return true;
            }
        }
        return false;
    }

    public static boolean isFunction(String token) {
        switch (token.toLowerCase(Locale.US)) {
            case "abs": 
            case "avg": 
            case "char": 
            case "coalesce": 
            case "count": 
            case "glob": 
            case "group_concat": 
            case "hex": 
            case "ifnull": 
            case "instr": 
            case "length": 
            case "like": 
            case "likelihood": 
            case "likely": 
            case "lower": 
            case "ltrim": 
            case "max": 
            case "min": 
            case "nullif": 
            case "random": 
            case "randomblob": 
            case "replace": 
            case "round": 
            case "rtrim": 
            case "substr": 
            case "sum": 
            case "total": 
            case "trim": 
            case "typeof": 
            case "unicode": 
            case "unlikely": 
            case "upper": 
            case "zeroblob": {
                return true;
            }
        }
        return false;
    }

    public static boolean isType(String token) {
        switch (token.toUpperCase(Locale.US)) {
            case "INT": 
            case "INTEGER": 
            case "TINYINT": 
            case "SMALLINT": 
            case "MEDIUMINT": 
            case "BIGINT": 
            case "INT2": 
            case "INT8": 
            case "CHARACTER": 
            case "VARCHAR": 
            case "NCHAR": 
            case "NVARCHAR": 
            case "TEXT": 
            case "CLOB": 
            case "BLOB": 
            case "REAL": 
            case "DOUBLE": 
            case "FLOAT": 
            case "NUMERIC": 
            case "DECIMAL": 
            case "BOOLEAN": 
            case "DATE": 
            case "DATETIME": {
                return true;
            }
        }
        return false;
    }
}

