/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.compat.annotation.UnsupportedAppUsage;
import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Rect;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class BitmapRegionDecoder {
    private long mNativeBitmapRegionDecoder;
    private boolean mRecycled;
    private final Object mNativeLock = new Object();

    public static BitmapRegionDecoder newInstance(byte[] data, int offset, int length, boolean isShareable) throws IOException {
        if ((offset | length) < 0 || data.length < offset + length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return BitmapRegionDecoder.nativeNewInstance(data, offset, length, isShareable);
    }

    public static BitmapRegionDecoder newInstance(FileDescriptor fd, boolean isShareable) throws IOException {
        return BitmapRegionDecoder.nativeNewInstance(fd, isShareable);
    }

    public static BitmapRegionDecoder newInstance(InputStream is, boolean isShareable) throws IOException {
        if (is instanceof AssetManager.AssetInputStream) {
            return BitmapRegionDecoder.nativeNewInstance(((AssetManager.AssetInputStream)is).getNativeAsset(), isShareable);
        }
        byte[] tempStorage = new byte[16384];
        return BitmapRegionDecoder.nativeNewInstance(is, tempStorage, isShareable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BitmapRegionDecoder newInstance(String pathName, boolean isShareable) throws IOException {
        BitmapRegionDecoder decoder = null;
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(pathName);
            decoder = BitmapRegionDecoder.newInstance(stream, isShareable);
        }
        finally {
            if (stream != null) {
                try {
                    ((InputStream)stream).close();
                }
                catch (IOException iOException) {}
            }
        }
        return decoder;
    }

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    private BitmapRegionDecoder(long decoder) {
        this.mNativeBitmapRegionDecoder = decoder;
        this.mRecycled = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bitmap decodeRegion(Rect rect, BitmapFactory.Options options) {
        BitmapFactory.Options.validate(options);
        Object object = this.mNativeLock;
        synchronized (object) {
            this.checkRecycled("decodeRegion called on recycled region decoder");
            if (rect.right <= 0 || rect.bottom <= 0 || rect.left >= this.getWidth() || rect.top >= this.getHeight()) {
                throw new IllegalArgumentException("rectangle is outside the image");
            }
            return BitmapRegionDecoder.nativeDecodeRegion(this.mNativeBitmapRegionDecoder, rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top, options, BitmapFactory.Options.nativeInBitmap(options), BitmapFactory.Options.nativeColorSpace(options));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getWidth() {
        Object object = this.mNativeLock;
        synchronized (object) {
            this.checkRecycled("getWidth called on recycled region decoder");
            return BitmapRegionDecoder.nativeGetWidth(this.mNativeBitmapRegionDecoder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getHeight() {
        Object object = this.mNativeLock;
        synchronized (object) {
            this.checkRecycled("getHeight called on recycled region decoder");
            return BitmapRegionDecoder.nativeGetHeight(this.mNativeBitmapRegionDecoder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recycle() {
        Object object = this.mNativeLock;
        synchronized (object) {
            if (!this.mRecycled) {
                BitmapRegionDecoder.nativeClean(this.mNativeBitmapRegionDecoder);
                this.mRecycled = true;
            }
        }
    }

    public boolean isRecycled() {
        return this.mRecycled;
    }

    private void checkRecycled(String errorMessage) {
        if (this.mRecycled) {
            throw new IllegalStateException(errorMessage);
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.recycle();
        }
        finally {
            super.finalize();
        }
    }

    private static Bitmap nativeDecodeRegion(long l, int n, int n2, int n3, int n4, BitmapFactory.Options options, long l2, long l3) {
        return (Bitmap)OverrideMethod.invokeA("android.graphics.BitmapRegionDecoder#nativeDecodeRegion(JIIIILandroid/graphics/BitmapFactory$Options;JJ)Landroid/graphics/Bitmap;", true, null);
    }

    private static int nativeGetWidth(long l) {
        return OverrideMethod.invokeI("android.graphics.BitmapRegionDecoder#nativeGetWidth(J)I", true, null);
    }

    private static int nativeGetHeight(long l) {
        return OverrideMethod.invokeI("android.graphics.BitmapRegionDecoder#nativeGetHeight(J)I", true, null);
    }

    private static void nativeClean(long l) {
        OverrideMethod.invokeV("android.graphics.BitmapRegionDecoder#nativeClean(J)V", true, null);
    }

    @UnsupportedAppUsage
    private static BitmapRegionDecoder nativeNewInstance(byte[] byArray, int n, int n2, boolean bl) {
        return (BitmapRegionDecoder)OverrideMethod.invokeA("android.graphics.BitmapRegionDecoder#nativeNewInstance([BIIZ)Landroid/graphics/BitmapRegionDecoder;", true, null);
    }

    private static BitmapRegionDecoder nativeNewInstance(FileDescriptor fileDescriptor, boolean bl) {
        return (BitmapRegionDecoder)OverrideMethod.invokeA("android.graphics.BitmapRegionDecoder#nativeNewInstance(Ljava/io/FileDescriptor;Z)Landroid/graphics/BitmapRegionDecoder;", true, null);
    }

    private static BitmapRegionDecoder nativeNewInstance(InputStream inputStream, byte[] byArray, boolean bl) {
        return (BitmapRegionDecoder)OverrideMethod.invokeA("android.graphics.BitmapRegionDecoder#nativeNewInstance(Ljava/io/InputStream;[BZ)Landroid/graphics/BitmapRegionDecoder;", true, null);
    }

    private static BitmapRegionDecoder nativeNewInstance(long l, boolean bl) {
        return (BitmapRegionDecoder)OverrideMethod.invokeA("android.graphics.BitmapRegionDecoder#nativeNewInstance(JZ)Landroid/graphics/BitmapRegionDecoder;", true, null);
    }
}

