/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.compat.annotation.UnsupportedAppUsage;
import android.graphics.Color;
import android.graphics.ColorSpace;
import android.graphics.Shader;

public class RadialGradient
extends Shader {
    @UnsupportedAppUsage
    private float mX;
    @UnsupportedAppUsage
    private float mY;
    @UnsupportedAppUsage
    private float mRadius;
    @UnsupportedAppUsage
    private float[] mPositions;
    @UnsupportedAppUsage
    private Shader.TileMode mTileMode;
    @UnsupportedAppUsage
    private int[] mColors;
    @UnsupportedAppUsage
    private int mCenterColor;
    @UnsupportedAppUsage
    private int mEdgeColor;
    private final long[] mColorLongs;

    public RadialGradient(float centerX, float centerY, float radius, int[] colors, float[] stops, Shader.TileMode tileMode) {
        this(centerX, centerY, radius, RadialGradient.convertColors(colors), stops, tileMode, ColorSpace.get(ColorSpace.Named.SRGB));
    }

    public RadialGradient(float centerX, float centerY, float radius, long[] colors, float[] stops, Shader.TileMode tileMode) {
        this(centerX, centerY, radius, (long[])colors.clone(), stops, tileMode, RadialGradient.detectColorSpace(colors));
    }

    private RadialGradient(float centerX, float centerY, float radius, long[] colors, float[] stops, Shader.TileMode tileMode, ColorSpace colorSpace) {
        super(colorSpace);
        if (radius <= 0.0f) {
            throw new IllegalArgumentException("radius must be > 0");
        }
        if (stops != null && colors.length != stops.length) {
            throw new IllegalArgumentException("color and position arrays must be of equal length");
        }
        this.mX = centerX;
        this.mY = centerY;
        this.mRadius = radius;
        this.mColorLongs = colors;
        this.mPositions = stops != null ? (float[])stops.clone() : null;
        this.mTileMode = tileMode;
    }

    public RadialGradient(float centerX, float centerY, float radius, int centerColor, int edgeColor, Shader.TileMode tileMode) {
        this(centerX, centerY, radius, Color.pack(centerColor), Color.pack(edgeColor), tileMode);
    }

    public RadialGradient(float centerX, float centerY, float radius, long centerColor, long edgeColor, Shader.TileMode tileMode) {
        this(centerX, centerY, radius, new long[]{centerColor, edgeColor}, null, tileMode);
    }

    @Override
    long createNativeInstance(long nativeMatrix) {
        return RadialGradient.nativeCreate(nativeMatrix, this.mX, this.mY, this.mRadius, this.mColorLongs, this.mPositions, this.mTileMode.nativeInt, this.colorSpace().getNativeInstance());
    }

    private static native long nativeCreate(long var0, float var2, float var3, float var4, long[] var5, float[] var6, int var7, long var8);
}

