/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.ColorSpace;
import android.graphics.Shader;
import libcore.util.NativeAllocationRegistry;

public class RuntimeShader
extends Shader {
    private byte[] mUniforms;
    private boolean mIsOpaque;
    private long mNativeInstanceRuntimeShaderFactory;

    public RuntimeShader(String sksl, byte[] uniforms, boolean isOpaque) {
        this(sksl, uniforms, isOpaque, ColorSpace.get(ColorSpace.Named.SRGB));
    }

    private RuntimeShader(String sksl, byte[] uniforms, boolean isOpaque, ColorSpace colorSpace) {
        super(colorSpace);
        this.mUniforms = uniforms;
        this.mIsOpaque = isOpaque;
        this.mNativeInstanceRuntimeShaderFactory = RuntimeShader.nativeCreateShaderFactory(sksl);
        NoImagePreloadHolder.sRegistry.registerNativeAllocation(this, this.mNativeInstanceRuntimeShaderFactory);
    }

    public void updateUniforms(byte[] uniforms) {
        this.mUniforms = uniforms;
        this.discardNativeInstance();
    }

    @Override
    long createNativeInstance(long nativeMatrix) {
        return RuntimeShader.nativeCreate(this.mNativeInstanceRuntimeShaderFactory, nativeMatrix, this.mUniforms, this.colorSpace().getNativeInstance(), this.mIsOpaque);
    }

    private static native long nativeCreate(long var0, long var2, byte[] var4, long var5, boolean var7);

    private static native long nativeCreateShaderFactory(String var0);

    private static native long nativeGetFinalizer();

    static /* synthetic */ long access$000() {
        return RuntimeShader.nativeGetFinalizer();
    }

    private static class NoImagePreloadHolder {
        public static final NativeAllocationRegistry sRegistry = NativeAllocationRegistry.createMalloced(RuntimeShader.class.getClassLoader(), RuntimeShader.access$000());

        private NoImagePreloadHolder() {
        }
    }
}

