/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.fonts;

import android.graphics.FontListParser;
import android.text.FontConfig;
import android.util.Xml;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class FontCustomizationParser {
    public static Result parse(InputStream in, String fontDir) throws XmlPullParserException, IOException {
        XmlPullParser parser = Xml.newPullParser();
        parser.setInput(in, null);
        parser.nextTag();
        return FontCustomizationParser.readFamilies(parser, fontDir);
    }

    private static void validate(Result result) {
        HashSet<String> familyNames = new HashSet<String>();
        for (int i = 0; i < result.mAdditionalNamedFamilies.size(); ++i) {
            FontConfig.Family family = result.mAdditionalNamedFamilies.get(i);
            String name = family.getName();
            if (name == null) {
                throw new IllegalArgumentException("new-named-family requires name attribute");
            }
            if (familyNames.add(name)) continue;
            throw new IllegalArgumentException("new-named-family requires unique name attribute");
        }
    }

    private static Result readFamilies(XmlPullParser parser, String fontDir) throws XmlPullParserException, IOException {
        Result out = new Result();
        parser.require(2, null, "fonts-modification");
        while (parser.next() != 3) {
            if (parser.getEventType() != 2) continue;
            String tag = parser.getName();
            if (tag.equals("family")) {
                FontCustomizationParser.readFamily(parser, fontDir, out);
                continue;
            }
            if (tag.equals("alias")) {
                out.mAdditionalAliases.add(FontListParser.readAlias(parser));
                continue;
            }
            FontListParser.skip(parser);
        }
        FontCustomizationParser.validate(out);
        return out;
    }

    private static void readFamily(XmlPullParser parser, String fontDir, Result out) throws XmlPullParserException, IOException {
        String customizationType = parser.getAttributeValue(null, "customizationType");
        if (customizationType == null) {
            throw new IllegalArgumentException("customizationType must be specified");
        }
        if (!customizationType.equals("new-named-family")) {
            throw new IllegalArgumentException("Unknown customizationType=" + customizationType);
        }
        out.mAdditionalNamedFamilies.add(FontListParser.readFamily(parser, fontDir));
    }

    public static class Result {
        ArrayList<FontConfig.Family> mAdditionalNamedFamilies = new ArrayList();
        ArrayList<FontConfig.Alias> mAdditionalAliases = new ArrayList();
    }
}

