/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.biometrics;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IBiometricServiceReceiverInternal
extends IInterface {
    public void onAuthenticationSucceeded(boolean var1, byte[] var2, boolean var3) throws RemoteException;

    public void onAuthenticationFailed() throws RemoteException;

    public void onError(int var1, int var2, int var3, int var4) throws RemoteException;

    public void onAcquired(int var1, String var2) throws RemoteException;

    public void onDialogDismissed(int var1, byte[] var2) throws RemoteException;

    public void onTryAgainPressed() throws RemoteException;

    public void onDeviceCredentialPressed() throws RemoteException;

    public void onSystemEvent(int var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IBiometricServiceReceiverInternal {
        private static final String DESCRIPTOR = "android.hardware.biometrics.IBiometricServiceReceiverInternal";
        static final int TRANSACTION_onAuthenticationSucceeded = 1;
        static final int TRANSACTION_onAuthenticationFailed = 2;
        static final int TRANSACTION_onError = 3;
        static final int TRANSACTION_onAcquired = 4;
        static final int TRANSACTION_onDialogDismissed = 5;
        static final int TRANSACTION_onTryAgainPressed = 6;
        static final int TRANSACTION_onDeviceCredentialPressed = 7;
        static final int TRANSACTION_onSystemEvent = 8;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IBiometricServiceReceiverInternal asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IBiometricServiceReceiverInternal) {
                return (IBiometricServiceReceiverInternal)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onAuthenticationSucceeded";
                }
                case 2: {
                    return "onAuthenticationFailed";
                }
                case 3: {
                    return "onError";
                }
                case 4: {
                    return "onAcquired";
                }
                case 5: {
                    return "onDialogDismissed";
                }
                case 6: {
                    return "onTryAgainPressed";
                }
                case 7: {
                    return "onDeviceCredentialPressed";
                }
                case 8: {
                    return "onSystemEvent";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
                case 1: {
                    data.enforceInterface(descriptor);
                    boolean _arg0 = 0 != data.readInt();
                    byte[] _arg1 = data.createByteArray();
                    boolean _arg2 = 0 != data.readInt();
                    this.onAuthenticationSucceeded(_arg0, _arg1, _arg2);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    this.onAuthenticationFailed();
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    this.onError(_arg0, _arg1, _arg2, _arg3);
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    this.onAcquired(_arg0, _arg1);
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    byte[] _arg1 = data.createByteArray();
                    this.onDialogDismissed(_arg0, _arg1);
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    this.onTryAgainPressed();
                    return true;
                }
                case 7: {
                    data.enforceInterface(descriptor);
                    this.onDeviceCredentialPressed();
                    return true;
                }
                case 8: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.onSystemEvent(_arg0);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IBiometricServiceReceiverInternal impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IBiometricServiceReceiverInternal getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IBiometricServiceReceiverInternal {
            private IBinder mRemote;
            public static IBiometricServiceReceiverInternal sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAuthenticationSucceeded(boolean requireConfirmation, byte[] token, boolean isStrongBiometric) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(requireConfirmation ? 1 : 0);
                    _data.writeByteArray(token);
                    _data.writeInt(isStrongBiometric ? 1 : 0);
                    boolean _status = this.mRemote.transact(1, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onAuthenticationSucceeded(requireConfirmation, token, isStrongBiometric);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onAuthenticationFailed() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(2, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onAuthenticationFailed();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onError(int cookie, int modality, int error, int vendorCode) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(cookie);
                    _data.writeInt(modality);
                    _data.writeInt(error);
                    _data.writeInt(vendorCode);
                    boolean _status = this.mRemote.transact(3, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onError(cookie, modality, error, vendorCode);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAcquired(int acquiredInfo, String message) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(acquiredInfo);
                    _data.writeString(message);
                    boolean _status = this.mRemote.transact(4, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onAcquired(acquiredInfo, message);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDialogDismissed(int reason, byte[] credentialAttestation) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(reason);
                    _data.writeByteArray(credentialAttestation);
                    boolean _status = this.mRemote.transact(5, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onDialogDismissed(reason, credentialAttestation);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onTryAgainPressed() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(6, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onTryAgainPressed();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onDeviceCredentialPressed() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(7, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onDeviceCredentialPressed();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSystemEvent(int event) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(event);
                    boolean _status = this.mRemote.transact(8, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onSystemEvent(event);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IBiometricServiceReceiverInternal {
        @Override
        public void onAuthenticationSucceeded(boolean requireConfirmation, byte[] token, boolean isStrongBiometric) throws RemoteException {
        }

        @Override
        public void onAuthenticationFailed() throws RemoteException {
        }

        @Override
        public void onError(int cookie, int modality, int error, int vendorCode) throws RemoteException {
        }

        @Override
        public void onAcquired(int acquiredInfo, String message) throws RemoteException {
        }

        @Override
        public void onDialogDismissed(int reason, byte[] credentialAttestation) throws RemoteException {
        }

        @Override
        public void onTryAgainPressed() throws RemoteException {
        }

        @Override
        public void onDeviceCredentialPressed() throws RemoteException {
        }

        @Override
        public void onSystemEvent(int event) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

