/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.impl;

import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraOfflineSession;
import android.hardware.camera2.CaptureFailure;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.ICameraDeviceCallbacks;
import android.hardware.camera2.ICameraDeviceUser;
import android.hardware.camera2.ICameraOfflineSession;
import android.hardware.camera2.TotalCaptureResult;
import android.hardware.camera2.impl.CameraCaptureSessionCore;
import android.hardware.camera2.impl.CameraCaptureSessionImpl;
import android.hardware.camera2.impl.CameraConstrainedHighSpeedCaptureSessionImpl;
import android.hardware.camera2.impl.CameraMetadataNative;
import android.hardware.camera2.impl.CameraOfflineSessionImpl;
import android.hardware.camera2.impl.CaptureCallback;
import android.hardware.camera2.impl.CaptureCallbackHolder;
import android.hardware.camera2.impl.CaptureResultExtras;
import android.hardware.camera2.impl.FrameNumberTracker;
import android.hardware.camera2.impl.ICameraDeviceUserWrapper;
import android.hardware.camera2.impl.PhysicalCaptureResultInfo;
import android.hardware.camera2.impl.RequestLastFrameNumbersHolder;
import android.hardware.camera2.params.InputConfiguration;
import android.hardware.camera2.params.OutputConfiguration;
import android.hardware.camera2.params.SessionConfiguration;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.hardware.camera2.utils.SubmitInfo;
import android.hardware.camera2.utils.SurfaceUtils;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.RemoteException;
import android.os.ServiceSpecificException;
import android.util.Log;
import android.util.Range;
import android.util.Size;
import android.util.SparseArray;
import android.view.Surface;
import com.android.internal.util.function.pooled.PooledLambda;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;

public class CameraDeviceImpl
extends CameraDevice
implements IBinder.DeathRecipient {
    private final String TAG;
    private final boolean DEBUG = false;
    private static final int REQUEST_ID_NONE = -1;
    private ICameraDeviceUserWrapper mRemoteDevice;
    final Object mInterfaceLock = new Object();
    private final CameraDeviceCallbacks mCallbacks = new CameraDeviceCallbacks();
    private final CameraDevice.StateCallback mDeviceCallback;
    private volatile StateCallbackKK mSessionStateCallback;
    private final Executor mDeviceExecutor;
    private final AtomicBoolean mClosing = new AtomicBoolean();
    private boolean mInError = false;
    private boolean mIdle = true;
    private SparseArray<CaptureCallbackHolder> mCaptureCallbackMap = new SparseArray();
    private int mRepeatingRequestId = -1;
    private int[] mRepeatingRequestTypes;
    private AbstractMap.SimpleEntry<Integer, InputConfiguration> mConfiguredInput = new AbstractMap.SimpleEntry<Integer, Object>(-1, null);
    private final SparseArray<OutputConfiguration> mConfiguredOutputs = new SparseArray();
    private final HashSet<Integer> mOfflineSupport = new HashSet();
    private final String mCameraId;
    private final CameraCharacteristics mCharacteristics;
    private final int mTotalPartialCount;
    private static final long NANO_PER_SECOND = 1000000000L;
    private final List<RequestLastFrameNumbersHolder> mRequestLastFrameNumbersList = new ArrayList<RequestLastFrameNumbersHolder>();
    private FrameNumberTracker mFrameNumberTracker = new FrameNumberTracker();
    private CameraCaptureSessionCore mCurrentSession;
    private int mNextSessionId = 0;
    private final int mAppTargetSdkVersion;
    private ExecutorService mOfflineSwitchService;
    private CameraOfflineSessionImpl mOfflineSessionImpl;
    private final Runnable mCallOnOpened = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            StateCallbackKK sessionCallback = null;
            Object object = CameraDeviceImpl.this.mInterfaceLock;
            synchronized (object) {
                if (CameraDeviceImpl.this.mRemoteDevice == null) {
                    return;
                }
                sessionCallback = CameraDeviceImpl.this.mSessionStateCallback;
            }
            if (sessionCallback != null) {
                sessionCallback.onOpened(CameraDeviceImpl.this);
            }
            CameraDeviceImpl.this.mDeviceCallback.onOpened(CameraDeviceImpl.this);
        }
    };
    private final Runnable mCallOnUnconfigured = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            StateCallbackKK sessionCallback = null;
            Object object = CameraDeviceImpl.this.mInterfaceLock;
            synchronized (object) {
                if (CameraDeviceImpl.this.mRemoteDevice == null) {
                    return;
                }
                sessionCallback = CameraDeviceImpl.this.mSessionStateCallback;
            }
            if (sessionCallback != null) {
                sessionCallback.onUnconfigured(CameraDeviceImpl.this);
            }
        }
    };
    private final Runnable mCallOnActive = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            StateCallbackKK sessionCallback = null;
            Object object = CameraDeviceImpl.this.mInterfaceLock;
            synchronized (object) {
                if (CameraDeviceImpl.this.mRemoteDevice == null) {
                    return;
                }
                sessionCallback = CameraDeviceImpl.this.mSessionStateCallback;
            }
            if (sessionCallback != null) {
                sessionCallback.onActive(CameraDeviceImpl.this);
            }
        }
    };
    private final Runnable mCallOnBusy = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            StateCallbackKK sessionCallback = null;
            Object object = CameraDeviceImpl.this.mInterfaceLock;
            synchronized (object) {
                if (CameraDeviceImpl.this.mRemoteDevice == null) {
                    return;
                }
                sessionCallback = CameraDeviceImpl.this.mSessionStateCallback;
            }
            if (sessionCallback != null) {
                sessionCallback.onBusy(CameraDeviceImpl.this);
            }
        }
    };
    private final Runnable mCallOnClosed = new Runnable(){
        private boolean mClosedOnce = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.mClosedOnce) {
                throw new AssertionError((Object)"Don't post #onClosed more than once");
            }
            StateCallbackKK sessionCallback = null;
            Object object = CameraDeviceImpl.this.mInterfaceLock;
            synchronized (object) {
                sessionCallback = CameraDeviceImpl.this.mSessionStateCallback;
            }
            if (sessionCallback != null) {
                sessionCallback.onClosed(CameraDeviceImpl.this);
            }
            CameraDeviceImpl.this.mDeviceCallback.onClosed(CameraDeviceImpl.this);
            this.mClosedOnce = true;
        }
    };
    private final Runnable mCallOnIdle = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            StateCallbackKK sessionCallback = null;
            Object object = CameraDeviceImpl.this.mInterfaceLock;
            synchronized (object) {
                if (CameraDeviceImpl.this.mRemoteDevice == null) {
                    return;
                }
                sessionCallback = CameraDeviceImpl.this.mSessionStateCallback;
            }
            if (sessionCallback != null) {
                sessionCallback.onIdle(CameraDeviceImpl.this);
            }
        }
    };
    private final Runnable mCallOnDisconnected = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            StateCallbackKK sessionCallback = null;
            Object object = CameraDeviceImpl.this.mInterfaceLock;
            synchronized (object) {
                if (CameraDeviceImpl.this.mRemoteDevice == null) {
                    return;
                }
                sessionCallback = CameraDeviceImpl.this.mSessionStateCallback;
            }
            if (sessionCallback != null) {
                sessionCallback.onDisconnected(CameraDeviceImpl.this);
            }
            CameraDeviceImpl.this.mDeviceCallback.onDisconnected(CameraDeviceImpl.this);
        }
    };

    public CameraDeviceImpl(String cameraId, CameraDevice.StateCallback callback, Executor executor, CameraCharacteristics characteristics, int appTargetSdkVersion) {
        if (cameraId == null || callback == null || executor == null || characteristics == null) {
            throw new IllegalArgumentException("Null argument given");
        }
        this.mCameraId = cameraId;
        this.mDeviceCallback = callback;
        this.mDeviceExecutor = executor;
        this.mCharacteristics = characteristics;
        this.mAppTargetSdkVersion = appTargetSdkVersion;
        int MAX_TAG_LEN = 23;
        String tag = String.format("CameraDevice-JV-%s", this.mCameraId);
        if (tag.length() > 23) {
            tag = tag.substring(0, 23);
        }
        this.TAG = tag;
        Integer partialCount = this.mCharacteristics.get(CameraCharacteristics.REQUEST_PARTIAL_RESULT_COUNT);
        this.mTotalPartialCount = partialCount == null ? 1 : partialCount;
    }

    public CameraDeviceCallbacks getCallbacks() {
        return this.mCallbacks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRemoteDevice(ICameraDeviceUser remoteDevice) throws CameraAccessException {
        Object object = this.mInterfaceLock;
        synchronized (object) {
            if (this.mInError) {
                return;
            }
            this.mRemoteDevice = new ICameraDeviceUserWrapper(remoteDevice);
            IBinder remoteDeviceBinder = remoteDevice.asBinder();
            if (remoteDeviceBinder != null) {
                try {
                    remoteDeviceBinder.linkToDeath(this, 0);
                }
                catch (RemoteException e) {
                    this.mDeviceExecutor.execute(this.mCallOnDisconnected);
                    throw new CameraAccessException(2, "The camera device has encountered a serious error");
                }
            }
            this.mDeviceExecutor.execute(this.mCallOnOpened);
            this.mDeviceExecutor.execute(this.mCallOnUnconfigured);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRemoteFailure(ServiceSpecificException failure) {
        int failureCode = 4;
        boolean failureIsError = true;
        switch (failure.errorCode) {
            case 7: {
                failureCode = 1;
                break;
            }
            case 8: {
                failureCode = 2;
                break;
            }
            case 6: {
                failureCode = 3;
                break;
            }
            case 4: {
                failureIsError = false;
                break;
            }
            case 10: {
                failureCode = 4;
                break;
            }
            default: {
                Log.e(this.TAG, "Unexpected failure in opening camera device: " + failure.errorCode + failure.getMessage());
            }
        }
        final int code = failureCode;
        final boolean isError = failureIsError;
        Object object = this.mInterfaceLock;
        synchronized (object) {
            this.mInError = true;
            this.mDeviceExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    if (isError) {
                        CameraDeviceImpl.this.mDeviceCallback.onError(CameraDeviceImpl.this, code);
                    } else {
                        CameraDeviceImpl.this.mDeviceCallback.onDisconnected(CameraDeviceImpl.this);
                    }
                }
            });
        }
    }

    @Override
    public String getId() {
        return this.mCameraId;
    }

    public void configureOutputs(List<Surface> outputs) throws CameraAccessException {
        ArrayList<OutputConfiguration> outputConfigs = new ArrayList<OutputConfiguration>(outputs.size());
        for (Surface s : outputs) {
            outputConfigs.add(new OutputConfiguration(s));
        }
        this.configureStreamsChecked(null, outputConfigs, 0, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean configureStreamsChecked(InputConfiguration inputConfig, List<OutputConfiguration> outputs, int operatingMode, CaptureRequest sessionParams) throws CameraAccessException {
        if (outputs == null) {
            outputs = new ArrayList<OutputConfiguration>();
        }
        if (outputs.size() == 0 && inputConfig != null) {
            throw new IllegalArgumentException("cannot configure an input stream without any output streams");
        }
        this.checkInputConfiguration(inputConfig);
        boolean success = false;
        Object object = this.mInterfaceLock;
        synchronized (object) {
            int streamId;
            this.checkIfCameraClosedOrInError();
            HashSet<OutputConfiguration> addSet = new HashSet<OutputConfiguration>(outputs);
            ArrayList<Integer> deleteList = new ArrayList<Integer>();
            for (int i = 0; i < this.mConfiguredOutputs.size(); ++i) {
                streamId = this.mConfiguredOutputs.keyAt(i);
                OutputConfiguration outConfig = this.mConfiguredOutputs.valueAt(i);
                if (!outputs.contains(outConfig) || outConfig.isDeferredConfiguration()) {
                    deleteList.add(streamId);
                    continue;
                }
                addSet.remove(outConfig);
            }
            this.mDeviceExecutor.execute(this.mCallOnBusy);
            this.stopRepeating();
            try {
                this.waitUntilIdle();
                this.mRemoteDevice.beginConfigure();
                InputConfiguration currentInputConfig = this.mConfiguredInput.getValue();
                if (!(inputConfig == currentInputConfig || inputConfig != null && inputConfig.equals(currentInputConfig))) {
                    if (currentInputConfig != null) {
                        this.mRemoteDevice.deleteStream(this.mConfiguredInput.getKey());
                        this.mConfiguredInput = new AbstractMap.SimpleEntry<Integer, Object>(-1, null);
                    }
                    if (inputConfig != null) {
                        streamId = this.mRemoteDevice.createInputStream(inputConfig.getWidth(), inputConfig.getHeight(), inputConfig.getFormat());
                        this.mConfiguredInput = new AbstractMap.SimpleEntry<Integer, InputConfiguration>(streamId, inputConfig);
                    }
                }
                for (Integer streamId2 : deleteList) {
                    this.mRemoteDevice.deleteStream(streamId2);
                    this.mConfiguredOutputs.delete(streamId2);
                }
                for (OutputConfiguration outConfig : outputs) {
                    if (!addSet.contains(outConfig)) continue;
                    int streamId3 = this.mRemoteDevice.createStream(outConfig);
                    this.mConfiguredOutputs.put(streamId3, outConfig);
                }
                int[] offlineStreamIds = sessionParams != null ? this.mRemoteDevice.endConfigure(operatingMode, sessionParams.getNativeCopy()) : this.mRemoteDevice.endConfigure(operatingMode, null);
                this.mOfflineSupport.clear();
                if (offlineStreamIds != null && offlineStreamIds.length > 0) {
                    for (int offlineStreamId : offlineStreamIds) {
                        this.mOfflineSupport.add(offlineStreamId);
                    }
                }
                success = true;
            }
            catch (IllegalArgumentException e) {
                Log.w(this.TAG, "Stream configuration failed due to: " + e.getMessage());
                boolean bl = false;
                return bl;
            }
            catch (CameraAccessException e) {
                if (e.getReason() != 4) throw e;
                throw new IllegalStateException("The camera is currently busy. You must wait until the previous operation completes.", e);
            }
            finally {
                if (success && outputs.size() > 0) {
                    this.mDeviceExecutor.execute(this.mCallOnIdle);
                } else {
                    this.mDeviceExecutor.execute(this.mCallOnUnconfigured);
                }
            }
            return success;
        }
    }

    @Override
    public void createCaptureSession(List<Surface> outputs, CameraCaptureSession.StateCallback callback, Handler handler) throws CameraAccessException {
        ArrayList<OutputConfiguration> outConfigurations = new ArrayList<OutputConfiguration>(outputs.size());
        for (Surface surface : outputs) {
            outConfigurations.add(new OutputConfiguration(surface));
        }
        this.createCaptureSessionInternal(null, outConfigurations, callback, CameraDeviceImpl.checkAndWrapHandler(handler), 0, null);
    }

    @Override
    public void createCaptureSessionByOutputConfigurations(List<OutputConfiguration> outputConfigurations, CameraCaptureSession.StateCallback callback, Handler handler) throws CameraAccessException {
        ArrayList<OutputConfiguration> currentOutputs = new ArrayList<OutputConfiguration>(outputConfigurations);
        this.createCaptureSessionInternal(null, currentOutputs, callback, CameraDeviceImpl.checkAndWrapHandler(handler), 0, null);
    }

    @Override
    public void createReprocessableCaptureSession(InputConfiguration inputConfig, List<Surface> outputs, CameraCaptureSession.StateCallback callback, Handler handler) throws CameraAccessException {
        if (inputConfig == null) {
            throw new IllegalArgumentException("inputConfig cannot be null when creating a reprocessable capture session");
        }
        ArrayList<OutputConfiguration> outConfigurations = new ArrayList<OutputConfiguration>(outputs.size());
        for (Surface surface : outputs) {
            outConfigurations.add(new OutputConfiguration(surface));
        }
        this.createCaptureSessionInternal(inputConfig, outConfigurations, callback, CameraDeviceImpl.checkAndWrapHandler(handler), 0, null);
    }

    @Override
    public void createReprocessableCaptureSessionByConfigurations(InputConfiguration inputConfig, List<OutputConfiguration> outputs, CameraCaptureSession.StateCallback callback, Handler handler) throws CameraAccessException {
        if (inputConfig == null) {
            throw new IllegalArgumentException("inputConfig cannot be null when creating a reprocessable capture session");
        }
        if (outputs == null) {
            throw new IllegalArgumentException("Output configurations cannot be null when creating a reprocessable capture session");
        }
        ArrayList<OutputConfiguration> currentOutputs = new ArrayList<OutputConfiguration>();
        for (OutputConfiguration output : outputs) {
            currentOutputs.add(new OutputConfiguration(output));
        }
        this.createCaptureSessionInternal(inputConfig, currentOutputs, callback, CameraDeviceImpl.checkAndWrapHandler(handler), 0, null);
    }

    @Override
    public void createConstrainedHighSpeedCaptureSession(List<Surface> outputs, CameraCaptureSession.StateCallback callback, Handler handler) throws CameraAccessException {
        if (outputs == null || outputs.size() == 0 || outputs.size() > 2) {
            throw new IllegalArgumentException("Output surface list must not be null and the size must be no more than 2");
        }
        ArrayList<OutputConfiguration> outConfigurations = new ArrayList<OutputConfiguration>(outputs.size());
        for (Surface surface : outputs) {
            outConfigurations.add(new OutputConfiguration(surface));
        }
        this.createCaptureSessionInternal(null, outConfigurations, callback, CameraDeviceImpl.checkAndWrapHandler(handler), 1, null);
    }

    @Override
    public void createCustomCaptureSession(InputConfiguration inputConfig, List<OutputConfiguration> outputs, int operatingMode, CameraCaptureSession.StateCallback callback, Handler handler) throws CameraAccessException {
        ArrayList<OutputConfiguration> currentOutputs = new ArrayList<OutputConfiguration>();
        for (OutputConfiguration output : outputs) {
            currentOutputs.add(new OutputConfiguration(output));
        }
        this.createCaptureSessionInternal(inputConfig, currentOutputs, callback, CameraDeviceImpl.checkAndWrapHandler(handler), operatingMode, null);
    }

    @Override
    public void createCaptureSession(SessionConfiguration config) throws CameraAccessException {
        if (config == null) {
            throw new IllegalArgumentException("Invalid session configuration");
        }
        List<OutputConfiguration> outputConfigs = config.getOutputConfigurations();
        if (outputConfigs == null) {
            throw new IllegalArgumentException("Invalid output configurations");
        }
        if (config.getExecutor() == null) {
            throw new IllegalArgumentException("Invalid executor");
        }
        this.createCaptureSessionInternal(config.getInputConfiguration(), outputConfigs, config.getStateCallback(), config.getExecutor(), config.getSessionType(), config.getSessionParameters());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createCaptureSessionInternal(InputConfiguration inputConfig, List<OutputConfiguration> outputConfigurations, CameraCaptureSession.StateCallback callback, Executor executor, int operatingMode, CaptureRequest sessionParams) throws CameraAccessException {
        Object object = this.mInterfaceLock;
        synchronized (object) {
            boolean isConstrainedHighSpeed;
            this.checkIfCameraClosedOrInError();
            boolean bl = isConstrainedHighSpeed = operatingMode == 1;
            if (isConstrainedHighSpeed && inputConfig != null) {
                throw new IllegalArgumentException("Constrained high speed session doesn't support input configuration yet.");
            }
            if (this.mCurrentSession != null) {
                this.mCurrentSession.replaceSessionClose();
            }
            boolean configureSuccess = true;
            CameraAccessException pendingException = null;
            Surface input = null;
            try {
                configureSuccess = this.configureStreamsChecked(inputConfig, outputConfigurations, operatingMode, sessionParams);
                if (configureSuccess && inputConfig != null) {
                    input = this.mRemoteDevice.getInputSurface();
                }
            }
            catch (CameraAccessException e) {
                configureSuccess = false;
                pendingException = e;
                input = null;
            }
            CameraCaptureSession newSession = null;
            if (isConstrainedHighSpeed) {
                ArrayList<Surface> surfaces = new ArrayList<Surface>(outputConfigurations.size());
                for (OutputConfiguration outConfig : outputConfigurations) {
                    surfaces.add(outConfig.getSurface());
                }
                StreamConfigurationMap config = this.getCharacteristics().get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
                SurfaceUtils.checkConstrainedHighSpeedSurfaces(surfaces, null, config);
                newSession = new CameraConstrainedHighSpeedCaptureSessionImpl(this.mNextSessionId++, callback, executor, this, this.mDeviceExecutor, configureSuccess, this.mCharacteristics);
            } else {
                newSession = new CameraCaptureSessionImpl(this.mNextSessionId++, input, callback, executor, this, this.mDeviceExecutor, configureSuccess);
            }
            this.mCurrentSession = newSession;
            if (pendingException != null) {
                throw pendingException;
            }
            this.mSessionStateCallback = this.mCurrentSession.getDeviceStateCallback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSessionConfigurationSupported(SessionConfiguration sessionConfig) throws CameraAccessException, UnsupportedOperationException, IllegalArgumentException {
        Object object = this.mInterfaceLock;
        synchronized (object) {
            this.checkIfCameraClosedOrInError();
            return this.mRemoteDevice.isSessionConfigurationSupported(sessionConfig);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSessionListener(StateCallbackKK sessionCallback) {
        Object object = this.mInterfaceLock;
        synchronized (object) {
            this.mSessionStateCallback = sessionCallback;
        }
    }

    private void overrideEnableZsl(CameraMetadataNative request, boolean newValue) {
        Boolean enableZsl = request.get(CaptureRequest.CONTROL_ENABLE_ZSL);
        if (enableZsl == null) {
            return;
        }
        request.set(CaptureRequest.CONTROL_ENABLE_ZSL, Boolean.valueOf(newValue));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CaptureRequest.Builder createCaptureRequest(int templateType, Set<String> physicalCameraIdSet) throws CameraAccessException {
        Object object = this.mInterfaceLock;
        synchronized (object) {
            this.checkIfCameraClosedOrInError();
            for (String physicalId : physicalCameraIdSet) {
                if (physicalId != this.getId()) continue;
                throw new IllegalStateException("Physical id matches the logical id!");
            }
            CameraMetadataNative templatedRequest = null;
            templatedRequest = this.mRemoteDevice.createDefaultRequest(templateType);
            if (this.mAppTargetSdkVersion < 26 || templateType != 2) {
                this.overrideEnableZsl(templatedRequest, false);
            }
            CaptureRequest.Builder builder = new CaptureRequest.Builder(templatedRequest, false, -1, this.getId(), physicalCameraIdSet);
            return builder;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CaptureRequest.Builder createCaptureRequest(int templateType) throws CameraAccessException {
        Object object = this.mInterfaceLock;
        synchronized (object) {
            this.checkIfCameraClosedOrInError();
            CameraMetadataNative templatedRequest = null;
            templatedRequest = this.mRemoteDevice.createDefaultRequest(templateType);
            if (this.mAppTargetSdkVersion < 26 || templateType != 2) {
                this.overrideEnableZsl(templatedRequest, false);
            }
            CaptureRequest.Builder builder = new CaptureRequest.Builder(templatedRequest, false, -1, this.getId(), null);
            return builder;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CaptureRequest.Builder createReprocessCaptureRequest(TotalCaptureResult inputResult) throws CameraAccessException {
        Object object = this.mInterfaceLock;
        synchronized (object) {
            this.checkIfCameraClosedOrInError();
            CameraMetadataNative resultMetadata = new CameraMetadataNative(inputResult.getNativeCopy());
            return new CaptureRequest.Builder(resultMetadata, true, inputResult.getSessionId(), this.getId(), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare(Surface surface) throws CameraAccessException {
        if (surface == null) {
            throw new IllegalArgumentException("Surface is null");
        }
        Object object = this.mInterfaceLock;
        synchronized (object) {
            this.checkIfCameraClosedOrInError();
            int streamId = -1;
            for (int i = 0; i < this.mConfiguredOutputs.size(); ++i) {
                List<Surface> surfaces = this.mConfiguredOutputs.valueAt(i).getSurfaces();
                if (!surfaces.contains(surface)) continue;
                streamId = this.mConfiguredOutputs.keyAt(i);
                break;
            }
            if (streamId == -1) {
                throw new IllegalArgumentException("Surface is not part of this session");
            }
            this.mRemoteDevice.prepare(streamId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare(int maxCount, Surface surface) throws CameraAccessException {
        if (surface == null) {
            throw new IllegalArgumentException("Surface is null");
        }
        if (maxCount <= 0) {
            throw new IllegalArgumentException("Invalid maxCount given: " + maxCount);
        }
        Object object = this.mInterfaceLock;
        synchronized (object) {
            this.checkIfCameraClosedOrInError();
            int streamId = -1;
            for (int i = 0; i < this.mConfiguredOutputs.size(); ++i) {
                if (surface != this.mConfiguredOutputs.valueAt(i).getSurface()) continue;
                streamId = this.mConfiguredOutputs.keyAt(i);
                break;
            }
            if (streamId == -1) {
                throw new IllegalArgumentException("Surface is not part of this session");
            }
            this.mRemoteDevice.prepare2(maxCount, streamId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateOutputConfiguration(OutputConfiguration config) throws CameraAccessException {
        Object object = this.mInterfaceLock;
        synchronized (object) {
            this.checkIfCameraClosedOrInError();
            int streamId = -1;
            for (int i = 0; i < this.mConfiguredOutputs.size(); ++i) {
                if (config.getSurface() != this.mConfiguredOutputs.valueAt(i).getSurface()) continue;
                streamId = this.mConfiguredOutputs.keyAt(i);
                break;
            }
            if (streamId == -1) {
                throw new IllegalArgumentException("Invalid output configuration");
            }
            this.mRemoteDevice.updateOutputConfiguration(streamId, config);
            this.mConfiguredOutputs.put(streamId, config);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CameraOfflineSession switchToOffline(Collection<Surface> offlineOutputs, Executor executor, CameraOfflineSession.CameraOfflineSessionCallback listener) throws CameraAccessException {
        CameraOfflineSessionImpl ret;
        if (offlineOutputs.isEmpty()) {
            throw new IllegalArgumentException("Invalid offline surfaces!");
        }
        final HashSet<Integer> offlineStreamIds = new HashSet<Integer>();
        SparseArray<OutputConfiguration> offlineConfiguredOutputs = new SparseArray<OutputConfiguration>();
        Object object = this.mInterfaceLock;
        synchronized (object) {
            this.checkIfCameraClosedOrInError();
            if (this.mOfflineSessionImpl != null) {
                throw new IllegalStateException("Switch to offline mode already in progress");
            }
            for (Surface surface : offlineOutputs) {
                int streamId = -1;
                for (int i = 0; i < this.mConfiguredOutputs.size(); ++i) {
                    if (surface != this.mConfiguredOutputs.valueAt(i).getSurface()) continue;
                    streamId = this.mConfiguredOutputs.keyAt(i);
                    offlineConfiguredOutputs.append(streamId, this.mConfiguredOutputs.valueAt(i));
                    break;
                }
                if (streamId == -1) {
                    throw new IllegalArgumentException("Offline surface is not part of this session");
                }
                if (!this.mOfflineSupport.contains(streamId)) {
                    throw new IllegalArgumentException("Surface: " + surface + " does not  support offline mode");
                }
                offlineStreamIds.add(streamId);
            }
            this.stopRepeating();
            ret = this.mOfflineSessionImpl = new CameraOfflineSessionImpl(this.mCameraId, this.mCharacteristics, executor, listener, offlineConfiguredOutputs, this.mConfiguredInput, this.mConfiguredOutputs, this.mFrameNumberTracker, this.mCaptureCallbackMap, this.mRequestLastFrameNumbersList);
            this.mOfflineSwitchService = Executors.newSingleThreadExecutor();
            this.mConfiguredOutputs.clear();
            this.mConfiguredInput = new AbstractMap.SimpleEntry<Integer, Object>(-1, null);
            this.mIdle = true;
            this.mCaptureCallbackMap = new SparseArray();
            this.mFrameNumberTracker = new FrameNumberTracker();
            this.mCurrentSession.closeWithoutDraining();
            this.mCurrentSession = null;
        }
        this.mOfflineSwitchService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ICameraOfflineSession remoteOfflineSession = CameraDeviceImpl.this.mRemoteDevice.switchToOffline(CameraDeviceImpl.this.mOfflineSessionImpl.getCallbacks(), Arrays.stream(offlineStreamIds.toArray(new Integer[offlineStreamIds.size()])).mapToInt(Integer::intValue).toArray());
                    CameraDeviceImpl.this.mOfflineSessionImpl.setRemoteSession(remoteOfflineSession);
                }
                catch (CameraAccessException e) {
                    CameraDeviceImpl.this.mOfflineSessionImpl.notifyFailedSwitch();
                }
                finally {
                    CameraDeviceImpl.this.mOfflineSessionImpl = null;
                }
            }
        });
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean supportsOfflineProcessing(Surface surface) {
        if (surface == null) {
            throw new IllegalArgumentException("Surface is null");
        }
        Object object = this.mInterfaceLock;
        synchronized (object) {
            int streamId = -1;
            for (int i = 0; i < this.mConfiguredOutputs.size(); ++i) {
                if (surface != this.mConfiguredOutputs.valueAt(i).getSurface()) continue;
                streamId = this.mConfiguredOutputs.keyAt(i);
                break;
            }
            if (streamId == -1) {
                throw new IllegalArgumentException("Surface is not part of this session");
            }
            return this.mOfflineSupport.contains(streamId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tearDown(Surface surface) throws CameraAccessException {
        if (surface == null) {
            throw new IllegalArgumentException("Surface is null");
        }
        Object object = this.mInterfaceLock;
        synchronized (object) {
            this.checkIfCameraClosedOrInError();
            int streamId = -1;
            for (int i = 0; i < this.mConfiguredOutputs.size(); ++i) {
                if (surface != this.mConfiguredOutputs.valueAt(i).getSurface()) continue;
                streamId = this.mConfiguredOutputs.keyAt(i);
                break;
            }
            if (streamId == -1) {
                throw new IllegalArgumentException("Surface is not part of this session");
            }
            this.mRemoteDevice.tearDown(streamId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalizeOutputConfigs(List<OutputConfiguration> outputConfigs) throws CameraAccessException {
        if (outputConfigs == null || outputConfigs.size() == 0) {
            throw new IllegalArgumentException("deferred config is null or empty");
        }
        Object object = this.mInterfaceLock;
        synchronized (object) {
            this.checkIfCameraClosedOrInError();
            for (OutputConfiguration config : outputConfigs) {
                int streamId = -1;
                for (int i = 0; i < this.mConfiguredOutputs.size(); ++i) {
                    if (!config.equals(this.mConfiguredOutputs.valueAt(i))) continue;
                    streamId = this.mConfiguredOutputs.keyAt(i);
                    break;
                }
                if (streamId == -1) {
                    throw new IllegalArgumentException("Deferred config is not part of this session");
                }
                if (config.getSurfaces().size() == 0) {
                    throw new IllegalArgumentException("The final config for stream " + streamId + " must have at least 1 surface");
                }
                this.mRemoteDevice.finalizeOutputConfigurations(streamId, config);
                this.mConfiguredOutputs.put(streamId, config);
            }
        }
    }

    public int capture(CaptureRequest request, CaptureCallback callback, Executor executor) throws CameraAccessException {
        ArrayList<CaptureRequest> requestList = new ArrayList<CaptureRequest>();
        requestList.add(request);
        return this.submitCaptureRequest(requestList, callback, executor, false);
    }

    public int captureBurst(List<CaptureRequest> requests, CaptureCallback callback, Executor executor) throws CameraAccessException {
        if (requests == null || requests.isEmpty()) {
            throw new IllegalArgumentException("At least one request must be given");
        }
        return this.submitCaptureRequest(requests, callback, executor, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkEarlyTriggerSequenceCompleteLocked(final int requestId, long lastFrameNumber, int[] repeatingRequestTypes) {
        if (lastFrameNumber == -1L) {
            CaptureCallbackHolder holder;
            int index = this.mCaptureCallbackMap.indexOfKey(requestId);
            CaptureCallbackHolder captureCallbackHolder = holder = index >= 0 ? this.mCaptureCallbackMap.valueAt(index) : null;
            if (holder != null) {
                this.mCaptureCallbackMap.removeAt(index);
            }
            if (holder != null) {
                Runnable resultDispatch = new Runnable(){

                    @Override
                    public void run() {
                        if (!CameraDeviceImpl.this.isClosed()) {
                            holder.getCallback().onCaptureSequenceAborted(CameraDeviceImpl.this, requestId);
                        }
                    }
                };
                long ident = Binder.clearCallingIdentity();
                try {
                    holder.getExecutor().execute(resultDispatch);
                }
                finally {
                    Binder.restoreCallingIdentity(ident);
                }
            } else {
                Log.w(this.TAG, String.format("did not register callback to request %d", requestId));
            }
        } else {
            this.mRequestLastFrameNumbersList.add(new RequestLastFrameNumbersHolder(requestId, lastFrameNumber, repeatingRequestTypes));
            this.checkAndFireSequenceComplete();
        }
    }

    private int[] getRequestTypes(CaptureRequest[] requestArray) {
        int[] requestTypes = new int[requestArray.length];
        for (int i = 0; i < requestArray.length; ++i) {
            requestTypes[i] = requestArray[i].getRequestType();
        }
        return requestTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int submitCaptureRequest(List<CaptureRequest> requestList, CaptureCallback callback, Executor executor, boolean repeating) throws CameraAccessException {
        executor = CameraDeviceImpl.checkExecutor(executor, callback);
        Object object = this.mInterfaceLock;
        synchronized (object) {
            this.checkIfCameraClosedOrInError();
            for (CaptureRequest request : requestList) {
                if (request.getTargets().isEmpty()) {
                    throw new IllegalArgumentException("Each request must have at least one Surface target");
                }
                for (Surface surface : request.getTargets()) {
                    if (surface != null) continue;
                    throw new IllegalArgumentException("Null Surface targets are not allowed");
                }
            }
            if (repeating) {
                this.stopRepeating();
            }
            CaptureRequest[] requestArray = requestList.toArray(new CaptureRequest[requestList.size()]);
            for (CaptureRequest captureRequest : requestArray) {
                captureRequest.convertSurfaceToStreamId(this.mConfiguredOutputs);
            }
            SubmitInfo requestInfo = this.mRemoteDevice.submitRequestList(requestArray, repeating);
            for (CaptureRequest captureRequest : requestArray) {
                captureRequest.recoverStreamIdToSurface();
            }
            if (callback != null) {
                this.mCaptureCallbackMap.put(requestInfo.getRequestId(), new CaptureCallbackHolder(callback, requestList, executor, repeating, this.mNextSessionId - 1));
            }
            if (repeating) {
                if (this.mRepeatingRequestId != -1) {
                    this.checkEarlyTriggerSequenceCompleteLocked(this.mRepeatingRequestId, requestInfo.getLastFrameNumber(), this.mRepeatingRequestTypes);
                }
                this.mRepeatingRequestId = requestInfo.getRequestId();
                this.mRepeatingRequestTypes = this.getRequestTypes(requestArray);
            } else {
                this.mRequestLastFrameNumbersList.add(new RequestLastFrameNumbersHolder(requestList, requestInfo));
            }
            if (this.mIdle) {
                this.mDeviceExecutor.execute(this.mCallOnActive);
            }
            this.mIdle = false;
            return requestInfo.getRequestId();
        }
    }

    public int setRepeatingRequest(CaptureRequest request, CaptureCallback callback, Executor executor) throws CameraAccessException {
        ArrayList<CaptureRequest> requestList = new ArrayList<CaptureRequest>();
        requestList.add(request);
        return this.submitCaptureRequest(requestList, callback, executor, true);
    }

    public int setRepeatingBurst(List<CaptureRequest> requests, CaptureCallback callback, Executor executor) throws CameraAccessException {
        if (requests == null || requests.isEmpty()) {
            throw new IllegalArgumentException("At least one request must be given");
        }
        return this.submitCaptureRequest(requests, callback, executor, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopRepeating() throws CameraAccessException {
        Object object = this.mInterfaceLock;
        synchronized (object) {
            this.checkIfCameraClosedOrInError();
            if (this.mRepeatingRequestId != -1) {
                long lastFrameNumber;
                int requestId = this.mRepeatingRequestId;
                this.mRepeatingRequestId = -1;
                int[] requestTypes = this.mRepeatingRequestTypes;
                this.mRepeatingRequestTypes = null;
                try {
                    lastFrameNumber = this.mRemoteDevice.cancelRequest(requestId);
                }
                catch (IllegalArgumentException e) {
                    return;
                }
                this.checkEarlyTriggerSequenceCompleteLocked(requestId, lastFrameNumber, requestTypes);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitUntilIdle() throws CameraAccessException {
        Object object = this.mInterfaceLock;
        synchronized (object) {
            this.checkIfCameraClosedOrInError();
            if (this.mRepeatingRequestId != -1) {
                throw new IllegalStateException("Active repeating request ongoing");
            }
            this.mRemoteDevice.waitUntilIdle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws CameraAccessException {
        Object object = this.mInterfaceLock;
        synchronized (object) {
            this.checkIfCameraClosedOrInError();
            this.mDeviceExecutor.execute(this.mCallOnBusy);
            if (this.mIdle) {
                this.mDeviceExecutor.execute(this.mCallOnIdle);
                return;
            }
            long lastFrameNumber = this.mRemoteDevice.flush();
            if (this.mRepeatingRequestId != -1) {
                this.checkEarlyTriggerSequenceCompleteLocked(this.mRepeatingRequestId, lastFrameNumber, this.mRepeatingRequestTypes);
                this.mRepeatingRequestId = -1;
                this.mRepeatingRequestTypes = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.mInterfaceLock;
        synchronized (object) {
            if (this.mClosing.getAndSet(true)) {
                return;
            }
            if (this.mOfflineSwitchService != null) {
                this.mOfflineSwitchService.shutdownNow();
                this.mOfflineSwitchService = null;
            }
            if (this.mRemoteDevice != null) {
                this.mRemoteDevice.disconnect();
                this.mRemoteDevice.unlinkToDeath(this, 0);
            }
            if (this.mRemoteDevice != null || this.mInError) {
                this.mDeviceExecutor.execute(this.mCallOnClosed);
            }
            this.mRemoteDevice = null;
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    private void checkInputConfiguration(InputConfiguration inputConfig) {
        if (inputConfig != null) {
            Size[] inputSizes;
            StreamConfigurationMap configMap = this.mCharacteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
            int[] inputFormats = configMap.getInputFormats();
            boolean validFormat = false;
            for (int format : inputFormats) {
                if (format != inputConfig.getFormat()) continue;
                validFormat = true;
            }
            if (!validFormat) {
                throw new IllegalArgumentException("input format " + inputConfig.getFormat() + " is not valid");
            }
            boolean validSize = false;
            for (Size s : inputSizes = configMap.getInputSizes(inputConfig.getFormat())) {
                if (inputConfig.getWidth() != s.getWidth() || inputConfig.getHeight() != s.getHeight()) continue;
                validSize = true;
            }
            if (!validSize) {
                throw new IllegalArgumentException("input size " + inputConfig.getWidth() + "x" + inputConfig.getHeight() + " is not valid");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAndFireSequenceComplete() {
        long completedFrameNumber = this.mFrameNumberTracker.getCompletedFrameNumber();
        long completedReprocessFrameNumber = this.mFrameNumberTracker.getCompletedReprocessFrameNumber();
        long completedZslStillFrameNumber = this.mFrameNumberTracker.getCompletedZslStillFrameNumber();
        Iterator<RequestLastFrameNumbersHolder> iter = this.mRequestLastFrameNumbersList.iterator();
        while (iter.hasNext()) {
            final RequestLastFrameNumbersHolder requestLastFrameNumbers = iter.next();
            final int requestId = requestLastFrameNumbers.getRequestId();
            if (this.mRemoteDevice == null) {
                Log.w(this.TAG, "Camera closed while checking sequences");
                return;
            }
            if (!requestLastFrameNumbers.isSequenceCompleted()) {
                int index;
                CaptureCallbackHolder holder;
                long lastRegularFrameNumber = requestLastFrameNumbers.getLastRegularFrameNumber();
                long lastReprocessFrameNumber = requestLastFrameNumbers.getLastReprocessFrameNumber();
                long lastZslStillFrameNumber = requestLastFrameNumbers.getLastZslStillFrameNumber();
                if (lastRegularFrameNumber <= completedFrameNumber && lastReprocessFrameNumber <= completedReprocessFrameNumber && lastZslStillFrameNumber <= completedZslStillFrameNumber) {
                    requestLastFrameNumbers.markSequenceCompleted();
                }
                CaptureCallbackHolder captureCallbackHolder = holder = (index = this.mCaptureCallbackMap.indexOfKey(requestId)) >= 0 ? this.mCaptureCallbackMap.valueAt(index) : null;
                if (holder != null && requestLastFrameNumbers.isSequenceCompleted()) {
                    Runnable resultDispatch = new Runnable(){

                        @Override
                        public void run() {
                            if (!CameraDeviceImpl.this.isClosed()) {
                                holder.getCallback().onCaptureSequenceCompleted(CameraDeviceImpl.this, requestId, requestLastFrameNumbers.getLastFrameNumber());
                            }
                        }
                    };
                    long ident = Binder.clearCallingIdentity();
                    try {
                        holder.getExecutor().execute(resultDispatch);
                    }
                    finally {
                        Binder.restoreCallingIdentity(ident);
                    }
                }
            }
            if (!requestLastFrameNumbers.isSequenceCompleted() || !requestLastFrameNumbers.isInflightCompleted()) continue;
            int index = this.mCaptureCallbackMap.indexOfKey(requestId);
            if (index >= 0) {
                this.mCaptureCallbackMap.removeAt(index);
            }
            iter.remove();
        }
    }

    private void removeCompletedCallbackHolderLocked(long lastCompletedRegularFrameNumber, long lastCompletedReprocessFrameNumber, long lastCompletedZslStillFrameNumber) {
        Iterator<RequestLastFrameNumbersHolder> iter = this.mRequestLastFrameNumbersList.iterator();
        while (iter.hasNext()) {
            RequestLastFrameNumbersHolder requestLastFrameNumbers = iter.next();
            int requestId = requestLastFrameNumbers.getRequestId();
            if (this.mRemoteDevice == null) {
                Log.w(this.TAG, "Camera closed while removing completed callback holders");
                return;
            }
            long lastRegularFrameNumber = requestLastFrameNumbers.getLastRegularFrameNumber();
            long lastReprocessFrameNumber = requestLastFrameNumbers.getLastReprocessFrameNumber();
            long lastZslStillFrameNumber = requestLastFrameNumbers.getLastZslStillFrameNumber();
            if (lastRegularFrameNumber > lastCompletedRegularFrameNumber || lastReprocessFrameNumber > lastCompletedReprocessFrameNumber || lastZslStillFrameNumber > lastCompletedZslStillFrameNumber) continue;
            if (requestLastFrameNumbers.isSequenceCompleted()) {
                int index = this.mCaptureCallbackMap.indexOfKey(requestId);
                if (index >= 0) {
                    this.mCaptureCallbackMap.removeAt(index);
                }
                iter.remove();
                continue;
            }
            requestLastFrameNumbers.markInflightCompleted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDeviceError(int errorCode, CaptureResultExtras resultExtras) {
        Object object = this.mInterfaceLock;
        synchronized (object) {
            if (this.mRemoteDevice == null) {
                return;
            }
            if (this.mOfflineSessionImpl != null) {
                this.mOfflineSessionImpl.getCallbacks().onDeviceError(errorCode, resultExtras);
                return;
            }
            switch (errorCode) {
                case 0: {
                    long ident = Binder.clearCallingIdentity();
                    try {
                        this.mDeviceExecutor.execute(this.mCallOnDisconnected);
                        break;
                    }
                    finally {
                        Binder.restoreCallingIdentity(ident);
                    }
                }
                case 3: 
                case 4: 
                case 5: {
                    this.onCaptureErrorLocked(errorCode, resultExtras);
                    break;
                }
                case 1: {
                    this.scheduleNotifyError(4);
                    break;
                }
                case 6: {
                    this.scheduleNotifyError(3);
                    break;
                }
                default: {
                    Log.e(this.TAG, "Unknown error from camera device: " + errorCode);
                    this.scheduleNotifyError(5);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleNotifyError(int code) {
        this.mInError = true;
        long ident = Binder.clearCallingIdentity();
        try {
            this.mDeviceExecutor.execute(PooledLambda.obtainRunnable(CameraDeviceImpl::notifyError, this, code).recycleOnUse());
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    private void notifyError(int code) {
        if (!this.isClosed()) {
            this.mDeviceCallback.onError(this, code);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onCaptureErrorLocked(int errorCode, CaptureResultExtras resultExtras) {
        int requestId = resultExtras.getRequestId();
        int subsequenceId = resultExtras.getSubsequenceId();
        final long frameNumber = resultExtras.getFrameNumber();
        String errorPhysicalCameraId = resultExtras.getErrorPhysicalCameraId();
        final CaptureCallbackHolder holder = this.mCaptureCallbackMap.get(requestId);
        if (holder == null) {
            Log.e(this.TAG, String.format("Receive capture error on unknown request ID %d", requestId));
            return;
        }
        final CaptureRequest request = holder.getRequest(subsequenceId);
        Runnable failureDispatch = null;
        if (errorCode == 5) {
            OutputConfiguration config = this.mConfiguredOutputs.get(resultExtras.getErrorStreamId());
            if (config == null) {
                Log.v(this.TAG, String.format("Stream %d has been removed. Skipping buffer lost callback", resultExtras.getErrorStreamId()));
                return;
            }
            for (final Surface surface : config.getSurfaces()) {
                if (!request.containsTarget(surface)) continue;
                failureDispatch = new Runnable(){

                    @Override
                    public void run() {
                        if (!CameraDeviceImpl.this.isClosed()) {
                            holder.getCallback().onCaptureBufferLost(CameraDeviceImpl.this, request, surface, frameNumber);
                        }
                    }
                };
                long ident = Binder.clearCallingIdentity();
                try {
                    holder.getExecutor().execute(failureDispatch);
                }
                finally {
                    Binder.restoreCallingIdentity(ident);
                }
            }
        } else {
            boolean mayHaveBuffers = errorCode == 4;
            int reason = this.mCurrentSession != null && this.mCurrentSession.isAborting() ? 1 : 0;
            final CaptureFailure failure = new CaptureFailure(request, reason, mayHaveBuffers, requestId, frameNumber, errorPhysicalCameraId);
            failureDispatch = new Runnable(){

                @Override
                public void run() {
                    if (!CameraDeviceImpl.this.isClosed()) {
                        holder.getCallback().onCaptureFailed(CameraDeviceImpl.this, request, failure);
                    }
                }
            };
            this.mFrameNumberTracker.updateTracker(frameNumber, true, request.getRequestType());
            this.checkAndFireSequenceComplete();
            long ident = Binder.clearCallingIdentity();
            try {
                holder.getExecutor().execute(failureDispatch);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDeviceIdle() {
        Object object = this.mInterfaceLock;
        synchronized (object) {
            if (this.mRemoteDevice == null) {
                return;
            }
            if (this.mOfflineSessionImpl != null) {
                this.mOfflineSessionImpl.getCallbacks().onDeviceIdle();
                return;
            }
            this.removeCompletedCallbackHolderLocked(Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE);
            if (!this.mIdle) {
                long ident = Binder.clearCallingIdentity();
                try {
                    this.mDeviceExecutor.execute(this.mCallOnIdle);
                }
                finally {
                    Binder.restoreCallingIdentity(ident);
                }
            }
            this.mIdle = true;
        }
    }

    static Executor checkExecutor(Executor executor) {
        return executor == null ? CameraDeviceImpl.checkAndWrapHandler(null) : executor;
    }

    public static <T> Executor checkExecutor(Executor executor, T callback) {
        return callback != null ? CameraDeviceImpl.checkExecutor(executor) : executor;
    }

    public static Executor checkAndWrapHandler(Handler handler) {
        return new CameraHandlerExecutor(CameraDeviceImpl.checkHandler(handler));
    }

    static Handler checkHandler(Handler handler) {
        if (handler == null) {
            Looper looper = Looper.myLooper();
            if (looper == null) {
                throw new IllegalArgumentException("No handler given, and current thread has no looper!");
            }
            handler = new Handler(looper);
        }
        return handler;
    }

    static <T> Handler checkHandler(Handler handler, T callback) {
        if (callback != null) {
            return CameraDeviceImpl.checkHandler(handler);
        }
        return handler;
    }

    private void checkIfCameraClosedOrInError() throws CameraAccessException {
        if (this.mRemoteDevice == null) {
            throw new IllegalStateException("CameraDevice was already closed");
        }
        if (this.mInError) {
            throw new CameraAccessException(3, "The camera device has encountered a serious error");
        }
    }

    private boolean isClosed() {
        return this.mClosing.get();
    }

    private CameraCharacteristics getCharacteristics() {
        return this.mCharacteristics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void binderDied() {
        Log.w(this.TAG, "CameraDevice " + this.mCameraId + " died unexpectedly");
        if (this.mRemoteDevice == null) {
            return;
        }
        this.mInError = true;
        Runnable r = new Runnable(){

            @Override
            public void run() {
                if (!CameraDeviceImpl.this.isClosed()) {
                    CameraDeviceImpl.this.mDeviceCallback.onError(CameraDeviceImpl.this, 5);
                }
            }
        };
        long ident = Binder.clearCallingIdentity();
        try {
            this.mDeviceExecutor.execute(r);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCameraAudioRestriction(int mode) throws CameraAccessException {
        Object object = this.mInterfaceLock;
        synchronized (object) {
            this.checkIfCameraClosedOrInError();
            this.mRemoteDevice.setCameraAudioRestriction(mode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getCameraAudioRestriction() throws CameraAccessException {
        Object object = this.mInterfaceLock;
        synchronized (object) {
            this.checkIfCameraClosedOrInError();
            return this.mRemoteDevice.getGlobalAudioRestriction();
        }
    }

    static /* synthetic */ int[] access$602(CameraDeviceImpl x0, int[] x1) {
        x0.mRepeatingRequestTypes = x1;
        return x1;
    }

    private static class CameraHandlerExecutor
    implements Executor {
        private final Handler mHandler;

        public CameraHandlerExecutor(Handler handler) {
            this.mHandler = Objects.requireNonNull(handler);
        }

        @Override
        public void execute(Runnable command) {
            this.mHandler.post(command);
        }
    }

    public class CameraDeviceCallbacks
    extends ICameraDeviceCallbacks.Stub {
        @Override
        public IBinder asBinder() {
            return this;
        }

        @Override
        public void onDeviceError(int errorCode, CaptureResultExtras resultExtras) {
            CameraDeviceImpl.this.onDeviceError(errorCode, resultExtras);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRepeatingRequestError(long lastFrameNumber, int repeatingRequestId) {
            Object object = CameraDeviceImpl.this.mInterfaceLock;
            synchronized (object) {
                if (CameraDeviceImpl.this.mRemoteDevice == null || CameraDeviceImpl.this.mRepeatingRequestId == -1) {
                    return;
                }
                if (CameraDeviceImpl.this.mOfflineSessionImpl != null) {
                    CameraDeviceImpl.this.mOfflineSessionImpl.getCallbacks().onRepeatingRequestError(lastFrameNumber, repeatingRequestId);
                    return;
                }
                CameraDeviceImpl.this.checkEarlyTriggerSequenceCompleteLocked(CameraDeviceImpl.this.mRepeatingRequestId, lastFrameNumber, CameraDeviceImpl.this.mRepeatingRequestTypes);
                if (CameraDeviceImpl.this.mRepeatingRequestId == repeatingRequestId) {
                    CameraDeviceImpl.this.mRepeatingRequestId = -1;
                    CameraDeviceImpl.access$602(CameraDeviceImpl.this, null);
                }
            }
        }

        @Override
        public void onDeviceIdle() {
            CameraDeviceImpl.this.onDeviceIdle();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCaptureStarted(final CaptureResultExtras resultExtras, final long timestamp) {
            int requestId = resultExtras.getRequestId();
            final long frameNumber = resultExtras.getFrameNumber();
            long lastCompletedRegularFrameNumber = resultExtras.getLastCompletedRegularFrameNumber();
            long lastCompletedReprocessFrameNumber = resultExtras.getLastCompletedReprocessFrameNumber();
            long lastCompletedZslFrameNumber = resultExtras.getLastCompletedZslFrameNumber();
            Object object = CameraDeviceImpl.this.mInterfaceLock;
            synchronized (object) {
                if (CameraDeviceImpl.this.mRemoteDevice == null) {
                    return;
                }
                if (CameraDeviceImpl.this.mOfflineSessionImpl != null) {
                    CameraDeviceImpl.this.mOfflineSessionImpl.getCallbacks().onCaptureStarted(resultExtras, timestamp);
                    return;
                }
                CameraDeviceImpl.this.removeCompletedCallbackHolderLocked(lastCompletedRegularFrameNumber, lastCompletedReprocessFrameNumber, lastCompletedZslFrameNumber);
                final CaptureCallbackHolder holder = (CaptureCallbackHolder)CameraDeviceImpl.this.mCaptureCallbackMap.get(requestId);
                if (holder == null) {
                    return;
                }
                if (CameraDeviceImpl.this.isClosed()) {
                    return;
                }
                long ident = Binder.clearCallingIdentity();
                try {
                    holder.getExecutor().execute(new Runnable(){

                        @Override
                        public void run() {
                            if (!CameraDeviceImpl.this.isClosed()) {
                                int subsequenceId = resultExtras.getSubsequenceId();
                                CaptureRequest request = holder.getRequest(subsequenceId);
                                if (holder.hasBatchedOutputs()) {
                                    Range<Integer> fpsRange = request.get(CaptureRequest.CONTROL_AE_TARGET_FPS_RANGE);
                                    for (int i = 0; i < holder.getRequestCount(); ++i) {
                                        holder.getCallback().onCaptureStarted(CameraDeviceImpl.this, holder.getRequest(i), timestamp - (long)(subsequenceId - i) * 1000000000L / (long)fpsRange.getUpper().intValue(), frameNumber - (long)(subsequenceId - i));
                                    }
                                } else {
                                    holder.getCallback().onCaptureStarted(CameraDeviceImpl.this, holder.getRequest(resultExtras.getSubsequenceId()), timestamp, frameNumber);
                                }
                            }
                        }
                    });
                }
                finally {
                    Binder.restoreCallingIdentity(ident);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onResultReceived(CameraMetadataNative result, final CaptureResultExtras resultExtras, PhysicalCaptureResultInfo[] physicalResults) throws RemoteException {
            int requestId = resultExtras.getRequestId();
            long frameNumber = resultExtras.getFrameNumber();
            Object object = CameraDeviceImpl.this.mInterfaceLock;
            synchronized (object) {
                CaptureResult finalResult;
                if (CameraDeviceImpl.this.mRemoteDevice == null) {
                    return;
                }
                if (CameraDeviceImpl.this.mOfflineSessionImpl != null) {
                    CameraDeviceImpl.this.mOfflineSessionImpl.getCallbacks().onResultReceived(result, resultExtras, physicalResults);
                    return;
                }
                result.set(CameraCharacteristics.LENS_INFO_SHADING_MAP_SIZE, CameraDeviceImpl.this.getCharacteristics().get(CameraCharacteristics.LENS_INFO_SHADING_MAP_SIZE));
                final CaptureCallbackHolder holder = (CaptureCallbackHolder)CameraDeviceImpl.this.mCaptureCallbackMap.get(requestId);
                final CaptureRequest request = holder.getRequest(resultExtras.getSubsequenceId());
                boolean isPartialResult = resultExtras.getPartialResultCount() < CameraDeviceImpl.this.mTotalPartialCount;
                int requestType = request.getRequestType();
                if (holder == null) {
                    CameraDeviceImpl.this.mFrameNumberTracker.updateTracker(frameNumber, null, isPartialResult, requestType);
                    return;
                }
                if (CameraDeviceImpl.this.isClosed()) {
                    CameraDeviceImpl.this.mFrameNumberTracker.updateTracker(frameNumber, null, isPartialResult, requestType);
                    return;
                }
                Runnable resultDispatch = null;
                final CameraMetadataNative resultCopy = holder.hasBatchedOutputs() ? new CameraMetadataNative(result) : null;
                if (isPartialResult) {
                    final CaptureResult resultAsCapture = new CaptureResult(result, request, resultExtras);
                    resultDispatch = new Runnable(){

                        @Override
                        public void run() {
                            if (!CameraDeviceImpl.this.isClosed()) {
                                if (holder.hasBatchedOutputs()) {
                                    for (int i = 0; i < holder.getRequestCount(); ++i) {
                                        CameraMetadataNative resultLocal = new CameraMetadataNative(resultCopy);
                                        CaptureResult resultInBatch = new CaptureResult(resultLocal, holder.getRequest(i), resultExtras);
                                        holder.getCallback().onCaptureProgressed(CameraDeviceImpl.this, holder.getRequest(i), resultInBatch);
                                    }
                                } else {
                                    holder.getCallback().onCaptureProgressed(CameraDeviceImpl.this, request, resultAsCapture);
                                }
                            }
                        }
                    };
                    finalResult = resultAsCapture;
                } else {
                    final List<CaptureResult> partialResults = CameraDeviceImpl.this.mFrameNumberTracker.popPartialResults(frameNumber);
                    final long sensorTimestamp = result.get(CaptureResult.SENSOR_TIMESTAMP);
                    final Range<Integer> fpsRange = request.get(CaptureRequest.CONTROL_AE_TARGET_FPS_RANGE);
                    final int subsequenceId = resultExtras.getSubsequenceId();
                    final TotalCaptureResult resultAsCapture = new TotalCaptureResult(result, request, resultExtras, partialResults, holder.getSessionId(), physicalResults);
                    resultDispatch = new Runnable(){

                        @Override
                        public void run() {
                            if (!CameraDeviceImpl.this.isClosed()) {
                                if (holder.hasBatchedOutputs()) {
                                    for (int i = 0; i < holder.getRequestCount(); ++i) {
                                        resultCopy.set(CaptureResult.SENSOR_TIMESTAMP, Long.valueOf(sensorTimestamp - (long)(subsequenceId - i) * 1000000000L / (long)((Integer)fpsRange.getUpper()).intValue()));
                                        CameraMetadataNative resultLocal = new CameraMetadataNative(resultCopy);
                                        TotalCaptureResult resultInBatch = new TotalCaptureResult(resultLocal, holder.getRequest(i), resultExtras, partialResults, holder.getSessionId(), new PhysicalCaptureResultInfo[0]);
                                        holder.getCallback().onCaptureCompleted(CameraDeviceImpl.this, holder.getRequest(i), resultInBatch);
                                    }
                                } else {
                                    holder.getCallback().onCaptureCompleted(CameraDeviceImpl.this, request, resultAsCapture);
                                }
                            }
                        }
                    };
                    finalResult = resultAsCapture;
                }
                long ident = Binder.clearCallingIdentity();
                try {
                    holder.getExecutor().execute(resultDispatch);
                }
                finally {
                    Binder.restoreCallingIdentity(ident);
                }
                CameraDeviceImpl.this.mFrameNumberTracker.updateTracker(frameNumber, finalResult, isPartialResult, requestType);
                if (!isPartialResult) {
                    CameraDeviceImpl.this.checkAndFireSequenceComplete();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onPrepared(int streamId) {
            StateCallbackKK sessionCallback;
            OutputConfiguration output;
            Object object = CameraDeviceImpl.this.mInterfaceLock;
            synchronized (object) {
                if (CameraDeviceImpl.this.mOfflineSessionImpl != null) {
                    CameraDeviceImpl.this.mOfflineSessionImpl.getCallbacks().onPrepared(streamId);
                    return;
                }
                output = (OutputConfiguration)CameraDeviceImpl.this.mConfiguredOutputs.get(streamId);
                sessionCallback = CameraDeviceImpl.this.mSessionStateCallback;
            }
            if (sessionCallback == null) {
                return;
            }
            if (output == null) {
                Log.w(CameraDeviceImpl.this.TAG, "onPrepared invoked for unknown output Surface");
                return;
            }
            List<Surface> surfaces = output.getSurfaces();
            for (Surface surface : surfaces) {
                sessionCallback.onSurfacePrepared(surface);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRequestQueueEmpty() {
            StateCallbackKK sessionCallback;
            Object object = CameraDeviceImpl.this.mInterfaceLock;
            synchronized (object) {
                if (CameraDeviceImpl.this.mOfflineSessionImpl != null) {
                    CameraDeviceImpl.this.mOfflineSessionImpl.getCallbacks().onRequestQueueEmpty();
                    return;
                }
                sessionCallback = CameraDeviceImpl.this.mSessionStateCallback;
            }
            if (sessionCallback == null) {
                return;
            }
            sessionCallback.onRequestQueueEmpty();
        }
    }

    public static abstract class StateCallbackKK
    extends CameraDevice.StateCallback {
        public void onUnconfigured(CameraDevice camera) {
        }

        public void onActive(CameraDevice camera) {
        }

        public void onBusy(CameraDevice camera) {
        }

        public void onIdle(CameraDevice camera) {
        }

        public void onRequestQueueEmpty() {
        }

        public void onSurfacePrepared(Surface surface) {
        }
    }
}

