/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.legacy;

import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.ICameraDeviceCallbacks;
import android.hardware.camera2.impl.CameraMetadataNative;
import android.hardware.camera2.impl.CaptureResultExtras;
import android.hardware.camera2.impl.PhysicalCaptureResultInfo;
import android.hardware.camera2.legacy.CameraDeviceState;
import android.hardware.camera2.legacy.LegacyExceptionUtils;
import android.hardware.camera2.legacy.RequestHolder;
import android.hardware.camera2.legacy.RequestThreadManager;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.hardware.camera2.utils.ArrayUtils;
import android.hardware.camera2.utils.SubmitInfo;
import android.os.ConditionVariable;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.RemoteException;
import android.os.ServiceSpecificException;
import android.util.Log;
import android.util.Pair;
import android.util.Size;
import android.util.SparseArray;
import android.view.Surface;
import com.android.internal.util.Preconditions;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class LegacyCameraDevice
implements AutoCloseable {
    private final String TAG;
    private static final boolean DEBUG = false;
    private final int mCameraId;
    private final CameraCharacteristics mStaticCharacteristics;
    private final ICameraDeviceCallbacks mDeviceCallbacks;
    private final CameraDeviceState mDeviceState = new CameraDeviceState();
    private SparseArray<Surface> mConfiguredSurfaces;
    private boolean mClosed = false;
    private final ConditionVariable mIdle = new ConditionVariable(true);
    private final HandlerThread mResultThread = new HandlerThread("ResultThread");
    private final HandlerThread mCallbackHandlerThread = new HandlerThread("CallbackThread");
    private final Handler mCallbackHandler;
    private final Handler mResultHandler;
    private static final int ILLEGAL_VALUE = -1;
    private static final int GRALLOC_USAGE_RENDERSCRIPT = 0x100000;
    private static final int GRALLOC_USAGE_SW_READ_OFTEN = 3;
    private static final int GRALLOC_USAGE_HW_TEXTURE = 256;
    private static final int GRALLOC_USAGE_HW_COMPOSER = 2048;
    private static final int GRALLOC_USAGE_HW_RENDER = 512;
    private static final int GRALLOC_USAGE_HW_VIDEO_ENCODER = 65536;
    public static final int MAX_DIMEN_FOR_ROUNDING = 1920;
    public static final int NATIVE_WINDOW_SCALING_MODE_SCALE_TO_WINDOW = 1;
    private final CameraDeviceState.CameraDeviceStateListener mStateListener = new CameraDeviceState.CameraDeviceStateListener(){

        @Override
        public void onError(final int errorCode, Object errorArg, final RequestHolder holder) {
            switch (errorCode) {
                case 0: 
                case 1: 
                case 2: {
                    LegacyCameraDevice.this.mIdle.open();
                }
            }
            final CaptureResultExtras extras = LegacyCameraDevice.this.getExtrasFromRequest(holder, errorCode, errorArg);
            LegacyCameraDevice.this.mResultHandler.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        LegacyCameraDevice.this.mDeviceCallbacks.onDeviceError(errorCode, extras);
                    }
                    catch (RemoteException e) {
                        throw new IllegalStateException("Received remote exception during onCameraError callback: ", e);
                    }
                }
            });
        }

        @Override
        public void onConfiguring() {
        }

        @Override
        public void onIdle() {
            LegacyCameraDevice.this.mIdle.open();
            LegacyCameraDevice.this.mResultHandler.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        LegacyCameraDevice.this.mDeviceCallbacks.onDeviceIdle();
                    }
                    catch (RemoteException e) {
                        throw new IllegalStateException("Received remote exception during onCameraIdle callback: ", e);
                    }
                }
            });
        }

        @Override
        public void onBusy() {
            LegacyCameraDevice.this.mIdle.close();
        }

        @Override
        public void onCaptureStarted(final RequestHolder holder, final long timestamp) {
            final CaptureResultExtras extras = LegacyCameraDevice.this.getExtrasFromRequest(holder);
            LegacyCameraDevice.this.mResultHandler.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        LegacyCameraDevice.this.mDeviceCallbacks.onCaptureStarted(extras, timestamp);
                    }
                    catch (RemoteException e) {
                        throw new IllegalStateException("Received remote exception during onCameraError callback: ", e);
                    }
                }
            });
        }

        @Override
        public void onRequestQueueEmpty() {
            LegacyCameraDevice.this.mResultHandler.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        LegacyCameraDevice.this.mDeviceCallbacks.onRequestQueueEmpty();
                    }
                    catch (RemoteException e) {
                        throw new IllegalStateException("Received remote exception during onRequestQueueEmpty callback: ", e);
                    }
                }
            });
        }

        @Override
        public void onCaptureResult(final CameraMetadataNative result, final RequestHolder holder) {
            final CaptureResultExtras extras = LegacyCameraDevice.this.getExtrasFromRequest(holder);
            LegacyCameraDevice.this.mResultHandler.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        LegacyCameraDevice.this.mDeviceCallbacks.onResultReceived(result, extras, new PhysicalCaptureResultInfo[0]);
                    }
                    catch (RemoteException e) {
                        throw new IllegalStateException("Received remote exception during onCameraError callback: ", e);
                    }
                }
            });
        }

        @Override
        public void onRepeatingRequestError(final long lastFrameNumber, final int repeatingRequestId) {
            LegacyCameraDevice.this.mResultHandler.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        LegacyCameraDevice.this.mDeviceCallbacks.onRepeatingRequestError(lastFrameNumber, repeatingRequestId);
                    }
                    catch (RemoteException e) {
                        throw new IllegalStateException("Received remote exception during onRepeatingRequestError callback: ", e);
                    }
                }
            });
        }
    };
    private final RequestThreadManager mRequestThreadManager;

    private CaptureResultExtras getExtrasFromRequest(RequestHolder holder) {
        return this.getExtrasFromRequest(holder, -1, null);
    }

    private CaptureResultExtras getExtrasFromRequest(RequestHolder holder, int errorCode, Object errorArg) {
        int errorStreamId = -1;
        if (errorCode == 5) {
            Surface errorTarget = (Surface)errorArg;
            int indexOfTarget = this.mConfiguredSurfaces.indexOfValue(errorTarget);
            if (indexOfTarget < 0) {
                Log.e(this.TAG, "Buffer drop error reported for unknown Surface");
            } else {
                errorStreamId = this.mConfiguredSurfaces.keyAt(indexOfTarget);
            }
        }
        if (holder == null) {
            return new CaptureResultExtras(-1, -1, -1, -1, -1L, -1, -1, null, -1L, -1L, -1L);
        }
        return new CaptureResultExtras(holder.getRequestId(), holder.getSubsequeceId(), 0, 0, holder.getFrameNumber(), 1, errorStreamId, null, holder.getFrameNumber(), -1L, -1L);
    }

    static boolean needsConversion(Surface s) throws LegacyExceptionUtils.BufferQueueAbandonedException {
        int nativeType = LegacyCameraDevice.detectSurfaceType(s);
        return nativeType == 35 || nativeType == 842094169 || nativeType == 17;
    }

    public LegacyCameraDevice(int cameraId, Camera camera, CameraCharacteristics characteristics, ICameraDeviceCallbacks callbacks) {
        this.mCameraId = cameraId;
        this.mDeviceCallbacks = callbacks;
        this.TAG = String.format("CameraDevice-%d-LE", this.mCameraId);
        this.mResultThread.start();
        this.mResultHandler = new Handler(this.mResultThread.getLooper());
        this.mCallbackHandlerThread.start();
        this.mCallbackHandler = new Handler(this.mCallbackHandlerThread.getLooper());
        this.mDeviceState.setCameraDeviceCallbacks(this.mCallbackHandler, this.mStateListener);
        this.mStaticCharacteristics = characteristics;
        this.mRequestThreadManager = new RequestThreadManager(cameraId, camera, characteristics, this.mDeviceState);
        this.mRequestThreadManager.start();
    }

    public int configureOutputs(SparseArray<Surface> outputs) {
        return this.configureOutputs(outputs, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int configureOutputs(SparseArray<Surface> outputs, boolean validateSurfacesOnly) {
        ArrayList<Pair<Surface, Size>> sizedSurfaces = new ArrayList<Pair<Surface, Size>>();
        if (outputs != null) {
            int count = outputs.size();
            for (int i = 0; i < count; ++i) {
                Surface output = outputs.valueAt(i);
                if (output == null) {
                    Log.e(this.TAG, "configureOutputs - null outputs are not allowed");
                    return LegacyExceptionUtils.BAD_VALUE;
                }
                if (!output.isValid()) {
                    Log.e(this.TAG, "configureOutputs - invalid output surfaces are not allowed");
                    return LegacyExceptionUtils.BAD_VALUE;
                }
                StreamConfigurationMap streamConfigurations = this.mStaticCharacteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
                try {
                    Size s;
                    block15: {
                        s = LegacyCameraDevice.getSurfaceSize(output);
                        int surfaceType = LegacyCameraDevice.detectSurfaceType(output);
                        boolean flexibleConsumer = LegacyCameraDevice.isFlexibleConsumer(output);
                        Object[] sizes = streamConfigurations.getOutputSizes(surfaceType);
                        if (sizes == null) {
                            if (surfaceType == 34) {
                                sizes = streamConfigurations.getOutputSizes(35);
                            } else if (surfaceType == 33) {
                                sizes = streamConfigurations.getOutputSizes(256);
                            }
                        }
                        if (!ArrayUtils.contains(sizes, s)) {
                            if (flexibleConsumer && (s = LegacyCameraDevice.findClosestSize(s, (Size[])sizes)) != null) {
                                sizedSurfaces.add(new Pair<Surface, Size>(output, s));
                                break block15;
                            } else {
                                String reason = sizes == null ? "format is invalid." : "size not in valid set: " + Arrays.toString(sizes);
                                Log.e(this.TAG, String.format("Surface with size (w=%d, h=%d) and format 0x%x is not valid, %s", s.getWidth(), s.getHeight(), surfaceType, reason));
                                return LegacyExceptionUtils.BAD_VALUE;
                            }
                        }
                        sizedSurfaces.add(new Pair<Surface, Size>(output, s));
                    }
                    if (validateSurfacesOnly) continue;
                    LegacyCameraDevice.setSurfaceDimens(output, s.getWidth(), s.getHeight());
                    continue;
                }
                catch (LegacyExceptionUtils.BufferQueueAbandonedException e) {
                    Log.e(this.TAG, "Surface bufferqueue is abandoned, cannot configure as output: ", e);
                    return LegacyExceptionUtils.BAD_VALUE;
                }
            }
        }
        if (validateSurfacesOnly) {
            return 0;
        }
        boolean success = false;
        if (this.mDeviceState.setConfiguring()) {
            this.mRequestThreadManager.configure(sizedSurfaces);
            success = this.mDeviceState.setIdle();
        }
        if (!success) return LegacyExceptionUtils.INVALID_OPERATION;
        this.mConfiguredSurfaces = outputs;
        return 0;
    }

    public SubmitInfo submitRequestList(CaptureRequest[] requestList, boolean repeating) {
        ArrayList<Long> surfaceIds;
        if (requestList == null || requestList.length == 0) {
            Log.e(this.TAG, "submitRequestList - Empty/null requests are not allowed");
            throw new ServiceSpecificException(LegacyExceptionUtils.BAD_VALUE, "submitRequestList - Empty/null requests are not allowed");
        }
        try {
            surfaceIds = this.mConfiguredSurfaces == null ? new ArrayList() : LegacyCameraDevice.getSurfaceIds(this.mConfiguredSurfaces);
        }
        catch (LegacyExceptionUtils.BufferQueueAbandonedException e) {
            throw new ServiceSpecificException(LegacyExceptionUtils.BAD_VALUE, "submitRequestList - configured surface is abandoned.");
        }
        for (CaptureRequest request : requestList) {
            if (request.getTargets().isEmpty()) {
                Log.e(this.TAG, "submitRequestList - Each request must have at least one Surface target");
                throw new ServiceSpecificException(LegacyExceptionUtils.BAD_VALUE, "submitRequestList - Each request must have at least one Surface target");
            }
            for (Surface surface : request.getTargets()) {
                if (surface == null) {
                    Log.e(this.TAG, "submitRequestList - Null Surface targets are not allowed");
                    throw new ServiceSpecificException(LegacyExceptionUtils.BAD_VALUE, "submitRequestList - Null Surface targets are not allowed");
                }
                if (this.mConfiguredSurfaces == null) {
                    Log.e(this.TAG, "submitRequestList - must configure  device with valid surfaces before submitting requests");
                    throw new ServiceSpecificException(LegacyExceptionUtils.INVALID_OPERATION, "submitRequestList - must configure  device with valid surfaces before submitting requests");
                }
                if (LegacyCameraDevice.containsSurfaceId(surface, surfaceIds)) continue;
                Log.e(this.TAG, "submitRequestList - cannot use a surface that wasn't configured");
                throw new ServiceSpecificException(LegacyExceptionUtils.BAD_VALUE, "submitRequestList - cannot use a surface that wasn't configured");
            }
        }
        this.mIdle.close();
        return this.mRequestThreadManager.submitCaptureRequests(requestList, repeating);
    }

    public SubmitInfo submitRequest(CaptureRequest request, boolean repeating) {
        CaptureRequest[] requestList = new CaptureRequest[]{request};
        return this.submitRequestList(requestList, repeating);
    }

    public long cancelRequest(int requestId) {
        return this.mRequestThreadManager.cancelRepeating(requestId);
    }

    public void waitUntilIdle() {
        this.mIdle.block();
    }

    public long flush() {
        long lastFrame = this.mRequestThreadManager.flush();
        this.waitUntilIdle();
        return lastFrame;
    }

    public void setAudioRestriction(int mode) {
        this.mRequestThreadManager.setAudioRestriction(mode);
    }

    public int getAudioRestriction() {
        return this.mRequestThreadManager.getAudioRestriction();
    }

    public boolean isClosed() {
        return this.mClosed;
    }

    @Override
    public void close() {
        this.mRequestThreadManager.quit();
        this.mCallbackHandlerThread.quitSafely();
        this.mResultThread.quitSafely();
        try {
            this.mCallbackHandlerThread.join();
        }
        catch (InterruptedException e) {
            Log.e(this.TAG, String.format("Thread %s (%d) interrupted while quitting.", this.mCallbackHandlerThread.getName(), this.mCallbackHandlerThread.getId()));
        }
        try {
            this.mResultThread.join();
        }
        catch (InterruptedException e) {
            Log.e(this.TAG, String.format("Thread %s (%d) interrupted while quitting.", this.mResultThread.getName(), this.mResultThread.getId()));
        }
        this.mClosed = true;
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        catch (ServiceSpecificException e) {
            Log.e(this.TAG, "Got error while trying to finalize, ignoring: " + e.getMessage());
        }
        finally {
            super.finalize();
        }
    }

    static long findEuclidDistSquare(Size a, Size b) {
        long d0 = a.getWidth() - b.getWidth();
        long d1 = a.getHeight() - b.getHeight();
        return d0 * d0 + d1 * d1;
    }

    static Size findClosestSize(Size size, Size[] supportedSizes) {
        if (size == null || supportedSizes == null) {
            return null;
        }
        Size bestSize = null;
        for (Size s : supportedSizes) {
            if (s.equals(size)) {
                return size;
            }
            if (s.getWidth() > 1920 || bestSize != null && LegacyCameraDevice.findEuclidDistSquare(size, s) >= LegacyCameraDevice.findEuclidDistSquare(bestSize, s)) continue;
            bestSize = s;
        }
        return bestSize;
    }

    public static Size getSurfaceSize(Surface surface) throws LegacyExceptionUtils.BufferQueueAbandonedException {
        Preconditions.checkNotNull(surface);
        int[] dimens = new int[2];
        LegacyExceptionUtils.throwOnError(LegacyCameraDevice.nativeDetectSurfaceDimens(surface, dimens));
        return new Size(dimens[0], dimens[1]);
    }

    public static boolean isFlexibleConsumer(Surface output) {
        int usageFlags = LegacyCameraDevice.detectSurfaceUsageFlags(output);
        int disallowedFlags = 0x110000;
        int allowedFlags = 2307;
        boolean flexibleConsumer = (usageFlags & disallowedFlags) == 0 && (usageFlags & allowedFlags) != 0;
        return flexibleConsumer;
    }

    public static boolean isPreviewConsumer(Surface output) {
        int usageFlags = LegacyCameraDevice.detectSurfaceUsageFlags(output);
        int disallowedFlags = 0x110003;
        int allowedFlags = 2816;
        boolean previewConsumer = (usageFlags & disallowedFlags) == 0 && (usageFlags & allowedFlags) != 0;
        int surfaceFormat = 0;
        try {
            surfaceFormat = LegacyCameraDevice.detectSurfaceType(output);
        }
        catch (LegacyExceptionUtils.BufferQueueAbandonedException e) {
            throw new IllegalArgumentException("Surface was abandoned", e);
        }
        return previewConsumer;
    }

    public static boolean isVideoEncoderConsumer(Surface output) {
        int usageFlags = LegacyCameraDevice.detectSurfaceUsageFlags(output);
        int disallowedFlags = 1050883;
        int allowedFlags = 65536;
        boolean videoEncoderConsumer = (usageFlags & disallowedFlags) == 0 && (usageFlags & allowedFlags) != 0;
        int surfaceFormat = 0;
        try {
            surfaceFormat = LegacyCameraDevice.detectSurfaceType(output);
        }
        catch (LegacyExceptionUtils.BufferQueueAbandonedException e) {
            throw new IllegalArgumentException("Surface was abandoned", e);
        }
        return videoEncoderConsumer;
    }

    static int detectSurfaceUsageFlags(Surface surface) {
        Preconditions.checkNotNull(surface);
        return LegacyCameraDevice.nativeDetectSurfaceUsageFlags(surface);
    }

    public static int detectSurfaceType(Surface surface) throws LegacyExceptionUtils.BufferQueueAbandonedException {
        Preconditions.checkNotNull(surface);
        int surfaceType = LegacyCameraDevice.nativeDetectSurfaceType(surface);
        if (surfaceType >= 1 && surfaceType <= 5) {
            surfaceType = 34;
        }
        return LegacyExceptionUtils.throwOnError(surfaceType);
    }

    public static int detectSurfaceDataspace(Surface surface) throws LegacyExceptionUtils.BufferQueueAbandonedException {
        Preconditions.checkNotNull(surface);
        return LegacyExceptionUtils.throwOnError(LegacyCameraDevice.nativeDetectSurfaceDataspace(surface));
    }

    static void connectSurface(Surface surface) throws LegacyExceptionUtils.BufferQueueAbandonedException {
        Preconditions.checkNotNull(surface);
        LegacyExceptionUtils.throwOnError(LegacyCameraDevice.nativeConnectSurface(surface));
    }

    static void disconnectSurface(Surface surface) throws LegacyExceptionUtils.BufferQueueAbandonedException {
        if (surface == null) {
            return;
        }
        LegacyExceptionUtils.throwOnError(LegacyCameraDevice.nativeDisconnectSurface(surface));
    }

    static void produceFrame(Surface surface, byte[] pixelBuffer, int width, int height, int pixelFormat) throws LegacyExceptionUtils.BufferQueueAbandonedException {
        Preconditions.checkNotNull(surface);
        Preconditions.checkNotNull(pixelBuffer);
        Preconditions.checkArgumentPositive(width, "width must be positive.");
        Preconditions.checkArgumentPositive(height, "height must be positive.");
        LegacyExceptionUtils.throwOnError(LegacyCameraDevice.nativeProduceFrame(surface, pixelBuffer, width, height, pixelFormat));
    }

    static void setSurfaceFormat(Surface surface, int pixelFormat) throws LegacyExceptionUtils.BufferQueueAbandonedException {
        Preconditions.checkNotNull(surface);
        LegacyExceptionUtils.throwOnError(LegacyCameraDevice.nativeSetSurfaceFormat(surface, pixelFormat));
    }

    static void setSurfaceDimens(Surface surface, int width, int height) throws LegacyExceptionUtils.BufferQueueAbandonedException {
        Preconditions.checkNotNull(surface);
        Preconditions.checkArgumentPositive(width, "width must be positive.");
        Preconditions.checkArgumentPositive(height, "height must be positive.");
        LegacyExceptionUtils.throwOnError(LegacyCameraDevice.nativeSetSurfaceDimens(surface, width, height));
    }

    public static long getSurfaceId(Surface surface) throws LegacyExceptionUtils.BufferQueueAbandonedException {
        Preconditions.checkNotNull(surface);
        try {
            return LegacyCameraDevice.nativeGetSurfaceId(surface);
        }
        catch (IllegalArgumentException e) {
            throw new LegacyExceptionUtils.BufferQueueAbandonedException();
        }
    }

    static List<Long> getSurfaceIds(SparseArray<Surface> surfaces) throws LegacyExceptionUtils.BufferQueueAbandonedException {
        if (surfaces == null) {
            throw new NullPointerException("Null argument surfaces");
        }
        ArrayList<Long> surfaceIds = new ArrayList<Long>();
        int count = surfaces.size();
        for (int i = 0; i < count; ++i) {
            long id2 = LegacyCameraDevice.getSurfaceId(surfaces.valueAt(i));
            if (id2 == 0L) {
                throw new IllegalStateException("Configured surface had null native GraphicBufferProducer pointer!");
            }
            surfaceIds.add(id2);
        }
        return surfaceIds;
    }

    static List<Long> getSurfaceIds(Collection<Surface> surfaces) throws LegacyExceptionUtils.BufferQueueAbandonedException {
        if (surfaces == null) {
            throw new NullPointerException("Null argument surfaces");
        }
        ArrayList<Long> surfaceIds = new ArrayList<Long>();
        for (Surface s : surfaces) {
            long id2 = LegacyCameraDevice.getSurfaceId(s);
            if (id2 == 0L) {
                throw new IllegalStateException("Configured surface had null native GraphicBufferProducer pointer!");
            }
            surfaceIds.add(id2);
        }
        return surfaceIds;
    }

    static boolean containsSurfaceId(Surface s, Collection<Long> ids) {
        long id2 = 0L;
        try {
            id2 = LegacyCameraDevice.getSurfaceId(s);
        }
        catch (LegacyExceptionUtils.BufferQueueAbandonedException e) {
            return false;
        }
        return ids.contains(id2);
    }

    static void setSurfaceOrientation(Surface surface, int facing, int sensorOrientation) throws LegacyExceptionUtils.BufferQueueAbandonedException {
        Preconditions.checkNotNull(surface);
        LegacyExceptionUtils.throwOnError(LegacyCameraDevice.nativeSetSurfaceOrientation(surface, facing, sensorOrientation));
    }

    static Size getTextureSize(SurfaceTexture surfaceTexture) throws LegacyExceptionUtils.BufferQueueAbandonedException {
        Preconditions.checkNotNull(surfaceTexture);
        int[] dimens = new int[2];
        LegacyExceptionUtils.throwOnError(LegacyCameraDevice.nativeDetectTextureDimens(surfaceTexture, dimens));
        return new Size(dimens[0], dimens[1]);
    }

    static void setNextTimestamp(Surface surface, long timestamp) throws LegacyExceptionUtils.BufferQueueAbandonedException {
        Preconditions.checkNotNull(surface);
        LegacyExceptionUtils.throwOnError(LegacyCameraDevice.nativeSetNextTimestamp(surface, timestamp));
    }

    static void setScalingMode(Surface surface, int mode) throws LegacyExceptionUtils.BufferQueueAbandonedException {
        Preconditions.checkNotNull(surface);
        LegacyExceptionUtils.throwOnError(LegacyCameraDevice.nativeSetScalingMode(surface, mode));
    }

    private static int nativeDetectSurfaceType(Surface surface) {
        return OverrideMethod.invokeI("android.hardware.camera2.legacy.LegacyCameraDevice#nativeDetectSurfaceType(Landroid/view/Surface;)I", true, null);
    }

    private static int nativeDetectSurfaceDataspace(Surface surface) {
        return OverrideMethod.invokeI("android.hardware.camera2.legacy.LegacyCameraDevice#nativeDetectSurfaceDataspace(Landroid/view/Surface;)I", true, null);
    }

    private static int nativeDetectSurfaceDimens(Surface surface, int[] nArray) {
        return OverrideMethod.invokeI("android.hardware.camera2.legacy.LegacyCameraDevice#nativeDetectSurfaceDimens(Landroid/view/Surface;[I)I", true, null);
    }

    private static int nativeConnectSurface(Surface surface) {
        return OverrideMethod.invokeI("android.hardware.camera2.legacy.LegacyCameraDevice#nativeConnectSurface(Landroid/view/Surface;)I", true, null);
    }

    private static int nativeProduceFrame(Surface surface, byte[] byArray, int n, int n2, int n3) {
        return OverrideMethod.invokeI("android.hardware.camera2.legacy.LegacyCameraDevice#nativeProduceFrame(Landroid/view/Surface;[BIII)I", true, null);
    }

    private static int nativeSetSurfaceFormat(Surface surface, int n) {
        return OverrideMethod.invokeI("android.hardware.camera2.legacy.LegacyCameraDevice#nativeSetSurfaceFormat(Landroid/view/Surface;I)I", true, null);
    }

    private static int nativeSetSurfaceDimens(Surface surface, int n, int n2) {
        return OverrideMethod.invokeI("android.hardware.camera2.legacy.LegacyCameraDevice#nativeSetSurfaceDimens(Landroid/view/Surface;II)I", true, null);
    }

    private static long nativeGetSurfaceId(Surface surface) {
        return OverrideMethod.invokeL("android.hardware.camera2.legacy.LegacyCameraDevice#nativeGetSurfaceId(Landroid/view/Surface;)J", true, null);
    }

    private static int nativeSetSurfaceOrientation(Surface surface, int n, int n2) {
        return OverrideMethod.invokeI("android.hardware.camera2.legacy.LegacyCameraDevice#nativeSetSurfaceOrientation(Landroid/view/Surface;II)I", true, null);
    }

    private static int nativeDetectTextureDimens(SurfaceTexture surfaceTexture, int[] nArray) {
        return OverrideMethod.invokeI("android.hardware.camera2.legacy.LegacyCameraDevice#nativeDetectTextureDimens(Landroid/graphics/SurfaceTexture;[I)I", true, null);
    }

    private static int nativeSetNextTimestamp(Surface surface, long l) {
        return OverrideMethod.invokeI("android.hardware.camera2.legacy.LegacyCameraDevice#nativeSetNextTimestamp(Landroid/view/Surface;J)I", true, null);
    }

    private static int nativeDetectSurfaceUsageFlags(Surface surface) {
        return OverrideMethod.invokeI("android.hardware.camera2.legacy.LegacyCameraDevice#nativeDetectSurfaceUsageFlags(Landroid/view/Surface;)I", true, null);
    }

    private static int nativeSetScalingMode(Surface surface, int n) {
        return OverrideMethod.invokeI("android.hardware.camera2.legacy.LegacyCameraDevice#nativeSetScalingMode(Landroid/view/Surface;I)I", true, null);
    }

    private static int nativeDisconnectSurface(Surface surface) {
        return OverrideMethod.invokeI("android.hardware.camera2.legacy.LegacyCameraDevice#nativeDisconnectSurface(Landroid/view/Surface;)I", true, null);
    }

    static int nativeGetJpegFooterSize() {
        return OverrideMethod.invokeI("android.hardware.camera2.legacy.LegacyCameraDevice#nativeGetJpegFooterSize()I", true, null);
    }
}

