/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.utils;

import android.os.Parcel;
import android.os.Parcelable;
import java.util.HashSet;
import java.util.Set;

public class ConcurrentCameraIdCombination
implements Parcelable {
    private Set<String> mConcurrentCameraIds = new HashSet<String>();
    public static final Parcelable.Creator<ConcurrentCameraIdCombination> CREATOR = new Parcelable.Creator<ConcurrentCameraIdCombination>(){

        @Override
        public ConcurrentCameraIdCombination createFromParcel(Parcel in) {
            return new ConcurrentCameraIdCombination(in);
        }

        public ConcurrentCameraIdCombination[] newArray(int size) {
            return new ConcurrentCameraIdCombination[size];
        }
    };

    private ConcurrentCameraIdCombination(Parcel in) {
        this.readFromParcel(in);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mConcurrentCameraIds.size());
        for (String cameraId : this.mConcurrentCameraIds) {
            dest.writeString(cameraId);
        }
    }

    public void readFromParcel(Parcel in) {
        this.mConcurrentCameraIds.clear();
        int cameraCombinationSize = in.readInt();
        if (cameraCombinationSize < 0) {
            throw new RuntimeException("cameraCombinationSize " + cameraCombinationSize + " should not be negative");
        }
        for (int i = 0; i < cameraCombinationSize; ++i) {
            String cameraId = in.readString();
            if (cameraId == null) {
                throw new RuntimeException("Failed to read camera id from Parcel");
            }
            this.mConcurrentCameraIds.add(cameraId);
        }
    }

    public Set<String> getConcurrentCameraIdCombination() {
        return this.mConcurrentCameraIds;
    }
}

