/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.radio;

import android.annotation.SystemApi;
import android.hardware.radio.ProgramSelector;
import android.hardware.radio.RadioManager;
import android.hardware.radio.Utils;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;

@SystemApi
public class ProgramList
implements AutoCloseable {
    private final Object mLock = new Object();
    private final Map<ProgramSelector.Identifier, RadioManager.ProgramInfo> mPrograms = new HashMap<ProgramSelector.Identifier, RadioManager.ProgramInfo>();
    private final List<ListCallback> mListCallbacks = new ArrayList<ListCallback>();
    private final List<OnCompleteListener> mOnCompleteListeners = new ArrayList<OnCompleteListener>();
    private OnCloseListener mOnCloseListener;
    private boolean mIsClosed = false;
    private boolean mIsComplete = false;

    ProgramList() {
    }

    public void registerListCallback(final Executor executor, final ListCallback callback) {
        this.registerListCallback(new ListCallback(){

            @Override
            public void onItemChanged(ProgramSelector.Identifier id2) {
                executor.execute(() -> callback.onItemChanged(id2));
            }

            @Override
            public void onItemRemoved(ProgramSelector.Identifier id2) {
                executor.execute(() -> callback.onItemRemoved(id2));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerListCallback(ListCallback callback) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mIsClosed) {
                return;
            }
            this.mListCallbacks.add(Objects.requireNonNull(callback));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterListCallback(ListCallback callback) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mIsClosed) {
                return;
            }
            this.mListCallbacks.remove(Objects.requireNonNull(callback));
        }
    }

    public void addOnCompleteListener(Executor executor, OnCompleteListener listener) {
        this.addOnCompleteListener(() -> executor.execute(listener::onComplete));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOnCompleteListener(OnCompleteListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mIsClosed) {
                return;
            }
            this.mOnCompleteListeners.add(Objects.requireNonNull(listener));
            if (this.mIsComplete) {
                listener.onComplete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOnCompleteListener(OnCompleteListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mIsClosed) {
                return;
            }
            this.mOnCompleteListeners.remove(Objects.requireNonNull(listener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setOnCloseListener(OnCloseListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mOnCloseListener != null) {
                throw new IllegalStateException("Close callback is already set");
            }
            this.mOnCloseListener = listener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mIsClosed) {
                return;
            }
            this.mIsClosed = true;
            this.mPrograms.clear();
            this.mListCallbacks.clear();
            this.mOnCompleteListeners.clear();
            if (this.mOnCloseListener != null) {
                this.mOnCloseListener.onClose();
                this.mOnCloseListener = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void apply(Chunk chunk) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mIsClosed) {
                return;
            }
            this.mIsComplete = false;
            if (chunk.isPurge()) {
                new HashSet<ProgramSelector.Identifier>(this.mPrograms.keySet()).stream().forEach(id2 -> this.removeLocked((ProgramSelector.Identifier)id2));
            }
            chunk.getRemoved().stream().forEach(id2 -> this.removeLocked((ProgramSelector.Identifier)id2));
            chunk.getModified().stream().forEach(info -> this.putLocked((RadioManager.ProgramInfo)info));
            if (chunk.isComplete()) {
                this.mIsComplete = true;
                this.mOnCompleteListeners.forEach(cb -> cb.onComplete());
            }
        }
    }

    private void putLocked(RadioManager.ProgramInfo value) {
        ProgramSelector.Identifier key = value.getSelector().getPrimaryId();
        this.mPrograms.put(Objects.requireNonNull(key), value);
        ProgramSelector.Identifier sel = value.getSelector().getPrimaryId();
        this.mListCallbacks.forEach(cb -> cb.onItemChanged(sel));
    }

    private void removeLocked(ProgramSelector.Identifier key) {
        RadioManager.ProgramInfo removed = this.mPrograms.remove(Objects.requireNonNull(key));
        if (removed == null) {
            return;
        }
        ProgramSelector.Identifier sel = removed.getSelector().getPrimaryId();
        this.mListCallbacks.forEach(cb -> cb.onItemRemoved(sel));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RadioManager.ProgramInfo> toList() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mPrograms.values().stream().collect(Collectors.toList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RadioManager.ProgramInfo get(ProgramSelector.Identifier id2) {
        Object object = this.mLock;
        synchronized (object) {
            return this.mPrograms.get(Objects.requireNonNull(id2));
        }
    }

    public static class Chunk
    implements Parcelable {
        private final boolean mPurge;
        private final boolean mComplete;
        private final Set<RadioManager.ProgramInfo> mModified;
        private final Set<ProgramSelector.Identifier> mRemoved;
        public static final Parcelable.Creator<Chunk> CREATOR = new Parcelable.Creator<Chunk>(){

            @Override
            public Chunk createFromParcel(Parcel in) {
                return new Chunk(in);
            }

            public Chunk[] newArray(int size) {
                return new Chunk[size];
            }
        };

        public Chunk(boolean purge, boolean complete, Set<RadioManager.ProgramInfo> modified, Set<ProgramSelector.Identifier> removed) {
            this.mPurge = purge;
            this.mComplete = complete;
            this.mModified = modified != null ? modified : Collections.emptySet();
            this.mRemoved = removed != null ? removed : Collections.emptySet();
        }

        private Chunk(Parcel in) {
            this.mPurge = in.readByte() != 0;
            this.mComplete = in.readByte() != 0;
            this.mModified = Utils.createSet(in, RadioManager.ProgramInfo.CREATOR);
            this.mRemoved = Utils.createSet(in, ProgramSelector.Identifier.CREATOR);
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeByte((byte)(this.mPurge ? 1 : 0));
            dest.writeByte((byte)(this.mComplete ? 1 : 0));
            Utils.writeSet(dest, this.mModified);
            Utils.writeSet(dest, this.mRemoved);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        public boolean isPurge() {
            return this.mPurge;
        }

        public boolean isComplete() {
            return this.mComplete;
        }

        public Set<RadioManager.ProgramInfo> getModified() {
            return this.mModified;
        }

        public Set<ProgramSelector.Identifier> getRemoved() {
            return this.mRemoved;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Chunk)) {
                return false;
            }
            Chunk other = (Chunk)obj;
            if (this.mPurge != other.mPurge) {
                return false;
            }
            if (this.mComplete != other.mComplete) {
                return false;
            }
            if (!Objects.equals(this.mModified, other.mModified)) {
                return false;
            }
            return Objects.equals(this.mRemoved, other.mRemoved);
        }

        public String toString() {
            return "Chunk [mPurge=" + this.mPurge + ", mComplete=" + this.mComplete + ", mModified=" + this.mModified + ", mRemoved=" + this.mRemoved + "]";
        }
    }

    public static class Filter
    implements Parcelable {
        private final Set<Integer> mIdentifierTypes;
        private final Set<ProgramSelector.Identifier> mIdentifiers;
        private final boolean mIncludeCategories;
        private final boolean mExcludeModifications;
        private final Map<String, String> mVendorFilter;
        public static final Parcelable.Creator<Filter> CREATOR = new Parcelable.Creator<Filter>(){

            @Override
            public Filter createFromParcel(Parcel in) {
                return new Filter(in);
            }

            public Filter[] newArray(int size) {
                return new Filter[size];
            }
        };

        public Filter(Set<Integer> identifierTypes, Set<ProgramSelector.Identifier> identifiers, boolean includeCategories, boolean excludeModifications) {
            this.mIdentifierTypes = Objects.requireNonNull(identifierTypes);
            this.mIdentifiers = Objects.requireNonNull(identifiers);
            this.mIncludeCategories = includeCategories;
            this.mExcludeModifications = excludeModifications;
            this.mVendorFilter = null;
        }

        public Filter() {
            this.mIdentifierTypes = Collections.emptySet();
            this.mIdentifiers = Collections.emptySet();
            this.mIncludeCategories = false;
            this.mExcludeModifications = false;
            this.mVendorFilter = null;
        }

        public Filter(Map<String, String> vendorFilter) {
            this.mIdentifierTypes = Collections.emptySet();
            this.mIdentifiers = Collections.emptySet();
            this.mIncludeCategories = false;
            this.mExcludeModifications = false;
            this.mVendorFilter = vendorFilter;
        }

        private Filter(Parcel in) {
            this.mIdentifierTypes = Utils.createIntSet(in);
            this.mIdentifiers = Utils.createSet(in, ProgramSelector.Identifier.CREATOR);
            this.mIncludeCategories = in.readByte() != 0;
            this.mExcludeModifications = in.readByte() != 0;
            this.mVendorFilter = Utils.readStringMap(in);
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            Utils.writeIntSet(dest, this.mIdentifierTypes);
            Utils.writeSet(dest, this.mIdentifiers);
            dest.writeByte((byte)(this.mIncludeCategories ? 1 : 0));
            dest.writeByte((byte)(this.mExcludeModifications ? 1 : 0));
            Utils.writeStringMap(dest, this.mVendorFilter);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        public Map<String, String> getVendorFilter() {
            return this.mVendorFilter;
        }

        public Set<Integer> getIdentifierTypes() {
            return this.mIdentifierTypes;
        }

        public Set<ProgramSelector.Identifier> getIdentifiers() {
            return this.mIdentifiers;
        }

        public boolean areCategoriesIncluded() {
            return this.mIncludeCategories;
        }

        public boolean areModificationsExcluded() {
            return this.mExcludeModifications;
        }

        public int hashCode() {
            return Objects.hash(this.mIdentifierTypes, this.mIdentifiers, this.mIncludeCategories, this.mExcludeModifications);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Filter)) {
                return false;
            }
            Filter other = (Filter)obj;
            if (this.mIncludeCategories != other.mIncludeCategories) {
                return false;
            }
            if (this.mExcludeModifications != other.mExcludeModifications) {
                return false;
            }
            if (!Objects.equals(this.mIdentifierTypes, other.mIdentifierTypes)) {
                return false;
            }
            return Objects.equals(this.mIdentifiers, other.mIdentifiers);
        }

        public String toString() {
            return "Filter [mIdentifierTypes=" + this.mIdentifierTypes + ", mIdentifiers=" + this.mIdentifiers + ", mIncludeCategories=" + this.mIncludeCategories + ", mExcludeModifications=" + this.mExcludeModifications + "]";
        }
    }

    static interface OnCloseListener {
        public void onClose();
    }

    public static interface OnCompleteListener {
        public void onComplete();
    }

    public static abstract class ListCallback {
        public void onItemChanged(ProgramSelector.Identifier id2) {
        }

        public void onItemRemoved(ProgramSelector.Identifier id2) {
        }
    }
}

