/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.radio;

import android.hardware.radio.ICloseHandle;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

class Utils {
    private static final String TAG = "BroadcastRadio.utils";

    Utils() {
    }

    static void writeStringMap(Parcel dest, Map<String, String> map) {
        if (map == null) {
            dest.writeInt(0);
            return;
        }
        dest.writeInt(map.size());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            dest.writeString(entry.getKey());
            dest.writeString(entry.getValue());
        }
    }

    static Map<String, String> readStringMap(Parcel in) {
        int size = in.readInt();
        HashMap<String, String> map = new HashMap<String, String>(size);
        while (size-- > 0) {
            String key = in.readString();
            String value = in.readString();
            map.put(key, value);
        }
        return map;
    }

    static void writeStringIntMap(Parcel dest, Map<String, Integer> map) {
        if (map == null) {
            dest.writeInt(0);
            return;
        }
        dest.writeInt(map.size());
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            dest.writeString(entry.getKey());
            dest.writeInt(entry.getValue());
        }
    }

    static Map<String, Integer> readStringIntMap(Parcel in) {
        int size = in.readInt();
        HashMap<String, Integer> map = new HashMap<String, Integer>(size);
        while (size-- > 0) {
            String key = in.readString();
            int value = in.readInt();
            map.put(key, value);
        }
        return map;
    }

    static <T extends Parcelable> void writeSet(Parcel dest, Set<T> set) {
        if (set == null) {
            dest.writeInt(0);
            return;
        }
        dest.writeInt(set.size());
        set.stream().forEach(elem -> dest.writeTypedObject(elem, 0));
    }

    static <T> Set<T> createSet(Parcel in, Parcelable.Creator<T> c) {
        int size = in.readInt();
        HashSet<T> set = new HashSet<T>(size);
        while (size-- > 0) {
            set.add(in.readTypedObject(c));
        }
        return set;
    }

    static void writeIntSet(Parcel dest, Set<Integer> set) {
        if (set == null) {
            dest.writeInt(0);
            return;
        }
        dest.writeInt(set.size());
        set.stream().forEach(elem -> dest.writeInt(Objects.requireNonNull(elem)));
    }

    static Set<Integer> createIntSet(Parcel in) {
        int size = in.readInt();
        HashSet<Integer> set = new HashSet<Integer>(size);
        while (size-- > 0) {
            set.add(in.readInt());
        }
        return set;
    }

    static <T extends Parcelable> void writeTypedCollection(Parcel dest, Collection<T> coll) {
        ArrayList<T> list = null;
        if (coll != null) {
            list = coll instanceof ArrayList ? (ArrayList<T>)coll : new ArrayList<T>(coll);
        }
        dest.writeTypedList(list);
    }

    static void close(ICloseHandle handle) {
        try {
            handle.close();
        }
        catch (RemoteException ex) {
            ex.rethrowFromSystemServer();
        }
    }
}

