/*
 * Decompiled with CFR 0.152.
 */
package android.location;

import android.annotation.SystemApi;

public class GnssCapabilities {
    public static final long LOW_POWER_MODE = 1L;
    public static final long SATELLITE_BLACKLIST = 2L;
    public static final long GEOFENCING = 4L;
    public static final long MEASUREMENTS = 8L;
    public static final long NAV_MESSAGES = 16L;
    public static final long MEASUREMENT_CORRECTIONS = 32L;
    public static final long MEASUREMENT_CORRECTIONS_LOS_SATS = 64L;
    public static final long MEASUREMENT_CORRECTIONS_EXCESS_PATH_LENGTH = 128L;
    public static final long MEASUREMENT_CORRECTIONS_REFLECTING_PLANE = 256L;
    public static final long ANTENNA_INFO = 512L;
    public static final long INVALID_CAPABILITIES = -1L;
    private final long mGnssCapabilities;

    public static GnssCapabilities of(long gnssCapabilities) {
        return new GnssCapabilities(gnssCapabilities);
    }

    private GnssCapabilities(long gnssCapabilities) {
        this.mGnssCapabilities = gnssCapabilities;
    }

    @SystemApi
    public boolean hasLowPowerMode() {
        return this.hasCapability(1L);
    }

    @SystemApi
    public boolean hasSatelliteBlacklist() {
        return this.hasCapability(2L);
    }

    @SystemApi
    public boolean hasGeofencing() {
        return this.hasCapability(4L);
    }

    @SystemApi
    public boolean hasMeasurements() {
        return this.hasCapability(8L);
    }

    @SystemApi
    public boolean hasNavMessages() {
        return this.hasCapability(16L);
    }

    @SystemApi
    public boolean hasMeasurementCorrections() {
        return this.hasCapability(32L);
    }

    @SystemApi
    public boolean hasMeasurementCorrectionsLosSats() {
        return this.hasCapability(64L);
    }

    @SystemApi
    public boolean hasMeasurementCorrectionsExcessPathLength() {
        return this.hasCapability(128L);
    }

    @SystemApi
    public boolean hasMeasurementCorrectionsReflectingPane() {
        return this.hasCapability(256L);
    }

    public boolean hasGnssAntennaInfo() {
        return this.hasCapability(512L);
    }

    private boolean hasCapability(long capability) {
        return (this.mGnssCapabilities & capability) == capability;
    }
}

