/*
 * Decompiled with CFR 0.152.
 */
package android.location;

import android.annotation.SystemApi;
import android.compat.annotation.UnsupportedAppUsage;
import android.location.Criteria;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.WorkSource;
import android.util.TimeUtils;
import com.android.internal.util.Preconditions;

@SystemApi
public class LocationRequest
implements Parcelable {
    public static final int ACCURACY_FINE = 100;
    public static final int ACCURACY_BLOCK = 102;
    public static final int ACCURACY_CITY = 104;
    public static final int POWER_NONE = 200;
    public static final int POWER_LOW = 201;
    public static final int POWER_HIGH = 203;
    private static final long DEFAULT_INTERVAL_MS = 3600000L;
    private static final double FASTEST_INTERVAL_FACTOR = 6.0;
    @UnsupportedAppUsage
    private String mProvider;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    private int mQuality;
    @UnsupportedAppUsage
    private long mInterval;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    private long mFastestInterval;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    private boolean mExplicitFastestInterval;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    private long mExpireAt;
    private long mExpireIn;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    private int mNumUpdates;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    private float mSmallestDisplacement;
    @UnsupportedAppUsage
    private boolean mHideFromAppOps;
    private boolean mLocationSettingsIgnored;
    private boolean mLowPowerMode;
    @UnsupportedAppUsage
    private WorkSource mWorkSource;
    public static final Parcelable.Creator<LocationRequest> CREATOR = new Parcelable.Creator<LocationRequest>(){

        @Override
        public LocationRequest createFromParcel(Parcel in) {
            return new LocationRequest(in.readString(), in.readInt(), in.readLong(), in.readLong(), in.readBoolean(), in.readLong(), in.readLong(), in.readInt(), in.readFloat(), in.readBoolean(), in.readBoolean(), in.readBoolean(), in.readTypedObject(WorkSource.CREATOR));
        }

        public LocationRequest[] newArray(int size) {
            return new LocationRequest[size];
        }
    };

    public static LocationRequest create() {
        return new LocationRequest();
    }

    @SystemApi
    public static LocationRequest createFromDeprecatedProvider(String provider, long minTime, float minDistance, boolean singleShot) {
        Preconditions.checkArgument(provider != null, "invalid null provider");
        if (minTime < 0L) {
            minTime = 0L;
        }
        if (minDistance < 0.0f) {
            minDistance = 0.0f;
        }
        int quality = "passive".equals(provider) ? 200 : ("gps".equals(provider) ? 100 : 201);
        LocationRequest request = new LocationRequest().setProvider(provider).setQuality(quality).setInterval(minTime).setFastestInterval(minTime).setSmallestDisplacement(minDistance);
        if (singleShot) {
            request.setNumUpdates(1);
        }
        return request;
    }

    @SystemApi
    public static LocationRequest createFromDeprecatedCriteria(Criteria criteria, long minTime, float minDistance, boolean singleShot) {
        int quality;
        Preconditions.checkArgument(criteria != null, "invalid null criteria");
        if (minTime < 0L) {
            minTime = 0L;
        }
        if (minDistance < 0.0f) {
            minDistance = 0.0f;
        }
        switch (criteria.getAccuracy()) {
            case 2: {
                quality = 102;
                break;
            }
            case 1: {
                quality = 100;
                break;
            }
            default: {
                quality = criteria.getPowerRequirement() == 3 ? 203 : 201;
            }
        }
        LocationRequest request = new LocationRequest().setQuality(quality).setInterval(minTime).setFastestInterval(minTime).setSmallestDisplacement(minDistance);
        if (singleShot) {
            request.setNumUpdates(1);
        }
        return request;
    }

    public LocationRequest() {
        this("fused", 201, 3600000L, 600000L, false, Long.MAX_VALUE, Long.MAX_VALUE, Integer.MAX_VALUE, 0.0f, false, false, false, null);
    }

    public LocationRequest(LocationRequest src) {
        this(src.mProvider, src.mQuality, src.mInterval, src.mFastestInterval, src.mExplicitFastestInterval, src.mExpireAt, src.mExpireIn, src.mNumUpdates, src.mSmallestDisplacement, src.mHideFromAppOps, src.mLocationSettingsIgnored, src.mLowPowerMode, src.mWorkSource);
    }

    private LocationRequest(String provider, int quality, long intervalMs, long fastestIntervalMs, boolean explicitFastestInterval, long expireAt, long expireInMs, int numUpdates, float smallestDisplacementM, boolean hideFromAppOps, boolean locationSettingsIgnored, boolean lowPowerMode, WorkSource workSource) {
        Preconditions.checkArgument(provider != null, "invalid provider: null");
        LocationRequest.checkQuality(quality);
        this.mProvider = provider;
        this.mQuality = quality;
        this.mInterval = intervalMs;
        this.mFastestInterval = fastestIntervalMs;
        this.mExplicitFastestInterval = explicitFastestInterval;
        this.mExpireAt = expireAt;
        this.mExpireIn = expireInMs;
        this.mNumUpdates = numUpdates;
        this.mSmallestDisplacement = Preconditions.checkArgumentInRange(smallestDisplacementM, 0.0f, Float.MAX_VALUE, "smallestDisplacementM");
        this.mHideFromAppOps = hideFromAppOps;
        this.mLowPowerMode = lowPowerMode;
        this.mLocationSettingsIgnored = locationSettingsIgnored;
        this.mWorkSource = workSource;
    }

    public LocationRequest setQuality(int quality) {
        LocationRequest.checkQuality(quality);
        this.mQuality = quality;
        return this;
    }

    public int getQuality() {
        return this.mQuality;
    }

    public LocationRequest setInterval(long millis) {
        Preconditions.checkArgument(millis >= 0L, "invalid interval: + millis");
        this.mInterval = millis;
        if (!this.mExplicitFastestInterval) {
            this.mFastestInterval = (long)((double)this.mInterval / 6.0);
        }
        return this;
    }

    public long getInterval() {
        return this.mInterval;
    }

    public LocationRequest setLowPowerMode(boolean enabled) {
        this.mLowPowerMode = enabled;
        return this;
    }

    public boolean isLowPowerMode() {
        return this.mLowPowerMode;
    }

    public LocationRequest setLocationSettingsIgnored(boolean locationSettingsIgnored) {
        this.mLocationSettingsIgnored = locationSettingsIgnored;
        return this;
    }

    public boolean isLocationSettingsIgnored() {
        return this.mLocationSettingsIgnored;
    }

    public LocationRequest setFastestInterval(long millis) {
        Preconditions.checkArgument(millis >= 0L, "invalid interval: + millis");
        this.mExplicitFastestInterval = true;
        this.mFastestInterval = millis;
        return this;
    }

    public long getFastestInterval() {
        return this.mFastestInterval;
    }

    @Deprecated
    public LocationRequest setExpireAt(long millis) {
        this.mExpireAt = Math.max(millis, 0L);
        return this;
    }

    @Deprecated
    public long getExpireAt() {
        return this.mExpireAt;
    }

    public LocationRequest setExpireIn(long millis) {
        this.mExpireIn = millis;
        return this;
    }

    public long getExpireIn() {
        return this.mExpireIn;
    }

    public long getExpirationRealtimeMs(long startRealtimeMs) {
        long expirationRealtimeMs = this.mExpireIn > Long.MAX_VALUE - startRealtimeMs ? Long.MAX_VALUE : startRealtimeMs + this.mExpireIn;
        return Math.min(expirationRealtimeMs, this.mExpireAt);
    }

    public LocationRequest setNumUpdates(int numUpdates) {
        if (numUpdates <= 0) {
            throw new IllegalArgumentException("invalid numUpdates: " + numUpdates);
        }
        this.mNumUpdates = numUpdates;
        return this;
    }

    public int getNumUpdates() {
        return this.mNumUpdates;
    }

    public void decrementNumUpdates() {
        if (this.mNumUpdates != Integer.MAX_VALUE) {
            --this.mNumUpdates;
        }
        if (this.mNumUpdates < 0) {
            this.mNumUpdates = 0;
        }
    }

    public LocationRequest setProvider(String provider) {
        Preconditions.checkArgument(provider != null, "invalid provider: null");
        this.mProvider = provider;
        return this;
    }

    @SystemApi
    public String getProvider() {
        return this.mProvider;
    }

    @SystemApi
    public LocationRequest setSmallestDisplacement(float smallestDisplacementM) {
        this.mSmallestDisplacement = Preconditions.checkArgumentInRange(smallestDisplacementM, 0.0f, Float.MAX_VALUE, "smallestDisplacementM");
        return this;
    }

    @SystemApi
    public float getSmallestDisplacement() {
        return this.mSmallestDisplacement;
    }

    @SystemApi
    public void setWorkSource(WorkSource workSource) {
        this.mWorkSource = workSource;
    }

    @SystemApi
    public WorkSource getWorkSource() {
        return this.mWorkSource;
    }

    @SystemApi
    public void setHideFromAppOps(boolean hideFromAppOps) {
        this.mHideFromAppOps = hideFromAppOps;
    }

    @SystemApi
    public boolean getHideFromAppOps() {
        return this.mHideFromAppOps;
    }

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    private static void checkQuality(int quality) {
        switch (quality) {
            case 100: 
            case 102: 
            case 104: 
            case 200: 
            case 201: 
            case 203: {
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid quality: " + quality);
            }
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeString(this.mProvider);
        parcel.writeInt(this.mQuality);
        parcel.writeLong(this.mInterval);
        parcel.writeLong(this.mFastestInterval);
        parcel.writeBoolean(this.mExplicitFastestInterval);
        parcel.writeLong(this.mExpireAt);
        parcel.writeLong(this.mExpireIn);
        parcel.writeInt(this.mNumUpdates);
        parcel.writeFloat(this.mSmallestDisplacement);
        parcel.writeBoolean(this.mHideFromAppOps);
        parcel.writeBoolean(this.mLocationSettingsIgnored);
        parcel.writeBoolean(this.mLowPowerMode);
        parcel.writeTypedObject(this.mWorkSource, 0);
    }

    public static String qualityToString(int quality) {
        switch (quality) {
            case 100: {
                return "ACCURACY_FINE";
            }
            case 102: {
                return "ACCURACY_BLOCK";
            }
            case 104: {
                return "ACCURACY_CITY";
            }
            case 200: {
                return "POWER_NONE";
            }
            case 201: {
                return "POWER_LOW";
            }
            case 203: {
                return "POWER_HIGH";
            }
        }
        return "???";
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("Request[");
        s.append(LocationRequest.qualityToString(this.mQuality));
        s.append(" ").append(this.mProvider);
        if (this.mQuality != 200) {
            s.append(" interval=");
            TimeUtils.formatDuration(this.mInterval, s);
            if (this.mExplicitFastestInterval) {
                s.append(" fastestInterval=");
                TimeUtils.formatDuration(this.mFastestInterval, s);
            }
        }
        if (this.mExpireAt != Long.MAX_VALUE) {
            s.append(" expireAt=").append(TimeUtils.formatRealtime(this.mExpireAt));
        }
        if (this.mExpireIn != Long.MAX_VALUE) {
            s.append(" expireIn=");
            TimeUtils.formatDuration(this.mExpireIn, s);
        }
        if (this.mNumUpdates != Integer.MAX_VALUE) {
            s.append(" num=").append(this.mNumUpdates);
        }
        if (this.mLowPowerMode) {
            s.append(" lowPowerMode");
        }
        if (this.mLocationSettingsIgnored) {
            s.append(" locationSettingsIgnored");
        }
        s.append(']');
        return s.toString();
    }
}

