/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.annotation.SystemApi;
import android.media.AudioDeviceInfo;
import android.media.AudioSystem;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

@SystemApi
public class AudioDeviceAttributes
implements Parcelable {
    public static final int ROLE_INPUT = 1;
    public static final int ROLE_OUTPUT = 2;
    private final int mType;
    private final String mAddress;
    private final int mRole;
    public static final Parcelable.Creator<AudioDeviceAttributes> CREATOR = new Parcelable.Creator<AudioDeviceAttributes>(){

        @Override
        public AudioDeviceAttributes createFromParcel(Parcel p) {
            return new AudioDeviceAttributes(p);
        }

        public AudioDeviceAttributes[] newArray(int size) {
            return new AudioDeviceAttributes[size];
        }
    };

    @SystemApi
    public AudioDeviceAttributes(AudioDeviceInfo deviceInfo) {
        Objects.requireNonNull(deviceInfo);
        this.mRole = deviceInfo.isSink() ? 2 : 1;
        this.mType = deviceInfo.getType();
        this.mAddress = deviceInfo.getAddress();
    }

    @SystemApi
    public AudioDeviceAttributes(int role, int type, String address) {
        Objects.requireNonNull(address);
        if (role != 2 && role != 1) {
            throw new IllegalArgumentException("Invalid role " + role);
        }
        if (role == 2) {
            AudioDeviceInfo.enforceValidAudioDeviceTypeOut(type);
        }
        if (role == 1) {
            AudioDeviceInfo.enforceValidAudioDeviceTypeIn(type);
        }
        this.mRole = role;
        this.mType = type;
        this.mAddress = address;
    }

    AudioDeviceAttributes(int nativeType, String address) {
        this.mRole = (nativeType & Integer.MIN_VALUE) != 0 ? 1 : 2;
        this.mType = AudioDeviceInfo.convertInternalDeviceToDeviceType(nativeType);
        this.mAddress = address;
    }

    @SystemApi
    public int getRole() {
        return this.mRole;
    }

    @SystemApi
    public int getType() {
        return this.mType;
    }

    @SystemApi
    public String getAddress() {
        return this.mAddress;
    }

    public int hashCode() {
        return Objects.hash(this.mRole, this.mType, this.mAddress);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AudioDeviceAttributes that = (AudioDeviceAttributes)o;
        return this.mRole == that.mRole && this.mType == that.mType && this.mAddress.equals(that.mAddress);
    }

    public static String roleToString(int role) {
        return role == 2 ? "output" : "input";
    }

    public String toString() {
        return new String("AudioDeviceAttributes: role:" + AudioDeviceAttributes.roleToString(this.mRole) + " type:" + (this.mRole == 2 ? AudioSystem.getOutputDeviceName(AudioDeviceInfo.convertDeviceTypeToInternalDevice(this.mType)) : AudioSystem.getInputDeviceName(AudioDeviceInfo.convertDeviceTypeToInternalDevice(this.mType))) + " addr:" + this.mAddress);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mRole);
        dest.writeInt(this.mType);
        dest.writeString(this.mAddress);
    }

    private AudioDeviceAttributes(Parcel in) {
        this.mRole = in.readInt();
        this.mType = in.readInt();
        this.mAddress = in.readString();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Role {
    }
}

