/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.IMediaController2;
import android.media.MediaController2;
import android.media.Session2Command;
import android.os.Binder;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ResultReceiver;
import java.util.Objects;

public class Controller2Link
implements Parcelable {
    private static final String TAG = "Controller2Link";
    private static final boolean DEBUG = MediaController2.DEBUG;
    public static final Parcelable.Creator<Controller2Link> CREATOR = new Parcelable.Creator<Controller2Link>(){

        @Override
        public Controller2Link createFromParcel(Parcel in) {
            return new Controller2Link(in);
        }

        public Controller2Link[] newArray(int size) {
            return new Controller2Link[size];
        }
    };
    private final MediaController2 mController;
    private final IMediaController2 mIController;

    public Controller2Link(MediaController2 controller) {
        this.mController = controller;
        this.mIController = new Controller2Stub();
    }

    Controller2Link(Parcel in) {
        this.mController = null;
        this.mIController = IMediaController2.Stub.asInterface(in.readStrongBinder());
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeStrongBinder(this.mIController.asBinder());
    }

    public int hashCode() {
        return this.mIController.asBinder().hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Controller2Link)) {
            return false;
        }
        Controller2Link other = (Controller2Link)obj;
        return Objects.equals(this.mIController.asBinder(), other.mIController.asBinder());
    }

    public void notifyConnected(int seq, Bundle connectionResult) {
        try {
            this.mIController.notifyConnected(seq, connectionResult);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    public void notifyDisconnected(int seq) {
        try {
            this.mIController.notifyDisconnected(seq);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    public void notifyPlaybackActiveChanged(int seq, boolean playbackActive) {
        try {
            this.mIController.notifyPlaybackActiveChanged(seq, playbackActive);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    public void sendSessionCommand(int seq, Session2Command command, Bundle args, ResultReceiver resultReceiver) {
        try {
            this.mIController.sendSessionCommand(seq, command, args, resultReceiver);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    public void cancelSessionCommand(int seq) {
        try {
            this.mIController.cancelSessionCommand(seq);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    public void onConnected(int seq, Bundle connectionResult) {
        if (connectionResult == null) {
            this.onDisconnected(seq);
            return;
        }
        this.mController.onConnected(seq, connectionResult);
    }

    public void onDisconnected(int seq) {
        this.mController.onDisconnected(seq);
    }

    public void onPlaybackActiveChanged(int seq, boolean playbackActive) {
        this.mController.onPlaybackActiveChanged(seq, playbackActive);
    }

    public void onSessionCommand(int seq, Session2Command command, Bundle args, ResultReceiver resultReceiver) {
        this.mController.onSessionCommand(seq, command, args, resultReceiver);
    }

    public void onCancelCommand(int seq) {
        this.mController.onCancelCommand(seq);
    }

    private class Controller2Stub
    extends IMediaController2.Stub {
        private Controller2Stub() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void notifyConnected(int seq, Bundle connectionResult) {
            long token = Binder.clearCallingIdentity();
            try {
                Controller2Link.this.onConnected(seq, connectionResult);
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void notifyDisconnected(int seq) {
            long token = Binder.clearCallingIdentity();
            try {
                Controller2Link.this.onDisconnected(seq);
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void notifyPlaybackActiveChanged(int seq, boolean playbackActive) {
            long token = Binder.clearCallingIdentity();
            try {
                Controller2Link.this.onPlaybackActiveChanged(seq, playbackActive);
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sendSessionCommand(int seq, Session2Command command, Bundle args, ResultReceiver resultReceiver) {
            long token = Binder.clearCallingIdentity();
            try {
                Controller2Link.this.onSessionCommand(seq, command, args, resultReceiver);
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancelSessionCommand(int seq) {
            long token = Binder.clearCallingIdentity();
            try {
                Controller2Link.this.onCancelCommand(seq);
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }
    }
}

