/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.MediaRoute2Info;
import android.media.RoutingSessionInfo;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.List;

public interface IMediaRouter2
extends IInterface {
    public void notifyRouterRegistered(List<MediaRoute2Info> var1, RoutingSessionInfo var2) throws RemoteException;

    public void notifyRoutesAdded(List<MediaRoute2Info> var1) throws RemoteException;

    public void notifyRoutesRemoved(List<MediaRoute2Info> var1) throws RemoteException;

    public void notifyRoutesChanged(List<MediaRoute2Info> var1) throws RemoteException;

    public void notifySessionCreated(int var1, RoutingSessionInfo var2) throws RemoteException;

    public void notifySessionInfoChanged(RoutingSessionInfo var1) throws RemoteException;

    public void notifySessionReleased(RoutingSessionInfo var1) throws RemoteException;

    public void requestCreateSessionByManager(long var1, RoutingSessionInfo var3, MediaRoute2Info var4) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IMediaRouter2 {
        private static final String DESCRIPTOR = "android.media.IMediaRouter2";
        static final int TRANSACTION_notifyRouterRegistered = 1;
        static final int TRANSACTION_notifyRoutesAdded = 2;
        static final int TRANSACTION_notifyRoutesRemoved = 3;
        static final int TRANSACTION_notifyRoutesChanged = 4;
        static final int TRANSACTION_notifySessionCreated = 5;
        static final int TRANSACTION_notifySessionInfoChanged = 6;
        static final int TRANSACTION_notifySessionReleased = 7;
        static final int TRANSACTION_requestCreateSessionByManager = 8;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IMediaRouter2 asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IMediaRouter2) {
                return (IMediaRouter2)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "notifyRouterRegistered";
                }
                case 2: {
                    return "notifyRoutesAdded";
                }
                case 3: {
                    return "notifyRoutesRemoved";
                }
                case 4: {
                    return "notifyRoutesChanged";
                }
                case 5: {
                    return "notifySessionCreated";
                }
                case 6: {
                    return "notifySessionInfoChanged";
                }
                case 7: {
                    return "notifySessionReleased";
                }
                case 8: {
                    return "requestCreateSessionByManager";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
                case 1: {
                    data.enforceInterface(descriptor);
                    ArrayList<MediaRoute2Info> _arg0 = data.createTypedArrayList(MediaRoute2Info.CREATOR);
                    RoutingSessionInfo _arg1 = 0 != data.readInt() ? RoutingSessionInfo.CREATOR.createFromParcel(data) : null;
                    this.notifyRouterRegistered(_arg0, _arg1);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    ArrayList<MediaRoute2Info> _arg0 = data.createTypedArrayList(MediaRoute2Info.CREATOR);
                    this.notifyRoutesAdded(_arg0);
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    ArrayList<MediaRoute2Info> _arg0 = data.createTypedArrayList(MediaRoute2Info.CREATOR);
                    this.notifyRoutesRemoved(_arg0);
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    ArrayList<MediaRoute2Info> _arg0 = data.createTypedArrayList(MediaRoute2Info.CREATOR);
                    this.notifyRoutesChanged(_arg0);
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    RoutingSessionInfo _arg1 = 0 != data.readInt() ? RoutingSessionInfo.CREATOR.createFromParcel(data) : null;
                    this.notifySessionCreated(_arg0, _arg1);
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    RoutingSessionInfo _arg0 = 0 != data.readInt() ? RoutingSessionInfo.CREATOR.createFromParcel(data) : null;
                    this.notifySessionInfoChanged(_arg0);
                    return true;
                }
                case 7: {
                    data.enforceInterface(descriptor);
                    RoutingSessionInfo _arg0 = 0 != data.readInt() ? RoutingSessionInfo.CREATOR.createFromParcel(data) : null;
                    this.notifySessionReleased(_arg0);
                    return true;
                }
                case 8: {
                    data.enforceInterface(descriptor);
                    long _arg0 = data.readLong();
                    RoutingSessionInfo _arg1 = 0 != data.readInt() ? RoutingSessionInfo.CREATOR.createFromParcel(data) : null;
                    MediaRoute2Info _arg2 = 0 != data.readInt() ? MediaRoute2Info.CREATOR.createFromParcel(data) : null;
                    this.requestCreateSessionByManager(_arg0, _arg1, _arg2);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IMediaRouter2 impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IMediaRouter2 getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IMediaRouter2 {
            private IBinder mRemote;
            public static IMediaRouter2 sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyRouterRegistered(List<MediaRoute2Info> currentRoutes, RoutingSessionInfo currentSystemSessionInfo) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedList(currentRoutes);
                    if (currentSystemSessionInfo != null) {
                        _data.writeInt(1);
                        currentSystemSessionInfo.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(1, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().notifyRouterRegistered(currentRoutes, currentSystemSessionInfo);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyRoutesAdded(List<MediaRoute2Info> routes) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedList(routes);
                    boolean _status = this.mRemote.transact(2, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().notifyRoutesAdded(routes);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyRoutesRemoved(List<MediaRoute2Info> routes) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedList(routes);
                    boolean _status = this.mRemote.transact(3, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().notifyRoutesRemoved(routes);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyRoutesChanged(List<MediaRoute2Info> routes) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedList(routes);
                    boolean _status = this.mRemote.transact(4, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().notifyRoutesChanged(routes);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifySessionCreated(int requestId, RoutingSessionInfo sessionInfo) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(requestId);
                    if (sessionInfo != null) {
                        _data.writeInt(1);
                        sessionInfo.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(5, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().notifySessionCreated(requestId, sessionInfo);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifySessionInfoChanged(RoutingSessionInfo sessionInfo) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (sessionInfo != null) {
                        _data.writeInt(1);
                        sessionInfo.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(6, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().notifySessionInfoChanged(sessionInfo);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifySessionReleased(RoutingSessionInfo sessionInfo) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (sessionInfo != null) {
                        _data.writeInt(1);
                        sessionInfo.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(7, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().notifySessionReleased(sessionInfo);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestCreateSessionByManager(long uniqueRequestId, RoutingSessionInfo oldSession, MediaRoute2Info route) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(uniqueRequestId);
                    if (oldSession != null) {
                        _data.writeInt(1);
                        oldSession.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (route != null) {
                        _data.writeInt(1);
                        route.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(8, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().requestCreateSessionByManager(uniqueRequestId, oldSession, route);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IMediaRouter2 {
        @Override
        public void notifyRouterRegistered(List<MediaRoute2Info> currentRoutes, RoutingSessionInfo currentSystemSessionInfo) throws RemoteException {
        }

        @Override
        public void notifyRoutesAdded(List<MediaRoute2Info> routes) throws RemoteException {
        }

        @Override
        public void notifyRoutesRemoved(List<MediaRoute2Info> routes) throws RemoteException {
        }

        @Override
        public void notifyRoutesChanged(List<MediaRoute2Info> routes) throws RemoteException {
        }

        @Override
        public void notifySessionCreated(int requestId, RoutingSessionInfo sessionInfo) throws RemoteException {
        }

        @Override
        public void notifySessionInfoChanged(RoutingSessionInfo sessionInfo) throws RemoteException {
        }

        @Override
        public void notifySessionReleased(RoutingSessionInfo sessionInfo) throws RemoteException {
        }

        @Override
        public void requestCreateSessionByManager(long uniqueRequestId, RoutingSessionInfo oldSession, MediaRoute2Info route) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

