/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.Controller2Link;
import android.media.IMediaSession2;
import android.media.MediaSession2;
import android.media.Session2Command;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.util.Log;
import java.util.Objects;

public class Session2Link
implements Parcelable {
    private static final String TAG = "Session2Link";
    private static final boolean DEBUG = MediaSession2.DEBUG;
    public static final Parcelable.Creator<Session2Link> CREATOR = new Parcelable.Creator<Session2Link>(){

        @Override
        public Session2Link createFromParcel(Parcel in) {
            return new Session2Link(in);
        }

        public Session2Link[] newArray(int size) {
            return new Session2Link[size];
        }
    };
    private final MediaSession2 mSession;
    private final IMediaSession2 mISession;

    public Session2Link(MediaSession2 session) {
        this.mSession = session;
        this.mISession = new Session2Stub();
    }

    Session2Link(Parcel in) {
        this.mSession = null;
        this.mISession = IMediaSession2.Stub.asInterface(in.readStrongBinder());
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeStrongBinder(this.mISession.asBinder());
    }

    public int hashCode() {
        return this.mISession.asBinder().hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Session2Link)) {
            return false;
        }
        Session2Link other = (Session2Link)obj;
        return Objects.equals(this.mISession.asBinder(), other.mISession.asBinder());
    }

    public void linkToDeath(IBinder.DeathRecipient recipient, int flags) {
        block3: {
            if (this.mISession != null) {
                try {
                    this.mISession.asBinder().linkToDeath(recipient, flags);
                }
                catch (RemoteException e) {
                    if (!DEBUG) break block3;
                    Log.d(TAG, "Session died too early.", e);
                }
            }
        }
    }

    public boolean unlinkToDeath(IBinder.DeathRecipient recipient, int flags) {
        if (this.mISession != null) {
            return this.mISession.asBinder().unlinkToDeath(recipient, flags);
        }
        return true;
    }

    public void connect(Controller2Link caller, int seq, Bundle connectionRequest) {
        try {
            this.mISession.connect(caller, seq, connectionRequest);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    public void disconnect(Controller2Link caller, int seq) {
        try {
            this.mISession.disconnect(caller, seq);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    public void sendSessionCommand(Controller2Link caller, int seq, Session2Command command, Bundle args, ResultReceiver resultReceiver) {
        try {
            this.mISession.sendSessionCommand(caller, seq, command, args, resultReceiver);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    public void cancelSessionCommand(Controller2Link caller, int seq) {
        try {
            this.mISession.cancelSessionCommand(caller, seq);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    public void onConnect(Controller2Link caller, int pid, int uid, int seq, Bundle connectionRequest) {
        this.mSession.onConnect(caller, pid, uid, seq, connectionRequest);
    }

    public void onDisconnect(Controller2Link caller, int seq) {
        this.mSession.onDisconnect(caller, seq);
    }

    public void onSessionCommand(Controller2Link caller, int seq, Session2Command command, Bundle args, ResultReceiver resultReceiver) {
        this.mSession.onSessionCommand(caller, seq, command, args, resultReceiver);
    }

    public void onCancelCommand(Controller2Link caller, int seq) {
        this.mSession.onCancelCommand(caller, seq);
    }

    private class Session2Stub
    extends IMediaSession2.Stub {
        private Session2Stub() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void connect(Controller2Link caller, int seq, Bundle connectionRequest) {
            if (caller == null || connectionRequest == null) {
                return;
            }
            int pid = Binder.getCallingPid();
            int uid = Binder.getCallingUid();
            long token = Binder.clearCallingIdentity();
            try {
                Session2Link.this.onConnect(caller, pid, uid, seq, connectionRequest);
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void disconnect(Controller2Link caller, int seq) {
            if (caller == null) {
                return;
            }
            long token = Binder.clearCallingIdentity();
            try {
                Session2Link.this.onDisconnect(caller, seq);
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sendSessionCommand(Controller2Link caller, int seq, Session2Command command, Bundle args, ResultReceiver resultReceiver) {
            if (caller == null) {
                return;
            }
            long token = Binder.clearCallingIdentity();
            try {
                Session2Link.this.onSessionCommand(caller, seq, command, args, resultReceiver);
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancelSessionCommand(Controller2Link caller, int seq) {
            if (caller == null) {
                return;
            }
            long token = Binder.clearCallingIdentity();
            try {
                Session2Link.this.onCancelCommand(caller, seq);
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }
    }
}

