/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.media.MediaFormat;
import android.media.SubtitleController;
import android.media.SubtitleTrack;
import android.media.TtmlRenderingWidget;
import android.media.TtmlTrack;

public class TtmlRenderer
extends SubtitleController.Renderer {
    private final Context mContext;
    private static final String MEDIA_MIMETYPE_TEXT_TTML = "application/ttml+xml";
    private TtmlRenderingWidget mRenderingWidget;

    @UnsupportedAppUsage
    public TtmlRenderer(Context context) {
        this.mContext = context;
    }

    @Override
    public boolean supports(MediaFormat format) {
        if (format.containsKey("mime")) {
            return format.getString("mime").equals(MEDIA_MIMETYPE_TEXT_TTML);
        }
        return false;
    }

    @Override
    public SubtitleTrack createTrack(MediaFormat format) {
        if (this.mRenderingWidget == null) {
            this.mRenderingWidget = new TtmlRenderingWidget(this.mContext);
        }
        return new TtmlTrack(this.mRenderingWidget, format);
    }
}

