/*
 * Decompiled with CFR 0.152.
 */
package android.media.session;

import android.annotation.SystemApi;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ParceledListSlice;
import android.media.IRemoteVolumeController;
import android.media.Session2Token;
import android.media.session.IActiveSessionsListener;
import android.media.session.IOnMediaKeyEventDispatchedListener;
import android.media.session.IOnMediaKeyEventSessionChangedListener;
import android.media.session.IOnMediaKeyListener;
import android.media.session.IOnVolumeKeyLongPressListener;
import android.media.session.ISession;
import android.media.session.ISession2TokensListener;
import android.media.session.ISessionManager;
import android.media.session.MediaController;
import android.media.session.MediaSession;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.ServiceManager;
import android.os.UserHandle;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.Log;
import android.view.KeyEvent;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;

public class MediaSessionManager {
    private static final String TAG = "SessionManager";
    public static final int RESULT_MEDIA_KEY_NOT_HANDLED = 0;
    public static final int RESULT_MEDIA_KEY_HANDLED = 1;
    private final ISessionManager mService;
    private final OnMediaKeyEventDispatchedListenerStub mOnMediaKeyEventDispatchedListenerStub = new OnMediaKeyEventDispatchedListenerStub();
    private final OnMediaKeyEventSessionChangedListenerStub mOnMediaKeyEventSessionChangedListenerStub = new OnMediaKeyEventSessionChangedListenerStub();
    private final Object mLock = new Object();
    @GuardedBy(value={"mLock"})
    private final ArrayMap<OnActiveSessionsChangedListener, SessionsChangedWrapper> mListeners = new ArrayMap();
    @GuardedBy(value={"mLock"})
    private final ArrayMap<OnSession2TokensChangedListener, Session2TokensChangedWrapper> mSession2TokensListeners = new ArrayMap();
    @GuardedBy(value={"mLock"})
    private final Map<OnMediaKeyEventDispatchedListener, Executor> mOnMediaKeyEventDispatchedListeners = new HashMap<OnMediaKeyEventDispatchedListener, Executor>();
    @GuardedBy(value={"mLock"})
    private final Map<OnMediaKeyEventSessionChangedListener, Executor> mMediaKeyEventSessionChangedCallbacks = new HashMap<OnMediaKeyEventSessionChangedListener, Executor>();
    @GuardedBy(value={"mLock"})
    private String mCurMediaKeyEventSessionPackage;
    @GuardedBy(value={"mLock"})
    private MediaSession.Token mCurMediaKeyEventSession;
    private Context mContext;
    private OnVolumeKeyLongPressListenerImpl mOnVolumeKeyLongPressListener;
    private OnMediaKeyListenerImpl mOnMediaKeyListener;

    public MediaSessionManager(Context context) {
        this.mContext = context;
        IBinder b = ServiceManager.getService("media_session");
        this.mService = ISessionManager.Stub.asInterface(b);
    }

    public ISession createSession(MediaSession.CallbackStub cbStub, String tag, Bundle sessionInfo) {
        try {
            return this.mService.createSession(this.mContext.getPackageName(), cbStub, tag, sessionInfo, UserHandle.myUserId());
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    public void notifySession2Created(Session2Token token) {
        if (token == null) {
            throw new IllegalArgumentException("token shouldn't be null");
        }
        if (token.getType() != 0) {
            throw new IllegalArgumentException("token's type should be TYPE_SESSION");
        }
        try {
            this.mService.notifySession2Created(token);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    public List<MediaController> getActiveSessions(ComponentName notificationListener) {
        return this.getActiveSessionsForUser(notificationListener, UserHandle.myUserId());
    }

    @UnsupportedAppUsage
    public List<MediaController> getActiveSessionsForUser(ComponentName notificationListener, int userId) {
        ArrayList<MediaController> controllers = new ArrayList<MediaController>();
        try {
            List<MediaSession.Token> tokens = this.mService.getSessions(notificationListener, userId);
            int size = tokens.size();
            for (int i = 0; i < size; ++i) {
                MediaController controller = new MediaController(this.mContext, tokens.get(i));
                controllers.add(controller);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to get active sessions: ", e);
        }
        return controllers;
    }

    public List<Session2Token> getSession2Tokens() {
        return this.getSession2Tokens(UserHandle.myUserId());
    }

    public List<Session2Token> getSession2Tokens(int userId) {
        try {
            ParceledListSlice slice = this.mService.getSession2Tokens(userId);
            return slice == null ? new ArrayList() : slice.getList();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to get session tokens", e);
            return new ArrayList<Session2Token>();
        }
    }

    public void addOnActiveSessionsChangedListener(OnActiveSessionsChangedListener sessionListener, ComponentName notificationListener) {
        this.addOnActiveSessionsChangedListener(sessionListener, notificationListener, null);
    }

    public void addOnActiveSessionsChangedListener(OnActiveSessionsChangedListener sessionListener, ComponentName notificationListener, Handler handler) {
        this.addOnActiveSessionsChangedListener(sessionListener, notificationListener, UserHandle.myUserId(), handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOnActiveSessionsChangedListener(OnActiveSessionsChangedListener sessionListener, ComponentName notificationListener, int userId, Handler handler) {
        if (sessionListener == null) {
            throw new IllegalArgumentException("listener may not be null");
        }
        if (handler == null) {
            handler = new Handler();
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mListeners.get(sessionListener) != null) {
                Log.w(TAG, "Attempted to add session listener twice, ignoring.");
                return;
            }
            SessionsChangedWrapper wrapper = new SessionsChangedWrapper(this.mContext, sessionListener, handler);
            try {
                this.mService.addSessionsListener(wrapper.mStub, notificationListener, userId);
                this.mListeners.put(sessionListener, wrapper);
            }
            catch (RemoteException e) {
                Log.e(TAG, "Error in addOnActiveSessionsChangedListener.", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOnActiveSessionsChangedListener(OnActiveSessionsChangedListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener may not be null");
        }
        Object object = this.mLock;
        synchronized (object) {
            SessionsChangedWrapper wrapper = this.mListeners.remove(listener);
            if (wrapper != null) {
                try {
                    this.mService.removeSessionsListener(wrapper.mStub);
                }
                catch (RemoteException e) {
                    Log.e(TAG, "Error in removeOnActiveSessionsChangedListener.", e);
                }
                finally {
                    wrapper.release();
                }
            }
        }
    }

    public void addOnSession2TokensChangedListener(OnSession2TokensChangedListener listener) {
        this.addOnSession2TokensChangedListener(UserHandle.myUserId(), listener, new Handler());
    }

    public void addOnSession2TokensChangedListener(OnSession2TokensChangedListener listener, Handler handler) {
        this.addOnSession2TokensChangedListener(UserHandle.myUserId(), listener, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOnSession2TokensChangedListener(int userId, OnSession2TokensChangedListener listener, Handler handler) {
        if (listener == null) {
            throw new IllegalArgumentException("listener shouldn't be null");
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mSession2TokensListeners.get(listener) != null) {
                Log.w(TAG, "Attempted to add session listener twice, ignoring.");
                return;
            }
            Session2TokensChangedWrapper wrapper = new Session2TokensChangedWrapper(listener, handler);
            try {
                this.mService.addSession2TokensListener(wrapper.getStub(), userId);
                this.mSession2TokensListeners.put(listener, wrapper);
            }
            catch (RemoteException e) {
                Log.e(TAG, "Error in addSessionTokensListener.", e);
                e.rethrowFromSystemServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOnSession2TokensChangedListener(OnSession2TokensChangedListener listener) {
        Session2TokensChangedWrapper wrapper;
        if (listener == null) {
            throw new IllegalArgumentException("listener may not be null");
        }
        Object object = this.mLock;
        synchronized (object) {
            wrapper = this.mSession2TokensListeners.remove(listener);
        }
        if (wrapper != null) {
            try {
                this.mService.removeSession2TokensListener(wrapper.getStub());
            }
            catch (RemoteException e) {
                Log.e(TAG, "Error in removeSessionTokensListener.", e);
                e.rethrowFromSystemServer();
            }
        }
    }

    public void registerRemoteVolumeController(IRemoteVolumeController rvc) {
        try {
            this.mService.registerRemoteVolumeController(rvc);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error in registerRemoteVolumeController.", e);
        }
    }

    public void unregisterRemoteVolumeController(IRemoteVolumeController rvc) {
        try {
            this.mService.unregisterRemoteVolumeController(rvc);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error in unregisterRemoteVolumeController.", e);
        }
    }

    public void dispatchMediaKeyEvent(KeyEvent keyEvent) {
        this.dispatchMediaKeyEvent(keyEvent, false);
    }

    public void dispatchMediaKeyEvent(KeyEvent keyEvent, boolean needWakeLock) {
        this.dispatchMediaKeyEventInternal(false, keyEvent, needWakeLock);
    }

    public void dispatchMediaKeyEventAsSystemService(KeyEvent keyEvent) {
        this.dispatchMediaKeyEventInternal(true, keyEvent, false);
    }

    private void dispatchMediaKeyEventInternal(boolean asSystemService, KeyEvent keyEvent, boolean needWakeLock) {
        try {
            this.mService.dispatchMediaKeyEvent(this.mContext.getPackageName(), asSystemService, keyEvent, needWakeLock);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to send key event.", e);
        }
    }

    public boolean dispatchMediaKeyEventAsSystemService(MediaSession.Token sessionToken, KeyEvent keyEvent) {
        if (sessionToken == null) {
            throw new IllegalArgumentException("sessionToken shouldn't be null");
        }
        if (keyEvent == null) {
            throw new IllegalArgumentException("keyEvent shouldn't be null");
        }
        if (!KeyEvent.isMediaSessionKey(keyEvent.getKeyCode())) {
            return false;
        }
        try {
            return this.mService.dispatchMediaKeyEventToSessionAsSystemService(this.mContext.getPackageName(), sessionToken, keyEvent);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to send key event.", e);
            return false;
        }
    }

    public void dispatchVolumeKeyEvent(KeyEvent keyEvent, int stream, boolean musicOnly) {
        this.dispatchVolumeKeyEventInternal(false, keyEvent, stream, musicOnly);
    }

    public void dispatchVolumeKeyEventAsSystemService(KeyEvent keyEvent, int streamType) {
        this.dispatchVolumeKeyEventInternal(true, keyEvent, streamType, false);
    }

    private void dispatchVolumeKeyEventInternal(boolean asSystemService, KeyEvent keyEvent, int stream, boolean musicOnly) {
        try {
            this.mService.dispatchVolumeKeyEvent(this.mContext.getPackageName(), this.mContext.getOpPackageName(), asSystemService, keyEvent, stream, musicOnly);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to send volume key event.", e);
        }
    }

    public void dispatchVolumeKeyEventAsSystemService(MediaSession.Token sessionToken, KeyEvent keyEvent) {
        if (sessionToken == null) {
            throw new IllegalArgumentException("sessionToken shouldn't be null");
        }
        if (keyEvent == null) {
            throw new IllegalArgumentException("keyEvent shouldn't be null");
        }
        try {
            this.mService.dispatchVolumeKeyEventToSessionAsSystemService(this.mContext.getPackageName(), this.mContext.getOpPackageName(), sessionToken, keyEvent);
        }
        catch (RemoteException e) {
            Log.wtf(TAG, "Error calling dispatchVolumeKeyEventAsSystemService", e);
        }
    }

    public void dispatchAdjustVolume(int suggestedStream, int direction, int flags) {
        try {
            this.mService.dispatchAdjustVolume(this.mContext.getPackageName(), this.mContext.getOpPackageName(), suggestedStream, direction, flags);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to send adjust volume.", e);
        }
    }

    public boolean isTrustedForMediaControl(RemoteUserInfo userInfo) {
        if (userInfo == null) {
            throw new IllegalArgumentException("userInfo may not be null");
        }
        if (userInfo.getPackageName() == null) {
            return false;
        }
        try {
            return this.mService.isTrusted(userInfo.getPackageName(), userInfo.getPid(), userInfo.getUid());
        }
        catch (RemoteException e) {
            Log.wtf(TAG, "Cannot communicate with the service.", e);
            return false;
        }
    }

    public boolean isGlobalPriorityActive() {
        try {
            return this.mService.isGlobalPriorityActive();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to check if the global priority is active.", e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    public void setOnVolumeKeyLongPressListener(OnVolumeKeyLongPressListener listener, Handler handler) {
        Object object = this.mLock;
        synchronized (object) {
            try {
                if (listener == null) {
                    this.mOnVolumeKeyLongPressListener = null;
                    this.mService.setOnVolumeKeyLongPressListener(null);
                } else {
                    if (handler == null) {
                        handler = new Handler();
                    }
                    this.mOnVolumeKeyLongPressListener = new OnVolumeKeyLongPressListenerImpl(listener, handler);
                    this.mService.setOnVolumeKeyLongPressListener(this.mOnVolumeKeyLongPressListener);
                }
            }
            catch (RemoteException e) {
                Log.e(TAG, "Failed to set volume key long press listener", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    public void setOnMediaKeyListener(OnMediaKeyListener listener, Handler handler) {
        Object object = this.mLock;
        synchronized (object) {
            try {
                if (listener == null) {
                    this.mOnMediaKeyListener = null;
                    this.mService.setOnMediaKeyListener(null);
                } else {
                    if (handler == null) {
                        handler = new Handler();
                    }
                    this.mOnMediaKeyListener = new OnMediaKeyListenerImpl(listener, handler);
                    this.mService.setOnMediaKeyListener(this.mOnMediaKeyListener);
                }
            }
            catch (RemoteException e) {
                Log.e(TAG, "Failed to set media key listener", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    public void addOnMediaKeyEventDispatchedListener(Executor executor, OnMediaKeyEventDispatchedListener listener) {
        if (executor == null) {
            throw new NullPointerException("executor shouldn't be null");
        }
        if (listener == null) {
            throw new NullPointerException("listener shouldn't be null");
        }
        Object object = this.mLock;
        synchronized (object) {
            try {
                this.mOnMediaKeyEventDispatchedListeners.put(listener, executor);
                if (this.mOnMediaKeyEventDispatchedListeners.size() == 1) {
                    this.mService.addOnMediaKeyEventDispatchedListener(this.mOnMediaKeyEventDispatchedListenerStub);
                }
            }
            catch (RemoteException e) {
                Log.e(TAG, "Failed to set media key listener", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    public void removeOnMediaKeyEventDispatchedListener(OnMediaKeyEventDispatchedListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener shouldn't be null");
        }
        Object object = this.mLock;
        synchronized (object) {
            try {
                this.mOnMediaKeyEventDispatchedListeners.remove(listener);
                if (this.mOnMediaKeyEventDispatchedListeners.size() == 0) {
                    this.mService.removeOnMediaKeyEventDispatchedListener(this.mOnMediaKeyEventDispatchedListenerStub);
                }
            }
            catch (RemoteException e) {
                Log.e(TAG, "Failed to set media key event dispatched listener", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    public void addOnMediaKeyEventSessionChangedListener(Executor executor, OnMediaKeyEventSessionChangedListener listener) {
        if (executor == null) {
            throw new NullPointerException("executor shouldn't be null");
        }
        if (listener == null) {
            throw new NullPointerException("listener shouldn't be null");
        }
        Object object = this.mLock;
        synchronized (object) {
            try {
                this.mMediaKeyEventSessionChangedCallbacks.put(listener, executor);
                executor.execute(() -> listener.onMediaKeyEventSessionChanged(this.mCurMediaKeyEventSessionPackage, this.mCurMediaKeyEventSession));
                if (this.mMediaKeyEventSessionChangedCallbacks.size() == 1) {
                    this.mService.addOnMediaKeyEventSessionChangedListener(this.mOnMediaKeyEventSessionChangedListenerStub);
                }
            }
            catch (RemoteException e) {
                Log.e(TAG, "Failed to set media key listener", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    public void removeOnMediaKeyEventSessionChangedListener(OnMediaKeyEventSessionChangedListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener shouldn't be null");
        }
        Object object = this.mLock;
        synchronized (object) {
            try {
                this.mMediaKeyEventSessionChangedCallbacks.remove(listener);
                if (this.mMediaKeyEventSessionChangedCallbacks.size() == 0) {
                    this.mService.removeOnMediaKeyEventSessionChangedListener(this.mOnMediaKeyEventSessionChangedListenerStub);
                }
            }
            catch (RemoteException e) {
                Log.e(TAG, "Failed to set media key listener", e);
            }
        }
    }

    @VisibleForTesting
    public void setCustomMediaKeyDispatcherForTesting(String name) {
        try {
            this.mService.setCustomMediaKeyDispatcherForTesting(name);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to set custom media key dispatcher name", e);
        }
    }

    @VisibleForTesting
    public void setCustomSessionPolicyProviderForTesting(String name) {
        try {
            this.mService.setCustomSessionPolicyProviderForTesting(name);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to set custom session policy provider name", e);
        }
    }

    public int getSessionPolicies(MediaSession.Token token) {
        try {
            return this.mService.getSessionPolicies(token);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to get session policies", e);
            return 0;
        }
    }

    public void setSessionPolicies(MediaSession.Token token, int policies) {
        try {
            this.mService.setSessionPolicies(token, policies);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to set session policies", e);
        }
    }

    private class OnMediaKeyEventSessionChangedListenerStub
    extends IOnMediaKeyEventSessionChangedListener.Stub {
        private OnMediaKeyEventSessionChangedListenerStub() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onMediaKeyEventSessionChanged(String packageName, MediaSession.Token sessionToken) {
            Object object = MediaSessionManager.this.mLock;
            synchronized (object) {
                MediaSessionManager.this.mCurMediaKeyEventSessionPackage = packageName;
                MediaSessionManager.this.mCurMediaKeyEventSession = sessionToken;
                for (Map.Entry e : MediaSessionManager.this.mMediaKeyEventSessionChangedCallbacks.entrySet()) {
                    ((Executor)e.getValue()).execute(() -> ((OnMediaKeyEventSessionChangedListener)e.getKey()).onMediaKeyEventSessionChanged(packageName, sessionToken));
                }
            }
        }
    }

    private class OnMediaKeyEventDispatchedListenerStub
    extends IOnMediaKeyEventDispatchedListener.Stub {
        private OnMediaKeyEventDispatchedListenerStub() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onMediaKeyEventDispatched(KeyEvent event, String packageName, MediaSession.Token sessionToken) {
            Object object = MediaSessionManager.this.mLock;
            synchronized (object) {
                for (Map.Entry e : MediaSessionManager.this.mOnMediaKeyEventDispatchedListeners.entrySet()) {
                    ((Executor)e.getValue()).execute(() -> ((OnMediaKeyEventDispatchedListener)e.getKey()).onMediaKeyEventDispatched(event, packageName, sessionToken));
                }
            }
        }
    }

    private static class OnMediaKeyListenerImpl
    extends IOnMediaKeyListener.Stub {
        private OnMediaKeyListener mListener;
        private Handler mHandler;

        public OnMediaKeyListenerImpl(OnMediaKeyListener listener, Handler handler) {
            this.mListener = listener;
            this.mHandler = handler;
        }

        @Override
        public void onMediaKey(final KeyEvent event, final ResultReceiver result) {
            if (this.mListener == null || this.mHandler == null) {
                Log.w(MediaSessionManager.TAG, "Failed to call media key listener. Either mListener or mHandler is null");
                return;
            }
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    boolean handled = mListener.onMediaKey(event);
                    Log.d(MediaSessionManager.TAG, "The media key listener is returned " + handled);
                    if (result != null) {
                        result.send(handled ? 1 : 0, null);
                    }
                }
            });
        }
    }

    private static class OnVolumeKeyLongPressListenerImpl
    extends IOnVolumeKeyLongPressListener.Stub {
        private OnVolumeKeyLongPressListener mListener;
        private Handler mHandler;

        public OnVolumeKeyLongPressListenerImpl(OnVolumeKeyLongPressListener listener, Handler handler) {
            this.mListener = listener;
            this.mHandler = handler;
        }

        @Override
        public void onVolumeKeyLongPress(final KeyEvent event) {
            if (this.mListener == null || this.mHandler == null) {
                Log.w(MediaSessionManager.TAG, "Failed to call volume key long-press listener. Either mListener or mHandler is null");
                return;
            }
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    mListener.onVolumeKeyLongPress(event);
                }
            });
        }
    }

    private static class Session2TokensChangedWrapper {
        private final OnSession2TokensChangedListener mListener;
        private final Handler mHandler;
        private final ISession2TokensListener.Stub mStub = new ISession2TokensListener.Stub(){

            @Override
            public void onSession2TokensChanged(List<Session2Token> tokens) {
                mHandler.post(() -> mListener.onSession2TokensChanged(tokens));
            }
        };

        Session2TokensChangedWrapper(OnSession2TokensChangedListener listener, Handler handler) {
            this.mListener = listener;
            this.mHandler = handler == null ? new Handler() : new Handler(handler.getLooper());
        }

        public ISession2TokensListener.Stub getStub() {
            return this.mStub;
        }
    }

    private static class SessionsChangedWrapper {
        private Context mContext;
        private OnActiveSessionsChangedListener mListener;
        private Handler mHandler;
        private final IActiveSessionsListener.Stub mStub = new IActiveSessionsListener.Stub(){

            @Override
            public void onActiveSessionsChanged(final List<MediaSession.Token> tokens) {
                Handler handler = mHandler;
                if (handler != null) {
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            Context context = mContext;
                            if (context != null) {
                                ArrayList<MediaController> controllers = new ArrayList<MediaController>();
                                int size = tokens.size();
                                for (int i = 0; i < size; ++i) {
                                    controllers.add(new MediaController(context, (MediaSession.Token)tokens.get(i)));
                                }
                                OnActiveSessionsChangedListener listener = mListener;
                                if (listener != null) {
                                    listener.onActiveSessionsChanged(controllers);
                                }
                            }
                        }
                    });
                }
            }
        };

        public SessionsChangedWrapper(Context context, OnActiveSessionsChangedListener listener, Handler handler) {
            this.mContext = context;
            this.mListener = listener;
            this.mHandler = handler;
        }

        private void release() {
            this.mListener = null;
            this.mContext = null;
            this.mHandler = null;
        }
    }

    public static class RemoteUserInfo {
        private final String mPackageName;
        private final int mPid;
        private final int mUid;

        public RemoteUserInfo(String packageName, int pid, int uid) {
            this.mPackageName = packageName;
            this.mPid = pid;
            this.mUid = uid;
        }

        public String getPackageName() {
            return this.mPackageName;
        }

        public int getPid() {
            return this.mPid;
        }

        public int getUid() {
            return this.mUid;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof RemoteUserInfo)) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            RemoteUserInfo otherUserInfo = (RemoteUserInfo)obj;
            return TextUtils.equals(this.mPackageName, otherUserInfo.mPackageName) && this.mPid == otherUserInfo.mPid && this.mUid == otherUserInfo.mUid;
        }

        public int hashCode() {
            return Objects.hash(this.mPackageName, this.mPid, this.mUid);
        }
    }

    @SystemApi
    public static interface OnMediaKeyEventSessionChangedListener {
        public void onMediaKeyEventSessionChanged(String var1, MediaSession.Token var2);
    }

    @SystemApi
    public static interface OnMediaKeyEventDispatchedListener {
        public void onMediaKeyEventDispatched(KeyEvent var1, String var2, MediaSession.Token var3);
    }

    @SystemApi
    public static interface OnMediaKeyListener {
        public boolean onMediaKey(KeyEvent var1);
    }

    @SystemApi
    public static interface OnVolumeKeyLongPressListener {
        public void onVolumeKeyLongPress(KeyEvent var1);
    }

    public static interface OnSession2TokensChangedListener {
        public void onSession2TokensChanged(List<Session2Token> var1);
    }

    public static interface OnActiveSessionsChangedListener {
        public void onActiveSessionsChanged(List<MediaController> var1);
    }
}

