/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.annotation.SystemApi;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Objects;

@SystemApi
public class CaptivePortalData
implements Parcelable {
    private final long mRefreshTimeMillis;
    private final Uri mUserPortalUrl;
    private final Uri mVenueInfoUrl;
    private final boolean mIsSessionExtendable;
    private final long mByteLimit;
    private final long mExpiryTimeMillis;
    private final boolean mCaptive;
    public static final Parcelable.Creator<CaptivePortalData> CREATOR = new Parcelable.Creator<CaptivePortalData>(){

        @Override
        public CaptivePortalData createFromParcel(Parcel source) {
            return new CaptivePortalData(source);
        }

        public CaptivePortalData[] newArray(int size) {
            return new CaptivePortalData[size];
        }
    };

    private CaptivePortalData(long refreshTimeMillis, Uri userPortalUrl, Uri venueInfoUrl, boolean isSessionExtendable, long byteLimit, long expiryTimeMillis, boolean captive) {
        this.mRefreshTimeMillis = refreshTimeMillis;
        this.mUserPortalUrl = userPortalUrl;
        this.mVenueInfoUrl = venueInfoUrl;
        this.mIsSessionExtendable = isSessionExtendable;
        this.mByteLimit = byteLimit;
        this.mExpiryTimeMillis = expiryTimeMillis;
        this.mCaptive = captive;
    }

    private CaptivePortalData(Parcel p) {
        this(p.readLong(), (Uri)p.readParcelable(null), (Uri)p.readParcelable(null), p.readBoolean(), p.readLong(), p.readLong(), p.readBoolean());
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.mRefreshTimeMillis);
        dest.writeParcelable(this.mUserPortalUrl, 0);
        dest.writeParcelable(this.mVenueInfoUrl, 0);
        dest.writeBoolean(this.mIsSessionExtendable);
        dest.writeLong(this.mByteLimit);
        dest.writeLong(this.mExpiryTimeMillis);
        dest.writeBoolean(this.mCaptive);
    }

    public long getRefreshTimeMillis() {
        return this.mRefreshTimeMillis;
    }

    public Uri getUserPortalUrl() {
        return this.mUserPortalUrl;
    }

    public Uri getVenueInfoUrl() {
        return this.mVenueInfoUrl;
    }

    public boolean isSessionExtendable() {
        return this.mIsSessionExtendable;
    }

    public long getByteLimit() {
        return this.mByteLimit;
    }

    public long getExpiryTimeMillis() {
        return this.mExpiryTimeMillis;
    }

    public boolean isCaptive() {
        return this.mCaptive;
    }

    public int hashCode() {
        return Objects.hash(this.mRefreshTimeMillis, this.mUserPortalUrl, this.mVenueInfoUrl, this.mIsSessionExtendable, this.mByteLimit, this.mExpiryTimeMillis, this.mCaptive);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CaptivePortalData)) {
            return false;
        }
        CaptivePortalData other = (CaptivePortalData)obj;
        return this.mRefreshTimeMillis == other.mRefreshTimeMillis && Objects.equals(this.mUserPortalUrl, other.mUserPortalUrl) && Objects.equals(this.mVenueInfoUrl, other.mVenueInfoUrl) && this.mIsSessionExtendable == other.mIsSessionExtendable && this.mByteLimit == other.mByteLimit && this.mExpiryTimeMillis == other.mExpiryTimeMillis && this.mCaptive == other.mCaptive;
    }

    public String toString() {
        return "CaptivePortalData {refreshTime: " + this.mRefreshTimeMillis + ", userPortalUrl: " + this.mUserPortalUrl + ", venueInfoUrl: " + this.mVenueInfoUrl + ", isSessionExtendable: " + this.mIsSessionExtendable + ", byteLimit: " + this.mByteLimit + ", expiryTime: " + this.mExpiryTimeMillis + ", captive: " + this.mCaptive + "}";
    }

    public static class Builder {
        private long mRefreshTime;
        private Uri mUserPortalUrl;
        private Uri mVenueInfoUrl;
        private boolean mIsSessionExtendable;
        private long mBytesRemaining = -1L;
        private long mExpiryTime = -1L;
        private boolean mCaptive;

        public Builder() {
        }

        public Builder(CaptivePortalData data) {
            if (data == null) {
                return;
            }
            this.setRefreshTime(data.mRefreshTimeMillis).setUserPortalUrl(data.mUserPortalUrl).setVenueInfoUrl(data.mVenueInfoUrl).setSessionExtendable(data.mIsSessionExtendable).setBytesRemaining(data.mByteLimit).setExpiryTime(data.mExpiryTimeMillis).setCaptive(data.mCaptive);
        }

        public Builder setRefreshTime(long refreshTime) {
            this.mRefreshTime = refreshTime;
            return this;
        }

        public Builder setUserPortalUrl(Uri userPortalUrl) {
            this.mUserPortalUrl = userPortalUrl;
            return this;
        }

        public Builder setVenueInfoUrl(Uri venueInfoUrl) {
            this.mVenueInfoUrl = venueInfoUrl;
            return this;
        }

        public Builder setSessionExtendable(boolean sessionExtendable) {
            this.mIsSessionExtendable = sessionExtendable;
            return this;
        }

        public Builder setBytesRemaining(long bytesRemaining) {
            this.mBytesRemaining = bytesRemaining;
            return this;
        }

        public Builder setExpiryTime(long expiryTime) {
            this.mExpiryTime = expiryTime;
            return this;
        }

        public Builder setCaptive(boolean captive) {
            this.mCaptive = captive;
            return this;
        }

        public CaptivePortalData build() {
            return new CaptivePortalData(this.mRefreshTime, this.mUserPortalUrl, this.mVenueInfoUrl, this.mIsSessionExtendable, this.mBytesRemaining, this.mExpiryTime, this.mCaptive);
        }
    }
}

