/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.annotation.SystemApi;
import android.content.Context;
import android.net.IIntResultListener;
import android.net.ITetheringConnector;
import android.net.ITetheringEventCallback;
import android.net.IpPrefix;
import android.net.LinkAddress;
import android.net.Network;
import android.net.TetherStatesParcel;
import android.net.TetheredClient;
import android.net.TetheringCallbackStartedParcel;
import android.net.TetheringConfigurationParcel;
import android.net.TetheringRequestParcel;
import android.os.Bundle;
import android.os.ConditionVariable;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.util.ArrayMap;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.Supplier;

@SystemApi.Container(value={@SystemApi, @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)})
public class TetheringManager {
    private static final String TAG = TetheringManager.class.getSimpleName();
    private static final int DEFAULT_TIMEOUT_MS = 60000;
    private static final long CONNECTOR_POLL_INTERVAL_MILLIS = 200L;
    @GuardedBy(value={"mConnectorWaitQueue"})
    private ITetheringConnector mConnector;
    @GuardedBy(value={"mConnectorWaitQueue"})
    private final List<ConnectorConsumer> mConnectorWaitQueue = new ArrayList<ConnectorConsumer>();
    private final Supplier<IBinder> mConnectorSupplier;
    private final TetheringCallbackInternal mCallback;
    private final Context mContext;
    private final ArrayMap<TetheringEventCallback, ITetheringEventCallback> mTetheringEventCallbacks = new ArrayMap();
    private volatile TetheringConfigurationParcel mTetheringConfiguration;
    private volatile TetherStatesParcel mTetherStatesParcel;
    public static final String ACTION_TETHER_STATE_CHANGED = "android.net.conn.TETHER_STATE_CHANGED";
    public static final String EXTRA_AVAILABLE_TETHER = "availableArray";
    public static final String EXTRA_ACTIVE_LOCAL_ONLY = "android.net.extra.ACTIVE_LOCAL_ONLY";
    public static final String EXTRA_ACTIVE_TETHER = "tetherArray";
    public static final String EXTRA_ERRORED_TETHER = "erroredArray";
    public static final int TETHERING_INVALID = -1;
    public static final int TETHERING_WIFI = 0;
    public static final int TETHERING_USB = 1;
    public static final int TETHERING_BLUETOOTH = 2;
    public static final int TETHERING_WIFI_P2P = 3;
    public static final int TETHERING_NCM = 4;
    public static final int TETHERING_ETHERNET = 5;
    public static final int TETHERING_WIGIG = 6;
    public static final int TETHER_ERROR_NO_ERROR = 0;
    public static final int TETHER_ERROR_UNKNOWN_IFACE = 1;
    public static final int TETHER_ERROR_SERVICE_UNAVAIL = 2;
    public static final int TETHER_ERROR_UNSUPPORTED = 3;
    public static final int TETHER_ERROR_UNAVAIL_IFACE = 4;
    public static final int TETHER_ERROR_INTERNAL_ERROR = 5;
    public static final int TETHER_ERROR_TETHER_IFACE_ERROR = 6;
    public static final int TETHER_ERROR_UNTETHER_IFACE_ERROR = 7;
    public static final int TETHER_ERROR_ENABLE_FORWARDING_ERROR = 8;
    public static final int TETHER_ERROR_DISABLE_FORWARDING_ERROR = 9;
    public static final int TETHER_ERROR_IFACE_CFG_ERROR = 10;
    public static final int TETHER_ERROR_PROVISIONING_FAILED = 11;
    public static final int TETHER_ERROR_DHCPSERVER_ERROR = 12;
    public static final int TETHER_ERROR_ENTITLEMENT_UNKNOWN = 13;
    public static final int TETHER_ERROR_NO_CHANGE_TETHERING_PERMISSION = 14;
    public static final int TETHER_ERROR_NO_ACCESS_TETHERING_PERMISSION = 15;
    public static final int TETHER_ERROR_UNKNOWN_TYPE = 16;
    public static final int TETHER_HARDWARE_OFFLOAD_STOPPED = 0;
    public static final int TETHER_HARDWARE_OFFLOAD_STARTED = 1;
    public static final int TETHER_HARDWARE_OFFLOAD_FAILED = 2;

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public TetheringManager(Context context, Supplier<IBinder> connectorSupplier) {
        this.mContext = context;
        this.mCallback = new TetheringCallbackInternal();
        this.mConnectorSupplier = connectorSupplier;
        String pkgName = this.mContext.getOpPackageName();
        IBinder connector = this.mConnectorSupplier.get();
        if (connector != null) {
            this.mConnector = ITetheringConnector.Stub.asInterface(connector);
        } else {
            this.startPollingForConnector();
        }
        Log.i(TAG, "registerTetheringEventCallback:" + pkgName);
        this.getConnector(c -> c.registerTetheringEventCallback(this.mCallback, pkgName));
    }

    private void startPollingForConnector() {
        new Thread(() -> {
            IBinder connector;
            do {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while ((connector = this.mConnectorSupplier.get()) == null);
            this.onTetheringConnected(ITetheringConnector.Stub.asInterface(connector));
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onTetheringConnected(ITetheringConnector connector) {
        while (true) {
            ArrayList<ConnectorConsumer> localWaitQueue;
            List<ConnectorConsumer> list = this.mConnectorWaitQueue;
            synchronized (list) {
                localWaitQueue = new ArrayList<ConnectorConsumer>(this.mConnectorWaitQueue);
                this.mConnectorWaitQueue.clear();
            }
            for (ConnectorConsumer task : localWaitQueue) {
                try {
                    task.onConnectorAvailable(connector);
                }
                catch (RemoteException e) {
                    Log.wtf(TAG, "Error processing request for the tethering connector", e);
                }
            }
            list = this.mConnectorWaitQueue;
            synchronized (list) {
                if (this.mConnectorWaitQueue.size() == 0) {
                    this.mConnector = connector;
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getConnector(ConnectorConsumer consumer) {
        ITetheringConnector connector;
        List<ConnectorConsumer> list = this.mConnectorWaitQueue;
        synchronized (list) {
            connector = this.mConnector;
            if (connector == null) {
                this.mConnectorWaitQueue.add(consumer);
                return;
            }
        }
        try {
            consumer.onConnectorAvailable(connector);
        }
        catch (RemoteException e) {
            throw new IllegalStateException(e);
        }
    }

    private void throwIfPermissionFailure(int errorCode) {
        switch (errorCode) {
            case 14: {
                throw new SecurityException("No android.permission.TETHER_PRIVILEGED or android.permission.WRITE_SETTINGS permission");
            }
            case 15: {
                throw new SecurityException("No android.permission.ACCESS_NETWORK_STATE permission");
            }
        }
    }

    @Deprecated
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public int tether(String iface) {
        String callerPkg = this.mContext.getOpPackageName();
        Log.i(TAG, "tether caller:" + callerPkg);
        RequestDispatcher dispatcher = new RequestDispatcher();
        return dispatcher.waitForResult((connector, listener) -> {
            try {
                connector.tether(iface, callerPkg, listener);
            }
            catch (RemoteException e) {
                throw new IllegalStateException(e);
            }
        });
    }

    @Deprecated
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public int untether(String iface) {
        String callerPkg = this.mContext.getOpPackageName();
        Log.i(TAG, "untether caller:" + callerPkg);
        RequestDispatcher dispatcher = new RequestDispatcher();
        return dispatcher.waitForResult((connector, listener) -> {
            try {
                connector.untether(iface, callerPkg, listener);
            }
            catch (RemoteException e) {
                throw new IllegalStateException(e);
            }
        });
    }

    @Deprecated
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public int setUsbTethering(boolean enable) {
        String callerPkg = this.mContext.getOpPackageName();
        Log.i(TAG, "setUsbTethering caller:" + callerPkg);
        RequestDispatcher dispatcher = new RequestDispatcher();
        return dispatcher.waitForResult((connector, listener) -> {
            try {
                connector.setUsbTethering(enable, callerPkg, listener);
            }
            catch (RemoteException e) {
                throw new IllegalStateException(e);
            }
        });
    }

    public void startTethering(TetheringRequest request, final Executor executor, final StartTetheringCallback callback) {
        String callerPkg = this.mContext.getOpPackageName();
        Log.i(TAG, "startTethering caller:" + callerPkg);
        IIntResultListener.Stub listener = new IIntResultListener.Stub(){

            @Override
            public void onResult(int resultCode) {
                executor.execute(() -> {
                    if (resultCode == 0) {
                        callback.onTetheringStarted();
                    } else {
                        callback.onTetheringFailed(resultCode);
                    }
                });
            }
        };
        this.getConnector(c -> c.startTethering(request.getParcel(), callerPkg, listener));
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public void startTethering(int type, Executor executor, StartTetheringCallback callback) {
        this.startTethering(new TetheringRequest.Builder(type).build(), executor, callback);
    }

    public void stopTethering(int type) {
        String callerPkg = this.mContext.getOpPackageName();
        Log.i(TAG, "stopTethering caller:" + callerPkg);
        this.getConnector(c -> c.stopTethering(type, callerPkg, new IIntResultListener.Stub(){

            @Override
            public void onResult(int resultCode) {
            }
        }));
    }

    public void requestLatestTetheringEntitlementResult(int type, boolean showEntitlementUi, final Executor executor, final OnTetheringEntitlementResultListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("OnTetheringEntitlementResultListener cannot be null.");
        }
        ResultReceiver wrappedListener = new ResultReceiver(null){

            @Override
            protected void onReceiveResult(int resultCode, Bundle resultData) {
                executor.execute(() -> listener.onTetheringEntitlementResult(resultCode));
            }
        };
        this.requestLatestTetheringEntitlementResult(type, wrappedListener, showEntitlementUi);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public void requestLatestTetheringEntitlementResult(int type, ResultReceiver receiver, boolean showEntitlementUi) {
        String callerPkg = this.mContext.getOpPackageName();
        Log.i(TAG, "getLatestTetheringEntitlementResult caller:" + callerPkg);
        this.getConnector(c -> c.requestLatestTetheringEntitlementResult(type, receiver, showEntitlementUi, callerPkg));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerTetheringEventCallback(final Executor executor, final TetheringEventCallback callback) {
        String callerPkg = this.mContext.getOpPackageName();
        Log.i(TAG, "registerTetheringEventCallback caller:" + callerPkg);
        ArrayMap<TetheringEventCallback, ITetheringEventCallback> arrayMap = this.mTetheringEventCallbacks;
        synchronized (arrayMap) {
            if (this.mTetheringEventCallbacks.containsKey(callback)) {
                throw new IllegalArgumentException("callback was already registered.");
            }
            ITetheringEventCallback.Stub remoteCallback = new ITetheringEventCallback.Stub(){
                private final HashMap<String, Integer> mErrorStates = new HashMap();
                private String[] mLastTetherableInterfaces = null;
                private String[] mLastTetheredInterfaces = null;

                @Override
                public void onUpstreamChanged(Network network) throws RemoteException {
                    executor.execute(() -> callback.onUpstreamChanged(network));
                }

                private synchronized void sendErrorCallbacks(TetherStatesParcel newStates) {
                    for (int i = 0; i < newStates.erroredIfaceList.length; ++i) {
                        String iface = newStates.erroredIfaceList[i];
                        Integer lastError = this.mErrorStates.get(iface);
                        int newError = newStates.lastErrorList[i];
                        if (newError != 0 && !Objects.equals(lastError, newError)) {
                            callback.onError(iface, newError);
                        }
                        this.mErrorStates.put(iface, newError);
                    }
                }

                private synchronized void maybeSendTetherableIfacesChangedCallback(TetherStatesParcel newStates) {
                    if (Arrays.equals(this.mLastTetherableInterfaces, newStates.availableList)) {
                        return;
                    }
                    this.mLastTetherableInterfaces = (String[])newStates.availableList.clone();
                    callback.onTetherableInterfacesChanged(Collections.unmodifiableList(Arrays.asList(this.mLastTetherableInterfaces)));
                }

                private synchronized void maybeSendTetheredIfacesChangedCallback(TetherStatesParcel newStates) {
                    if (Arrays.equals(this.mLastTetheredInterfaces, newStates.tetheredList)) {
                        return;
                    }
                    this.mLastTetheredInterfaces = (String[])newStates.tetheredList.clone();
                    callback.onTetheredInterfacesChanged(Collections.unmodifiableList(Arrays.asList(this.mLastTetheredInterfaces)));
                }

                @Override
                public void onCallbackStarted(TetheringCallbackStartedParcel parcel) {
                    executor.execute(() -> {
                        callback.onTetheringSupported(parcel.tetheringSupported);
                        callback.onUpstreamChanged(parcel.upstreamNetwork);
                        this.sendErrorCallbacks(parcel.states);
                        this.sendRegexpsChanged(parcel.config);
                        this.maybeSendTetherableIfacesChangedCallback(parcel.states);
                        this.maybeSendTetheredIfacesChangedCallback(parcel.states);
                        callback.onClientsChanged(parcel.tetheredClients);
                        callback.onOffloadStatusChanged(parcel.offloadStatus);
                    });
                }

                @Override
                public void onCallbackStopped(int errorCode) {
                    executor.execute(() -> TetheringManager.this.throwIfPermissionFailure(errorCode));
                }

                private void sendRegexpsChanged(TetheringConfigurationParcel parcel) {
                    callback.onTetherableInterfaceRegexpsChanged(new TetheringInterfaceRegexps(parcel.tetherableBluetoothRegexs, parcel.tetherableUsbRegexs, parcel.tetherableWifiRegexs));
                }

                @Override
                public void onConfigurationChanged(TetheringConfigurationParcel config) {
                    executor.execute(() -> this.sendRegexpsChanged(config));
                }

                @Override
                public void onTetherStatesChanged(TetherStatesParcel states) {
                    executor.execute(() -> {
                        this.sendErrorCallbacks(states);
                        this.maybeSendTetherableIfacesChangedCallback(states);
                        this.maybeSendTetheredIfacesChangedCallback(states);
                    });
                }

                @Override
                public void onTetherClientsChanged(List<TetheredClient> clients) {
                    executor.execute(() -> callback.onClientsChanged(clients));
                }

                @Override
                public void onOffloadStatusChanged(int status) {
                    executor.execute(() -> callback.onOffloadStatusChanged(status));
                }
            };
            this.getConnector(c -> c.registerTetheringEventCallback(remoteCallback, callerPkg));
            this.mTetheringEventCallbacks.put(callback, remoteCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterTetheringEventCallback(TetheringEventCallback callback) {
        String callerPkg = this.mContext.getOpPackageName();
        Log.i(TAG, "unregisterTetheringEventCallback caller:" + callerPkg);
        ArrayMap<TetheringEventCallback, ITetheringEventCallback> arrayMap = this.mTetheringEventCallbacks;
        synchronized (arrayMap) {
            ITetheringEventCallback remoteCallback = this.mTetheringEventCallbacks.remove(callback);
            if (remoteCallback == null) {
                throw new IllegalArgumentException("callback was not registered.");
            }
            this.getConnector(c -> c.unregisterTetheringEventCallback(remoteCallback, callerPkg));
        }
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public int getLastTetherError(String iface) {
        this.mCallback.waitForStarted();
        if (this.mTetherStatesParcel == null) {
            return 0;
        }
        int i = 0;
        for (String errored : this.mTetherStatesParcel.erroredIfaceList) {
            if (iface.equals(errored)) {
                return this.mTetherStatesParcel.lastErrorList[i];
            }
            ++i;
        }
        return 0;
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public String[] getTetherableUsbRegexs() {
        this.mCallback.waitForStarted();
        return this.mTetheringConfiguration.tetherableUsbRegexs;
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public String[] getTetherableWifiRegexs() {
        this.mCallback.waitForStarted();
        return this.mTetheringConfiguration.tetherableWifiRegexs;
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public String[] getTetherableBluetoothRegexs() {
        this.mCallback.waitForStarted();
        return this.mTetheringConfiguration.tetherableBluetoothRegexs;
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public String[] getTetherableIfaces() {
        this.mCallback.waitForStarted();
        if (this.mTetherStatesParcel == null) {
            return new String[0];
        }
        return this.mTetherStatesParcel.availableList;
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public String[] getTetheredIfaces() {
        this.mCallback.waitForStarted();
        if (this.mTetherStatesParcel == null) {
            return new String[0];
        }
        return this.mTetherStatesParcel.tetheredList;
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public String[] getTetheringErroredIfaces() {
        this.mCallback.waitForStarted();
        if (this.mTetherStatesParcel == null) {
            return new String[0];
        }
        return this.mTetherStatesParcel.erroredIfaceList;
    }

    @Deprecated
    public String[] getTetheredDhcpRanges() {
        this.mCallback.waitForStarted();
        return this.mTetheringConfiguration.legacyDhcpRanges;
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public boolean isTetheringSupported() {
        String callerPkg = this.mContext.getOpPackageName();
        return this.isTetheringSupported(callerPkg);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public boolean isTetheringSupported(String callerPkg) {
        RequestDispatcher dispatcher = new RequestDispatcher();
        int ret = dispatcher.waitForResult((connector, listener) -> {
            try {
                connector.isTetheringSupported(callerPkg, listener);
            }
            catch (RemoteException e) {
                throw new IllegalStateException(e);
            }
        });
        return ret == 0;
    }

    public void stopAllTethering() {
        String callerPkg = this.mContext.getOpPackageName();
        Log.i(TAG, "stopAllTethering caller:" + callerPkg);
        this.getConnector(c -> c.stopAllTethering(callerPkg, new IIntResultListener.Stub(){

            @Override
            public void onResult(int resultCode) {
            }
        }));
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static class TetheringInterfaceRegexps {
        private final String[] mTetherableBluetoothRegexs;
        private final String[] mTetherableUsbRegexs;
        private final String[] mTetherableWifiRegexs;

        public TetheringInterfaceRegexps(String[] tetherableBluetoothRegexs, String[] tetherableUsbRegexs, String[] tetherableWifiRegexs) {
            this.mTetherableBluetoothRegexs = (String[])tetherableBluetoothRegexs.clone();
            this.mTetherableUsbRegexs = (String[])tetherableUsbRegexs.clone();
            this.mTetherableWifiRegexs = (String[])tetherableWifiRegexs.clone();
        }

        public List<String> getTetherableBluetoothRegexs() {
            return Collections.unmodifiableList(Arrays.asList(this.mTetherableBluetoothRegexs));
        }

        public List<String> getTetherableUsbRegexs() {
            return Collections.unmodifiableList(Arrays.asList(this.mTetherableUsbRegexs));
        }

        public List<String> getTetherableWifiRegexs() {
            return Collections.unmodifiableList(Arrays.asList(this.mTetherableWifiRegexs));
        }

        public int hashCode() {
            return Objects.hash(this.mTetherableBluetoothRegexs, this.mTetherableUsbRegexs, this.mTetherableWifiRegexs);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TetheringInterfaceRegexps)) {
                return false;
            }
            TetheringInterfaceRegexps other = (TetheringInterfaceRegexps)obj;
            return Arrays.equals(this.mTetherableBluetoothRegexs, other.mTetherableBluetoothRegexs) && Arrays.equals(this.mTetherableUsbRegexs, other.mTetherableUsbRegexs) && Arrays.equals(this.mTetherableWifiRegexs, other.mTetherableWifiRegexs);
        }
    }

    public static interface TetheringEventCallback {
        default public void onTetheringSupported(boolean supported) {
        }

        default public void onUpstreamChanged(Network network) {
        }

        @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
        default public void onTetherableInterfaceRegexpsChanged(TetheringInterfaceRegexps reg) {
        }

        default public void onTetherableInterfacesChanged(List<String> interfaces) {
        }

        default public void onTetheredInterfacesChanged(List<String> interfaces) {
        }

        default public void onError(String ifName, int error) {
        }

        default public void onClientsChanged(Collection<TetheredClient> clients) {
        }

        default public void onOffloadStatusChanged(int status) {
        }
    }

    public static interface OnTetheringEntitlementResultListener {
        public void onTetheringEntitlementResult(int var1);
    }

    public static interface StartTetheringCallback {
        default public void onTetheringStarted() {
        }

        default public void onTetheringFailed(int error) {
        }
    }

    public static class TetheringRequest {
        private final TetheringRequestParcel mRequestParcel;

        private TetheringRequest(TetheringRequestParcel request) {
            this.mRequestParcel = request;
        }

        public LinkAddress getLocalIpv4Address() {
            return this.mRequestParcel.localIPv4Address;
        }

        public LinkAddress getClientStaticIpv4Address() {
            return this.mRequestParcel.staticClientAddress;
        }

        public int getTetheringType() {
            return this.mRequestParcel.tetheringType;
        }

        public boolean isExemptFromEntitlementCheck() {
            return this.mRequestParcel.exemptFromEntitlementCheck;
        }

        public boolean getShouldShowEntitlementUi() {
            return this.mRequestParcel.showProvisioningUi;
        }

        public static boolean checkStaticAddressConfiguration(LinkAddress localIPv4Address, LinkAddress clientAddress) {
            return localIPv4Address.getPrefixLength() == clientAddress.getPrefixLength() && localIPv4Address.isIpv4() && clientAddress.isIpv4() && new IpPrefix(localIPv4Address.toString()).equals(new IpPrefix(clientAddress.toString()));
        }

        public TetheringRequestParcel getParcel() {
            return this.mRequestParcel;
        }

        public String toString() {
            return "TetheringRequest [ type= " + this.mRequestParcel.tetheringType + ", localIPv4Address= " + this.mRequestParcel.localIPv4Address + ", staticClientAddress= " + this.mRequestParcel.staticClientAddress + ", exemptFromEntitlementCheck= " + this.mRequestParcel.exemptFromEntitlementCheck + ", showProvisioningUi= " + this.mRequestParcel.showProvisioningUi + " ]";
        }

        public static class Builder {
            private final TetheringRequestParcel mBuilderParcel = new TetheringRequestParcel();

            public Builder(int type) {
                this.mBuilderParcel.tetheringType = type;
                this.mBuilderParcel.localIPv4Address = null;
                this.mBuilderParcel.staticClientAddress = null;
                this.mBuilderParcel.exemptFromEntitlementCheck = false;
                this.mBuilderParcel.showProvisioningUi = true;
            }

            public Builder setStaticIpv4Addresses(LinkAddress localIPv4Address, LinkAddress clientAddress) {
                Objects.requireNonNull(localIPv4Address);
                Objects.requireNonNull(clientAddress);
                if (!TetheringRequest.checkStaticAddressConfiguration(localIPv4Address, clientAddress)) {
                    throw new IllegalArgumentException("Invalid server or client addresses");
                }
                this.mBuilderParcel.localIPv4Address = localIPv4Address;
                this.mBuilderParcel.staticClientAddress = clientAddress;
                return this;
            }

            public Builder setExemptFromEntitlementCheck(boolean exempt) {
                this.mBuilderParcel.exemptFromEntitlementCheck = exempt;
                return this;
            }

            public Builder setShouldShowEntitlementUi(boolean showUi) {
                this.mBuilderParcel.showProvisioningUi = showUi;
                return this;
            }

            public TetheringRequest build() {
                return new TetheringRequest(this.mBuilderParcel);
            }
        }
    }

    private class TetheringCallbackInternal
    extends ITetheringEventCallback.Stub {
        private volatile int mError = 0;
        private final ConditionVariable mWaitForCallback = new ConditionVariable();

        private TetheringCallbackInternal() {
        }

        @Override
        public void onCallbackStarted(TetheringCallbackStartedParcel parcel) {
            TetheringManager.this.mTetheringConfiguration = parcel.config;
            TetheringManager.this.mTetherStatesParcel = parcel.states;
            this.mWaitForCallback.open();
        }

        @Override
        public void onCallbackStopped(int errorCode) {
            this.mError = errorCode;
            this.mWaitForCallback.open();
        }

        @Override
        public void onUpstreamChanged(Network network) {
        }

        @Override
        public void onConfigurationChanged(TetheringConfigurationParcel config) {
            TetheringManager.this.mTetheringConfiguration = config;
        }

        @Override
        public void onTetherStatesChanged(TetherStatesParcel states) {
            TetheringManager.this.mTetherStatesParcel = states;
        }

        @Override
        public void onTetherClientsChanged(List<TetheredClient> clients) {
        }

        @Override
        public void onOffloadStatusChanged(int status) {
        }

        public void waitForStarted() {
            this.mWaitForCallback.block(60000L);
            TetheringManager.this.throwIfPermissionFailure(this.mError);
        }
    }

    private class RequestDispatcher {
        private final ConditionVariable mWaiting;
        public volatile int mRemoteResult;
        private final IIntResultListener mListener = new IIntResultListener.Stub(){

            @Override
            public void onResult(int resultCode) {
                RequestDispatcher.this.mRemoteResult = resultCode;
                RequestDispatcher.this.mWaiting.open();
            }
        };

        RequestDispatcher() {
            this.mWaiting = new ConditionVariable();
        }

        int waitForResult(RequestHelper request) {
            TetheringManager.this.getConnector(c -> request.runRequest(c, this.mListener));
            if (!this.mWaiting.block(60000L)) {
                throw new IllegalStateException("Callback timeout");
            }
            TetheringManager.this.throwIfPermissionFailure(this.mRemoteResult);
            return this.mRemoteResult;
        }
    }

    private static interface RequestHelper {
        public void runRequest(ITetheringConnector var1, IIntResultListener var2);
    }

    private static interface ConnectorConsumer {
        public void onConnectorAvailable(ITetheringConnector var1) throws RemoteException;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TetherOffloadStatus {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface StartTetheringError {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TetheringIfaceError {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface EntitlementResult {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TetheringType {
    }
}

